﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DataLayer
{
    public class Stock
    {
        public string Name { get; set; }
        public string Symbol { get; set; }
        public double LastValue { get; set; }
        public double Change { get; set; }
        public string Currency { get; set; }
        public string ImageName { get; set; }

        public Stock(string name, string symbol, double lastValue, double change, string currency, string imageName)
        {
            this.Name = name;
            this.Symbol = symbol;
            this.LastValue = lastValue;
            this.Change = change;
            this.Currency = currency;
            this.ImageName = imageName;
        }

        public static List<Stock> GetPreciousMetals()
        {
            System.Threading.Thread.Sleep(2000);
            List<Stock> preciousMetals = new List<Stock>();

            preciousMetals.Add(new Stock("First Majestic Silver", "TSX FR", 5.23, 12.72, "CAD", "CA"));
            preciousMetals.Add(new Stock("Newmont", "NYSE NEM", 20.01, 4.87, "USD", "US"));
            preciousMetals.Add(new Stock("Endeavour Silver", "TSX EDR", 2.88, 2.86, "CAD", "CA"));
            preciousMetals.Add(new Stock("Freeport-McMoRan", "NYSE FCX", 25.03, 0, "USD", "US"));
            preciousMetals.Add(new Stock("Petaquilla Minerals", "TSX PTQ", 0.04, 33.33, "CAD", "CA"));

            return preciousMetals;

        }

        public static List<Stock> GetStocks()
        {
            System.Threading.Thread.Sleep(2000);

            List<Stock> stocks = new List<Stock>();

            stocks.Add(new Stock("Bank Audi GDR", "BAG Bank", 15.12, 11, "LBP", "LB"));
            stocks.Add(new Stock("National American Bank", "NAM Bank", 22.1, 3.21, "USD", "US"));
            stocks.Add(new Stock("Mono Software", "MS", 2.3, 7.1, "EURO", "GE"));
            stocks.Add(new Stock("Funds Trusts", "FT", 14.04, 2.9, "USD", "US"));
            stocks.Add(new Stock("Food and Beverages CO", "FB CO", 22.17, 22.12, "CAD", "CA"));

            return stocks;

        }

        public static List<Stock> GetMoneyStocks()
        {
            System.Threading.Thread.Sleep(2000);

            List<Stock> moneyStocks = new List<Stock>();

            moneyStocks.Add(new Stock("European Euro", "EURO", 1.2395, 0.1, "USD", "EU"));
            moneyStocks.Add(new Stock("United Kingdom Pound", "Pound", 1.5709, 3.21, "USD", "GB"));
            moneyStocks.Add(new Stock("Japanese Yen", "Yen", 0.0084, 1.2, "USD", "JA"));
            moneyStocks.Add(new Stock("Canadian Dollar", "CAD", 0.87, 1.2, "USD", "CA"));

            return moneyStocks;

        }
    }
}
