﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Web;

namespace StudentManagement.Models
{
    /// <summary>
    /// View Model class for Student
    /// </summary>
    public class Student
    {
        private int _branchId;
        private int _courseId;
        [Key]
        [DatabaseGeneratedAttribute(DatabaseGeneratedOption.Identity)]
        public int StudentId { get; set; }
        [Required]
        public string Name { get; set; }
        [Required]
        [Display(Name = "Branch")]
        public int BranchId { get { return _branchId; } set { _branchId = value; if (value > 0) GetBranchName(); } }
        [NotMapped]
        [Display(Name = "Branch")]
        public string BranchName { get; set; }
        [Required]
        [Display(Name="Course")]
        public int CourseId { get { return _courseId; } set { _courseId = value; if (value > 0) GetCourseName(); } }
        [NotMapped]
        [Display(Name = "Course")]
        public string CourseName { get; set; }
        [Required]
        [Display(Name = "Gender(Male)")]
        public bool Gender { get; set; }
        [DataType(DataType.MultilineText)]
        public string Address { get; set; }
        private void GetBranchName()
        {
            var context = new AdminContext();
            var branch = context.Branches.Find(_branchId);
            if (branch != null)
                BranchName = branch.Name;
            context.Dispose();
        }
        private void GetCourseName()
        {
            var context = new AdminContext();
            var course = context.Courses.Find(_courseId);
            if (course != null)
                CourseName = course.Name;
            context.Dispose();
        }

    }
}