﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Web;

namespace StudentManagement.Models
{
    /// <summary>
    /// View Model class for Branch 
    /// </summary>
    public class Branch
    {
        [Key]
        [DatabaseGeneratedAttribute(DatabaseGeneratedOption.Identity)]
        public int BranchId { get; set; }
        [Required]
        public string Name { get; set; }
        [Required]
        [RegularExpression("^[A-Z]{2,5}$",ErrorMessage="Short Name should contains only alpha upper case letters and length should be in 2 to 5 letters")]
        [Display(Name="Short Name")]
        public string ShortName { get; set; }
        [DataType(DataType.MultilineText)]
        public string Description { get; set; }
    }
}