﻿using GoogleMap.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Security;

namespace GoogleMap.Controllers
{
    public class MapController : Controller
    {
        // GET: Map
        public ActionResult Index()
        {
            GoogleMapEntities GE = new GoogleMapEntities();
            return View(GE.Locations.ToList());
        }

        [HttpPost]
        public ActionResult Search(string Location)
        {

            GoogleMapEntities GE = new GoogleMapEntities();
            var result = GE.Locations.Where(x => x.LocationName.StartsWith(Location)).ToList();
            return Json(result, JsonRequestBehavior.AllowGet);
        }
    }
}