﻿using System.Collections.Generic;
using System.Linq;

namespace CountryStateApplication.Models
{
    public class AddressRepository : IAddressRepository
    {
        private AddressDataContext _dataContext;

        public AddressRepository()
        {
            _dataContext = new AddressDataContext();
        }

        public IList<Country> GetAllCountries()
        {           
            var query = from countries in _dataContext.Countries
                        select countries;
            var content = query.ToList<Country>();
            return content;            
        }
        public IList<State> GetAllStatesByCountryId(int countryId)
        {
            var query = from states in _dataContext.States
                        where states.CountryId == countryId
                        select states;
            var content = query.ToList<State>();
            return content;
        }
    }
}