<?php

// >==============================================
// Custom functions and variables
// >==============================================
$url = $_SERVER['REQUEST_URI'];
$url_explode = explode('/', parse_url($url)['path']);
$url_end = end($url_explode);
$config_finished = 'conf/config_finished.end';
$auth = 'conf/auth.ini';
$config_json = 'conf/configuration.json';
$introduction_md =  'conf/introduction.md';

class submitForm {
    public function fStart($t, $p) { 
    global $editFormAction, $preface, $title;
        ?>
    <div class="row config">
        <div class="col-sm-6 col-sm-offset-3"> 
        <?php 
         if ($t) {echo "<h1>" . $title . "</h1>";}
        if ($p) { ?>
        <div class="alert alert-info alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?php echo $preface; ?>
        </div>
        <?php }
       
        ?><form action="<?php echo $editFormAction;?>" name="config" method="POST">
  <?php  }

    public function fEnd() { 
        ?>
        </form>
        </div> <!-- col-md -->
    </div> <!-- row -->
  <?php  }

    public function fButton($align, $text, $value) { 
        ?>
            <div class="<?php echo $align; ?> create_button"><input class="btn btn-success" type="submit" name="create" value="<?php echo $text;?>" /></div>
              <input type="hidden" name="config" value="<?php echo $value;?>" />
  <?php  }
}

function isJson($string) {
 json_decode($string);
 return (json_last_error() == JSON_ERROR_NONE);
}

function stylesheet_dir() {
global $current_page;
  switch ($current_page ) {
      case 'incl':
      echo "../";
          break;

      default:
      echo "";
          break;
  }
}

function alert_box($why, $class, $color, $button) {
global $homepage, $jD, $lang;
$error_button_text = "Take me home!"; 

  switch ($why) {
    case 'connection':
    $why =  $lang['alerts']['connection'];
      break;
    case 'no_JSON':
    $why = $lang['alerts']['no_JSON'];
      break;

    case 'bad_JSON':
    $why = $lang['alerts']['bad_JSON'];
      break;
    case 'config_finished':
    $why = $lang['finished']['alert_text'];
      break;
    case 'already_voted':
    $why = $jD["content"]["already_voted"];
      break;
    case 'same_ip':
    $why = $lang["alerts"]["same_ip"];
      break;
    case 'missing_files':
    $why = $lang['alerts']['missing_files'];
      break;
    case 'wrong_pass':
    $why = $lang['alerts']['wrong_pass'];
      break;
    case 'pass_no_match':
    $why = $lang['alerts']['pass_no_match'];
      break;      
    default:
    $why = $lang['alerts']['unknown_error'];
      break;
  }

  switch ($color) {
    case 'orange':
    $color = "warning";
      break;
    case 'red':
    $color = "danger";
      break;
    case 'green':
    $color = "success";
      break;
    case 'blue':
    $color = "info";
      break;
    default:
    $color = "info";
      break;
  }

  switch ($button) {
    case 'config_finished':
    $button = $lang['finished']['button_text'];
      break;
    case 'already_voted':
    $button = $jD["content"]["voted_takemehome_button"];
      break;
    case 'standard':
    $button = $lang['alerts']['button_text'];
      break;
    default:
    $button = $lang['alerts']['button_text'];
      break;
  }

?>
<div class="row">
<div class="col-md-4 col-md-offset-4">
    <div class="alert alert-<?php echo $color; ?> <?php echo $class; ?>" role="alert">
      <p><?php echo $why; ?></p> <br>
      <div class="c"><a href="<?php echo $homepage; ?>"><button class="btn btn-warning" ><?php echo $button; ?></button></a></div>
    </div>
</div>
</div>
<?php
}

function redirect($where, $delay) { 
global $homepage;

switch ($where) {
  case 'home':
  $where = 'index.php';
    break;
  case 'results':
  $where = 'results.php';
    break;
  case 'config':
  $where = 'config.php';
    break;
  case 'login':
  $where = 'login.php';
    break;  
  case 'root':
  $where =  $homepage;
    break;      
  default:
  $where = 'goback';
    break;
}
  if ($where == 'goback') { ?>
<script type='text/javascript'>setTimeout(function() {window.history.back();}, <?php echo $delay*1000; ?>);</script>
<?php } else {
  ?>
<script type='text/javascript'>setTimeout(function() {window.location = "<?php echo $where;?>"}, <?php echo $delay*1000; ?>);</script>
<?php
        }
}

function email_to_ent($str) {
$str = mb_convert_encoding($str , 'UTF-32', 'UTF-8');
$t = unpack("N*", $str);
$t = array_map(function($n) { return "&#$n;"; }, $t);
return implode("", $t);
}

// >==============================================
// Initial configuration
// >==============================================

$homepage = "http://" . $_SERVER['SERVER_NAME'] . "/";
$editFormAction = htmlspecialchars($_SERVER['PHP_SELF']);

if (file_exists("lang/language.json")) {
$lang = json_decode(file_get_contents("lang/language.json"), true);
}
include "parsedown.php";
$Parsedown = new Parsedown();

switch ($current_page ) {
    case 'incl':
    $invitation_text = "../conf/introduction.md";
        break;

    default:
    $invitation_text = "conf/introduction.md";
        break;
}


// >==============================================
// Check if congiguration file exists and load it
// >==============================================
$json_path = __DIR__ . "/../conf/configuration.json";



if (file_exists($json_path) && (call_user_func('isJson', file_get_contents($json_path))) ) {
  $json = file_get_contents($json_path);
  $jD = json_decode($json, true);
}





$token = session_id();
$ip = $_SERVER['REMOTE_ADDR'];
$date = date('Y-m-d H:i:s');



?>