<?php
$current_page = basename(__DIR__);

if ((isset($_POST["config"])) && ($_POST["config"] == "lang")) {
$lang_chosen = $_POST['selectlang'];
$lang_path = __DIR__ . "/lang/" . $lang_chosen . ".json";
$lang_path_final = __DIR__ . "/lang/language.json";
copy($lang_path, $lang_path_final);
}

require_once('incl/functions.php');

if (file_exists($config_finished)) {
header('Location: index.php');
}


include 'incl/head.php';
?>


<?
if (!isset($_POST["config"])) {
$_POST["config"] = 'default';
}




$f = new submitForm;



function select_lang() {
global $f, $title, $preface; 
$title = "Select language";
$preface = '';
$f->fStart(1,0);
?>

    <select name="selectlang">
        <?php
        $langfiles = scandir('lang');

        foreach ($langfiles as $file ) {
            if ($file == '.' || $file == '..' || $file == 'language.json') {
            continue;
            }
            $withoutExt = preg_replace('/\\.[^.\\s]{3,4}$/', '', $file);
        ?>

        <option value="<?php echo $withoutExt; ?>"><?php echo $withoutExt; ?></option>    
        
        <?php } ?>
    </select>
<?php  
$f->fButton('l','Choose language', 'lang');
$f->fEnd();
}




if (file_exists("lang/language.json")) {
$lang = json_decode(file_get_contents("lang/language.json"), true);
}
function config_database() { 
global $f, $title, $preface, $lang;
$title = $lang['db_conn']['title'] ;
$preface = $lang['db_conn']['preface'] ;
$f->fStart(1,1);
?>
        
    <div class="form-group">
        <label for="host"><?php echo $lang['db_conn']['host'] ?></label>
        <input required type="text" class="form-control" id="host" placeholder="<?php echo $lang['db_conn']['host_ph'] ?>" name="form_host" value="localhost">
    </div>
    <div class="form-group">
        <label for="database"><?php echo $lang['db_conn']['database'] ?></label>
        <input required type="text" class="form-control" id="database" placeholder="<?php echo $lang['db_conn']['database_ph'] ?>" name="form_db">
    </div>
    <div class="form-group">
        <label for="user"><?php echo $lang['db_conn']['user'] ?></label>
        <input required type="text" class="form-control" id="user" placeholder="<?php echo $lang['db_conn']['user_ph'] ?>" name="form_user">
    </div>
    <div class="form-group">
        <label for="password"><?php echo $lang['db_conn']['password'] ?></label>
        <input required type="password" class="form-control" id="password" placeholder="<?php echo $lang['db_conn']['password_ph'] ?>" name="form_passwd">
    </div>
    <div class="form-group">
        <label for="table_name"><?php echo $lang['db_conn']['table_name'] ?></label>
        <input required type="text" class="form-control" id="table_name" placeholder="<?php echo $lang['db_conn']['table_name_ph'] ?>" name="form_table">
    </div>

<button class="btn btn-warning btn-sm" type="button" onClick="showDiv('GAscript');"><?php echo $lang['db_conn']['ga_toggle_button']; ?></button>

<div id="GAscript" style="display:none;">
    <div class="form-group">
        <label for="google_analytics"><?php echo $lang['db_conn']['google_analytics'] ?></label>
        <input type='text' class='form-control' id='google_analytics' placeholder="<?php echo $lang['db_conn']['google_analytics_ph'] ?>" name='form_ga' autocomplete="off">
    </div>
</div>


<?php 
$f->fButton('c', $lang['db_conn']['create_button'], 'database');
$f->fEnd();
}

function config_settings() {
global $f, $title, $preface, $lang;
$title = $lang['gen_settings']['title'] ;
$preface = $lang['gen_settings']['preface'] ;
$f->fStart(1,1);
?>
    <div class="form-group">
        <label><?php echo $lang['gen_settings']['site_title']; ?></label>
        <input type="text" class="form-control" placeholder="" name="site_title">
    </div>

    <div class="form-group">
        <label><?php echo $lang['gen_settings']['site_subtitle']; ?></label>
        <input type="text" class="form-control" placeholder="" name="site_subtitle">
    </div>

    <div class="form-group">
        <label><?php echo $lang['gen_settings']['poll_pagetitle']; ?></label>
        <input type="text" class="form-control" placeholder="PHP Simple Poll by mDfRg" name="question_pagetitle">
    </div>

    <div class="form-group">
        <label><?php echo $lang['gen_settings']['results_pagetitle']; ?></label>
        <input type="text" class="form-control" placeholder="" name="results_pagetitle" value="<?php echo $lang['gen_settings']['results_pagetitle_i']; ?>">
    </div>

    <div class="form-group">
        <label><?php echo $lang['gen_settings']['main_question']; ?></label>
        <input required type="text" class="form-control" placeholder="<?php echo $lang['gen_settings']['main_question_ph']; ?>" name="main_question">
    </div>
    <div class="checkbox">
        <label>
        <input type="checkbox" name="introduction" value="Yes" checked> <?php echo $lang['gen_settings']['tick_introduction']; ?>
        </label>
    </div>
    <div class="checkbox">
        <label>
        <input type="checkbox" name="hide_results" id="hide_results" onClick="showDiv('results_protected');"> <?php echo $lang['gen_settings']['tick_results']; ?>
        </label>
    </div>

<div id="results_protected" style="display:none;">
    <div class="form-group">
        <label for="results_login"><?php echo $lang['db_conn']['results_login'] ?></label>
        <input type="text" class="form-control" id="results_login" placeholder="" name="results_login" autocomplete="off">
    </div>
    <div class="form-group">
        <label for="results_password"><?php echo $lang['db_conn']['results_password'] ?></label>
        <input type="password" class="form-control" id="results_password" placeholder="" name="results_password" autocomplete="off">
    </div>

    <div class="form-group">
        <label for="results_password_0"><?php echo $lang['db_conn']['results_confirm'] ?></label>
        <input type="password" class="form-control" id="results_password_0" placeholder="" name="results_password_0" onkeyup="checkPass(); return false;" autocomplete="off">
        <div id="confirmMessage" class="confirmMessage"></div>
    </div>

</div>

    <div class="checkbox">
        <label>
        <input type="checkbox" name="email_admin" id="show_email" onClick="showDiv2('email_admin');"> <?php echo $lang['gen_settings']['tick_email']; ?>
        </label>
    </div>    


<!-- <button class="btn btn-warning btn-sm" type="button" onClick="showDiv2('email_admin');"><?php echo $lang['db_conn']['ga_toggle_button']; ?></button> -->

<div id="email_admin" style="display:none;">
    <div class="form-group">
        <label for="email_admin"><?php echo $lang['db_conn']['email_admin'] ?></label>
        <input type="text" class="form-control"  placeholder="" name="email_admin" autocomplete="off">
    </div>
</div>


<?php
$f->fButton('c', $lang['gen_settings']['create_button'], 'settings');
$f->fEnd();
}

function config_questions() {
global $f, $title, $preface, $lang;
$title = $_POST['main_question'];
$preface = $lang['answers']['preface'];
$f->fStart(1,1);
?>

            <div class="form-group">
                <div class="row">
                    <div class="col-md-11">
                        <input required type="text" class="form-control" placeholder="" name="answ_1">
                    </div>
                    <div class="col-md-1">
                        <label><span id="first" class='glyphicon glyphicon-ok-circle' aria-hidden='true'></span></label>
                    </div>
                </div>
            </div>
             <div class="form-group" id="add_answers">
                <div class="row">
                    <div class="col-md-11">
                        <input required type="text" class="form-control" placeholder="" name="answ_2" id="answ_2">
                    </div>
                    <div class="col-md-1">
                        <label><span class='glyphicon glyphicon-ok-circle' aria-hidden='true'></span></label>
                    </div>
                </div>
            </div>
            <input class="btn btn-info btn-sm" type="button" value="<?php echo $lang['answers']['add_new']; ?>" onClick="addInput('add_answers');">

<?php 
$f->fButton('c', $lang['gen_settings']['create_button'], 'questions');
$f->fEnd();
}

function config_translations() {
global $f, $title, $preface, $lang;
$title = $lang['translations']['title'];
$preface = $lang['translations']['preface'];
$f->fStart(1,1);
?>

            
            <div class="form-group">
                <label><?php echo $lang['translations']['return']; ?></label>
                <input required type="text" class="form-control" placeholder="" name="results_return" value="<?php echo $lang['translations']['return']; ?>">
            </div>
            <div class="form-group">
                <label><?php echo $lang['translations']['t_votes']; ?></label>
                <input required type="text" class="form-control" placeholder="" name="total_votes" value="<?php echo $lang['translations']['t_votes']; ?>">
            </div>
            <div class="form-group">
                <label><?php echo $lang['translations']['results_link']; ?></label>
                <input required type="text" class="form-control" placeholder="" name="results_link_box_text" value="<?php echo $lang['translations']['results_link_value']; ?>">
            </div>
            <div class="form-group">
                <label><?php echo $lang['translations']['thanks']; ?></label>
                <input required type="text" class="form-control" placeholder="" name="already_voted" value="<?php echo $lang['translations']['thanks']; ?>">
            </div>
            <div class="form-group">
                <label><?php echo $lang['translations']['vote_button']; ?></label>
                <input required type="text" class="form-control" placeholder="" name="vote_submit_button" value="<?php echo $lang['translations']['vote_button']; ?>">
            </div>
            <div class="form-group">
                <label><?php echo $lang['translations']['return_button']; ?></label>
                <input required type="text" class="form-control" placeholder="" name="voted_takemehome_button" value="<?php echo $lang['translations']['return_button']; ?>">
            </div>

<?php 
$f->fButton('c', $lang['gen_settings']['create_button'], 'translations');
$f->fEnd();
}


function config_introduction() {
global $f, $title, $preface, $lang;
$title = $lang["introduction"]["title"];
$preface = $lang['introduction']['preface'] ;
$json = file_get_contents('conf/configuration.json');
$jD = json_decode($json, true);

if ($jD['settings']['display_introduction'] == true) {

$f->fStart(1,1);

?>

    <textarea required rows="20" cols="10" id="introduction-md" name="text_introduction"></textarea>

<?php 
$f->fButton('c', $lang['gen_settings']['create_button'], 'introduction');
$f->fEnd();
} else {
   config_end();
}

}

function config_end()  {
global $editFormAction, $config_finished, $lang, $homepage;

$text_config_finished = <<<EOT
#########################################################################################
#                                                                                       #
#  If this file exists, it means that the configuration process was successful.         #
#  Just enter the root directory of your poll and you should be redirected              #
#  to index.php automatically.                                                          #
#  You can delete this (config_finished.end) file and enter config.php at the end of    #
#  your address to run it again or edit files located in conf/ directory manually,      #
#                                                                                       #
#  Files to edit:                                                                       #
#   * auth.ini - the authentication data needed to connect to the database              #
#   * configuration.json - all the settings provided during the configuration           #
#   * introduction.md - where your introduction seen at the top of the poll is written  #
#   * config_finished.end - this file, you can delete it to gain access to config.php   #
#                                                                                       #
#########################################################################################
EOT;

$config_finished_w = fopen($config_finished,"w");
fwrite($config_finished_w,$text_config_finished);
fclose($config_finished_w);


alert_box('config_finished','alert_box','green','config_finished');
redirect('home', 5);

?>
<script type="text/javascript">setTimeout(function() {window.location = "index.php"}, 5000);</script>

<?php 
}

if ((isset($_POST["config"])) && ($_POST["config"] == "database")) {

$conf_host =        $_POST['form_host'];
$conf_db =          $_POST['form_db'];
$conf_user =        $_POST['form_user'];
$conf_passwd =      $_POST['form_passwd'];
$conf_db_table =    $_POST['form_table'];
$conf_ga =          $_POST['form_ga'];


$text_auth = <<<EOT
<?php
\$host = "$conf_host";           
\$db = "$conf_db";             
\$user = "$conf_user";           
\$passwd = "$conf_passwd";         

\$db_table = "$conf_db_table"; 

\$ga_id = "$conf_ga";
?>
EOT;

$auth_w = fopen($auth,"w");
fwrite($auth_w,$text_auth);
fclose($auth_w);
require_once('incl/connect.php');
config_settings();
} 


if ((isset($_POST["config"])) && ($_POST["config"] == "settings")) {



if ($_POST['results_password'] != $_POST['results_password_0'])  {
alert_box('pass_no_match', 'alert_box', 'blue', 'standard');
redirect('goback', 3);
include_once 'incl/footer.php';
}





$question_pagetitle = $_POST['question_pagetitle'];
$main_question = $_POST['main_question'];
$results_pagetitle = $_POST['results_pagetitle'];
$email = $_POST['email_admin'];
$site_title = $_POST['site_title'];
$site_subtitle = $_POST['site_subtitle'];

if (isset($_POST['introduction'])) {
  $introduction = "true";
} else {
  $introduction = "false";
}

if (isset($_POST['hide_results'])) {
$hide_results = "true";  
$results_login = $_POST['results_login'];
$results_password = $_POST['results_password'];

$del_lines = file($auth);
array_pop($del_lines);
$file = join('',$del_lines);

$text_results_lock = <<<EOT
$file
\$results_lock_login =      "$results_login";
\$results_lock_password =   "$results_password";
?>
EOT;

$results_lock = fopen($auth,"w");
fwrite($results_lock,$text_results_lock);
fclose($results_lock);
} else {
  $hide_results = "false";
}





$lang_chosen = $lang['gen_settings']['locale'];

$text_settings = <<<EOT
{
    "settings": {
        "lang": "$lang_chosen",
        "question_pagetitle": "$question_pagetitle",
        "results_pagetitle": "$results_pagetitle",
        "config_pagetitle" : "Create a poll",
        "main_question": "$main_question",
        "display_introduction": $introduction,
        "hide_results": $hide_results,
        "site_title": "$site_title",
        "site_subtitle": "$site_subtitle",
        "show_email": "$email"
    },

EOT;

$configuration_w = fopen('conf/configuration.json', 'w');
fwrite($configuration_w, $text_settings);
fclose($configuration_w);
}

if ( (isset($_POST["config"])) && ($_POST["config"] == "questions") ) {


$questions_opening = <<<EOT
    "questions": {                   

EOT;

$questions = fopen('conf/configuration.json', 'a');
fwrite($questions, $questions_opening);
fclose($questions);

$text_all = "";

$x = count($_POST);

$z = 1;
for ($i=1; $i <= $x - 1; $i++) { 

if (isset($_POST['answ_'.$i])) {
$answ = $_POST['answ_'.$i];

$text = <<<EOT

    "$z": {
        "answer": "$answ",
        "id_submit": "$z"
        },
EOT;

$text_all .= $text;
$z++;
}
}

$text_final = rtrim($text_all,',');

$questions = fopen('conf/configuration.json', 'a');
fwrite($questions, "$text_final");
fclose($questions);



$questions_closing = <<<EOT

},               

EOT;

$questions = fopen('conf/configuration.json', 'a');
fwrite($questions, $questions_closing);
fclose($questions);
}


if ( (isset($_POST["config"])) && ($_POST["config"] == "translations") ) {
$results_return = $_POST['results_return'];
$total_votes = $_POST['total_votes'];
$results_link_box_text = $_POST['results_link_box_text'];
$already_voted = $_POST['already_voted'];
$vote_submit_button = $_POST['vote_submit_button'];
$voted_takemehome_button = $_POST['voted_takemehome_button'];



$text_translations = <<<EOT
    "content": {
        "results_return" : "$results_return",
        "total_votes" : "$total_votes",
        "results_link_box_text": "$results_link_box_text",
        "already_voted": "$already_voted",
        "vote_submit_button" : "$vote_submit_button",
        "voted_takemehome_button": "$voted_takemehome_button"
    }
}
EOT;

$translations = fopen('conf/configuration.json', 'a');
fwrite($translations, $text_translations);
fclose($translations);
}


if ( (isset($_POST["config"])) && ($_POST["config"] == "introduction") ) {
$text_introduction = $_POST['text_introduction'];

$introduction = fopen($introduction_md, 'w');
fwrite($introduction, $text_introduction);
fclose($introduction);

}


    switch ($_POST["config"]) {
        default:
            select_lang();
            break;
 
        case 'lang':
            config_database();
            break;

        case 'database':
            continue;

            break;
        
        case 'settings':
            config_questions();
            break;

        case 'questions':
            config_translations();
            break;

        case 'translations':
            config_introduction();
            break;       

        case 'introduction':
            config_end();
            break;     
        }


include 'incl/footer.php';
?>