﻿var productcatControllers = angular.module('productcatControllers', []);
productcatControllers.controller('ProductListCtrl', ['$scope', '$routeParams', '$location', '$route', 'productService',
function ($scope, $routeParams, $location, $route, productService) {
    productService.query(function (data) {
        $scope.products = data;
    });
    $scope.deleteProduct = function (product) {
        debugger;
        productService.delete({ id: product.id }, function () {
            $route.reload();
        });
    }
    $scope.newProduct = function () {
        $location.path('/productNew');
    }
}]);
productcatControllers.controller('ProductDetailCtrl', ['$scope', '$routeParams', '$location', 'productService',
function ($scope, $routeParams, $location, productService) {
    productService.get({ id: $routeParams.productId }, function (data) {
        $scope.product = data;
    });
    $scope.backToProduct = function () {
        $location.path('/products');
    }
}]);
productcatControllers.controller('ProductNewCtrl', ['$scope', '$routeParams', '$location', 'productService',
function ($scope, $routeParams, $location, productService) {
    $scope.product = { name: "", imageUrl: "", ProductDetail: { number: 0, price: 0.0, description: "", companyName: "" } };
    $scope.addNewProduct = function (product) {
        productService.save(product, function () {
            $location.path('/products');
        });
    }
    $scope.cancelNewProduct = function () {
        $location.path('/products');
    }
}]);
productcatControllers.controller('ProductUpdateCtrl', ['$scope', '$routeParams', '$location', 'productService',
function ($scope, $routeParams, $location, productService) {
    productService.get({ id: $routeParams.productId }, function (data) {
        $scope.product = data;
    });
    $scope.updateProduct = function (product) {
        var post = productService.get({}, { id: product.id }, function (data) {
            debugger;
            post.name = product.name;
            post.imageUrl = product.imageUrl;
            post.ProductDetail.number = product.ProductDetail.number;
            post.ProductDetail.price = product.ProductDetail.price;
            post.ProductDetail.description = product.ProductDetail.description;
            post.ProductDetail.companyName = product.ProductDetail.companyName;
            productService.update(post, function () {
                $location.path('/products');
            });
        });
    }
    $scope.cancelUpdateProduct = function () {
        $location.path('/products');
    }
}]);







