﻿app.controller('employeeEditCtrl', ['$scope', '$http', 'employeeFactory', function ($scope, $http, employeeFactory) {
    
    $scope.employees;
    $scope.countries;

    getEmployeeData();
    
    function getEmployeeData() {
        employeeFactory.getCountries()
            .success(function (data) {
                $scope.countries = data;
            })
            .error(function (error) {
                $scope.status = 'Unable to load country data: ' + error;
                console.log(error);
            });

        employeeFactory.getEmployees()
            .success(function (data) {
                $scope.employees = data;
                $scope.employees.forEach(function (emp) {
                    $scope.setDropDown(emp);
                });
            })
            .error(function (error) {
                $scope.status = 'Unable to load employee data: ' + error;
                console.log(error);
            });

    }

    $scope.setDropDown = function (emp) {
        for (var index in $scope.countries) {
            if ($scope.countries[index].Id == emp.CountryId) {
                emp.Country = $scope.countries[index];
                return $scope.countries[index];
            }
        }
    }

    $scope.onSubmit = function () {
        var employees = $scope.employees;
        $http.post('api/Employee/Save', employees).success(function (data, status) {
            alert(data);
        });
    }
}]);