﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace BatchEdit.Models
{
    public class Employee
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public string Address { get; set; }
        public DateTime? BirthDate { get; set; }
        public int Salary { get; set; }
        public int CountryId { get; set; }
        public Country Country { get; set; }
        
        public Employee()
        {

        }

        public Employee(string name, string address, DateTime? birthDate, int salary, int countryId)
        {
            this.Name = name;
            this.Address = address;
            this.BirthDate = birthDate;
            this.Salary = salary;
            this.CountryId = countryId;

            this.Country = MockDb.GetCountry().SingleOrDefault(x => x.Id == countryId);
        }
    }
}