﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MvcMusicStore.Models;

namespace MvcMusicStore.Repositories
{
    public class LoggingRepository 
    {
        MusicStoreEntities storeDB = new MusicStoreEntities();
        const string APPLICATION = "Music Store"; 

        // Returns the LogId
        public long LogException(Exception ex)
        {
            var sb = new StringBuilder();

            var exceptionType = ex.GetType().ToString();
            var exceptionTypeSplit = exceptionType.Split('.');
            exceptionType = exceptionTypeSplit[exceptionTypeSplit.Length - 1];

            sb.Append(exceptionType).Append(": ").Append(ex.Message);
            sb.Append(ex.StackTrace);

            var innerException = ex.InnerException;
            if (innerException != null)
            {
                var innerExType = innerException.GetType().ToString();
                var innerExTypeTypeSplit = innerExType.Split('.');
                innerExType = innerExTypeTypeSplit[innerExTypeTypeSplit.Length - 1];

                sb.Append("\r\nINNER EXCEPTION: ").Append(innerExType).Append(": ")
                    .Append(innerException.Message).Append(innerException.StackTrace);
            }
            var context = System.Web.HttpContext.Current;
            var logEntity = new Logging()
            {
                Application = APPLICATION + " " + context.Session.SessionID,
                LogType = "Exception",
                Message = sb.ToString(),
                UserId = string.IsNullOrEmpty(context.User.Identity.Name) ? "" : context.User.Identity.Name,
                CreatedDate = DateTime.Now,
            };

            try
            {
                storeDB.Loggings.Add(logEntity);
                storeDB.SaveChanges();
                return logEntity.LogId;
            }
            catch
            {
                // TODO: if Logging fails, provide an alternate mechanism for
                // documentation of that fact than through the logging mechanism.
            }
            return -1;
        }

        public long LogTrace(string message)
        {
            var context = System.Web.HttpContext.Current;
            var logEntity = new Logging()
            {
                Application = APPLICATION + " " + context.Session.SessionID,
                LogType = "Trace",
                Message = message,
                UserId = string.IsNullOrEmpty(context.User.Identity.Name) ? "" : context.User.Identity.Name,
                CreatedDate = DateTime.Now,
            };

            try
            {
                storeDB.Loggings.Add(logEntity);
                storeDB.SaveChanges();
                return logEntity.LogId;
            }
            catch
            {
                // TODO: if Logging fails, provide an alternate mechanism for
                // documentation of that fact than through the logging mechanism.
            }
            return -1;
        }




    }
}
