﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MvcMusicStore.Repositories;

namespace MvcMusicStore.Filters
{
    public class GeneralExceptionHandlerAttribute : FilterAttribute, IExceptionFilter
    {
        public void OnException(ExceptionContext filterContext)
        {
            if (!filterContext.ExceptionHandled)
            {
                var msg = new string[2];

                msg[0] = filterContext.Exception.Message;

                var logRepository = new LoggingRepository();
                var logID = logRepository.LogException(filterContext.Exception);

                HttpContext.Current.Session["CustomErrorMessage"] = msg[0];
                msg[1] = logID.ToString();

                var repository = new LoggingRepository();
                repository.LogException(filterContext.Exception);

                filterContext.Result = new ViewResult
                {
                    ViewName = "Exception",
                    ViewData = new ViewDataDictionary<string[]>(msg)
                };
                filterContext.ExceptionHandled = true;
            }
        }
    }
}