﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace RoutingTest.Models.ViewEngine
{

    /// <summary>
    /// This view engine will change
    /// </summary>
    public class CMSViewEngine : RazorViewEngine
    {
        public CMSViewEngine()
            : base()
        {
        }

        /// <summary>
        /// Creates a view by using the specified controller context and the paths of the view and master view.
        /// If the page has a sitemap node, it's Layout will be used
        /// </summary>
        /// <param name="controllerContext">The controller context.</param>
        /// <param name="viewPath">The path to the view.</param>
        /// <param name="masterPath">The path to the master view.</param>
        /// <returns>
        /// The view.
        /// </returns>
        protected override IView CreateView(ControllerContext controllerContext, string viewPath, string masterPath)
        {
            if (MvcSiteMapProvider.SiteMaps.Current.CurrentNode != null)
            {
                masterPath = MvcSiteMapProvider.SiteMaps.Current.CurrentNode.Attributes["Template"].ToString();
            }

            return base.CreateView(controllerContext, viewPath, masterPath);
        }

        protected override IView CreatePartialView(ControllerContext controllerContext, string partialPath)
        {
            return base.CreatePartialView(controllerContext, partialPath);
        }

        protected override bool FileExists(ControllerContext controllerContext, string virtualPath)
        {
            return base.FileExists(controllerContext, virtualPath);
        }
    }
}