﻿using MvcSiteMapProvider;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nFrall.Core.Web.Base.SiteMap
{
    /// <summary>
    /// A base DynamicSiteMapNode
    /// </summary>
    public class BaseSiteMapNode : DynamicNodeProviderBase
    {
        /// <summary>
        /// Gets the dynamic node collection.
        /// </summary>
        /// <param name="node">The node.</param>
        /// <returns></returns>
        public override IEnumerable<DynamicNode> GetDynamicNodeCollection(ISiteMapNode node)
        {
            return ReturnAll();
        }

        /// <summary>
        /// Returns all.
        /// </summary>
        /// <returns></returns>
        public static IEnumerable<DynamicNode> ReturnAll()
        {
            //Todo: Load From Database
            var nodes = new[] {
            new DynamicNode
            {
               Title = "Misc",
               ParentKey = "00000000-0000-0000-0000-000000000001",
               Key = "id1",
               Controller = "Page",
               Action = "Index",
               Url = "~/Misc",
               Attributes = new Dictionary<string, object>
                        {
                            {"Template", "~/Views/Shared/_LayoutBlue.cshtml"},
                        }
            }
            ,
            new DynamicNode
            {
               Title = "Help",
               ParentKey = "00000000-0000-0000-0000-000000000001",
               Key = "id2",
               Controller = "Page",
               Action = "Index",
               Url = "~/Misc/Help",
               Attributes = new Dictionary<string, object>
                        {
                            {"Template", "~/Views/Shared/_Layout.cshtml"}
                        }
            },
            new DynamicNode
            {
               Title = "Base Page",
               ParentKey = "00000000-0000-0000-0000-000000000001",
               Key = "id3",
               Controller = "Page",
               Action = "Index",
               Url = "~/Page/Index",
               Attributes = new Dictionary<string, object>
                        {
                            {"Template", "~/Views/Shared/_LayoutBlue.cshtml"}
                        },
                        
            }
         };
            nodes[0].RouteValues.Add("id", 1);
            nodes[1].RouteValues.Add("id", 2);
            nodes[2].RouteValues.Add("id", 3);
            return nodes;
        }
    }
}