<?php
/**
 * The Italian language file.
 *
 * @package    phpMyFAQ 
 * @subpackage i18n
 * @author     Stefano Bramato <stefano@pubblideaweb.it>
 * @auhtor     Rudy <webmaster@queenarena.com>
 * @author     Matteo Scaramuccia <matteo@phpmyfaq.de>
 * @since      2004-06-24
 * @version    SVN: $Id$ 
 * @copyright  (c) 2004-2014 phpMyFAQ Team
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 */

$PMF_LANG["metaCharset"] = 'UTF-8';
$PMF_LANG["metaLanguage"] = 'it';
$PMF_LANG["language"] = 'Italian';
// ltr: left to right (e.g. English language); rtl: right to left (e.g. Arabic language)
$PMF_LANG["dir"] = 'ltr';

$PMF_LANG["nplurals"] = '2';
/**
 * This parameter is used with the function 'plural' from inc/Language/Plurals.php
 * If this parameter and function are not in sync plural form support will be broken.
 */

// Navigation
$PMF_LANG["msgCategory"] = 'Categorie';
$PMF_LANG["msgShowAllCategories"] = 'Categorie';
$PMF_LANG["msgSearch"] = 'Ricerca';
$PMF_LANG["msgAddContent"] = 'Proposta FAQ';
$PMF_LANG["msgQuestion"] = 'Fai una domanda';
$PMF_LANG["msgOpenQuestions"] = 'Domande aperte';
$PMF_LANG["msgHelp"] = 'Aiuto';
$PMF_LANG["msgContact"] = 'Contatti';
$PMF_LANG["msgHome"] = 'Home';
$PMF_LANG["msgNews"] = 'FAQ-News';
$PMF_LANG["msgUserOnline"] = ' Utenti Online';
$PMF_LANG["msgXMLExport"] = 'XML-File';
$PMF_LANG["msgBack2Home"] = 'indietro alla home';

// Contentpages
$PMF_LANG["msgFullCategories"] = 'Elenco delle categorie';
$PMF_LANG["msgFullCategoriesIn"] = 'Categorie con FAQ in ';
$PMF_LANG["msgSubCategories"] = 'Sottocategorie';
$PMF_LANG["msgEntries"] = 'FAQ';
$PMF_LANG["msgEntriesIn"] = 'FAQ in ';
$PMF_LANG["msgViews"] = 'accessi';
$PMF_LANG["msgPage"] = 'Pagina ';
$PMF_LANG["msgPages"] = ' Pagine';
$PMF_LANG["msgPrevious"] = 'Precedente';
$PMF_LANG["msgNext"] = 'Successiva';
$PMF_LANG["msgCategoryUp"] = 'Una categoria sopra';
$PMF_LANG["msgLastUpdateArticle"] = 'Aggiornato il: ';
$PMF_LANG["msgAuthor"] = 'Autore: ';
$PMF_LANG["msgPrinterFriendly"] = 'Versione stampabile';
$PMF_LANG["msgPrintArticle"] = 'Stampa questa FAQ';
$PMF_LANG["msgMakeXMLExport"] = 'Esporta come file XML';
$PMF_LANG["msgAverageVote"] = 'Valutazione media:';
$PMF_LANG["msgVoteUseability"] = 'Valuta questa FAQ:';
$PMF_LANG["msgVoteFrom"] = 'su';
$PMF_LANG["msgVoteBad"] = '<em>completamente inutile</em>';
$PMF_LANG["msgVoteGood"] = '<em>di gran valore</em>';
$PMF_LANG["msgVotings"] = 'Voti';
$PMF_LANG["msgVoteSubmit"] = 'Vota';
$PMF_LANG["msgVoteThanks"] = 'Grazie per aver votato questa FAQ!';
$PMF_LANG["msgYouCan"] = 'Tu puoi: ';
$PMF_LANG["msgWriteComment"] = 'Commenta questa FAQ';
$PMF_LANG["msgShowCategory"] = 'Descrizione del contenuto: ';
$PMF_LANG["msgCommentBy"] = 'Commento di ';
$PMF_LANG["msgCommentHeader"] = 'Commenta questa FAQ';
$PMF_LANG["msgYourComment"] = 'Il tuo commento:';
$PMF_LANG["msgCommentThanks"] = 'Grazie per aver inviato il tuo commento!';
$PMF_LANG["msgSeeXMLFile"] = 'Apri il file XML';
$PMF_LANG["msgSend2Friend"] = 'Invia ad un amico';
$PMF_LANG["msgS2FName"] = 'Il tuo nome:';
$PMF_LANG["msgS2FEMail"] = 'Il tuo indirizzo e-mail:';
$PMF_LANG["msgS2FFriends"] = 'I tuoi amici:';
$PMF_LANG["msgS2FEMails"] = '. indirizzo e-mail:';
$PMF_LANG["msgS2FText"] = 'Sar&agrave; spedito il seguente testo:';
$PMF_LANG["msgS2FText2"] = 'Troverai la FAQ al seguente indirizzo:';
$PMF_LANG["msgS2FMessage"] = 'Un messaggio supplementare per i tuoi amici:';
$PMF_LANG["msgS2FButton"] = 'Invia l\'e-mail';
$PMF_LANG["msgS2FThx"] = 'Grazie per aver inviato la tua raccomandazione!';
$PMF_LANG["msgS2FMailSubject"] = 'Raccomandazione da ';

// Search
$PMF_LANG["msgSearchWord"] = 'Parola chiave';
$PMF_LANG["msgSearchFind"] = 'Cerca risultati per ';
$PMF_LANG["msgSearchAmount"] = ' risultato per la tua ricerca';
$PMF_LANG["msgSearchAmounts"] = ' risultati per la tua ricerca';
$PMF_LANG["msgSearchCategory"] = 'Categoria: ';
$PMF_LANG["msgSearchContent"] = 'Contenuto: ';

// new Content
$PMF_LANG["msgNewContentHeader"] = 'Proposta per una FAQ';
$PMF_LANG["msgNewContentAddon"] = 'La tua proposta non sar&agrave; pubblicata immediatamente ma sar&agrave; pubblicata dall\'amministratore dopo la sua validazione.<br />I campi richiesti sono il <strong>tuo Nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>categoria</strong>, il <strong>titolo</strong> e il <strong>testo</strong>.<br />Ricordati di separare le parole chiave con lo spazio.';
$PMF_LANG["msgNewContentName"] = 'Il tuo Nome:';
$PMF_LANG["msgNewContentMail"] = 'Il tuo indirizzo email:';
$PMF_LANG["msgNewContentCategory"] = 'Quale categoria vuoi scegliere?';
$PMF_LANG["msgNewContentTheme"] = 'Titolo:';
$PMF_LANG["msgNewContentArticle"] = 'La tua FAQ:';
$PMF_LANG["msgNewContentKeywords"] = 'Parole chiave:';
$PMF_LANG["msgNewContentLink"] = 'Link per questa FAQ:';
$PMF_LANG["msgNewContentSubmit"] = 'Invia';
$PMF_LANG["msgInfo"] = 'Altre informazioni: ';
$PMF_LANG["msgNewContentThanks"] = 'Grazie per aver inviato la tua proposta!';
$PMF_LANG["msgNoQuestionsAvailable"] = 'Al momento non ci sono domande.';

// ask Question
$PMF_LANG["msgNewQuestion"] = 'Scrivi la tua domanda qui sotto';
$PMF_LANG["msgAskCategory"] = 'La tua domanda &egrave; sulla categoria:';
$PMF_LANG["msgAskYourQuestion"] = 'La tua domanda:';
$PMF_LANG["msgAskThx4Mail"] = '<h2>Grazie per aver inviato la tua domanda!</h2>';
$PMF_LANG["msgDate_User"] = 'Data / Utente';
$PMF_LANG["msgQuestion2"] = 'Domanda';
$PMF_LANG["msg2answer"] = 'Rispondi';
$PMF_LANG["msgQuestionText"] = 'Qui puoi vedere le domande fatte da altri utenti. Puoi rispondere a queste domande perché la risposta potrebbe essere inserita nelle FAQ.';

// Help
$PMF_LANG["msgHelpText"] = '<p>L\'accesso alle FAQ (<strong>F</strong>requently <strong>A</strong>sked <strong>Q</strong>uestions, in italiano le <em>Domande Pi&ugrave; frequenti</em>) &egrave; semplice. Puoi effettuare ricerche tramite:<ul><li>le <strong><a href=\"?action=show\">categorie</a></strong>;</li><li>il <strong><a href=\"?action=search\">motore di ricerca</a></strong>, usando opportune parole chiave.</li></ul></p>';

// Contact
$PMF_LANG["msgContactEMail"] = 'Spedisci una email al webmaster:';
$PMF_LANG["msgMessage"] = 'Il tuo messaggio:';

// Startseite
$PMF_LANG["msgNews"] = ' News';
$PMF_LANG["msgTopTen"] = 'TOP 10';
$PMF_LANG["msgHomeThereAre"] = 'Ci sono ';
$PMF_LANG["msgHomeArticlesOnline"] = ' FAQ disponibili';
$PMF_LANG["msgNoNews"] = 'Non ci sono news disponibili.';
$PMF_LANG["msgLatestArticles"] = 'Le ultime 5 FAQ pubblicate';

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = 'Grazie per la tua proposta per una nuova FAQ.';
$PMF_LANG["msgMailCheck"] = 'C\'&egrave; una nuova proposta per una FAQ!Per cortesia controlla la sezione \'Amministrazione\'.';
$PMF_LANG["msgMailContact"] = 'Il tuo messaggio &egrave; stato spedito all\'amministratore.';

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = 'Nessuna connessione al database disponibile.';
$PMF_LANG["err_noHeaders"] = 'Nessuna categoria trovata.';
$PMF_LANG["err_noArticles"] = '<p>Nessuna FAQ trovata.</p>';
$PMF_LANG["err_badID"] = '<p>ID sbagliato.</p>';
$PMF_LANG["err_noTopTen"] = '<p>Nessuna FAQ ancora disponibile.</p>';
$PMF_LANG["err_nothingFound"] = '<p>Nessun informazione trovata.</p>';
$PMF_LANG["err_SaveEntries"] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>categoria</strong>, il <strong>titolo</strong>, il <strong>testo</strong> e, quando richiesto, il <strong>codice <a href=\"http://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br />Per favore controlla i dati immessi.<br /><br /><a href=\"javascript:history.back();\">Una pagina indietro</a><br /><br />';
$PMF_LANG["err_SaveComment"] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, il <strong>tuo commento</strong> e, quando richiesto, il <strong>codice <a href=\"http://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br />Per favore controlla i dati immessi.<br /><br /><a href=\"javascript:history.back();\">Una pagina indietro</a><br /><br />';
$PMF_LANG["err_VoteTooMuch"] = '<p>Attenzione, hai gi&agrave votato: non registriamo votazioni multiple nella stessa sessione. Riprova pi&ugrave tardi.<br /><a href=\"javascript:history.back();\">Clicca qui</a>, per tornare indietro.</p>';
$PMF_LANG["err_noVote"] = '<p><strong>Non hai votato!</strong> <a href=\"javascript:history.back();\">Per cortesia clicca qui</a>, per votare.</p>';
$PMF_LANG["err_noMailAdress"] = 'Il tuo indirizzo email non &egrave; corretto.<br /><a href=\"javascript:history.back();\">indietro</a>';
$PMF_LANG["err_sendMail"] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, gli <strong>indirizzi dei destinatari</strong> e, quando richiesto, il <strong>codice <a href=\"http://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br />Per favore controlla i dati immessi.';

// Hilfe zur Suche
$PMF_LANG["help_search"] = '<p><strong>Cerca nelle FAQ</strong>: usando un criterio come \"<strong style=\"font-style: italic; color: Red;\">parola1 parola2</strong>\" puoi fare una ricerca ordinata per importanza per due (o piu\') chiavi di ricerca.</p><p><strong>Nota:</strong> la tua chiave deve essere composta da almeno 4 caratteri altrimenti potrebbe non essere accettata.</p>';

// Men&uuml;
$PMF_LANG["ad"] = 'SEZIONE AMMINISTRAZIONE';
$PMF_LANG["ad_menu_user_administration"] = 'Amministrazione <em>Utenti</em>';
$PMF_LANG["ad_menu_entry_aprove"] = 'Approva <em>FAQ</em>';
$PMF_LANG["ad_menu_entry_edit"] = 'Modifica <em>FAQ</em>';
$PMF_LANG["ad_menu_categ_add"] = 'Aggiungi <em>Categoria</em>';
$PMF_LANG["ad_menu_categ_edit"] = 'Modifica <em>Categorie</em>';
$PMF_LANG["ad_menu_news_add"] = 'Aggiungi <em>News</em>';
$PMF_LANG["ad_menu_news_edit"] = 'Modifica <em>News</em>';
$PMF_LANG["ad_menu_open"] = 'Modifica <em>Domande aperte</em>';
$PMF_LANG["ad_menu_stat"] = 'Statistiche';
$PMF_LANG["ad_menu_cookie"] = 'Gestione del <em>Cookie</em>';
$PMF_LANG["ad_menu_session"] = 'Vedi <em>Sessioni</em>';
$PMF_LANG["ad_menu_adminlog"] = 'Vedi <em>Log Amministrazione</em>';
$PMF_LANG["ad_menu_passwd"] = 'Cambia la <em>tua password</em>';
$PMF_LANG["ad_menu_logout"] = 'Esci';
$PMF_LANG["ad_menu_startpage"] = 'Pagina iniziale';

// Nachrichten
$PMF_LANG["ad_msg_identify"] = 'Per cortesia identificati.';
$PMF_LANG["ad_msg_passmatch"] = 'Entrambe le password devono <strong>corrispondere</strong>!';
$PMF_LANG["ad_msg_savedsuc_1"] = 'Il profilo di';
$PMF_LANG["ad_msg_savedsuc_2"] = '&egrave; stato salvato con successo.';
$PMF_LANG["ad_msg_mysqlerr"] = 'A causa di un <strong>errore del database</strong> il profilo potrebbe non essere stato salvato.';
$PMF_LANG["ad_msg_noauth"] = 'Non sei autorizzato.';

// Allgemein
$PMF_LANG["ad_gen_page"] = 'Pagina';
$PMF_LANG["ad_gen_of"] = 'di';
$PMF_LANG["ad_gen_lastpage"] = 'Pagina precedente';
$PMF_LANG["ad_gen_nextpage"] = 'Pagina successiva';
$PMF_LANG["ad_gen_save"] = 'Salva';
$PMF_LANG["ad_gen_reset"] = 'Reimposta';
$PMF_LANG["ad_gen_yes"] = 'Si';
$PMF_LANG["ad_gen_no"] = 'No';
$PMF_LANG["ad_gen_top"] = 'Inizio della pagina';
$PMF_LANG["ad_gen_ncf"] = 'Nessuna categoria trovata!';
$PMF_LANG["ad_gen_delete"] = 'Cancella';

// Benutzerverwaltung
$PMF_LANG["ad_user"] = 'Amministrazione utenti';
$PMF_LANG["ad_user_username"] = 'Utenti registrati';
$PMF_LANG["ad_user_rights"] = 'Diritti utenti';
$PMF_LANG["ad_user_edit"] = 'Modifica';
$PMF_LANG["ad_user_delete"] = 'Cancella';
$PMF_LANG["ad_user_add"] = 'Aggiungi utente';
$PMF_LANG["ad_user_profou"] = 'Profilo dell\'utente';
$PMF_LANG["ad_user_name"] = 'Nome (<em>username</em>)';
$PMF_LANG["ad_user_password"] = 'Password';
$PMF_LANG["ad_user_confirm"] = 'Conferma password';
$PMF_LANG["ad_user_rights"] = 'Diritti';
$PMF_LANG["ad_user_del_1"] = 'L\'utente';
$PMF_LANG["ad_user_del_2"] = 'sta per essere cancellato?';
$PMF_LANG["ad_user_del_3"] = 'Sei sicuro?';
$PMF_LANG["ad_user_deleted"] = 'Utente cancellato con successo.';
$PMF_LANG["ad_user_checkall"] = 'Seleziona tutto';

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = 'Gestione delle FAQ';
$PMF_LANG["ad_entry_id"] = 'ID';
$PMF_LANG["ad_entry_topic"] = 'Titolo';
$PMF_LANG["ad_entry_action"] = 'Azione';
$PMF_LANG["ad_entry_edit_1"] = 'Modifica FAQ';
$PMF_LANG["ad_entry_edit_2"] = '';
$PMF_LANG["ad_entry_theme"] = 'Tema:';
$PMF_LANG["ad_entry_content"] = 'Contenuto:';
$PMF_LANG["ad_entry_keywords"] = 'Parole chiave:';
$PMF_LANG["ad_entry_author"] = 'Autore:';
$PMF_LANG["ad_entry_category"] = 'Categoria:';
$PMF_LANG["ad_entry_active"] = 'Attivo?';
$PMF_LANG["ad_entry_date"] = 'Data:';
$PMF_LANG["ad_entry_changed"] = 'Motivo della modifica:';
$PMF_LANG["ad_entry_changelog"] = 'Diario delle variazioni:';
$PMF_LANG["ad_entry_commentby"] = 'Commentato da';
$PMF_LANG["ad_entry_comment"] = 'Commenti:';
$PMF_LANG["ad_entry_save"] = 'Salva';
$PMF_LANG["ad_entry_delete"] = 'Cancella';
$PMF_LANG["ad_entry_delcom_1"] = 'Sei sicuro che il commento dell\'utente';
$PMF_LANG["ad_entry_delcom_2"] = 'debba essere cancellato?';
$PMF_LANG["ad_entry_commentdelsuc"] = 'Il commento &egrave; stato cancellato <strong>con successo</strong>.';
$PMF_LANG["ad_entry_back"] = 'Torna alla FAQ';
$PMF_LANG["ad_entry_commentdelfail"] = 'Il commento <strong>non</strong> &egrave; stato cancellato.';
$PMF_LANG["ad_entry_savedsuc"] = 'Le modifiche sono state salvate con <strong>successo</strong>.';
$PMF_LANG["ad_entry_savedfail"] = 'Purtroppo c\'&egrave; stato un <strong>errore con il database</strong>.';
$PMF_LANG["ad_entry_del_1"] = 'Vuoi veramente che la FAQ';
$PMF_LANG["ad_entry_del_2"] = 'di ';
$PMF_LANG["ad_entry_del_3"] = ' venga cancellata?';
$PMF_LANG["ad_entry_delsuc"] = 'Pubblicazione cancellata con <strong>successo</strong>.';
$PMF_LANG["ad_entry_delfail"] = 'La publicazione <strong>non</strong> &egrave; stata cancellata!';
$PMF_LANG["ad_entry_back"] = 'Indietro';


// Newsverwaltung
$PMF_LANG["ad_news_header"] = 'Titolo:';
$PMF_LANG["ad_news_text"] = 'Testo:';
$PMF_LANG["ad_news_link_url"] = 'Link (<strong>senza <em>http://</em></strong>):';
$PMF_LANG["ad_news_link_title"] = 'Titolo del link:';
$PMF_LANG["ad_news_link_target"] = 'Target del link:';
$PMF_LANG["ad_news_link_window"] = 'Il link apre una nuova finestra';
$PMF_LANG["ad_news_link_faq"] = 'Il link si apre nella stessa finestra';
$PMF_LANG["ad_news_add"] = 'Aggiungi news';
$PMF_LANG["ad_news_id"] = '#';
$PMF_LANG["ad_news_headline"] = 'Titolo';
$PMF_LANG["ad_news_date"] = 'Data';
$PMF_LANG["ad_news_action"] = 'Azione';
$PMF_LANG["ad_news_update"] = 'Aggiorna';
$PMF_LANG["ad_news_delete"] = 'Cancella';
$PMF_LANG["ad_news_nodata"] = 'Nessuna informazione trovata nel database';
$PMF_LANG["ad_news_updatesuc"] = 'Le News sono state aggiornate.';
$PMF_LANG["ad_news_del"] = 'Sei sicuro di voler cancellare questa news?';
$PMF_LANG["ad_news_yesdelete"] = 'Si, cancella!';
$PMF_LANG["ad_news_nodelete"] = 'No, non cancellare!';
$PMF_LANG["ad_news_delsuc"] = 'News cancellata.';
$PMF_LANG["ad_news_updatenews"] = 'Aggiorna news';

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = 'Aggiungi una nuova categoria';
$PMF_LANG["ad_categ_catnum"] = 'Numero della categoria:';
$PMF_LANG["ad_categ_subcatnum"] = 'Numero Sottocategoria:';
$PMF_LANG["ad_categ_nya"] = '<em>non ancora disponibile!</em>';
$PMF_LANG["ad_categ_titel"] = 'Titolo della categoria:';
$PMF_LANG["ad_categ_add"] = 'Aggiungi una nuova categoria';
$PMF_LANG["ad_categ_existing"] = 'Categorie esistenti';
$PMF_LANG["ad_categ_id"] = '#';
$PMF_LANG["ad_categ_categ"] = 'Categoria';
$PMF_LANG["ad_categ_subcateg"] = 'Sottocategoria';
$PMF_LANG["ad_categ_titel"] = 'Titolo della categoria';
$PMF_LANG["ad_categ_action"] = 'Azione';
$PMF_LANG["ad_categ_update"] = 'Aggiorna';
$PMF_LANG["ad_categ_delete"] = 'Cancella';
$PMF_LANG["ad_categ_updatecateg"] = 'Aggiorna questa categoria';
$PMF_LANG["ad_categ_nodata"] = 'Nessuna informazione trovata nel database';
$PMF_LANG["ad_categ_remark"] = 'Ricorda che se cancelli una categoria, tutte le FAQ appartenenti a quella categoria <strong>non saranno pi&ugrave; visibili</strong>. Per renderle nuovamente visibili, devi riassegnarle ad una nuova categoria.';
$PMF_LANG["ad_categ_edit_1"] = 'Modifica';
$PMF_LANG["ad_categ_edit_2"] = 'Categoria';
$PMF_LANG["ad_categ_add"] = 'Aggiungi una nuova categoria';
$PMF_LANG["ad_categ_added"] = 'La categoria &egrave; stata aggiunta.';
$PMF_LANG["ad_categ_updated"] = 'La categoria &egrave; stata aggiornata.';
$PMF_LANG["ad_categ_del_yes"] = 'Si, cancella!';
$PMF_LANG["ad_categ_del_no"] = 'No, non cancellare!';
$PMF_LANG["ad_categ_deletesure"] = 'Sei sicuro di voler cancellare questa categoria?';
$PMF_LANG["ad_categ_deleted"] = 'Categoria cancellata.';

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = 'Il cookie &egrave; stato registrato con <strong>successo</strong>.';
$PMF_LANG["ad_cookie_already"] = 'Il cookie esiste gi&agrave;. Hai le seguenti opzioni:';
$PMF_LANG["ad_cookie_again"] = 'Registra il cookie nuovamente';
$PMF_LANG["ad_cookie_delete"] = 'Cancella il cookie';
$PMF_LANG["ad_cookie_no"] = 'Il cookie con le tue attuali credenziali non &egrave; stato ancora registrato. Con questo cookie puoi salvare i tuoi dati di accesso, in modo da non doverli ricordare per il prossimo accesso. Hai le seguenti opzioni:';
$PMF_LANG["ad_cookie_set"] = 'Registra il cookie';
$PMF_LANG["ad_cookie_deleted"] = 'Cookie rimosso con successo.';

// Adminlog
$PMF_LANG["ad_adminlog"] = '<em>Log</em> Amministrazione';

// Passwd
$PMF_LANG["ad_passwd_cop"] = 'Cambia la tua password';
$PMF_LANG["ad_passwd_old"] = 'Vecchia password:';
$PMF_LANG["ad_passwd_new"] = 'Nuova password:';
$PMF_LANG["ad_passwd_con"] = 'Conferma la nuova password:';
$PMF_LANG["ad_passwd_change"] = 'Modifica la tua password';
$PMF_LANG["ad_passwd_suc"] = 'Password modificata con successo.';
$PMF_LANG["ad_passwd_remark"] = '<strong>ATTENZIONE:</strong><br />Il cookie deve essere nuovamente registrato!';
$PMF_LANG["ad_passwd_fail"] = 'La vecchia password <strong>deve essere inserita correttamente</strong> e la nuova password <strong>deve corrispondere</strong> con quella digitata per conferma.';

// Adduser
$PMF_LANG["ad_adus_adduser"] = 'Aggiungi utente';
$PMF_LANG["ad_adus_name"] = 'Nome:';
$PMF_LANG["ad_adus_password"] = 'Password:';
$PMF_LANG["ad_adus_add"] = 'Aggiungi user';
$PMF_LANG["ad_adus_suc"] = 'Utente aggiunto con <strong>successo</strong>.';
$PMF_LANG["ad_adus_edit"] = 'Modifica profilo';
$PMF_LANG["ad_adus_dberr"] = '<strong>errore con il database!</strong>';
$PMF_LANG["ad_adus_exerr"] = 'Username <strong>gi&agrave; esistente</strong>.';

// Sessions
$PMF_LANG["ad_sess_id"] = 'ID';
$PMF_LANG["ad_sess_sid"] = 'ID di sessione';
$PMF_LANG["ad_sess_ip"] = 'IP';
$PMF_LANG["ad_sess_time"] = 'Tempo';
$PMF_LANG["ad_sess_pageviews"] = 'VistaPagine';
$PMF_LANG["ad_sess_search"] = 'Cerca';
$PMF_LANG["ad_sess_sfs"] = 'Cerca per sessioni';
$PMF_LANG["ad_sess_s_ip"] = 'IP:';
$PMF_LANG["ad_sess_s_minct"] = 'min. azioni:';
$PMF_LANG["ad_sess_s_date"] = 'Data';
$PMF_LANG["ad_sess_s_after"] = 'dopo';
$PMF_LANG["ad_sess_s_before"] = 'prima';
$PMF_LANG["ad_sess_s_search"] = 'Cerca';
$PMF_LANG["ad_sess_session"] = 'Sessione';
$PMF_LANG["ad_sess_r"] = 'Cerca risultati per';
$PMF_LANG["ad_sess_referer"] = 'Referer:';
$PMF_LANG["ad_sess_browser"] = 'Browser:';
$PMF_LANG["ad_sess_ai_rubrik"] = 'Categoria:';
$PMF_LANG["ad_sess_ai_artikel"] = 'FAQ:';
$PMF_LANG["ad_sess_ai_sb"] = 'Stringhe di ricerca:';
$PMF_LANG["ad_sess_ai_sid"] = 'ID di sessione:';
$PMF_LANG["ad_sess_back"] = 'Indietro';

// Statistik
$PMF_LANG["ad_rs"] = 'Statistica delle Valutazioni';
$PMF_LANG["ad_rs_rating_1"] = 'La classifica di';
$PMF_LANG["ad_rs_rating_2"] = 'Mostra utenti:';
$PMF_LANG["ad_rs_red"] = 'Rosso';
$PMF_LANG["ad_rs_green"] = 'Verde';
$PMF_LANG["ad_rs_altt"] = 'con una media piu bassa di 20%';
$PMF_LANG["ad_rs_ahtf"] = 'con una media piu alta di 80%';
$PMF_LANG["ad_rs_no"] = 'Nessuna statistica disponibile';

// Auth
$PMF_LANG["ad_auth_insert"] = 'Inserisci le tue credenziali: <em>username</em> e <em>password</em>.';
$PMF_LANG["ad_auth_user"] = 'Pseudonimo:';
$PMF_LANG["ad_auth_passwd"] = 'Password:';
$PMF_LANG["ad_auth_ok"] = 'OK';
$PMF_LANG["ad_auth_reset"] = 'Reimposta';
$PMF_LANG["ad_auth_fail"] = 'Credenziali non valide.';
$PMF_LANG["ad_auth_sess"] = 'Sessione scaduta.';

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = 'Modifica la configurazione';
$PMF_LANG["ad_config_save"] = 'Salva la configurazione';
$PMF_LANG["ad_config_reset"] = 'Reimposta';
$PMF_LANG["ad_config_saved"] = 'La configurazione &egrave; stata salvata con successo.';
$PMF_LANG["ad_menu_editconfig"] = 'Modifica la <em>configurazione</em>';
$PMF_LANG["ad_att_none"] = 'Nessun allegato disponibile';
$PMF_LANG["ad_att_att"] = 'Allegati:';
$PMF_LANG["ad_att_add"] = 'Allega file';
$PMF_LANG["ad_entryins_suc"] = 'FAQ salvata con successo.';
$PMF_LANG["ad_entryins_fail"] = 'FAQ non salvata: si &egrave; verificato un errore.';
$PMF_LANG["ad_att_del"] = 'Cancella';
$PMF_LANG["ad_att_nope"] = 'Si possono aggiungere allegati solo durante la modifica.';
$PMF_LANG["ad_att_delsuc"] = 'L\'allegato &egrave; stato cancellato con successo.';
$PMF_LANG["ad_att_delfail"] = 'C\'&egrave; stato un errore durante la cancellazione dell\'allegato.';
$PMF_LANG["ad_entry_add"] = 'Crea <em>FAQ</em>';

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = 'Un backup &egrave; una immagine completa del contenuto del database. Il formato del backup &egrave; un file di transazione SQL, che pu&ograve; essere importato tramite programmi come phpMyAdmin o client SQL a linea di comando.<br /><em>Suggerimento:</em> un backup dovrebbe essere fatto <strong>almeno</strong> una volta al mese (la decisione dipende anche dalla dinamicit&agrave; delle FAQ).';
$PMF_LANG["ad_csv_link"] = 'Scarica il backup';
$PMF_LANG["ad_csv_head"] = 'Crea un backup';
$PMF_LANG["ad_att_addto"] = 'Aggiungi un allegato al documento corrente';
$PMF_LANG["ad_att_addto_2"] = '';
$PMF_LANG["ad_att_att"] = 'File:';
$PMF_LANG["ad_att_butt"] = 'OK';
$PMF_LANG["ad_att_suc"] = 'Il file &egrave; stato allegato con successo';
$PMF_LANG["ad_att_fail"] = 'C\'&egrave; stato un errore nell\'allegare il file.';
$PMF_LANG["ad_att_close"] = 'Chiudi questa finestra';

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = 'Usando questo modulo puoi ripristinare il contenuto del database, usando un backup <strong>creato da phpMyFAQ</strong>. Attenzione: il database esistente verr&agrave; <strong>SOVRASCRITTO</strong>, con la conseguente perdit&agrave; totale dei dati attuali!';
$PMF_LANG["ad_csv_file"] = 'File';
$PMF_LANG["ad_csv_ok"] = 'OK';
$PMF_LANG["ad_csv_linklog"] = 'Crea un backup dei <em>LOG</em>';
$PMF_LANG["ad_csv_linkdat"] = 'Crea un backup delle <em>FAQ</em>';
$PMF_LANG["ad_csv_head2"] = 'Ripristina un precedente backup';
$PMF_LANG["ad_csv_no"] = 'Questo file non sembra essere un backup di phpMyFAQ.';
$PMF_LANG["ad_csv_prepare"] = 'Sto preparando le queries al database...';
$PMF_LANG["ad_csv_process"] = 'Querying...';
$PMF_LANG["ad_csv_of"] = 'di';
$PMF_LANG["ad_csv_suc"] = 'sono andate a buon fine.';
$PMF_LANG["ad_csv_backup"] = 'Backup';
$PMF_LANG["ad_csv_rest"] = 'Ripristina un precedente backup';

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = 'Gestione del <em>Backup</em>';
$PMF_LANG["ad_logout"] = 'Sessione terminata con successo.';
$PMF_LANG["ad_news_add"] = 'Aggiungi news';
$PMF_LANG["ad_news_edit"] = 'Modifica news';
$PMF_LANG["ad_cookie"] = 'Memorizza le tue credenziali di accesso in un cookie';
$PMF_LANG["ad_sess_head"] = 'Visualizza le Sessioni';

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = 'Amministrazione delle <em>Categorie</em>';
$PMF_LANG["ad_menu_stat"] = 'Statistica delle <em>Valutazioni</em>';
$PMF_LANG["ad_kateg_add"] = 'Aggiungi una nuova categoria';
$PMF_LANG["ad_kateg_rename"] = 'Rinomina';
$PMF_LANG["ad_adminlog_date"] = 'Data';
$PMF_LANG["ad_adminlog_user"] = 'Utente';
$PMF_LANG["ad_adminlog_ip"] = 'Indirizzo IP';

$PMF_LANG["ad_stat_sess"] = 'Sessioni';
$PMF_LANG["ad_stat_days"] = 'Giorni';
$PMF_LANG["ad_stat_vis"] = 'Sessioni (Accessi)';
$PMF_LANG["ad_stat_vpd"] = 'Accessi per Giorno';
$PMF_LANG["ad_stat_fien"] = 'Primo Log';
$PMF_LANG["ad_stat_laen"] = 'Ultimo Log';
$PMF_LANG["ad_stat_browse"] = 'Naviga Sessioni';
$PMF_LANG["ad_stat_ok"] = 'OK';

$PMF_LANG["ad_sess_time"] = 'Tempo';
$PMF_LANG["ad_sess_sid"] = 'ID Sessione';
$PMF_LANG["ad_sess_ip"] = 'Indirizzo IP';

$PMF_LANG["ad_ques_take"] = 'Apri la domanda e modificala';
$PMF_LANG["no_cats"] = 'Nessuna categoria trovata!';

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = 'Credenziali non valide.';
$PMF_LANG["ad_log_sess"] = 'Sessione scaduta.';
$PMF_LANG["ad_log_edit"] = 'Form \"Modifica Utente\", per il seguente utente: ';
$PMF_LANG["ad_log_crea"] = 'Form \"Nuova FAQ\".';
$PMF_LANG["ad_log_crsa"] = 'Creato un nuovo elemento.';
$PMF_LANG["ad_log_ussa"] = 'Aggiornati i dati per il seguente utente: ';
$PMF_LANG["ad_log_usde"] = 'Cancellato il seguente utente: ';
$PMF_LANG["ad_log_beed"] = 'Form di modifica per il seguente utente: ';
$PMF_LANG["ad_log_bede"] = 'Cancella il seguente elemento: ';

$PMF_LANG["ad_start_visits"] = 'Accessi';
$PMF_LANG["ad_start_articles"] = 'FAQ';
$PMF_LANG["ad_start_comments"] = 'Commenti';


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = 'Incolla';
$PMF_LANG["ad_categ_cut"] = 'Taglia';
$PMF_LANG["ad_categ_copy"] = 'Copia';
$PMF_LANG["ad_categ_process"] = 'Sto processando le categorie...';

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = '<strong>Non sei autorizzato.</strong>';

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = 'Pagina precedente';
$PMF_LANG["msgNextPage"] = 'Pagina successiva';
$PMF_LANG["msgPageDoublePoint"] = 'Pagina: ';
$PMF_LANG["msgMainCategory"] = 'Categoria principale';

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = 'La tua password &egrave; stata cambiata.';

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = 'Mostra come file PDF';
$PMF_LANG["ad_xml_head"] = 'XML-Backup';
$PMF_LANG["ad_xml_hint"] = 'Salva tutti i <em>record</em> delle tue FAQ in un unico file XML.';
$PMF_LANG["ad_xml_gen"] = 'Crea il file XML';
$PMF_LANG["ad_entry_locale"] = 'Lingua';
$PMF_LANG["msgLangaugeSubmit"] = 'Cambia lingua';

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = 'Anteprima';
$PMF_LANG["ad_attach_1"] = 'Scegli una cartella per gli allegati innanzitutto nella configurazione.';
$PMF_LANG["ad_attach_2"] = 'Scegli un link per gli allegati innanzitutto nella configurazione.';
$PMF_LANG["ad_attach_3"] = 'Il file <em>attachment.php</em> non pu&ograve; essere aperto senza una autenticazione.';
$PMF_LANG["ad_attach_4"] = 'Il file in allegato non deve essere pi&ugrave; grande di %s Bytes.';
$PMF_LANG["ad_menu_export"] = 'Esporta le <em>FAQ</em>';
$PMF_LANG["ad_export_1"] = 'Costruisci un Feed RSS';
$PMF_LANG["ad_export_2"] = '.';
$PMF_LANG["ad_export_file"] = 'Errore: non posso scrivere il file.';
$PMF_LANG["ad_export_news"] = 'News RSS-Feed';
$PMF_LANG["ad_export_topten"] = 'Top 10 RSS-Feed';
$PMF_LANG["ad_export_latest"] = '5 ultimi record RSS-Feed';
$PMF_LANG["ad_export_pdf"] = 'Esporta tutte le FAQ in un unico file PDF';
$PMF_LANG["ad_export_generate"] = 'Costruisci RSS-Feed';

$PMF_LANG["rightsLanguage"]["adduser"] = 'Aggiunge utenti';
$PMF_LANG["rightsLanguage"]["edituser"] = 'Modifica utenti';
$PMF_LANG["rightsLanguage"]["deluser"] = 'Cancella utenti';
$PMF_LANG["rightsLanguage"]["addbt"] = 'Aggiunge FAQ';
$PMF_LANG["rightsLanguage"]["editbt"] = 'Modifica FAQ';
$PMF_LANG["rightsLanguage"]["delbt"] = 'Cancella FAQ';
$PMF_LANG["rightsLanguage"]["viewlog"] = 'Vede il diario delle sessioni utente';
$PMF_LANG["rightsLanguage"]["adminlog"] = 'Vede il diario delle sessioni amministrative';
$PMF_LANG["rightsLanguage"]["delcomment"] = 'Cancella commenti';
$PMF_LANG["rightsLanguage"]["addnews"] = 'Aggiunge news';
$PMF_LANG["rightsLanguage"]["editnews"] = 'Modifica news';
$PMF_LANG["rightsLanguage"]["delnews"] = 'Cancella news';
$PMF_LANG["rightsLanguage"]["addcateg"] = 'Aggiunge categorie';
$PMF_LANG["rightsLanguage"]["editcateg"] = 'Modifica categorie';
$PMF_LANG["rightsLanguage"]["delcateg"] = 'Cancella categorie';
$PMF_LANG["rightsLanguage"]["passwd"] = 'Cambia password';
$PMF_LANG["rightsLanguage"]["editconfig"] = 'Modifica la configurazione';
$PMF_LANG["rightsLanguage"]["addatt"] = 'Aggiunge allegati';
$PMF_LANG["rightsLanguage"]["delatt"] = 'Cancella allegati';
$PMF_LANG["rightsLanguage"]["backup"] = 'Crea backup';
$PMF_LANG["rightsLanguage"]["restore"] = 'Ripristina backup';
$PMF_LANG["rightsLanguage"]["delquestion"] = 'Cancella domande aperte';
$PMF_LANG["rightsLanguage"]["changebtrevs"] = 'Modifica revisioni';

$PMF_LANG["msgAttachedFiles"] = 'Files allegati:';

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = 'Azione';
$PMF_LANG["ad_entry_email"] = 'Indirizzo email:';
$PMF_LANG["ad_entry_allowComments"] = 'Permetti commenti:';
$PMF_LANG["msgWriteNoComment"] = 'Non puoi commentare questa FAQ';
$PMF_LANG["ad_user_realname"] = 'Vero nome:';
$PMF_LANG["ad_export_generate_pdf"] = 'Crea il file PDF';
$PMF_LANG["ad_export_full_faq"] = 'Ecco le tue FAQ in un unico file PDF: ';
$PMF_LANG["err_bannedIP"] = '&Egrave; stato vietato l\'accesso al tuo indirizzo IP.';
$PMF_LANG["err_SaveQuestion"] = 'I campi richiesti sono il <strong>tuo nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>tua domanda</strong> e, quando richiesto, il <strong>codice <a href=\"http://it.wikipedia.org/wiki/Captcha\" title=\"Vai alla definizione di Wikipedia\" target=\"_blank\">captcha</a> corretto</strong>!<br />Per favore controlla i dati immessi.<br /><br /><a href=\"javascript:history.back();\">Una pagina indietro</a><br /><br />';

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = 'Colore del carattere: ';
$PMF_LANG["ad_entry_fontsize"] = 'Dimensione del carattere: ';

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF["main.language"] = array(0 => "select", 1 => "File di lingua");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "Abilita la <em>automatic content negotiation</em>");
$LANG_CONF["main.titleFAQ"] = array(0 => "input", 1 => "Titolo del sistema");
$LANG_CONF["main.currentVersion"] = array(0 => "print", 1 => "Versione di phpMyFAQ");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "Descrizione della pagina");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "Keywords per gli Spiders");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "Nome dell'Editore");
$LANG_CONF["main.administrationMail"] = array(0 => "input", 1 => "Indirizzo email dell'Amministratore");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "Testo per la pagina dei <em>Contatti</em>");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "Testo per la pagina <em>Invia ad un amico</em>");
$LANG_CONF["records.maxAttachmentSize"] = array(0 => "input", 1 => "Massima dimensione per gli allegati, in Bytes (max. %sByte)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "Mostra il link agli allegati");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "Abilito il tracciamento per le attivit&agrave; dell'Utente?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "Abilito il tracciamento per le attivit&agrave; di Amministrazione?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "Vuoi controllare l'IP quando verifico l'<em>UIN</em> in <em>admin.php</em>?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "Numero di elementi visualizzati per pagina");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "Numero di elementi visualizzati per la sezione News");
$LANG_CONF["security.bannedIPs"] = array(0 => "area", 1 => "Vieta l'accesso a questi indirizzi IP");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "Attivare il supporto a <em>mod_rewrite</em>? (predefinito: disabilitato)");
$LANG_CONF["security.ldapSupport"] = array(0 => "checkbox", 1 => "Attivare il supporto LDAP? (predefinito: disabilitato)");
$LANG_CONF["main.referenceURL"] = array(0 => "input", 1 => "<em>Base URL</em> dell'installazione di phpMyFAQ, es: http://www.example.org/faq (&egrave; necessaria per la verifica dei links)");
$LANG_CONF["main.urlValidateInterval"] = array(0 => "input", 1 => "Intervallo della verifica asincrona dei links (in secondi)");
$LANG_CONF["records.enableVisibilityQuestions"] = array(0 => "checkbox", 1 => "Disabilitare la visibilit&agrave; delle domande appena inserite?");
$LANG_CONF["security.permLevel"] = array(0 => "select", 1 => "Configurazione della Permessistica");

$PMF_LANG["ad_categ_new_main_cat"] = 'come nuova categoria principale';
$PMF_LANG["ad_categ_paste_error"] = 'Non &egrave; possibile spostare questa categoria.';
$PMF_LANG["ad_categ_move"] = 'Sposta';
$PMF_LANG["ad_categ_lang"] = 'Lingua';
$PMF_LANG["ad_categ_desc"] = 'Descrizione';
$PMF_LANG["ad_categ_change"] = 'Cambia con';

$PMF_LANG["lostPassword"] = 'Hai dimenticato la password? Clicca qui.';
$PMF_LANG["lostpwd_err_1"] = 'Errore: <em>Utente</em> e <em>Indirizzo e-mail</em> non trovati.';
$PMF_LANG["lostpwd_err_2"] = 'Errore: i dati inseriti sono sbagliati!';
$PMF_LANG["lostpwd_text_1"] = 'Grazie per aver richiesto i tuoi dati.';
$PMF_LANG["lostpwd_text_2"] = 'Per cortesia crea una nuova password personale nella sezione amministrativa delle FAQ.';
$PMF_LANG["lostpwd_mail_okay"] = 'L\'e-mail &egrave; stata inviata.';

$PMF_LANG["ad_xmlrpc_button"] = 'Controlla quale sia l\'ultima versione stabile di phpMyFAQ';
$PMF_LANG["ad_xmlrpc_latest"] = 'Questa &egrave; l\'ultima versione disponibile presso';

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG["ad_categ_select"] = 'Selezione la lingua della categoria';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG["msgSitemap"] = 'Mappa sito';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG["err_inactiveArticle"] = 'Questa FAQ &egrave; in revisione e non pu&ograve; essere visualizzata.';
$PMF_LANG["msgArticleCategories"] = 'Categorie per questa FAQ';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG["ad_entry_solution_id"] = 'ID univoco';
$PMF_LANG["ad_entry_faq_record"] = 'Dati della FAQ';
$PMF_LANG["ad_entry_new_revision"] = 'Vuoi creare una nuova versione?';
$PMF_LANG["ad_entry_record_administration"] = 'Gestione della FAQ';
$PMF_LANG["ad_entry_changelog"] = 'Diario delle variazioni';
$PMF_LANG["ad_entry_revision"] = 'Versione';
$PMF_LANG["ad_changerev"] = 'Seleziona la versione';
$PMF_LANG["msgCaptcha"] = 'Scrivi le lettere e i numeri che leggi nella immagine';
$PMF_LANG["msgSelectCategories"] = 'Cerca in: ';
$PMF_LANG["msgAllCategories"] = 'Tutte le categorie';
$PMF_LANG["ad_you_should_update"] = 'La tua installazione di phpMyFAQ non &egrave; aggiornata. Dovresti aggiornarla all\'ultima versione disponibile.';
$PMF_LANG["msgAdvancedSearch"] = 'Ricerca avanzata';

// added v1.6.1 - 2006-04-25 by Matteo and Thorsten
$PMF_LANG["spamControlCenter"] = 'Centro di controllo contro lo Spam';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => 'checkbox', 1 => 'Stampa l\'email dell\'utente in maniera sicura (predefinito: abilitato).');
$LANG_CONF["spam.checkBannedWords"] = array(0 => 'checkbox', 1 => 'Controlla se il testo delle form pubbliche contenga parole vietate (predefinito: abilitato).');
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => 'checkbox', 1 => 'Usa un codice <a href="http://it.wikipedia.org/wiki/Captcha" title="Vai alla definizione di Wikipedia" target="_blank">captcha</a> per permettere la sottomissione delle form pubbliche (predefinito: abilitato).');
$PMF_LANG["ad_session_expiring"] = 'Questa sessione scadrà tra %d minuti: vuoi continuare a lavorare?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG["ad_stat_management"] = 'Gestione delle sessioni';
$PMF_LANG["ad_stat_choose"] = 'Scegli il mese';
$PMF_LANG["ad_stat_delete"] = 'Cancella immediatamente le sessioni selezionate';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG["ad_menu_glossary"] = 'Glossario';
$PMF_LANG["ad_glossary_add"] = 'Aggiungi una voce al Glossario';
$PMF_LANG["ad_glossary_edit"] = 'Modifica una voce del Glossario';
$PMF_LANG["ad_glossary_item"] = 'Voce';
$PMF_LANG["ad_glossary_definition"] = 'Definizione';
$PMF_LANG["ad_glossary_save"] = 'Salva la voce';
$PMF_LANG["ad_glossary_save_success"] = 'La voce &egrave; stata salvata con successo!';
$PMF_LANG["ad_glossary_save_error"] = 'Si &egrave; verificato un errore: la voce non &egrave; stata salvata.';
$PMF_LANG["ad_glossary_update_success"] = 'La voce &egrave; stata aggiornata con successo!';
$PMF_LANG["ad_glossary_update_error"] = 'Si &egrave; verificato un errore: la voce non &egrave; stata aggiornata.';
$PMF_LANG["ad_glossary_delete"] = 'Cancella la voce';
$PMF_LANG["ad_glossary_delete_success"] = 'La voce &egrave; stata cancellata!';
$PMF_LANG["ad_glossary_delete_error"] = 'Si &egrave; verificato un errore: la voce non pu&ograve; essere cancellata.';
$PMF_LANG["ad_linkcheck_noReferenceURL"] = 'Verifica automatica dei links disabilitata (non &egrave; stata definita la <em>base URL</em>)';
$PMF_LANG["ad_linkcheck_noAllowUrlOpen"] = 'Verifica automatica dei links disabilitata (l\'opzione PHP "allow_url_fopen" non &egrave; abilitata)';
$PMF_LANG["ad_linkcheck_checkResult"] = 'Risultato della verifica automatica dei links';
$PMF_LANG["ad_linkcheck_checkSuccess"] = 'OK';
$PMF_LANG["ad_linkcheck_checkFailed"] = 'Fallito';
$PMF_LANG["ad_linkcheck_failReason"] = 'Motivo(i) del fallimento:';
$PMF_LANG["ad_linkcheck_noLinksFound"] = 'Non &egrave; stata trovata nessuna URL compatibile con la funzionalit&agrave; della verifica automatica dei links.';
$PMF_LANG["ad_linkcheck_searchbadonly"] = 'Soltanto con links rotti';
$PMF_LANG["ad_linkcheck_infoReason"] = 'Informazioni aggiuntive:';
$PMF_LANG["ad_linkcheck_openurl_infoprefix"] = 'Trovato durante il test di <strong>%s</strong>: ';
$PMF_LANG["ad_linkcheck_openurl_notready"] = 'LinkVerifier non pronto.';
$PMF_LANG["ad_linkcheck_openurl_maxredirect"] = 'Superato il numero massimo di redirezioni <strong>%d</strong>.';
$PMF_LANG["ad_linkcheck_openurl_urlisblank"] = 'Risolto come <em>Blank URL</em>.';
$PMF_LANG["ad_linkcheck_openurl_tooslow"] = 'L\'host <strong>%s</strong> &egrave lento o non risponde.';
$PMF_LANG["ad_linkcheck_openurl_nodns"] = 'La risoluzione DNS dell\'host <strong>%s</strong> &egrave; lenta o non &egrave; possibile effettuarla tramite i settaggi attuali del DNS, locale o remoto.';
$PMF_LANG["ad_linkcheck_openurl_redirected"] = 'L\'URL &egrave; stata rediretta <strong>%s</strong>.';
$PMF_LANG["ad_linkcheck_openurl_ambiguous"] = 'E\' stato ritornato uno stato HTTP ambiguo, <strong>%s</strong>.';
$PMF_LANG["ad_linkcheck_openurl_not_allowed"] = 'Il metodo <em>HEAD</em> non &egrave; supportato dal server <strong>%s<strong>, questi i metodi supportati: <strong>%s</strong>.';
$PMF_LANG["ad_linkcheck_openurl_not_found"] = 'La risorsa non &egrave; stata trovata nel server <strong>%s</strong>.';
$PMF_LANG["ad_linkcheck_protocol_unsupported"] = 'Il protocollo %s non &egrave; supportato dalla verifica automatica dei links.';
$PMF_LANG["msgNewQuestionVisible"] = 'La domanda deve essere verificata prima di essere pubblicata.';
$PMF_LANG["msgQuestionsWaiting"] = 'In attesa di essere pubblicate dagli amministratori: ';
$PMF_LANG["ad_entry_visibility"] = 'Pubblica';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG["ad_user_error_password"] = 'Per cortesia inserisci una password.';
$PMF_LANG["ad_user_error_passwordsDontMatch"] = 'Le password non corrispondono ';
$PMF_LANG["ad_user_error_loginInvalid"] = 'Lo pseudonimo fornito non &egrave; valido.';
$PMF_LANG["ad_user_error_noEmail"] = 'Per cortesia inserisci un indirizzo email valido. ';
$PMF_LANG["ad_user_error_noRealName"] = 'Per cortesia inserisci il vero nome. ';
$PMF_LANG["ad_user_error_delete"] = 'Questo account non pu&ograve; essere cancellato. ';
$PMF_LANG["ad_user_error_noId"] = 'Nessun ID specificato. ';
$PMF_LANG["ad_user_error_protectedAccount"] = 'Questo account &egrave; \'protetto\'. ';
$PMF_LANG["ad_user_deleteUser"] = 'Cancella Utenti';
$PMF_LANG["ad_user_status"] = 'Stato:';
$PMF_LANG["ad_user_lastModified"] = 'Ultima modifica:';
$PMF_LANG["ad_gen_cancel"] = 'Torna indietro';
$PMF_LANG["rightsLanguage"]["addglossary"] = 'Aggiunge voci al Glossario';
$PMF_LANG["rightsLanguage"]["editglossary"] = 'Modifica voci del Glossario';
$PMF_LANG["rightsLanguage"]["delglossary"] = 'Cancella voci del Glossario';
$PMF_LANG["ad_menu_group_administration"] = 'Amministrazione dei Gruppi';
$PMF_LANG["ad_user_loggedin"] = 'Sei autenticato come ';

$PMF_LANG["ad_group_details"] = 'Dettagli del Gruppo';
$PMF_LANG["ad_group_add"] = 'Aggiungi Gruppo';
$PMF_LANG["ad_group_add_link"] = 'Aggiungi il gruppo';
$PMF_LANG["ad_group_name"] = 'Nome:';
$PMF_LANG["ad_group_description"] = 'Descrizione:';
$PMF_LANG["ad_group_autoJoin"] = 'Autoiscrizione:';
$PMF_LANG["ad_group_suc"] = 'Il Gruppo &egrave; stato aggiunto con <strong>successo</strong>.';
$PMF_LANG["ad_group_error_noName"] = 'Per cortesia inserisci il nome del gruppo. ';
$PMF_LANG["ad_group_error_delete"] = 'Questo gruppo non pu&ograve; essere cancellato. ';
$PMF_LANG["ad_group_deleted"] = 'Il Gruppo &egrave; stato cancellato con <strong>successo</strong>.';
$PMF_LANG["ad_group_deleteGroup"] = 'Cancella Gruppi';
$PMF_LANG["ad_group_deleteQuestion"] = 'Sei sicuro che questo gruppo debba essere cancellato?';
$PMF_LANG["ad_user_uncheckall"] = 'Deseleziona tutto';
$PMF_LANG["ad_group_membership"] = 'Membri del Gruppo';
$PMF_LANG["ad_group_members"] = 'Membri';
$PMF_LANG["ad_group_addMember"] = '+';
$PMF_LANG["ad_group_removeMember"] = '-';

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG["ad_export_which_cat"] = 'Limita le FAQ da esportare (opzionale)';
$PMF_LANG["ad_export_cat_downwards"] = 'Anche le sottocategorie?';
$PMF_LANG["ad_export_type"] = 'Formato dell\'esportazione';
$PMF_LANG["ad_export_type_choose"] = 'Scegli tra i formati supportati:';
$PMF_LANG["ad_export_download_view"] = 'Scarichi il file o lo guardi subito?';
$PMF_LANG["ad_export_download"] = 'scarico';
$PMF_LANG["ad_export_view"] = 'guardo';
$PMF_LANG["ad_export_gen_xhtml"] = 'Crea il file XHTML';
$PMF_LANG["ad_export_gen_docbook"] = 'Crea il file Docbook';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG["ad_news_data"] = 'Dati della notizia';
$PMF_LANG["ad_news_author_name"] = 'Nome dell\'autore:';
$PMF_LANG["ad_news_author_email"] = 'Email dell\'autore:';
$PMF_LANG["ad_news_set_active"] = 'Attiva';
$PMF_LANG["ad_news_allowComments"] = 'Permetti commenti:';
$PMF_LANG["ad_news_expiration_window"] = 'Validit&agrave; della notizia (opzionale)';
$PMF_LANG["ad_news_from"] = 'Dal:';
$PMF_LANG["ad_news_to"] = 'Al:';
$PMF_LANG["ad_news_insertfail"] = 'Inserimento della notizia fallito.';
$PMF_LANG["ad_news_updatefail"] = 'Aggiornamento della notizia fallito.';
$PMF_LANG["newsShowCurrent"] = 'Mostra le notizie attuali.';
$PMF_LANG["newsShowArchive"] = 'Mostra le notizie archiviate.';
$PMF_LANG["newsArchive"] = ' News - Archvio';
$PMF_LANG["newsWriteComment"] = 'Commenta questa notizia';
$PMF_LANG["newsCommentDate"] = 'Inserito il: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG["ad_record_expiration_window"] = 'Validit&agrave; della faq (opzionale)';
$PMF_LANG["admin_mainmenu_home"] = 'Home';
$PMF_LANG["admin_mainmenu_users"] = 'Utenti';
$PMF_LANG["admin_mainmenu_content"] = 'Contenuti';
$PMF_LANG["admin_mainmenu_statistics"] = 'Statistiche';
$PMF_LANG["admin_mainmenu_exports"] = 'Esportazione';
$PMF_LANG["admin_mainmenu_backup"] = 'Backup';
$PMF_LANG["admin_mainmenu_configuration"] = 'Configurazione';
$PMF_LANG["admin_mainmenu_logout"] = 'Logout';

// added v2.0.0 - 2006-08-15 by Thorsten
$PMF_LANG["ad_categ_owner"] = 'Responsabile della categoria';
$PMF_LANG["adminSection"] = 'Amministrazione';
$PMF_LANG["err_expiredArticle"] = 'Questa FAQ &egrave; in scaduta e non pu&ograve; essere visualizzata.';
$PMF_LANG["err_expiredNews"] = 'Questa notizia &egrave; in scaduta e non pu&ograve; essere visualizzata.';
$PMF_LANG["err_inactiveNews"] = 'Questa notizia &egrave; in revisione e non pu&ograve; essere visualizzata.';
$PMF_LANG["msgSearchOnAllLanguages"] = 'Cerca in tutte le lingue:';
$PMF_LANG["ad_entry_tags"] = '<a href="http://en.wikipedia.org/wiki/Tags" title="Vai alla definizione in inglese di Wikipedia" target="_blank">Tags</a>';
$PMF_LANG["msg_tags"] = '<a href="http://en.wikipedia.org/wiki/Tags" title="Vai alla definizione in inglese di Wikipedia" target="_blank">Tags</a>';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG["msg_related_articles"] = 'FAQ correlate';
$LANG_CONF["records.numberOfRelatedArticles"] = array(0 => "input", 1 => "Numero di FAQ correlate");

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG["ad_linkcheck_feedback_url-batch1"] = 'In corso...';
$PMF_LANG["ad_linkcheck_feedback_url-batch2"] = 'In corso...';
$PMF_LANG["ad_linkcheck_feedback_url-batch3"] = 'In corso...';
$PMF_LANG["ad_linkcheck_feedback_url-checking"] = 'In corso...';
$PMF_LANG["ad_linkcheck_feedback_url-disabled"] = 'Disabilitato';
$PMF_LANG["ad_linkcheck_feedback_url-linkbad"] = 'Links KO';
$PMF_LANG["ad_linkcheck_feedback_url-linkok"] = 'Links OK';
$PMF_LANG["ad_linkcheck_feedback_url-noaccess"] = 'Accesso KO';
$PMF_LANG["ad_linkcheck_feedback_url-noajax"] = 'No AJAX';
$PMF_LANG["ad_linkcheck_feedback_url-nolinks"] = 'Nessun Link';
$PMF_LANG["ad_linkcheck_feedback_url-noscript"] = 'JS disabilitato';

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG["ad_categ_trans_1"] = 'Traduci la categoria ';
$PMF_LANG["ad_categ_trans_2"] = '';
$PMF_LANG["ad_categ_translatecateg"] = 'Traduci questa categoria';
$PMF_LANG["ad_categ_translate"] = 'Traduci';
$PMF_LANG["ad_categ_transalready"] = 'Già tradotta in: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Cancellare in tutte le lingue?';
$PMF_LANG["ad_categ_deletethislang"] = 'Cancellare solo questa lingua?';
$PMF_LANG["ad_categ_translated"] = 'La categoria è stata tradotta.';

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = 'Sommario';
$PMF_LANG["ad_menu_categ_structure"] = 'Sommario delle Categorie e delle lingue presenti';

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG["ad_entry_userpermission"] = 'Permessi dell\'utente:';
$PMF_LANG["ad_entry_grouppermission"] = 'Permessi del gruppo:';
$PMF_LANG["ad_entry_all_users"] = 'Accesso per tutti gli utenti';
$PMF_LANG["ad_entry_restricted_users"] = 'Accesso ristretto a';
$PMF_LANG["ad_entry_all_groups"] = 'Accesso per tutti i gruppi';
$PMF_LANG["ad_entry_restricted_groups"] = 'Accesso ristretto a';
$PMF_LANG["ad_session_expiration"] = 'La sessione scadr&agrave; entro';
$PMF_LANG["ad_user_active"] = 'attivo';
$PMF_LANG["ad_user_blocked"] = 'bloccato';
$PMF_LANG["ad_user_protected"] = 'protetto';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG["ad_entry_intlink"] = 'Seleziona una FAQ per aggiungerla come link...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = 'Incolla dopo';
$PMF_LANG["ad_categ_remark_move"] = 'Lo scambio di due categorie è possibile solo con elementi dello stesso livello.';
$PMF_LANG["ad_categ_remark_overview"] = 'Viene mostrato l\'ordine corretto delle categorie se sono state definite tutte le categorie per la lingua corrente (vedi prima colonna).';

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG["msgUsersOnline"] = '%d Ospiti e %d Registrati';
$PMF_LANG["ad_adminlog_del_older_30d"] = 'Cancella immediatamente i dati pi&ugrave; vecchi di 30 giorni';
$PMF_LANG["ad_adminlog_delete_success"] = 'I dati sono stati cancellati.';
$PMF_LANG["ad_adminlog_delete_failure"] = 'I dati non sono stati cancellati: si &egrave; verificato un errore.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG["opensearch_plugin_install"] = 'Aggiungi il plugin di ricerca';
$PMF_LANG["ad_quicklinks"] = 'Links veloci';
$PMF_LANG["ad_quick_category"] = 'Aggiungi una nuova categoria';
$PMF_LANG["ad_quick_record"] = 'Aggiungi una nuova FAQ';
$PMF_LANG["ad_quick_user"] = 'Aggiungi un nuovo utente';
$PMF_LANG["ad_quick_group"] = 'Aggiungi un nuovo gruppo';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG["msgNewTranslationHeader"] = 'Proposta per una traduzione';
$PMF_LANG["msgNewTranslationAddon"] = 'La tua proposta non sar&agrave; pubblicata immediatamente ma sar&agrave; pubblicata dall\'amministratore dopo la sua validazione.<br />I campi richiesti sono il <strong>tuo Nome</strong>, il <strong>tuo indirizzo email</strong>, la <strong>categoria</strong>, la <strong>traduzione del titolo</strong> e la <strong>traduzione del testo</strong> della faq.<br />Ricordati di separare le parole chiave con lo spazio.';
$PMF_LANG["msgNewTransSourcePane"] = 'Faq originale';
$PMF_LANG["msgNewTranslationPane"] = 'La tua traduzione';
$PMF_LANG["msgNewTranslationName"] = 'Your Name:';
$PMF_LANG["msgNewTranslationMail"] = 'Your email address:';
$PMF_LANG["msgNewTranslationKeywords"] = 'Keywords:';
$PMF_LANG["msgNewTranslationSubmit"] = 'Invia la tua proposta';
$PMF_LANG["msgTranslate"] = 'Proponi una traduzione per';
$PMF_LANG["msgTranslateSubmit"] = 'Inizia a tradurre...';
$PMF_LANG["msgNewTranslationThanks"] = 'Grazie per aver proposto la tua traduzione!';

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]["addgroup"] = 'Aggiunge gruppi';
$PMF_LANG["rightsLanguage"]["editgroup"] = 'Modifica gruppi';
$PMF_LANG["rightsLanguage"]["delgroup"] = 'Cancella gruppi';

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG["ad_news_link_parent"] = 'Il link si apre nella finestra padre';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG["ad_menu_comments"] = 'Commenti';
$PMF_LANG["ad_comment_administration"] = 'Amministrazione dei commenti';
$PMF_LANG["ad_comment_faqs"] = 'Commenti introdotti nelle FAQ:';
$PMF_LANG["ad_comment_news"] = 'Commenti introdotti nelle Notizie:';
$PMF_LANG["ad_groups"] = 'Gruppi';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF["records.orderby"] = array(0 => 'select', 1 => 'Ordinamento delle FAQ (voce)');
$LANG_CONF["records.sortby"] = array(0 => 'select', 1 => 'Ordinamento delle FAQ (decrescente o crescente)');
$PMF_LANG["ad_conf_order_id"] = 'Identificativo (predefinito)';
$PMF_LANG["ad_conf_order_thema"] = 'Titolo';
$PMF_LANG["ad_conf_order_visits"] = 'Numero di visitatori';
$PMF_LANG["ad_conf_order_datum"] = 'Data';
$PMF_LANG["ad_conf_order_author"] = 'Autore';
$PMF_LANG["ad_conf_desc"] = 'Decrescente';
$PMF_LANG["ad_conf_asc"] = 'Crescente';
$PMF_LANG["mainControlCenter"] = 'Configurazione principale';
$PMF_LANG["recordsControlCenter"] = 'Configurazione delle FAQ';

// added v2.0.0 - 2007-03-17 by Thorsten
$PMF_LANG["msgInstantResponse"] = 'Ricerca veloce';
$PMF_LANG["msgInstantResponseMaxRecords"] = '. Qui sotto trovi le prime %d faq.';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF["records.defaultActivation"] = array(0 => "checkbox", 1 => "Attiva le nuove faq (predefinito: disattivato)");
$LANG_CONF["records.defaultAllowComments"] = array(0 => "checkbox", 1 => "Permetti i commenti per le nuove faq (predefinito: non permesso)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG["msgAllCatArticles"] = 'FAQ in questa categoria';
$PMF_LANG["msgDescriptionInstantResponse"] = 'Iniziare a scrivere e troverai le risposte...';
$PMF_LANG["msgTagSearch"] = 'Ricerca tramite Tags';
$PMF_LANG["ad_pmf_info"] = 'phpMyFAQ Info';
$PMF_LANG["ad_online_info"] = 'Verifica della versione (richiede la connessione alla rete)';
$PMF_LANG["ad_system_info"] = 'Informazioni di sistema';

// added 2.5.0-alpha - 2008-01-25 by Elger
$PMF_LANG["msgRegisterUser"] = 'Vuoi registrarti?';
$PMF_LANG["ad_user_loginname"] = 'Pseudonimo:';
$PMF_LANG["errorRegistration"] = 'Questo campo è necessario!';
$PMF_LANG["submitRegister"] = 'Registrati';
$PMF_LANG["msgUserData"] = 'Informazioni richieste per la registrazione';
$PMF_LANG["captchaError"] = 'Inserisci il <strong>codice <a href="http://it.wikipedia.org/wiki/Captcha" title="Vai alla definizione di Wikipedia" target="_blank">captcha</a> corretto</strong>!';
$PMF_LANG["msgRegError"] = 'Questi gli errori trovati, correggili:';
$PMF_LANG["successMessage"] = 'La tua registrazione è stata effettuata! Riceverai una email di conferma con i tuoi dati di accesso dopo l\'approvazione!';
$PMF_LANG["msgRegThankYou"] = 'Grazie per esserti registrato';
$PMF_LANG["emailRegSubject"] = '[%sitename%] Registrazione nuovo utente';

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten
$PMF_LANG["msgMostPopularSearches"] = 'Le ricerche pi&ugrave; popolari sono:';
$LANG_CONF["main.enableWysiwygEditor"] = array(0 => "checkbox", 1 => "Abilita l'editor WYSIWYG preinstallato (predefinito: abilitato)");

// added 2.5.0-beta - 2009-03-30 by Anatoliy
$PMF_LANG["ad_menu_searchstats"] = 'Statistiche sulla ricerca';
$PMF_LANG["ad_searchstats_search_term"] = 'Chiave';
$PMF_LANG["ad_searchstats_search_term_count"] = 'Incidenza';
$PMF_LANG["ad_searchstats_search_term_lang"] = 'Lingua';
$PMF_LANG["ad_searchstats_search_term_percentage"] = 'Percentuale';

// added 2.5.0-beta - 2009-03-31 by Anatoliy
$PMF_LANG["ad_record_sticky"] = 'Sticky';
$PMF_LANG["ad_entry_sticky"] = 'Sticky';
$PMF_LANG["stickyRecordsHeader"] = 'Sticky FAQs';

// added 2.5.0-beta - 2009-04-01 by Anatoliy
$PMF_LANG["ad_menu_stopwordsconfig"] = 'Parole comuni (stop words)';
$PMF_LANG["ad_config_stopword_input"] = 'Aggiungi una nuova parola comune (stop word)';

// added 2.5.0-beta - 2009-04-06 by Anatoliy
$PMF_LANG["msgSendMailDespiteEverything"] = 'Non c\'&grave; ancora una risposta adeguata (sar&grave; inviata una email)';
$PMF_LANG["msgSendMailIfNothingIsFound"] = 'La risposta desiderata &grave; indicata nella lista di cui sopra?';

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten
$PMF_LANG["msgChooseLanguageToTranslate"] = 'Scegli la lingua da tradurre';
$PMF_LANG["msgLangDirIsntWritable"] = 'La cartella per le localizzazioni (/lang) non &egrave; scrivibile!';
$PMF_LANG["ad_menu_translations"] = 'Interfaccia per le traduzioni';
$PMF_LANG["ad_start_notactive"] = 'In attesa di attivazione';
