﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Main.Master" AutoEventWireup="true"
    CodeBehind="MemberListTemplate.aspx.cs" Inherits="Sample.MemberListTemplate" %>

<asp:Content ID="Content1" ContentPlaceHolderID="StyleSection" runat="server">
    <link href="Content/footable.core.css" rel="stylesheet" />
    <link href="Content/footable.standalone.css" rel="stylesheet" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentSection" runat="server">
    <div class="page-header">
        <h3>Member List</h3>
    </div>
    <div>
        <table id="gvMembers">
            <thead>
                <tr>
                    <th data-toggle="true">Member Id</th>
                    <th data-hide="phone">First Name</th>
                    <th data-hide="tablet,phone">Middle Name</th>
                    <th data-hide="phone">Last Name</th>
                    <th data-hide="tablet,phone">Email Id</th>
                    <th>Nickname</th>
                    <th data-hide="tablet,phone">Age</th>
                    <th data-hide="tablet,phone">Status</th>
                    <th data-hide="tablet,phone">Created On</th>
                    <th>Company</th>
                    <th data-hide="tablet,phone">Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td colspan="11" class="label-warning">No records found!</td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="11"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptSection" runat="server">
    <script src="Scripts/footable.js"></script>
    <script src="Scripts/handlebars-v2.0.0.js"></script>
    <script id="template1" type="text/x-handlebars-template">
        {{#each members}}
        <tr>
            <td>{{MemberId}}</td>
            <td>{{FirstName}}</td>
            <td>{{MiddleName}}</td>
            <td>{{LastName}}</td>
            <td>{{EmailId}}</td>
            <td>{{NickName}}</td>
            <td>{{Age}}</td>
            <td>{{IsActive}}</td>
            <td>{{CreatedDate}}</td>
            <td>{{Company}}</td>
            <td></td>
        </tr>
        {{/each}}
    </script>
    <script type="text/javascript">
        var MembersList = {
            serviceAPI: '<%=ConfigurationManager.AppSettings["ApiPath"]%>',
            getMembers: function () {
                try {
                    $.ajax({
                        url: this.serviceAPI + "Member/getMembers",
                        type: "GET",
                        contentType: "application/json; charset=utf-8",
                        datatype: "json",
                        data: [],
                        async: true,
                        success: function (response) { MembersList.getMembersSuccess(response); },
                        error: function (error) { MembersList.getMembersError(error); },
                    });
                } catch (ex) { alert('Something went wrong!'); }
            },
            getMembersSuccess: function (response) {
                var data = $.parseJSON(response);
                var table = $("#gvMembers");
                // Remove tbody within the table
                table.find("tbody").html("");
                // Get The Template HTML from the source
                var template = $("#template1").html();
                // Compile it 
                var compiledCode = Handlebars.compile(template);
                // Then, process compiled code using data as an input
                var dynamicCode = compiledCode(data);
                // Assign the output to placeholder
                table.find("tbody").append(dynamicCode);
                $('#gvMembers').trigger('footable_redraw');
            },
            getMembersError: function (error) {
                var err = $.parseJSON(error.responseText);
                alert(err.ExceptionMessage);
            }
        };
    </script>
    <script type="text/javascript">
        $(function () {
            $('#gvMembers').footable();
            MembersList.getMembers();
            $('#gvMembers').trigger('footable_redraw');
        })();
    </script>
</asp:Content>
