﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;

namespace SinglePageApp.Web.Models
{
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Method)]
    public class AngularJsAuthorizeAttribute : AuthorizeAttribute
    {
        protected override void HandleUnauthorizedRequest(AuthorizationContext filterContext)
        {
            string returnUrl = filterContext.RequestContext.HttpContext.Request.QueryString["returnUrl"];

            var routeValues = new RouteValueDictionary(new
            {
                controller = "Account",
                action = "LoginPartial",
                returnUrl = returnUrl
            });
            filterContext.Result = new RedirectToRouteResult(routeValues);
        }
    }
}