﻿using Newtonsoft.Json;
using SinglePageApp.Core.DAL;
using SinglePageApp.Core.Domains;
using SinglePageApp.Infrastructure.DAL;
using SinglePageApp.Web.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Http;
using System.Web.Mvc;

namespace SinglePageApp.Web.Controllers
{
    public class PhoneController : ApiController
    {
        private IUnitOfWork unitOfWork;
        private IRepository<Phone> phoneRepository;

        public PhoneController(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
            phoneRepository = this.unitOfWork.Repository<Phone>();
        }

        // GET api/<controller>
        public IEnumerable<Phone> Get()
        {
            return phoneRepository.GetAll();
        }

        // GET api/<controller>/5
        public PhoneDetailDTO Get(string id)
        {
            return JsonConvert.DeserializeObject<PhoneDetailDTO>(phoneRepository.GetById(id).PhoneDetail.Json);            
        }

        // POST api/<controller>
        public void Post([FromBody]string value)
        {
        }

        // PUT api/<controller>/5
        public void Put(int id, [FromBody]string value)
        {
        }

        // DELETE api/<controller>/5
        public void Delete(int id)
        {
        }
        
	}
}