﻿using SinglePageApp.Core.Domains;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Data.Entity.ModelConfiguration.Conventions;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace SinglePageApp.Infrastructure.DAL
{
    public class SpaContext : DbContext
    {
        public SpaContext() : base()
        {
            Database.SetInitializer<SpaContext>(new SpaContextInitializer());
        }

        public DbSet<Phone> Phones { get; set; }
        public DbSet<PhoneDetail> PhoneDetails { get; set; }
        

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            modelBuilder.Conventions.Remove<PluralizingTableNameConvention>();
        }

    }
}
