﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Entity;
using System.Linq.Expressions;
using System.Data;
using System.Data.Entity.Validation;
using System.Diagnostics;
using NLog;
using SinglePageApp.Core.DAL;

namespace SinglePageApp.Infrastructure.DAL
{
    public class Repository<T> : IRepository<T> where T : class
    {
        protected SpaContext spaContext;
        protected DbSet<T> DbSet;
        private static Logger logger = LogManager.GetCurrentClassLogger();


        public Repository(SpaContext spaContext)
        {
            this.spaContext = spaContext;
            this.DbSet = spaContext.Set<T>();
        }
        

        #region IRepository<T> Members

        public virtual void Insert(T entity)
        {
            DbSet.Add(entity);
        }

        public virtual void Update(T entity)
        {
            spaContext.Entry(entity).State = EntityState.Modified;
        }

        public void Delete(T entity)
        {
            DbSet.Remove(entity);
        }

        public virtual IQueryable<T> Find(Expression<Func<T, bool>> predicate)
        {
            return DbSet.Where(predicate);
        }

        public virtual IQueryable<T> GetAll()
        {
            return DbSet;
        }

        public virtual T GetById(string id)
        {
            return DbSet.Find(id);
        }

        
        #endregion        
        
        
    }
}
