﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;
using JsonRenderingMvcApplication.Models;

namespace JsonRenderingMvcApplication.Controllers
{
    public class BookController : Controller
    {
        public ActionResult BookByPublisher(int id)
        {
            IEnumerable<BookModel> modelList = new List<BookModel>();
            using (DAL.DevelopmentEntities context = new DAL.DevelopmentEntities())
            {
                var books = context.BOOKs.Where(x => x.PublisherId == id).ToList();
                modelList = books.Select(x =>
                                            new BookModel()
                                            {
                                                Title = x.Title,
                                                Author = x.Auther,
                                                Year = x.Year,
                                                Price = x.Price
                                            });
            }
            return PartialView(modelList);   
        }

        public JsonResult BooksByPublisherId(int id)
        {
            IEnumerable<BookModel> modelList = new List<BookModel>();
            using (DAL.DevelopmentEntities context = new DAL.DevelopmentEntities())
            {
                var books = context.BOOKs.Where(x => x.PublisherId == id).ToList();
                modelList = books.Select(x =>
                                            new BookModel()
                                            {
                                                Title = x.Title,
                                                Author = x.Auther,
                                                Year = x.Year,
                                                Price = x.Price
                                            });
            }
            return Json(modelList,JsonRequestBehavior.AllowGet); 
        }

    }
}
