function Universe() {
	// the cached instance
	var instance;
	// rewrite the constructor
	Universe = function Universe() {
		return instance;
	};
	// carry over the prototype properties
	Universe.prototype = this;
	// the instance
	instance = new Universe();
	// reset the constructor pointer
	instance.constructor = Universe;
	// all the functionality
	instance.start_time = 0;
	instance.bang = "Big";
	return instance;
};

// update prototype and create instance
Universe.prototype.nothing = true; // true
var uni = new Universe();
Universe.prototype.everything = true; // true

var uni2 = new Universe();

// it's the same single instance
console.log(uni === uni2); // true

// all prototype properties work
// no matter when they were defined
// the normal properties work

console.log(uni.bang); // "Big"

// the constructor points correctly
console.log(uni.constructor === Universe); // true