var OOP = {};

OOP.extend = function extendClass(subClass, baseClass) {
    function inheritance() {};
    inheritance.prototype = baseClass.prototype;

    subClass.prototype = new inheritance();
    subClass.prototype.constructor = subClass;
    subClass.baseConstructor = baseClass;
    subClass.superClass = baseClass.prototype;
};

function Person(first, last) {
    this.first = first;
    this.last = last;

    Person.prototype.toString = function () {
        return this.first + " " + this.last;
    }
};

function Employee(first, last, id) {
    Employee.baseConstructor.call(this, first, last);

    this.id = id;

    Employee.prototype.toString = function() {
        return Employee.superClass.toString.call(this) + ": " + this.id;
    }
};

OOP.extend(Employee, Person);

var emp1 = new Employee("Vasia", "Pupkin", 123);
var pers1 = new Person("Petia", "Vasin", 123);

console.log(emp1.toString());
console.log(pers1.toString());