function Class() { }

Class.prototype.construct = function() {};

Class.__asMethod__ = function(func, superClass) {
    return function() {
        var currentSuperClass = this.base;
        this.base = superClass;
        var ret = func.apply(this, arguments);
        this.base = currentSuperClass;
        return ret;
    };
};

Class.extend = function(def) {
    var classDef = function() {
        if (arguments[0] !== Class) { this.construct.apply(this, arguments); }
    };

    var proto = new this(Class);
    var superClass = this.prototype;

    for (var n in def) {
        var item = def[n];

        if (item instanceof Function) {
            item = Class.__asMethod__(item, superClass);
        }

        proto[n] = item;
    }

    proto.base = superClass;
    classDef.prototype = proto;
    classDef.extend = this.extend;
    return classDef;
};

var BasePageController = Class.extend({
    // Constructor
    construct: function() {
        // Default values can be set in this method
        var a = "Base";
    },

    // OnLoad event handler
    start: function() {
        this._init();
        this._setEventHandlers();
    },

    // This method can be used to init any controller specific data
    _init: function() {
        var a = "Base";
    },

    // This method should be used to attach event handlers to controls
    _setEventHandlers: function() {
        var a = "Base";
    }
});


var SomePageController = BasePageController.extend({
    construct: function() {
        this.base.construct.call(this);

        var b = "Some";
    },

    _init: function() {
        this.base._init.call(this);

        var b = "Some";
    },

    _setEventHandlers: function() {
        this.base._setEventHandlers.call(this);

        var b = "Some";
    }
});

var controller = new SomePageController();
controller.start();