define([
	"app/controller/BaseController",
	"pubsub",
	"app/common/topic"
],
function(BaseController, ps, topic) {
    return BaseController.extend({

        ulPerson: null,

        _loadControls: function () {
            this.base();

            this.ulPerson = this.getByID("personList");
        },

        _setEventHandlers: function() {
            this.base();

            ps.subscribe(topic.Person_Ready_To_Process, this._onPersonAdded.bind(this));
        },

        _onPersonAdded: function(event, args) {
            $.ajax({
                url: '/default.aspx',
                dataType:'json',
                data: { command: "processPerson", firstName: args.firstName, lastName: args.lastName },
                success: this._onPersonProcessed.bind(this),
                error: function (xml, status, error) {
                    // do something if there was an error
                    alert(error);
                }
            });
        },

        _onPersonProcessed: function (data) {
	        var person = data.FirstName + ' ' + data.LastName;

            this.ulPerson.append($("<li>").text(person));

            ps.publish(topic.Person_Processed, { person: person });
        }
    });
});