define([
	"app/controller/BaseController",
	"pubsub",
	"app/common/topic"
],
function(BaseController, ps, topic) {
    return BaseController.extend({
        txtFirstName: null,
        txtLastName: null,
        btnCheck: null,

        _loadControls: function() {
            this.base();

            this.txtFirstName = this.getByID("txtFirstName");
            this.txtLastName = this.getByID("txtLastName");
            this.btnCheck = this.getByID("btnCheck");
        },

        _setEventHandlers: function() {
            this.base();

            this.btnCheck.on("click", this._onBtnCheckClick.bind(this));

            ps.subscribe(topic.Person_Processed, this._onPersonProcessed.bind(this));
            //this.btnCheck.off("click");
        },

        _onBtnCheckClick: function() {
            ps.publish(topic.Person_Ready_To_Process, { firstName: this.txtFirstName.val(), lastName: this.txtLastName.val() });
        },

        _onPersonProcessed: function (event, args) {
            this.txtFirstName.val("");
            this.txtLastName.val("");

            alert("Person " + args.person + " was successfully processed!");
        }
    });
});