define([
	"jquery",
	"app/common/BaseModule"
],
function ($, BaseModule) {
    return BaseModule.extend({
        // Header container
        container: null,

        // Entry point
        start: function() {
            this._loadControls();
            this._setEventHandlers();
        },

        // This method should be used to load page-specific controls and set references to them in controller
        _loadControls: function() {
        },

        // This method should be used to attach event handlers to controls
        _setEventHandlers: function() {
        },

        // Helper method to find controls using jQuery with controller container context
        getByID: function (id, context) {
            // Set search context if applicable
            if (!context && this.container) {
                context = this.container;
            }

            // Basic jQuery selector
            var el = $("#" + id, context);

            // If unable to find element - lets try to check ASP.NET naming container prefix
            if (el.length < 1) {
                el = $("[id$=_" + id + "]", context);
            }

            return el;
        }
    });
});