define([
	"app/common/BaseModule",
	"jquery"
],
function(BaseModule, $) {
	return BaseModule.extend({
		loadDeclaredControllers: function() {
			var controllers = $("[data-controller]");

			for(var i = 0; i < controllers.length; i++) {
				var containerDiv = $(controllers[i]);
				this.loadController(containerDiv.data("controller"), containerDiv);
			}
		},

		loadController: function(controllerName, containerDiv) {
		    require([controllerName], function(ControllerModule) {
		        // Call base module constructor and init() method
		        var controller = new ControllerModule();

		        // Set container to be able to determine context
		        if (containerDiv) {
		            controller.container = containerDiv;
		        }

		        // Call default entry point for controller if defined
		        if (controller.start) {
		            controller.start();
		        }
		    });
		}
	});
});