﻿using System.Collections.Generic;
using System.Web;
using CommandHandlers.Handlers;

namespace CommandHandlers
{
    public class HttpRequestProcessor
    {
        // This should be replaced with Dependency Injection container
        private readonly Dictionary<string, IHttpCommandHandler> _handlers = new Dictionary<string, IHttpCommandHandler>
        {
            { "processPerson", new ProcessPersonCommandHandler() }
        };

        public void HandleRequest(HttpRequest request, HttpResponse response)
        {
            var cmd = this.GetCommandFromRequest(request);

            if (cmd != null)
            {
                cmd.ProcessRequest(request);
                cmd.WriteResponse(response);
            }
        }

        private IHttpCommandHandler GetCommandFromRequest(HttpRequest request)
        {
            IHttpCommandHandler cmd = null;

            var commandName = request.Params["command"];

            if (!string.IsNullOrEmpty(commandName) && _handlers.ContainsKey(commandName))
            {
                cmd = _handlers[commandName];
            }

            return cmd;
        }
    }
}