﻿using System.Web;
using System.Web.Script.Serialization;
using Model;

namespace CommandHandlers.Handlers
{
    public class ProcessPersonCommandHandler : IHttpCommandHandler
    {
        private Person _person;

        public void ProcessRequest(HttpRequest request)
        {
            InitPersonFromRequest(request);

            if (this._person == null) return;

            SavePersonToDB();
        }

        public void WriteResponse(HttpResponse response)
        {
            var serializer = new JavaScriptSerializer();

            response.Clear();
            response.ContentType = "application/json";
            response.Write(serializer.Serialize(_person));
            response.End();
        }

        private void SavePersonToDB()
        {
            // Do some important staff
        }

        private void InitPersonFromRequest(HttpRequest request)
        {
            var firstName = request.Params["firstname"];
            var lastName = request.Params["lastname"];

            this._person = new Person { FirstName = firstName, LastName = lastName };
        }
    }
}