﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Web;

namespace GroupGrid.Models
{
    public class db
    {
        private static string _ExcelPath = "~/App_Data/";

        public static List<Employee> Employees { get; set; }
        static db()
        {
            Employees = GetItems<Employee>("Employee.xlsx").ToList();
        }

        private static List<T> GetItems<T>(string fileName) where T : class
        {
            List<T> list = new List<T>();
            DataTable dt = ExcelLayer.GetDataTable(HttpContext.Current.Server.MapPath(_ExcelPath + fileName));

            foreach (DataRow row in dt.Rows)
            {
                Type t = typeof(T);
                T instance = (T)Activator.CreateInstance(t);
                Fill(instance, row);
                list.Add(instance);
            }
            return list;
        }

        public static T Fill<T>(T LogicObject, DataRow Row)
        {
            Dictionary<string, PropertyInfo> props = new Dictionary<string, PropertyInfo>();
            foreach (PropertyInfo p in LogicObject.GetType().GetProperties())
                props.Add(p.Name, p);
            foreach (DataColumn col in Row.Table.Columns)
            {
                string name = col.ColumnName;
                if (Row[name] != DBNull.Value && props.ContainsKey(name))
                {
                    object item = Row[name];
                    PropertyInfo p = props[name];
                    if (p.PropertyType != col.DataType)
                    {
                        if (p.PropertyType.Name.Equals("Boolean"))
                            item = Convert.ToBoolean(Convert.ToInt32(item));
                        else
                            item = Convert.ChangeType(item, p.PropertyType);
                    }
                    p.SetValue(LogicObject, item, null);
                }
            }
            return LogicObject;
        }
    }
}