﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;

namespace TestRealWorldIntegration
{
    public class IisExpressAgent
    {
        public void Start(string arguments)
        {
            ProcessStartInfo info= new ProcessStartInfo(@"C:\Program Files (x86)\IIS Express\iisexpress.exe", arguments)
            {
              // WindowStyle= ProcessWindowStyle.Minimized,
            };

            process = Process.Start(info);
        }

        Process  process;

        public void Stop()
        {
            process.Kill();
        }
    }

    /// <summary>
    /// Launch IIS Express if AppSettings["Testing_UseIisExpress"] is true, using the following settings
    /// AppSettings["Testing_HostSite"]; AppSettings["Testing_HostSiteApplicationPool"];
    /// </summary>
    public class IisExpressFixture : IDisposable
    {
        public IisExpressFixture()
        {
            var useIisExpress = System.Configuration.ConfigurationManager.AppSettings["Testing_UseIisExpress"];
            if (String.Equals(useIisExpress, "true", StringComparison.CurrentCultureIgnoreCase))
            {
                var hostSite = System.Configuration.ConfigurationManager.AppSettings["Testing_HostSite"];
                var hostSiteApplicationPool = System.Configuration.ConfigurationManager.AppSettings["Testing_HostSiteApplicationPool"];
                iisExpressAgentLazy = new Lazy<IisExpressAgent>();
                iisExpressAgentLazy.Value.Start(String.Format("/site:\"{0}\" /apppool:\"{1}\"", hostSite, hostSiteApplicationPool));
            }
        }

        /// <summary>
        /// Create the fixture only if AppSettings["Testing_UseIisExpress"].
        /// </summary>
        /// <returns>Null if AppSettings["Testing_UseIisExpress"] is false.</returns>
        public static IisExpressFixture Create()
        {
            var useIisExpress = System.Configuration.ConfigurationManager.AppSettings["Testing_UseIisExpress"];
            if (String.Equals(useIisExpress, "true", StringComparison.CurrentCultureIgnoreCase))
                return new IisExpressFixture();

            return null;
        }

        Lazy<IisExpressAgent> iisExpressAgentLazy;


        bool disposed;

        // implements IDisposable
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (!disposed)
            {
                // if this is a dispose call dispose on all state you
                // hold, and take yourself off the Finalization queue.
                if (disposing)
                {
                    if (iisExpressAgentLazy.IsValueCreated)
                    {
                        iisExpressAgentLazy.Value.Stop();
                    }
                }

                disposed = true;
            }
        }

    }

}
