﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Net.Http.Formatting;
using System.Reflection;
using System.Text;
using Newtonsoft.Json;
using SM.Store.Api.Models;

namespace TestApiClientConsole
{
    class Program
    {
        private static string apiBaseUri = "http://localhost:5611/api/";
     
        static void Main(string[] args)
        {
            GetCategoriesAndProducts();
            
            Console.WriteLine("");
            Console.WriteLine("Press any key to exit...");
            Console.ReadKey();            
        }

        private static void GetCategoriesAndProducts()
        {
            var uri = apiBaseUri + "getmultiplesets";
            CategoriesProducts resp = default(CategoriesProducts);

            using (HttpClient client = new HttpClient())
            {
                HttpResponseMessage result = client.GetAsync(uri).Result;
                resp = result.Content.ReadAsAsync<CategoriesProducts>().Result;
            }

            //Display data using custome genetic List extension ToString<>.
            var strResult = resp.Categories.ToString<Category_Result>() + "\n";
            strResult += resp.Products.ToString<Product_Result>(include:"ProductName,CategoryId,UnitPrice");
            Console.Write(strResult);
        }
    }
}
