﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.Http.ModelBinding;
using SM.Store.Api.BLL;
using SM.Store.Api.Common;
using SM.Store.Api.DAL;
using SM.Store.Api.Models;

namespace SM.Store.Api.Controllers
{    
    [RoutePrefix("api/products")]
    public class ProductsController : ApiController
    {
        [Route("~/api/getproducts")]
        public IList<Models.ProductCM> GetAllProducts()
        {
            //IProductBS bs = default(IProductBS);
            IProductBS bs = DIFactoryDesigntime.GetInstance<IProductBS>();
            IList<Models.ProductCM> rtn = default(IList<Models.ProductCM>);
            try
            {
                rtn = bs.GetAllProductsByCategoryId(0);
            }
            catch (Exception ex)
            {
                var msg = ex.Message;
            }
            return rtn;
        }
        
        [Route("~/api/getproductsbycategoryid/{categoryId:int}")]
        public IList<Models.ProductCM> GetAllProductsByCategoryId(int categoryId)
        {
            //IProductBS bs = default(IProductBS);
            IProductBS bs = DIFactoryDesigntime.GetInstance<IProductBS>();
            return bs.GetAllProductsByCategoryId(categoryId);
        }

        [Route("{id:int}", Name = "GetProductById")]
        [ResponseType(typeof(Product))]
        public IHttpActionResult GetProductById(int id)
        {
            IProductBS bs = DIFactoryDesigntime.GetInstance<IProductBS>();
            var eProduct = bs.GetProductById(id);
            if (eProduct == null)
            {
                return NotFound();
            }
            else
            {
                IBaseConverter<Entities.Product, Models.Product> convtResult = new AutoMapConverter<Entities.Product, Models.Product>();
                Models.Product mProduct = convtResult.ConvertObject(eProduct);
                return Ok(mProduct);
            }
        }

        [Route("~/api/getmultiplesets")]
        public CategoriesProducts GetCategoriesAndProducts()
        {
            var resp = new CategoriesProducts();            
            IProductBS bs = DIFactoryDesigntime.GetInstance<IProductBS>();
            resp = bs.GetCategoriesAndProducts();            
            return resp;
        }        
    }
}
