﻿'use strict';

angular.module('smApp.controllers', ['ui.bootstrap', function () {
}])
.controller('productListController', ['$scope', '$http', function ($scope, $http) {    
    $scope.model = {};
    $scope.model.productList = [];
    $scope.model.errorMessage = undefined;
    $scope.model.isAjaxInProgress = true;

    $http({
        url: 'api/getproducts',
        method: "GET"
    }).
        success(function (data, status, headers, config) {
            //this callback will be called asynchronously when the response is available
            $scope.model.productList = data;
            //Done with AJAX loading
            $scope.model.isAjaxInProgress = false;
        }).
        error(function (data, status, headers, config) {
            //If an error occurs, returns response with an error status.
            $scope.model.errorMessage = "Error occurred status:" + status;
            //Done with AJAX loading
            $scope.model.isAjaxInProgress = false;
        });

    $scope.productTitle = {
        0: "No Product",
        other: "Product List (total {} products)"
    };
}])

.controller('categoriesAndProducstController', ['$scope', '$http', function ($scope, $http) {
    $scope.model = {};
    $scope.model.categories = [];
    $scope.model.products = [];
    $scope.model.errorMessage = undefined;
    $scope.model.isAjaxInProgress = true;

    $http({
        url: 'api/getmultiplesets',
        method: "GET"
    }).
        success(function (data, status, headers, config) {
            //this callback will be called asynchronously when the response is available
            $scope.model.categories = data.Categories;
            $scope.model.products = data.Products;
            //Done with AJAX loading
            $scope.model.isAjaxInProgress = false;
        }).
        error(function (data, status, headers, config) {
            //If an error occurs, returns response with an error status.
            $scope.model.errorMessage = "Error occurred status:" + status;
            //Done with AJAX loading
            $scope.model.isAjaxInProgress = false;
        });

    $scope.categoryTitle = {
        0: "No Category",
        other: "Category List (total {} categories)"
    };
    $scope.productTitle = {
        0: "No Product",
        other: "Product List (total {} products)"
    };
}])

.controller('aboutController', ['$scope', function ($scope) {
    $scope.message = 'This is an example.';
}])

.controller('productController', ['$scope', '$routeParams', '$http', '$window',
    function ($scope, $routeParams, $http, $window) {
        $scope.model.Product = {};
        $scope.model.errorMessage = undefined;
        $scope.model.isAjaxInProgress = true;
        $http({
            url: 'api/products/' + $routeParams.id,
            method: "GET"
        })
        .success(function (data, status, headers, config) {
            data.UnitPrice = data.UnitPrice.toFixed(2);
            var avDate = new Date(data.AvailableSince);
            data.AvailableSince = getFormattedDate(avDate);
            $scope.model.Product = data;
            $scope.model.isAjaxInProgress = false;
        })
        .error(function (data, status, headers, config) {
            $scope.model.errorMessage = "Error occurred status:" + status;
            $scope.model.isAjaxInProgress = false;
        });

        $scope.saveProduct = function () {
            $window.alert("Changes saved.")
        };

        $scope.backToProductList = function () {
            $window.history.back();
        };
}]);

function getFormattedDate(date) {
    var year = date.getFullYear();
    var month = (1 + date.getMonth()).toString();
    month = month.length > 1 ? month : '0' + month;
    var day = date.getDate().toString();
    day = day.length > 1 ? day : '0' + day;
    return month + '/' + day + '/' + year;
}
