﻿using System;
using System.Configuration;
using System.Data.Entity;

namespace SM.Store.Api.DAL
{
    public class StoreDataSpUnitOfWork : IStoreDataSpUnitOfWork
    {
        private StoreDataSpContext context;
        public StoreDataSpUnitOfWork(string connectionString)
        {
            //Needed if config file is in the separate assembly.
            var type = typeof(System.Data.Entity.SqlServer.SqlProviderServices);            
            
            //Used for design time DI configuration
            if (connectionString == "{connectionString_SP}")
            {
                connectionString = ConfigurationManager.ConnectionStrings["StoreDataSpContext"].ConnectionString;
            }
            this.context = new StoreDataSpContext(connectionString);
        }

        public StoreDataSpContext Context
        {
            get
            {
                return this.context;
            }
            set
            {
                this.context = value;
            }
        }

        public void Dispose()
        {
            this.Context.Dispose();
        }
    }
}
