﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Linq.Expressions;
using SM.Store.Api.Models;
using SM.Store.Api.DAL;

namespace SM.Store.Api.DAL
{
    public class ProductSpRepository : IProductSpRepository
    {
        public IStoreDataSpUnitOfWork UnitOfWork_SP { get; set; }
        public ProductSpRepository(IStoreDataSpUnitOfWork unitOfWork_SP)
        {
            this.UnitOfWork_SP = unitOfWork_SP;
        }

        public CategoriesProducts GetCategoriesAndProducts()
        {
            CategoriesProducts categProd = new CategoriesProducts();
            categProd.Categories = new List<Category_Result>();
            categProd.Products = new List<Product_Result>();

            //Call stored procedure and get all result sets
            var results = this.UnitOfWork_SP.Context.GetAllCategorisAndProducts();

            //Get first enumerate result set
            categProd.Categories.AddRange(results);

            //Get second result set
            var products = results.GetNextResult<Product_Result>();
            categProd.Products.AddRange(products);

            //Return all result sets
            return categProd;
        }
    }
}
