﻿using System;
using SM.Store.Api.Entities;
using System.Linq;
using System.Collections.Generic;
using SM.Store.Api.DAL;
using System.Data.Entity;
using SM.Store.Api.Common;
using SM.Store.Api.Models;
using System.Data.Entity.Infrastructure;
using System.Data.Entity.Core.Objects;

namespace SM.Store.Api.DAL
{
    public class ProductRepository : GenericRepository<Entities.Product>, IProductRepository
    {
        public ProductRepository(IStoreDataUnitOfWork unitOfWork)
            : base(unitOfWork)
        {
        }
                
        public IList<Entities.Product> GetProducts()
        {
            return this.GetAll();
        }

        public Entities.Product GetProductById(int id)
        {
            return this.GetById(id);
        }
        
        public IList<Models.ProductCM> GetAllProductsByCategoryId(int categoryId)
        {
            IQueryable<Models.ProductCM> query = this.UnitOfWork.Context.Products
                       .GroupJoin(this.UnitOfWork.Context.Categories,
                        p => p.CategoryID, c => c.CategoryID,
                        (p, c) => new { p, c })
                       .GroupJoin(this.UnitOfWork.Context.ProductStatusTypes,
                        p1 => p1.p.StatusCode, s => s.StatusCode,
                       (p1, s) => new { p1, s })
                       .SelectMany(p2 => p2.s.DefaultIfEmpty(), (p2, s2) => new { p2 = p2.p1, s2 = s2 })
                       .Select(f => new Models.ProductCM
                       {
                           ProductID = f.p2.p.ProductID,
                           ProductName = f.p2.p.ProductName,
                           CategoryID = f.p2.p.CategoryID,
                           CategoryName = f.p2.p.Category.CategoryName,
                           UnitPrice = f.p2.p.UnitPrice,
                           StatusCode = f.p2.p.StatusCode,
                           StatusDescription = f.s2.Description,
                           AvailableSince = f.p2.p.AvailableSince
                       });

            //Add predicate for dynamic search
            var predicate = PredicateBuilder.True<Models.ProductCM>();
            if (categoryId > 0)
            {                
                predicate = predicate.And(p => p.CategoryID == categoryId);
            }
            query = query.Where(predicate);
            return query.ToList();
        }
    }
}
