﻿using System.Collections.Generic;
using System;
using SM.Store.Api.Entities;
using System.Linq;
using System.Linq.Expressions;
using System.Reflection;
using SM.Store.Api.DAL;
using SM.Store.Api.Common;
using SM.Store.Api.Models;
using System.Threading.Tasks;

namespace SM.Store.Api.BLL
{
    public class ProductBS : IProductBS
    {
        private IProductRepository _productRepository;
        private IProductSpRepository _productRepository_SP;
        public ProductBS(IProductRepository productRepository)
        {
            if (productRepository != null)
                this._productRepository = productRepository;            
        }
        public ProductBS(IProductSpRepository productRepository_SP)
        {            
            if (productRepository_SP != null)
                this._productRepository_SP = productRepository_SP;
        }
        public ProductBS(IProductRepository productRepository, IProductSpRepository productRepository_SP)
        {
            if (productRepository != null)
                this._productRepository = productRepository;
            if (productRepository_SP != null)
                this._productRepository_SP = productRepository_SP;
        }
        
        public IList<Entities.Product> GetProducts()
        {
            return this._productRepository.GetProducts();
        }

        public Entities.Product GetProductById(int id)
        {
            return this._productRepository.GetProductById(id);
        }

        public IList<Models.ProductCM> GetAllProductsByCategoryId(int categoryId)
        {

            var rtn = this._productRepository.GetAllProductsByCategoryId(categoryId);
            return rtn; 
        }
        
        //Call stored procedure and return multiple result sets
        public CategoriesProducts GetCategoriesAndProducts()
        {
            //try
            //{                
                //Test
                var rtn = this._productRepository_SP.GetCategoriesAndProducts();
                return rtn;
            //}
            //catch(Exception ex)
            //{
            //    throw ex;
            //}            
        }        
    }
}
