<?
/**
 * Class cls_form - administrator manager
 * @author Francisco Caserio - francisco.caserio@gmail.com
 * @version 2.4.3 - 01/10/2008
 */
class cls_form {
	public function cls_form($db = "MSSQL") {
		$this->db = strtoupper($db);
		// flags
		$this->add_print = 0;
		$this->ck_active = 0;
		$this->ck_collapse = 0;
		$this->ck_recursive = 0;
		$this->ck_csv_export = 0;
		$this->ck_global_form = 0;
		$this->ck_multiple_entry = 0;
		$this->ck_showtotal = 0;
		$this->ck_notification = 0;
		$this->ck_flag_mode = 0;
		$this->ck_display_title = 1;
		$this->ck_repeat_row = 0;
		$this->ck_return_pk = 0;
		$this->ck_unique = 0;
		$this->ck_unlock = 0;
		$this->ck_redirect = 1;
		$this->ck_verify_email = 0;
		$this->repeat_insert = 1;
		// containers
		$this->ref = array();
		$this->ref_filter = array();
		$this->label = array();
		$this->group_key = array();
		$this->order = array();
		$this->group = array();
		$this->graph = array();
		$this->ent_1XN = array();
		$this->ent_NXN = array();
		$this->condition = array();
		$this->related = array();
		$this->dependency = array();
		$this->delete_cascade = array();
		$this->form_rule = array();
		$this->header = array();
		$this->tab_ref = array();
		$this->hidden_ref = array();
		$this->link_ref = array();
		$this->color_ref = array();
		$this->publisher_ref = array();
		$this->flag_mode_action = array();
		$this->flag_mode_ref = array();
		$this->onload_action = array();
		$this->onsubmit_action = array();
		$this->ck_new_ref = array();
		$this->list_param = array();
		$this->js_ref = array("fn_table_aux.js", "form_globals_lib.js");
		// document linkage
		$this->document_name_list = "";
		$this->document_name_form = "";
		$this->document_name_xml = "";
		// templates indiactors
		$this->tpl_form = "";
		$this->tpl_prompt = "";
		$this->tpl_return_insert_pk = "";
		$this->tpl_return_update_pk = "";
		// constants managed by methods
		$this->pk = "id";
		$this->pageby = null;
		$this->redirect_str = null;
		$this->field_group = null;
		$this->list_title_mode = "H";
		$this->list_modo = "auto";
		// constants managed by config
		$this->use_sysdoc = 0;
		$this->use_CalendarPopup = 0;
		$this->use_print_close = 0;
		$this->use_print_button = 0;
		$this->use_print_back = 0;
		$this->use_list_filter = 0;
		$this->use_list_header_separator = 1;
		$this->use_required_position = "down";
		// config custom
		include "cls_form.config.php";
		// setup required
		if (is_file("$this->img_dir/$this->img_required"))
			$this->str_required = "<img src=\"$this->img_dir/$this->img_required\" border=0 align=absmiddle>";
		else
			$this->str_required = $this->img_required;
		// setup calendar
		if ($this->use_CalendarPopup == 1) {
			array_push($this->js_ref, "Calendar/CalendarPopup.js");
			array_push($this->js_ref, "Calendar/PopupWindow.js");
			array_push($this->js_ref, "Calendar/AnchorPosition.js");
			array_push($this->js_ref, "Calendar/date.js");
		}
		$this->debug = 0;
	}
	public function set_form_width($w) {
		$this->form_width = $w;
	}
	public function set_css($css, $class) {
		if (substr($css,0,3) != "css" ||
			!isset($this->$css)) echo "INVALID CSS";
		else
			$this->$css = $class;
	}
	public function set_template($scope, $tpl) {
		if ($scope == "form")
			$this->tpl_form = $tpl;
		else if ($scope == "filter")
			$this->tpl_filter = $tpl;
		else if ($scope == "prompt")
			$this->tpl_prompt = $tpl;
		else if ($scope == "return_insert_pk")
			$this->tpl_return_insert_pk = $tpl;
		else if ($scope == "return_update_pk")
			$this->tpl_return_update_pk = $tpl;
	}
	public function add_template_value($marker, $val) {
		$this->tpl_val[$marker] = $val;
	}
	public function pageby($num,$method="GET") {
		$this->pageby = $num;
		$this->pageby_method = $method;
		if (!isset($this->pageby_pos)) 
			$this->pageby_pos = "U";
		if (!isset($this->pageby_align)) 
			$this->pageby_align = "right";
	}
	public function display_title($ck) {
		$this->ck_display_title = $ck;
	}
	public function set_document_name($value, $scope="list") {
		if (strtolower($scope) == "list")
			$this->document_name_list = $value;
		else if (strtolower($scope) == "form")
			$this->document_name_form = $value;
		else if (strtolower($scope) == "xml") {
			$this->document_name_xml = $value;
			for ($i=0; $i<count($this->ref); $i++) {
				if (isset($this->ref[$i]["prop"]["onchange"]) &&
					strpos($this->ref[$i]["prop"]["onchange"], "?modo=xml") !== false) {
					$this->ref[$i]["prop"]["onchange"] = str_replace("?modo=xml", "$this->document_name_xml?modo=xml", $this->ref[$i]["prop"]["onchange"]);
				}
			}
			for ($i=0; $i<count($this->ref_filter); $i++) {
				if (isset($this->ref_filter[$i]["prop"]["onchange"]) &&
					strpos($this->ref_filter[$i]["prop"]["onchange"], "?modo=xml") !== false) {
					$this->ref_filter[$i]["prop"]["onchange"] = str_replace("?modo=xml", "$this->document_name_xml?modo=xml", $this->ref_filter[$i]["prop"]["onchange"]);
				}
			}
		}
	}
	public function set_redirect($value) {
		if (!$value) $this->ck_redirect = 0;
		$this->redirect_str = $value;
	}
	public function set_css_path($css_path) {
		$this->css_path = $css_path;
	}
	public function set_img_dir($img_dir) {
		$this->img_dir = $img_dir;
	}
	public function set_js_dir($js_dir) {
		$this->js_dir = $js_dir;
	}
	public function set_entity($table, $ent) {
		$this->table = $table;
		$this->ent = $ent;
	}
	public function add_onload_action($action) {
		$ck_exists = 0;
		for ($i=0; $i<count($this->onload_action); $i++) {
			if ($this->onload_action[$i] == $action) {
				$ck_exists = 1;
				break;
			}
		}
		if ($ck_exists == 0) {
			$c = count($this->onload_action);
			$this->onload_action[$c] = $action;
		}
	}
	public function add_onsubmit_action($action) {
		$ck_exists = 0;
		for ($i=0; $i<count($this->onsubmit_action); $i++) {
			if ($this->onsubmit_action[$i] == $action) {
				$ck_exists = 1;
				break;
			}
		}
		if ($ck_exists == 0) {
			$c = count($this->onsubmit_action);
			$this->onsubmit_action[$c] = $action;
		}
	}
	public function add_print_option($ck_popup = 1) {
		$this->add_print = 1;
		$this->add_print_popup = $ck_popup;
		$this->add_onload_action("window.focus()");
	}
	public function add_filter($field, $label, $type=null) {
		$c_ref = count($this->ref_filter); // new index
		$this->ref_filter[$c_ref] = array(
			"field" => $this->get_field_label($field), 
			"qry_field" => $this->get_field_index($field), 
			"label" => $label, 
			"type" => $type, 
			"ck_req" => 0, 
			"ck_hidden" => 0, 
			"ck_separator" => 0, 
			"tab_id" => 0, 
			"field_group" => $this->field_group, 
			"prop" => array());
	}
	public function add_filter_keyword($field, $label) {
		$this->add_filter("keyword", "Palavra-chave", "findtext");
		$c = count($this->ref_filter)-1; // existing index
		$this->ref_filter[$c]["keyword_ref"] = $field;
		if (is_array($field)) {
			$str = "<br>";
			for ($i=0; $i<count($field); $i++) {
				if (strpos($field[$i], ".") > 0)
					$field_name = substr($field[$i], strpos($field[$i], ".")+1);
				else
					$field_name = $field[$i];
				$label_name = $label[$i];
				$str .= "<input type=checkbox name=ck_$field_name id=ck_$field_name value=1 CHECKED>$label_name\n";
			}
		}
		$this->set_filter_comment($str);
	}
	public function add_filter_prop($prop, $value=null, $ix=null) {
		$c_ref = is_numeric($ix) ? $ix : count($this->ref_filter)-1;
		if (isset($this->ref_filter[$c_ref]["prop"][$prop]))
			$this->ref_filter[$c_ref]["prop"][$prop] .= ";" . $value;
		else
			$this->ref_filter[$c_ref]["prop"][$prop] = $value;
	}
	public function set_filter_default($value) {
		$c_ref = count($this->ref_filter)-1;
		$this->ref_filter[$c_ref]["default"] = $value;
	}
	public function set_filter_comment($value,$pos="after") {
		$c_ref = count($this->ref_filter)-1;
		if ($pos == "after")
			$this->ref_filter[$c_ref]["comment"] = $value;
		if ($pos == "before")
			$this->ref_filter[$c_ref]["comment_before"] = $value;
	}
	public function set_filter_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->ref_filter)-1;
		$this->ref_filter[$c_ref]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label,
			"xtra_fields" => $xtra_fields,
			"ajax" => $this->ck_ajax_qry($qry, $this->ref_filter, "filter"),
			"ck_new_entry" => 0
		);
		$this->ref_filter[$c_ref]["ajaxfunction"] = "nc_query";
	}
	public function set_filter_mask($value, $write_mask=1, $unlock_mask=0) {
		$c_ref = count($this->ref_filter)-1;
		$this->ref_filter[$c_ref]["mask"] = $value;
		$this->ref_filter[$c_ref]["write_mask"] = $write_mask;
		$this->ref_filter[$c_ref]["unlock_mask"] = $unlock_mask;
		if ($unlock_mask == 1) $this->ck_unlock = 1;
		$this->add_filter_prop("onfocus", "recvalue(this)");
		$this->add_filter_prop("onkeyup", "gotofield(this.form,this)");
	}
	public function set_filter_list($list) {
		$c_ref = count($this->ref_filter)-1;
		$this->ref_filter[$c_ref]["list"] = $list;
	}
	public function return_pk($entity = "default") {
		$this->get_return_pk("I", $entity);
	}
	public function get_return_pk($use = "I", $entity = "default") {
		$this->ck_return_pk = 1;
		$this->ck_return_use = $use;
		$this->ck_return_entity = $entity;
	}
	public function add_entity($ent, $table, $key_field, $rel = "1XN", $xtra_key=array()) {
		$c = count($this->ref); // new index
		$tab_id = count($this->tab_ref)-1;
		$this->ref[$c] = array(
			"type" => "entity", 
			"label" => $ent, 
			"table" => $table, 
			"key_field" => $key_field, 
			"key_condition" => "", 
			"xtra_key" => $xtra_key, 
			"rel" => $rel, 
			"path" => null, 
			"entity_cols" => 1, 
			"entity_layout" => "H", 
			"ck_hidden" => 0,
			"ck_edicao_global" => 0, 
			"ck_multiple_entry" => 0, 
			"ck_separator" => 0,
			"req_dependency" => $tab_id >= 0 ? $this->tab_ref[$tab_id]["req_dependency"] : array(), 
			"tab_id" => $tab_id, 
			"pk" => "id");
		if ($rel == "1XN") $this->ent_1XN[count($this->ent_1XN)] = $c;
		if ($rel == "NXN") $this->ent_NXN[count($this->ent_NXN)] = $c;
	}
	public function set_entity_pk($pk) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["pk"] = $pk; 
	}
	public function set_entity_condition($sql, $key_exclusive=1) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["key_condition"] = $sql; 
		$this->ref[$c]["key_exclusive"] = $key_exclusive; 
	}
	public function set_entity_html($path) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["path"] = $path; 
	}
	public function set_entity_multiple_entry() {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["ck_multiple_entry"] = 1; 
		$this->ck_multiple_entry = 1; 
	}
	public function add_entity_global_form($ref=array()) {
		$c = count($this->ref)-1; // existing index
		if (!is_array($ref)) $ref = array($ref);
		$this->ref[$c]["ck_edicao_global"] = 1; 
		$this->ref[$c]["edicao_global_ref"] = $ref; 
		$this->ck_global_form = 1; 
	}
	public function add_entity_related($condition) {
		$c = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c]["related"])) $this->ref[$c]["related"] = array();
		$this->ref[$c]["related"][count($this->ref[$c]["related"])] = $condition; 
	}
	public function add_js($name) {
		$ck_exists = 0;
		for ($i=0; $i<count($this->js_ref); $i++) {
			if ($this->js_ref[$i] == $name) {
				$ck_exists = 1;
				break;
			}
		}
		if ($ck_exists == 0) {
			$c = count($this->js_ref); // new index
			$this->js_ref[$c] = $name; 
		}
	}
	public function add_link($url, $name, $receiver=null, $popup=0, $target="_self") {
		$this->ck_label_link = -1;
		for ($i=0; $i<count($this->label); $i++) {
			if ($receiver == $this->label[$i]["field"]) {
				$this->label[$i]["link"] = array(
					"url" => $url,
					"name" => $name,
					"receiver" => $receiver,
					"popup" => $popup,
					"target" => $target,
					"param" => null,
					"param_condition" => null,
					"param_var" => null
				);
				$this->ck_label_link = $i;
				break;
			}
		}
		if ($this->ck_label_link < 0) {
			$c = count($this->link_ref); // new index
			$this->link_ref[$c] = array(
				"url" => $url,
				"name" => $name,
				"receiver" => $receiver,
				"popup" => $popup,
				"target" => $target,
				"param" => null,
				"param_condition" => null,
				"param_var" => null
			);
		}
	}
	public function add_link_param($param, $condition, $var) {
		if ($this->ck_label_link >= 0) {
			$this->label[$this->ck_label_link]["link"]["param"] = $param;
			$this->label[$this->ck_label_link]["link"]["param_condition"] = $condition;
			$this->label[$this->ck_label_link]["link"]["param_var"] = $var;
		} else {
			$c = count($this->link_ref)-1; // existing index
			$this->link_ref[$c]["param"] = $param;
			$this->link_ref[$c]["param_condition"] = $condition;
			$this->link_ref[$c]["param_var"] = $var;
		}
	}
	public function add_color_param($param, $condition, $var, $color) {
		$c = count($this->color_ref); // new index
		$this->color_ref[$c]["color"] = $color;
		$this->color_ref[$c]["param"] = $param;
		$this->color_ref[$c]["param_condition"] = $condition;
		$this->color_ref[$c]["param_var"] = $var;
	}
	public function add_header($header) {
		$c = count($this->header); // new index
		$this->header[$c] = $header;
	}
	/*
	public function set_entity_origem($join_column, $table, $id, $label) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_join"] = $join_column;
		$this->ref[$c]["entity_table"] = $table;
		$this->ref[$c]["entity_label"] = $label;
		$this->ref[$c]["entity_id"] = $id;
	}
	public function set_entity_entity_group($join_column, $table, $id, $label) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["group_join"] = $join_column;
		$this->ref[$c]["group_table"] = $table;
		$this->ref[$c]["group_label"] = $label;
		$this->ref[$c]["group_id"] = $id;
	}
	*/
	public function set_entity_origem($qry, $label, $ck_dependent=1) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_qry"] = $qry;
		$this->ref[$c]["entity_label"] = $label;
		$this->ref[$c]["entity_dependent"] = $ck_dependent;
		$this->ref[$c]["entity_group"] = "";
	}
	public function set_entity_group($group) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_group"] = $group;
	}
	public function set_entity_cols($cols) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_cols"] = $cols;
	}
	public function set_entity_layout($layout) {
		// V = Vertical, H = Horizontal
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_layout"] = $layout;
	}
	public function set_key($pk, $label = null) {
		$this->pk = $pk;
		if (is_array($this->pk)) {
			$this->list_param = array();
			for ($i=0; $i<count($this->pk); $i++) {
				$this->list_param[$this->pk[$i]] = "GETFROMQRY";
			}
		} else {
			$this->list_param[$pk] = "GETFROMQRY";
		}
		if ($label != null) {
			$this->label[0] = array(
				"field" => $label,
				"label" => $label,
				"orderby" => null,
				"repeat" => 0,
				"mode" => "default",
				"alignment" => "left",
				"type" => "",
				"nowrap" => 0,
				"ck_update" => 0,
				"ck_hidden" => 0
			);
		}
	}
	public function add_label($field, $label, $orderby = null, $repeat = 0) {
		if ($repeat == 1) $this->ck_repeat_row = 1;
		$c = count($this->label); // new index
		//$this->set_order($orderby != null ? $orderby : $this->get_field_index($field));
		$this->label[$c] = array(
			"field" => $field,
			"label" => $label,
			"orderby" => $orderby,
			"repeat" => $repeat,
			"mode" => "default",
			"alignment" => "left",
			"type" => "",
			"total" => 0,
			"nowrap" => 0,
			"ck_update" => 0,
			"ck_hidden" => 0
		);
	}
	public function add_label_hidden() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["ck_hidden"] = 1;
	}
	public function set_label_sum($un="R\$") {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["ck_show_total"] = 1;
		$this->set_label_numeric($un);
	}
	public function set_label_numeric($un="R\$") {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["mode"] = "NUM";
		$this->label[$c]["total"] = 0;
		$this->label[$c]["un"] = $un;
		$this->label[$c]["nowrap"] = 1;
		$this->label[$c]["alignment"] = "right";
		$this->ck_showtotal = 1;
	}
	public function set_label_flag_mode() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["mode"] = "flag";
		$this->label[$c]["alignment"] = "center";
		$this->label[$c]["ck_update"] = "0";
	}
	public function set_label_edit_mode($type, $update_key=null, $table=null) {
		$c = count($this->label)-1; // existing index
		//if ($type == "checkbox") $this->label[$c]["alignment"] = "center";
		$this->label[$c]["ck_update"] = "1";
		$this->label[$c]["nowrap"] = "1";
		$this->label[$c]["type"] = $type;
		$this->label[$c]["update_key"] = $update_key;
		$this->label[$c]["table"] = $table != null ? $table : $this->table;
		$this->label[$c]["prop"] = array();
		$this->label[$c]["ck_req"] = 0;
		$this->ck_flag_mode = 1;
	}
	public function add_label_field_prop($prop, $value=null, $ix=null) {
		$c = count($this->label)-1; // existing index
		if (isset($this->label[$c]["prop"][$prop]))
			$this->label[$c]["prop"][$prop] .= ";" . $value;
		else
			$this->label[$c]["prop"][$prop] = $value;
	}
	public function set_label_field_comment($value,$pos="after") {
		$c = count($this->label)-1; // existing index
		if ($pos == "after")
			$this->label[$c]["comment"] = $value;
		if ($pos == "before")
			$this->label[$c]["comment_before"] = $value;
	}
	public function set_label_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label,
			"xtra_fields" => $xtra_fields,
			"ck_new_entry" => 0
		);
	}
	public function set_order($field, $direction = "ASC") {
		$c = count($this->order); // new index
		$this->order[$c] = array(
			"field" => $field,
			"direction" => $direction
		);
	}
	public function set_group($field) {
		$c = count($this->group); // new index
		$this->group[$c] = array(
			"field" => $field
		);
	}
	public function add_graph($fields, $type) {
		$c = count($this->graph); // new index
		$this->graph[$c] = array(
			"fields" => is_array($fields) ? $fields : array($fields),
			"type" => $type
		);
	}
	public function add_edit_mode_action($url, $label, $function="ckform_list(this.form)") {
		$c = count($this->flag_mode_action); // new index
		$this->flag_mode_action[$c] = array("url"=>$url, "label"=>$label, "function"=>$function, "xtra_field"=>array());
	}
	public function add_edit_mode_action_val($field, $val) {
		$c = count($this->flag_mode_action)-1; // existing index
		$c_ref = count($this->flag_mode_action[$c]["xtra_field"]); // new index
		$this->flag_mode_action[$c]["xtra_field"][$c_ref] = array("field"=>$field, "val"=>$val);
	}
	public function add_edit_mode_field($field, $label, $type, $ck_req=0) {
		$c_ref = count($this->flag_mode_ref); // new index
		$this->flag_mode_ref[$c_ref] = array(
			"field" => $field, 
			"label" => $label, 
			"type" => $type, 
			"prop" => array(), 
			"ck_req" => $ck_req);
		if ($type == "filteredtext") {
			$this->add_js("ajax_lib.js");
			//$this->add_js("filteredtext.js");
			$this->add_js("sarissa.js");
		}
	}
	public function add_edit_mode_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->flag_mode_ref)-1; // existing index
		$this->flag_mode_ref[$c_ref]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label,
			"xtra_fields" => $xtra_fields,
			"ck_new_entry" => 0
		);
	}
	public function set_edit_field_mask($value, $write_mask=1, $unlock_mask=0) {
		$c_ref = count($this->flag_mode_ref)-1;
		$this->flag_mode_ref[$c_ref]["mask"] = $value;
		$this->flag_mode_ref[$c_ref]["write_mask"] = $write_mask;
		$this->flag_mode_ref[$c_ref]["unlock_mask"] = $unlock_mask;
		if ($unlock_mask == 1) $this->ck_unlock = 1;
		$this->add_edit_field_prop("onfocus", "recvalue(this)");
		$this->add_edit_field_prop("onkeyup", "gotofield(this.form,this)");
	}
	public function add_edit_field_prop($prop, $value=null, $ix=null) {
		$c_ref = is_numeric($ix) ? $ix : count($this->flag_mode_ref)-1;
		if (isset($this->flag_mode_ref[$c_ref]["prop"][$prop]))
			$this->flag_mode_ref[$c_ref]["prop"][$prop] .= ";" . $value;
		else
			$this->flag_mode_ref[$c_ref]["prop"][$prop] = $value;
	}
	public function set_label_alignment($val) {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["alignment"] = $val;
	}
	public function set_label_nowrap() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["nowrap"] = 1;
	}
	public function add_group_key($field, $order=null, $direction="ASC") {
		$c = count($this->group_key);
		$this->group_key[$c]["field"] = $field;
		$this->group_key[$c]["order"] = $order == null ? $field : $order;
		$this->group_key[$c]["direction"] = $direction;
	}
	public function set_recursive_mode($ix_hierarquia) {
		$this->ck_recursive = 1;
		$this->recursive_index = $ix_hierarquia;
	}
	public function set_csv_export($ref) {
		$this->ck_csv_export = 1;
		$this->csv_export_ref = $ref;
	}
	public function add_condition($str) {
		$this->condition[count($this->condition)] = $str;
	}
	public function add_related($join, $use="L") {
		$this->related[count($this->related)] = array(
			"sql" => $join,
			"use" => $use
		);
	}
	public function add_dependency($table, $ix, $label = null) {
		$this->dependency[count($this->dependency)] = array(
			"table" => $table,
			"ix" => $ix,
			"label" => $label != null ? $label : $table
		);
	}
	public function add_delete_cascade($table, $ix) {
		$this->delete_cascade[count($this->delete_cascade)] = array(
			"table" => $table,
			"ix" => $ix
		);
	}
	public function set_groupbyativo($field = false) {
		$this->set_groupby_active_flag($field);
	}
	public function set_groupby_active_flag($field = false) {
		$this->ck_active = 1; 
		$temp = explode(" ", $this->table);
		$qry_table = $temp[count($temp)-1];
		if ($field == false)
			$this->active_field = "$qry_table.ativo"; 
		else
			$this->active_field = $field; 
	}
	public function set_collapse() {
		$this->ck_collapse = 1; 
	}
	public function set_list_qry($qry) {
		$this->list_qry = $qry;
		$this->list_modo = "custom";
	}
	// field
	public function get_field_label($field) {
		if (strpos($field, "AS ") > 1)
			return substr($field, strpos($field, "AS ")+3);
		elseif (strpos($field, ".") > 1 && 
			(substr($field, strpos($field, ".")-3, 3) != "dbo" || $this->db != "MSSQL"))
			return substr($field, strpos($field, ".")+1);
		else
			return $field;
	}
	public function get_field_index($field) { // public used by cls_report
		if (strpos($field, "AS ") > 1)
			return substr($field, 0, strpos($field, "AS "));
		//else if (strpos($field, ".") > 1)
		//	return substr($field, strpos($field, ".")+1);
		else
			return $field;
	}
	public function add_tab($label, $table=null, $key=null) {
		$c_ref = count($this->tab_ref); // new index
		$this->tab_ref[$c_ref]["label"] = $label;
		$this->tab_ref[$c_ref]["table"] = $table;
		$this->tab_ref[$c_ref]["key"] = $key;
		$this->tab_ref[$c_ref]["req_dependency"] = array();
		if ($table != null) {
			$this->add_related("LEFT JOIN $table ON $table.$key = $this->table.$this->pk", $use="FU");
		}
	}
	public function config_tab_req($field="tab") {
		$c_ref = count($this->tab_ref)-1; // existing index
		$this->tab_ref[$c_ref]["req_dependency"][count($this->tab_ref[$c_ref]["req_dependency"])] = $field;
	}
	public function add_field($field, $label, $type, $ck_req=0, $ck_qry=1) {
		$c_ref = count($this->ref); // new index
		$tab_id = count($this->tab_ref)-1; 
		$this->ref[$c_ref] = array(
			"field" => $field, 
			"label" => $label, 
			"type" => $type, 
			"ck_req" => $ck_req, 
			"req_dependency" => $ck_req == 1 && $tab_id >= 0 ? $this->tab_ref[$tab_id]["req_dependency"] : array(), 
			"ck_qry" => $ck_qry, 
			"prop" => array(),
			"field_group" => $this->field_group, 
			"ck_hidden" => 0,
			"ck_separator" => 0, 
			"ck_bak" => 0,
			"file_name_mask" => "[id]",
			"tab_id" => $tab_id);
		if ($type == "color") {
			$this->add_js("fn_buildcolortable.js");
		} else if ($type == "publisher") {
			$this->publisher_ref[count($this->publisher_ref)] = $field;
			$this->ref[$c_ref]["publisher_img_action"] = "$this->js_dir/publisher_lib.img.php";
			$this->ref[$c_ref]["publisher_img_dir"] = "imagens/";
			$this->add_js("publisher_lib.js");
			$this->add_onload_action("_initPublisher()");
		} else if ($type == "filteredtext") {
			$this->add_js("ajax_lib.js");
			$this->add_js("sarissa.js");
		} else if ($type == "dynamiclist") {
			$this->add_js("dynamiclist_lib.js");
			$this->add_js("drag_lib.js");
			$this->add_js("sarissa.js");
		} else if ($type == "password" && $ck_qry==1) {
			$this->add_field("confirm_$field", "$this->lang_password_confirm $label", "password", $ck_req=1, $ck_qry=0);
			$this->add_form_rule("form.$field.value != \"\" && form.$field.value != form.confirm_$field.value", "$this->lang_js_field \\\"$field\\\" $this->lang_js_password");
		}
	}
	public function config_field_req($field) {
		$c_ref = count($this->ref)-1; // existing index
		$this->ref[$c_ref]["req_dependency"][count($this->ref[$c_ref]["req_dependency"])] = $field;
	}
	public function add_form_separator() {
		$c_ref = count($this->ref)-1; // existing index
		$this->ref[$c_ref]["ck_separator"] = 1;
	}
	public function add_form_rule_unique($ix) {
		if (!is_array($ix)) $ix = array($ix);
		$str_fn = "";
		$str_cn = "";
		for ($i=0; $i<count($this->ref); $i++) {
			for ($j=0; $j<count($ix); $j++) {
				if ($this->ref[$i]["field"] == $ix[$j]) {
					$str_fn .= ($str_fn != "" ? "," : "") . "'".$this->ref[$i]["field"]."'";
					if ($this->ref[$i]["type"] == "dropdown")
						$prop = "document.getElementById(\"".$this->ref[$i]["field"]."\")[document.getElementById(\"".$this->ref[$i]["field"]."\").selectedIndex].text";
					elseif ($this->ref[$i]["type"] == "radio")
						$prop = "fn_get_radio_value(\"".$this->ref[$i]["field"]."\")";
					else
						$prop = "document.getElementById(\"".$this->ref[$i]["field"]."\").value";
					if ($this->ref[$i]["label"] != "")
						$str_cn .= " - ".$this->ref[$i]["label"]." = \" + $prop + \"\\n";
				}
			}
		}
		$fn = "fn_ck_unique($this->ck_unique,new Array($str_fn))";
		for ($i=0; $i<count($this->ref); $i++) {
			for ($j=0; $j<count($ix); $j++) {
				if ($this->ref[$i]["field"] == $ix[$j]) {
					if ($this->ref[$i]["type"] == "dropdown")
						$this->add_field_prop("onchange", $fn, $i);
					elseif ($this->ref[$i]["type"] == "radio")
						$this->add_field_prop("onclick", $fn, $i);
					else 
						$this->add_field_prop("onblur", $fn, $i);
				}
			}
		}
		$this->add_form_rule("document.formulario.ck_unique$this->ck_unique.value == 1", "$this->lang_js_unique:\\n$str_cn");
		$this->add_js("sarissa.js");
		$this->add_js("ajax_lib.js");
		$this->ck_unique++;
	}
	public function add_form_rule($condition, $msg, $scope = "form") {
		$c_ref = count($this->form_rule);
		$this->form_rule[$c_ref]["condition"] = $condition;
		$this->form_rule[$c_ref]["msg"] = $msg;
		$this->form_rule[$c_ref]["scope"] = $scope;
	}
	public function start_field_group($value) {
		$this->field_group = $value; 
	}
	public function end_field_group() {
		$this->field_group = null; 
	}
	public function set_field_mask($value, $write_mask=1, $unlock_mask=0) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["mask"] = $value;
		$this->ref[$c_ref]["write_mask"] = $write_mask;
		$this->ref[$c_ref]["unlock_mask"] = $unlock_mask;
		if ($unlock_mask == 1) $this->ck_unlock = 1;
		$this->add_field_prop("onfocus", "recvalue(this)");
		$this->add_field_prop("onkeyup", "gotofield(this.form,this)");
	}
	public function set_field_default($value) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["default"] = $value;
	}
	public function ck_field_email() {
		$c_ref = count($this->ref)-1;
		$this->add_form_rule("!mail_reg.test(form." . $this->ref[$c_ref]["field"] . ".value)", "$this->lang_js_field \\\"" . $this->ref[$c_ref]["label"] . "\\\" $this->lang_js_format.");
		$this->ck_verify_email = 1;
	}
	public function add_field_bak() {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ck_bak"] = 1;
	}
	public function set_field_comment($value,$pos="after") {
		$c_ref = count($this->ref)-1;
		if ($pos == "after")
			$this->ref[$c_ref]["comment"] = $value;
		if ($pos == "before")
			$this->ref[$c_ref]["comment_before"] = $value;
	}
	public function set_field_hidden($field = null, $val = "") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ck_hidden"] = 1;
		if ($field != null) {
			$this->ref[$c_ref]["ck_hidden_condition"] = array("field" => $field, "val" => $val);
			for ($i=0; $i<count($this->ref); $i++) {
				if ($this->ref[$i]["field"] == $field) {
					if ($this->ref[$i]["type"] == "checkbox" && $val == 1)
						$this->add_field_prop("onclick", "document.getElementById('tr$c_ref').style.display=(this.checked?'none':'')", $i);
					else if ($this->ref[$i]["type"] == "checkbox" && $val == 0)
						$this->add_field_prop("onclick", "document.getElementById('tr$c_ref').style.display=(!this.checked?'none':'')", $i);
					else
						$this->add_field_prop("onclick", "document.getElementById('tr$c_ref').style.display=(this.value=='$val'?'none':'')", $i);
					break;
				}
			}
		}
		$this->hidden_ref[count($this->hidden_ref)] = $c_ref;
	}
	public function set_field_ajaxtable($table, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxtable"] = $table;
		$this->ref[$c_ref]["ajaxid"] = $id;
		$this->ref[$c_ref]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["ajaxcondition"] = "";
		$this->ref[$c_ref]["ajaxfunction"] = "nc_query";
		if (!isset($this->ref[$c_ref]["ajaxaction"])) 
			$this->ref[$c_ref]["ajaxaction"] = array();
		$this->ref[$c_ref]["ajax_xtrafield"] = array();
	}
	public function set_field_ajaxqry($qry, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxqry"] = $qry;
		$this->ref[$c_ref]["ajaxid"] = $id;
		$this->ref[$c_ref]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["ajaxaction"] = array();
		$this->ref[$c_ref]["ajax_xtrafield"] = array();
	}
	public function set_field_ajaxcondition($condition) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxcondition"] = $condition;
	}
	public function set_field_ajaxfunction($function) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxfunction"] = $function;
	}
	public function set_field_ajaxpath($url, $filter="") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxpath"] = $url;
		$this->ref[$c_ref]["ajaxfilter"] = $filter;
		$this->ref[$c_ref]["ajaxaction"] = array();
		$this->ref[$c_ref]["ajax_xtrafield"] = array();
	}
	public function set_field_ajaxaction($action, $modo="S", $ix=null) {
		$this->add_field_ajaxaction($action, $modo, $ix);
	}
	public function add_field_ajaxaction($action, $modo="S", $ix=null) {
		// $modo => S = SELECT, R = RESET
		$c_ref = is_numeric($ix) ? $ix : count($this->ref)-1;
		if (!isset($this->ref[$c_ref]["ajaxaction"])) $this->ref[$c_ref]["ajaxaction"] = array();
		$c = count($this->ref[$c_ref]["ajaxaction"]);
		$this->ref[$c_ref]["ajaxaction"][$c] = array("action" => $action, "modo" => $modo);
	}
	public function add_field_ajax_xtrafield($field, $xml_label, $ix=null) {
		$c_ref = is_numeric($ix) ? $ix : count($this->ref)-1;
		if (!isset($this->ref[$c_ref]["ajax_xtrafield"])) $this->ref[$c_ref]["ajax_xtrafield"] = array();
		$c = count($this->ref[$c_ref]["ajax_xtrafield"]);
		$this->ref[$c_ref]["ajax_xtrafield"][$c] = array("field" => $field, "xml_label" => $xml_label);
	}
	public function set_field_currency($value) {
		$this->set_field_comment($value,"before");
	}
	public function add_field_prop($prop, $value=null, $ix=null) {
		$c_ref = is_numeric($ix) ? $ix : count($this->ref)-1;
		if (isset($this->ref[$c_ref]["prop"][$prop]))
			$this->ref[$c_ref]["prop"][$prop] .= ";" . $value;
		else
			$this->ref[$c_ref]["prop"][$prop] = $value;
	}
	public function add_field_list($list) {
		$this->set_field_list($list);
	}
	public function set_field_list($list) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["list"] = $list;
	}
	public function add_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$this->set_field_qry($qry, $ix, $label, $group_label, $xtra_fields);
	}
	public function set_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label,
			"xtra_fields" => $xtra_fields,
			"ajax" => $this->ck_ajax_qry($qry, $this->ref, "field"),
			"ck_new_entry" => 0
		);
		$this->ref[$c_ref]["ajaxfunction"] = "nc_query";
	}
	public function set_field_index($ix, $table = null) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["field_qry"] = $ix;
		$this->ref[$c_ref]["table"] = $table;
	}
	private function ck_ajax_qry($qry, $ref, $obj) {
		$c_ref = count($ref)-1;
		$ck_ajax = 0;
		preg_match_all("[\[([a-zA-Z0-9_])+\]]", $qry, $match);
		if (count($match[0]) > 0) {
			$this->add_js("ajax_lib.js");
			$this->add_js("sarissa.js");
			for ($i=0; $i<count($match[0]); $i++) {
				for ($j=0; $j<count($ref); $j++) {
					if (strtolower(substr($match[0][$i],1,-1)) == strtolower($ref[$j]["field"])) {
						$action = "fn_get_list('" . $ref[$c_ref]["field"] . "','$this->document_name_xml?modo=xml&field=" . $ref[$c_ref]["field"] . "&obj=$obj&" . ereg_replace("modo=([a-z]+)(\&)*","",$_SERVER["QUERY_STRING"]) . "',document.getElementById('".$ref[$j]["field"]."').value)";
						$action_reset = "fn_get_list('" . $ref[$c_ref]["field"] . "','$this->document_name_xml?modo=xml&field=" . $ref[$c_ref]["field"] . "&obj=$obj&" . ereg_replace("modo=([a-z]+)(\&)*","",$_SERVER["QUERY_STRING"]) . "',0)";
						if ($ref[$j]["type"] == "dropdown") {	
							if ($obj == "field")
								$this->add_field_prop("onchange", $action, $j);
							elseif ($obj == "entity_field")
								$this->add_entity_field_prop("onchange", $action, $j);
							elseif ($obj == "filter")
								$this->add_filter_prop("onchange", $action, $j);
						} else if ($ref[$j]["type"] == "filteredtext") {
							if ($obj == "field") {
								$this->add_field_ajaxaction($action,"S", $j);
								$this->add_field_ajaxaction($action_reset, "R", $j);
							} else if ($obj == "entity_field") {
								$this->set_entity_field_ajaxaction($action,"S", $j);
								$this->set_entity_field_ajaxaction($action_reset, "R", $j);
							} else if ($obj == "filter") {
								$this->set_filter_ajaxaction($action,"S", $j);
								$this->set_filter_ajaxaction($action_reset, "R", $j);
							}
						}
						$ck_ajax = 1;
					}
					if ($ck_ajax == 1) break;
				}
				if ($ck_ajax == 1) break;
			}
		}
		return $ck_ajax;
	}
	public function set_field_qry_new_entry($table, $field, $url, $pk="@@identity") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["qry"]["ck_new_entry"] = 1;
		$this->ref[$c_ref]["qry"]["new_entry_table"] = $table;
		$this->ref[$c_ref]["qry"]["new_entry_field"] = $field;
		$this->ref[$c_ref]["qry"]["new_entry_url"] = $url;
		$this->ref[$c_ref]["qry"]["new_entry_pk"] = $pk;
		$this->add_field_prop("onchange", "document.getElementById(this.id+'_entry').style.display=this.value=='NEW'?'':'none'");
	}
	public function set_dropdown_multiple($size, $table, $key, $xtra_key=array()) {
		$c_ref = count($this->ref)-1;
		$this->add_field_prop("size", $size);
		$this->add_field_prop("multiple");
		$this->set_field_entity($table, $key, $xtra_key);
	}
	public function set_field_entity($table, $key, $xtra_key=array()) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["table"] = $table;
		$this->ref[$c_ref]["key_field"] = $key;
		$this->ref[$c_ref]["xtra_key"] = $xtra_key;
		// form join
		$str = "LEFT JOIN $table ON $table.$key = $this->table.$this->pk";
		$keys = array_keys($xtra_key);
		for ($i=0; $i<count($keys); $i++) {
			if (substr($xtra_key[$keys[$i]],0,6) == "SELECT")
				$str .= " AND $table." . $keys[$i] . " IN (" . $xtra_key[$keys[$i]] . ")";
			else
				$str .= " AND $table." . $keys[$i] . " = '" . $xtra_key[$keys[$i]] . "'";
		}
		$this->add_related($str, $use="F");
	}
	public function set_field_ref_query($sql, $label, $function="nc_query") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ref_qry"] = $sql;
		$this->ref[$c_ref]["ref_label"] = $label;
		$this->ref[$c_ref]["ref_function"] = $function;
	}
	public function set_field_filedir($dirgrande, $maxsizegrande=false, $dirthumb=false, $maxsizethumb=false) {
		$this->add_field_dir($dirgrande, $maxsizegrande);
		if ($dirthumb != false) $this->add_field_dir($dirthumb, $maxsizethumb, 1);
		/*
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["filedir"] = $dirgrande;
		if ($maxsizegrande != false) $this->ref[$c_ref]["filemaxsize"] = $maxsizegrande;
		if ($dirthumb != false) $this->ref[$c_ref]["filedirthumb"] = $dirthumb;
		if ($maxsizethumb != false) $this->ref[$c_ref]["filemaxsizethumb"] = $maxsizethumb;
		*/
	}
	public function set_field_file_name($mask) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["file_name_mask"] = $mask;
	}
	public function add_field_dir($dir, $maxsize=false, $ck_thumb=0) {
		$c_ref = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c_ref]["file"])) $this->ref[$c_ref]["file"] = array();
		$c = count($this->ref[$c_ref]["file"]); // new index
		if (is_array($dir)) {
			$this->ref[$c_ref]["file"][$c]["dir"]["O"] = $dir[0]; // access dir
			$this->ref[$c_ref]["file"][$c]["dir"]["D"] = $dir[1]; // write dir
		} else {
			$this->ref[$c_ref]["file"][$c]["dir"]["O"] = $dir;
			$this->ref[$c_ref]["file"][$c]["dir"]["D"] = $dir;
		}
		$this->ref[$c_ref]["file"][$c]["maxsize"] = $maxsize;
		$this->ref[$c_ref]["file"][$c]["ck_thumb"] = $ck_thumb;
		//$this->ref[$c_ref]["file"][$c]["mask"] = $mask;
	}
	public function set_publisher_img_dir($dir) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["publisher_img_dir"] = $dir;
	}
	public function add_radio_option($val, $label, $field=null, $type=null, $sql=null, $qry_ix=null, $qry_label=null, $group_label=null) {
		$c_ref = count($this->ref)-1; // existing index
		$this->ref[$c_ref]["list"][$val] = array(
			"ck_xtra" => 1, 
			"label" => $label, 
			"field" => $field, 
			"type" => $type, 
			"ck_req" => 0, 
			"prop" => array(),
			"qry" => array(
				"sql" => $sql, 
				"ix" => $qry_ix, 
				"label" => $qry_label, 
				"group_label" => $group_label, 
				"ajax" => 0,
				"ck_new_entry" => 0,
				"xtra_fields" => array())
		);
		$tab_id = $this->ref[$c_ref]["tab_id"];
		$field = $this->ref[$c_ref]["field"];
		if (count($this->tab_ref) > 0 && $this->tab_ref[$tab_id]["table"] != null)
			 $field = $this->tab_ref[$tab_id]["table"] . "_" . $field;
		if ($type == "text") {
			$this->ref[$c_ref]["list"][$val]["prop"]["onfocus"] = "temp=this.value";
			$this->ref[$c_ref]["list"][$val]["prop"]["onblur"] = "temp!=this.value?{$field}[".(count($this->ref[$c_ref]["list"])-1)."].checked=true:void(null)";
		} else if ($type == "dropdown") {
			$this->ref[$c_ref]["list"][$val]["prop"]["onchange"] = "{$field}[".(count($this->ref[$c_ref]["list"])-1)."].checked=true";
		}
	}
	public function add_radio_field_prop($prop, $value=true) {
		$c_ref = count($this->ref)-1; // existing index
		$keys = array_keys($this->ref[$c_ref]["list"]);
		$ix = $keys[count($keys)-1];
		if (isset($this->ref[$c_ref]["list"][$ix]["prop"][$prop]))
			$this->ref[$c_ref]["list"][$ix]["prop"][$prop] .= ";" . $value;
		else
			$this->ref[$c_ref]["list"][$ix]["prop"][$prop] = $value;
	}
	// entity field
	public function add_entity_field($field, $label=null, $type=null, $ck_req=0, $ck_qry=1, $title=null) {
		$c_ref = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c_ref]["field"])) $this->ref[$c_ref]["field"] = array();
		$c = count($this->ref[$c_ref]["field"]);
		if ($this->ref[$c_ref]["rel"] == "NXN" && $this->ref[$c_ref]["entity_dependent"] == 0 && $c > 0) exit("NXN entity not dependent only accepts one field");
		$this->ref[$c_ref]["field"][$c] = array(
			"field" => $field, 
			"label" => $label, 
			"type" => $type, 
			"ck_req" => $ck_req, 
			"ck_qry" => $ck_qry, 
			"ck_bak" => 0, 
			"ck_hidden" => 0, 
			"prop" => array(),
			"file_name_mask" => "[id].jpg",
			"title" => $title,
			"tab_id" => $this->ref[$c_ref]["tab_id"]);
		if ($type == "filteredtext") {
			$this->add_js("ajax_lib.js");
			//$this->add_js("filteredtext.js");
			$this->add_js("sarissa.js");
		}
	}
	public function add_entity_trava($field, $val) {

		$c_ref = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c_ref]["entity_trava"])) $this->ref[$c_ref]["entity_trava"] = array();
		$c = count($this->ref[$c_ref]["entity_trava"]);
		$this->ref[$c_ref]["entity_trava"][$c] = array(
			"field" => $field,
			"val" => $val
		);
	}
	public function set_entity_field_mask($value, $write_mask=1, $unlock_mask=0) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["mask"] = $value;
		$this->ref[$c_ref]["field"][$c]["write_mask"] = $write_mask;
		$this->ref[$c_ref]["field"][$c]["unlock_mask"] = $unlock_mask;
		if ($unlock_mask == 1) $this->ck_unlock = 1;
		$this->add_entity_field_prop("onfocus", "recvalue(this)");
		$this->add_entity_field_prop("onkeyup", "gotofield(this.form,this)");
	}
	public function set_entity_field_default($value) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["default"] = $value;
	}
	public function add_entity_field_bak() {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ck_bak"] = 1;
	}
	public function set_entity_field_comment($value,$pos="after") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		if ($pos == "after")
			$this->ref[$c_ref]["field"][$c]["comment"] = $value;
		if ($pos == "before")
			$this->ref[$c_ref]["field"][$c]["comment_before"] = $value;
	}
	public function set_entity_field_hidden() {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ck_hidden"] = 1;
		//$this->hidden_ref[count($this->hidden_ref)] = $c_ref;
	}
	public function set_entity_field_ajaxtable($table, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxtable"] = $table;
		$this->ref[$c_ref]["field"][$c]["ajaxid"] = $id;
		$this->ref[$c_ref]["field"][$c]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["field"][$c]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["field"][$c]["ajaxaction"] = array();
		$this->ref[$c_ref]["field"][$c]["ajax_xtrafield"] = array();
	}
	public function set_entity_field_ajaxqry($qry, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxqry"] = $qry;
		$this->ref[$c_ref]["field"][$c]["ajaxid"] = $id;
		$this->ref[$c_ref]["field"][$c]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["field"][$c]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["field"][$c]["ajaxaction"] = array();
		$this->ref[$c_ref]["field"][$c]["ajax_xtrafield"] = array();
	}
	public function set_entity_field_ajaxcondition($condition) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxcondition"] = $condition;
	}
	public function set_entity_field_ajaxfunction($function) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = $function;
	}
	public function set_entity_field_ajaxpath($url, $filter="") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxpath"] = $url;
		$this->ref[$c_ref]["field"][$c]["ajaxfilter"] = $filter;
		$this->ref[$c_ref]["field"][$c]["ajaxaction"] = array();
		$this->ref[$c_ref]["field"][$c]["ajax_xtrafield"] = array();
	}
	public function set_entity_field_ajaxaction($action, $modo = "S", $ix=null) {
		$this->add_entity_field_ajaxaction($action, $modo, $ix);
	}
	public function add_entity_field_ajaxaction($action, $modo = "S", $ix=null) {
		// $modo => S = SELECT, R = RESET
		$c_ref = count($this->ref)-1;
		$c = is_numeric($ix) ? $ix : count($this->ref[$c_ref]["field"])-1;
		$c_action = isset($this->ref[$c_ref]["field"][$c]["ajaxaction"]) ? count($this->ref[$c_ref]["field"][$c]["ajaxaction"]) : 0;
		$this->ref[$c_ref]["field"][$c]["ajaxaction"][$c_action] = array("action" => $action, "modo" => $modo);
	}
	public function add_entity_field_ajax_xtrafield($field, $xml_label, $ix=null) {
		$c_ref = count($this->ref)-1;
		$c = is_numeric($ix) ? $ix : count($this->ref[$c_ref]["field"])-1;
		$c_field = isset($this->ref[$c_ref]["field"][$c]["ajax_xtrafield"]) ? count($this->ref[$c_ref]["field"][$c]["ajax_xtrafield"]) : 0;
		$this->ref[$c_ref]["field"][$c]["ajax_xtrafield"][$c_field] = array("field" => $field, "xml_label" => $xml_label);
	}
	public function set_entity_field_filedir($dirgrande, $maxsizegrande=false, $dirthumb=false, $maxsizethumb=false) {
		$this->add_entity_field_dir($dirgrande, $maxsizegrande);
		if ($dirthumb != false) $this->add_entity_field_dir($dirthumb, $maxsizethumb, 1);
		/*
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["filedir"] = $dirgrande;
		if ($maxsizegrande != false) $this->ref[$c_ref]["field"][$c]["filemaxsize"] = $maxsizegrande;
		if ($dirthumb != false) $this->ref[$c_ref]["field"][$c]["filedirthumb"] = $dirthumb;
		if ($maxsizethumb != false) $this->ref[$c_ref]["field"][$c]["filemaxsizethumb"] = $maxsizethumb;
		*/
	}
	public function set_entity_field_file_name($mask) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["file_name_mask"] = $mask;
	}
	public function add_entity_field_dir($dir, $maxsize=false, $ck_thumb=0) {
		$c_ref = count($this->ref)-1; // existing index
		$c = count($this->ref[$c_ref]["field"])-1; // existing index
		if (!isset($this->ref[$c_ref]["field"][$c]["file"])) $this->ref[$c_ref]["field"][$c]["file"] = array();
		$c2 = count($this->ref[$c_ref]["field"][$c]["file"]); // new index
		if (is_array($dir)) {
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["O"] = $dir[0];
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["D"] = $dir[1];
		} else {
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["O"] = $dir;
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["D"] = $dir;
		}
		$this->ref[$c_ref]["field"][$c]["file"][$c2]["maxsize"] = $maxsize;
		$this->ref[$c_ref]["field"][$c]["file"][$c2]["ck_thumb"] = $ck_thumb;
		//$this->ref[$c_ref]["field"][$c]["file"][$c2]["mask"] = $mask;
	}
	public function add_entity_field_prop($prop, $value=null, $ix=null) {
		$c_ref = count($this->ref)-1;
		$c = is_numeric($ix) ? $ix : count($this->ref[$c_ref]["field"])-1;
		if (isset($this->ref[$c_ref]["field"][$c]["prop"][$prop]))
			$this->ref[$c_ref]["field"][$c]["prop"][$prop] .= ";" . $value;
		else
			$this->ref[$c_ref]["field"][$c]["prop"][$prop] = $value;
	}
	public function add_entity_field_list($list) {
		$this->set_entity_field_list($list);
	}
	public function set_entity_field_list($list) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["list"] = $list;
		$this->ref[$c_ref]["field"][$c]["ref_qry"] = null;
	}
	public function add_entity_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$this->set_entity_field_qry($qry, $ix, $label, $group_label, $xtra_fields);
	}
	public function set_entity_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label, 
			"xtra_fields" => $xtra_fields, 
			"ajax" => $this->ck_ajax_qry($qry, $this->ref[$c_ref]["field"][$c], "entity_field"),
			"ck_new_entry" => 0
		);
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["field"][$c]["ref_qry"] = null;
	}
	public function set_entity_field_new_entry($table, $field, $url, $pk="@@identity") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["qry"]["ck_new_entry"] = 1;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_table"] = $table;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_field"] = $field;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_url"] = $url;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_pk"] = $pk;
		$field = $this->ref[$c_ref]["field"][$c]["field"];
		$this->add_entity_field_prop("onchange", "document.getElementById(this.id.replace('$field','{$field}_entry')).style.display=this.value=='NEW'?'':'none'");
	}
	public function set_entity_field_ref_query($sql, $label, $function="nc_query") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ref_qry"] = $sql;
		$this->ref[$c_ref]["field"][$c]["ref_label"] = $label;
		$this->ref[$c_ref]["field"][$c]["ref_function"] = $function;
	}
	public function set_entity_dropdown_multiple($size, $table, $key) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->add_entity_field_prop("size", $size);
		$this->add_entity_field_prop("multiple");
		$this->set_entity_field_entity($table, $key);
	}
	public function set_entity_field_entity($table, $key, $xtra_key=array()) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["table"] = $table;
		$this->ref[$c_ref]["field"][$c]["key_field"] = $key;
		$this->ref[$c_ref]["field"][$c]["xtra_key"] = $key;
	}
	public function add_list_param($param, $val = "GETFROMQRY") {
		$this->list_param[$param] = $val;
	}
	public function set_list_title_mode($value) {
		$this->list_title_mode = $value;
	}
	private function get_res_aux($ref,$nodebug=0) { 
		$ent_table = $ref["table"];
		$key_field = $ref["key_field"];
		$pk = $ref["pk"];
		if (count($this->tab_ref) == 0 || 
			!isset($ref["tab_id"]) || 
			$this->tab_ref[$ref["tab_id"]]["table"] == null)
			$tab_table = "";
		else
			$tab_table = $this->tab_ref[$ref["tab_id"]]["table"];
		$str_field = "";
		$str_join = "";
		for ($i=0; $i<count($ref["field"]); $i++) {
			$field = $ref["field"][$i]["field"];
			$type = $ref["field"][$i]["type"];
			$prop = $ref["field"][$i]["prop"];
			$ck_qry = $ref["field"][$i]["ck_qry"];
			if ($ck_qry == 1) {
				if ($type == "date" || $type == "datetime") {
					$str_field .= ($str_field != "" ? ",\n" : "") . "DAY($ent_table.$field) AS dia_$field, MONTH($ent_table.$field) AS mes_$field, YEAR($ent_table.$field) AS ano_$field";
				} elseif ($type == "daterange") {
					$str_field .= ($str_field != "" ? ",\n" : "") . "DAY($ent_table.{$field}_ini) AS dia_{$field}_ini, MONTH($ent_table.{$field}_ini) AS mes_{$field}_ini, YEAR($ent_table.{$field}_ini) AS ano_{$field}_ini";
					$str_field .= ($str_field != "" ? ",\n" : "") . "DAY($ent_table.{$field}_fim) AS dia_{$field}_fim, MONTH($ent_table.{$field}_fim) AS mes_{$field}_fim, YEAR($ent_table.{$field}_fim) AS ano_{$field}_fim";
				} elseif ($type != "dynamiclist" &&
					($type != "dropdown" || !array_key_exists("multiple", $prop))) {
					$str_field .= ($str_field != "" ? ",\n" : "") . "$ent_table.$field";
					if ($tab_table != "") $str_field .= " AS {$tab_table}_{$field}";
				}
			}
			if ($ref["field"][$i]["type"] == "filteredtext" &&
				isset($ref["field"][$i]["ajaxfunction"]) && 
				$ref["field"][$i]["ajaxfunction"] == "nc_query") {
				$str_field .= ",\n" . $ref["field"][$i]["ajaxtable"] . "." . $ref["field"][$i]["ajaxlabel"] . " AS filteredtext";
				$str_join .= "LEFT JOIN " . $ref["field"][$i]["ajaxtable"] . " ON " . $ref["field"][$i]["ajaxtable"] . "." . $ref["field"][$i]["ajaxid"] . " = $ent_table.$field\n";
			}
			if (isset($ref["field"][$i]["file"])) {
				for ($j=0; $j<count($ref["field"][$i]["file"]); $j++) {
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $ref["field"][$i]["file"][$j]["dir"]["O"], $match);
					for ($k=0; $k<count($match[0]); $k++) {
						if (strpos($match[0][$k], ".") === false)
							$temp = "$ent_table." . substr($match[0][$k],1,-1);
						else
							$temp = substr($match[0][$k],1,-1);
						if (strpos($str_field, $temp) === false) 
							$str_field .= ($str_field != "" ? ",\n" : "") . "$temp";
							if ($tab_table != "") $str_field .= " AS {$tab_table}_{$temp}";
					}
				}
			}
		}
		if (isset($ref["related"])) {
			for ($i=0; $i<count($ref["related"]); $i++) {
				$str_join .= $ref["related"][$i] . "\n";
			}
		}
		if (isset($ref["entity_trava"])) {
			for ($i=0; $i<count($ref["entity_trava"]); $i++) {
				$str_field .= ",$ent_table." . $ref["entity_trava"][$i]["field"];
				if ($tab_table != "") $str_field .= " AS {$tab_table}_" . $ref["entity_trava"][$i]["field"];
			}
		}
		if ($ref["key_condition"] == "" || $ref["key_exclusive"] == 0) {
			if ($tab_table == "")
				$key = $this->vars[$this->pk];
			else
				$key = $this->res_upd[0]["id_$tab_table"];
		}
		$qry = "SELECT 
				$ent_table.$pk, 
				" . (!is_array($key_field) ? "$ent_table.$key_field," : "") . "
				$str_field 
			FROM $ent_table
			$str_join
			WHERE 
				" . ($ref["key_condition"] != "" ? $ref["key_condition"] . " AND" : "") . "
				" . ($ref["key_condition"] == "" || $ref["key_exclusive"] == 0 ? "$ent_table.$key_field = $key AND" : "") . "
				1 = 1";
		if ($nodebug == 0 && $this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
		return nc_query($qry);
	}
	private function get_file_name($mask, $id) {
		$str = $mask;
		preg_match_all("[\[(\.)*[a-zA-Z0-9_]+\]]", $str, $match);
		for ($i=0; $i<count($match[0]); $i++) {
			$var = str_replace(array("[",".","]"), "", $match[0][$i]);
			if (isset($this->vars[$var]))
				$val = $this->vars[$var];
			else {
				$val = "";
				for ($j=0; $j<count($this->ref); $j++) {
					if ($this->ref[$j]["field"] == $var) {
						if (isset($this->ref[$j]["mask"])) {
							$c = 0;
							for ($k=0; $k<count($this->ref[$j]["mask"]); $k++) {
								if (is_numeric($this->ref[$j]["mask"][$k])) {
									$val .= $this->vars[$var.$c];
									$c++;
								} else
									$val .= $this->ref[$j]["mask"][$k];
							}
						}
						break;
					}
				}
			}
			$var = $match[0][$i];
			if (substr($var,0,2) == "[.")
				$str = str_replace($var, str_pad($val, (strlen($var)-2), '0', 'LEFT'), $str);
			else
				$str = str_replace($var, $val, $str);
		}
		return $str;
	}
	// build functions
	private function get_field($scope, $ref, $res = null, $prefix = null, $sufix = null, $class = null) {
		//echo "<pre style=text-align:left>"; print_r($res); echo "</pre>";
		if ($scope == "filter" &&
			($ref["type"] == "date" || $ref["type"] == "datetime")) {
			$ref["type"] = "daterange";
			$obj = "filter";
		} elseif ($scope == "filter" &&
			$ref["type"] == "text" &&
			isset($ref["mask"])) {
			$obj = "filter";
		} else {
			$obj = "field";
		}
		if (count($this->tab_ref) == 0 || 
			!isset($ref["tab_id"]) || 
			$this->tab_ref[$ref["tab_id"]]["table"] == null) {
			$ref["field"] = $this->get_field_label($ref["field"]);
		} else {
			$ref["field"] = $this->tab_ref[$ref["tab_id"]]["table"] . "_" . $ref["field"];
		}
		if ($class == null) $class = ($prefix == null ? "form" : "formpeq"); 
		$prop_str = "";
		if (isset($ref["prop"]) && count($ref["prop"]) > 0) {
			$keys = array_keys($ref["prop"]);
			for ($j=0; $j<count($keys); $j++) {
				$val = $ref["prop"][$keys[$j]];
				$prop_str .= " " . $keys[$j] . ($ref["prop"][$keys[$j]] != null ? "=\"$val\"" : "");
				if ($keys[$j] == "size") $size = $ref["prop"][$keys[$j]];
			}
		}
		$field_name = "$prefix" . $ref["field"] . "$sufix";
		$str = "";
		if (isset($ref["ck_bak"]) && $ref["ck_bak"] == 1)
			$str .= "<input type=\"hidden\" name=\"{$prefix}" . $ref["field"] . "_bak{$sufix}\" id=\"{$prefix}" . $ref["field"] . "_bak{$sufix}\" value=\"" . ($res != null ? $res[$ref["field"]] : "") . "\">\n";
		if ($ref["type"] == "text" || $ref["type"] == "findtext") {
			if ($this->ck_print == 1)
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">" . $res[$ref["field"]] . "</span>";
			else {
				if (isset($ref["mask"])) {
					$pos = 0;
					$c = 0;
					$str_js = "";
					$ck_show_mask = 1;
					if ($ref["unlock_mask"] == 1 && $res != null) {
						$pat = "";
						for ($i=0; $i<count($ref["mask"]); $i++) {
							if (is_numeric($ref["mask"][$i]))
								$pat .= "[0-9A-Za-z]{" . $ref["mask"][$i] . "}";
							else if ($ref["write_mask"] == 1)
								$pat .= $ref["mask"][$i];
						}
						$pat = "^$pat\$";
						ereg($pat, $res[$ref["field"]], $match);
						if ($res[$ref["field"]] != "" && count($match) == 0) $ck_show_mask = 0;
					}
					if ($ref["unlock_mask"] == 1) {
						$str .= "<span id=\"field_{$field_name}\" " . ($ck_show_mask == 1 ? "style=\"display:none\"" : "") . ">";
						$str .= "<input type=text name=\"{$prefix}" . $ref["field"] . "_{$sufix}\" id=\"{$prefix}" . $ref["field"] . "_{$sufix}\" value=\"" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "\" class=$class $prop_str " . ($ck_show_mask == 1 ? "disabled" : "") . ">\n";
						$str .= "</span>";
					}
					$str .= "<span id=\"mask_{$field_name}\" " . ($ck_show_mask == 0 ? "style=\"display:none\"" : "") . ">";
					for ($i=0; $i<count($ref["mask"]); $i++) {
						if (is_numeric($ref["mask"][$i])) {
							if ($obj == "filter") {
								$str .= "<input type=text name=\"{$prefix}" . $ref["field"] . "{$c}{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$c}{$sufix}\" value=\"" . ($res != null && $ck_show_mask == 1 ? substr($res[$ref["field"].$c], $pos, $ref["mask"][$i]) : "") . "\" class=$class size=".$ref["mask"][$i]." maxlength=".$ref["mask"][$i]." $prop_str>\n";
							} else {
								$str .= "<input type=text name=\"{$prefix}" . $ref["field"] . "{$c}{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$c}{$sufix}\" value=\"" . ($res != null && $ck_show_mask == 1 ? substr($res[$ref["field"]], $pos, $ref["mask"][$i]) : "") . "\" class=$class size=".$ref["mask"][$i]." maxlength=".$ref["mask"][$i]." $prop_str>\n";
								$pos += $ref["mask"][$i];
							}
							$str_js .= ($str_js != "" ? "," : "") . $ref["mask"][$i];
							$c++;
						} else {
							$str .= $ref["mask"][$i] . "\n";
							if ($ref["write_mask"] == 1) {
								$str_js .= ($str_js != "" ? "," : "") . "'" . $ref["mask"][$i] . "'";
								$pos += strlen($ref["mask"][$i]);
							}
						}
					}
					$str .= "</span>";
					if ($ref["unlock_mask"] == 1) {
						$str .= "<img id=\"toggle_{$field_name}\" src=\"$this->img_dir/" . ($ck_show_mask == 1 ? $this->img_lock : $this->img_unlock) . "\" style=\"cursor:pointer\" onclick=\"fn_toggle_lock('{$prefix}" . $ref["field"] . "',this.id.replace('toggle_{$prefix}" . $ref["field"] . "',''),new Array($str_js))\">";
					}
				} else
					$str .= "<input type=text name=\"{$field_name}\" id=\"{$field_name}\" value=\"" . ($res != null ? str_replace("\"","'",$res[$ref["field"]]) : (isset($ref["default"]) ? $ref["default"] : "")) . "\" class=$class $prop_str>\n";
			}
		} else if ($ref["type"] == "password") {
			$str .= "<input type=password name=\"{$field_name}\" id=\"{$field_name}\" class=$class $prop_str>\n";
		} else if ($ref["type"] == "hidden") {
			$str .= "<input type=\"hidden\" name=\"{$field_name}\" id=\"{$field_name}\" value=\"" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "\">\n";
		} else if ($ref["type"] == "file") {
			$thumb_ref = null;
			$preview_ref = null;
			for ($i=0; $i<count($ref["file"]); $i++) {
				if ($ref["file"][$i]["ck_thumb"] == 1 ||
					count($ref["file"]) == 1) {
					$thumb_ref = $ref["file"][$i];
					$thumb_dir = $thumb_ref["dir"]["O"]; // origem
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $thumb_dir, $match);
					for ($j=0; $j<count($match[0]); $j++) {
						$thumb_dir = str_replace($match[0][$j], $res[$this->get_field_label(substr($match[0][$j],1,-1))], $thumb_dir);
					}
				} 
				if ($ref["file"][$i]["ck_thumb"] == 0 ||
					count($ref["file"]) == 1) {
					$preview_ref = $ref["file"][$i];
					$preview_dir = $preview_ref["dir"]["O"];
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $preview_dir, $match);
					for ($j=0; $j<count($match[0]); $j++) {
						$preview_dir = str_replace($match[0][$j], $res[$this->get_field_label(substr($match[0][$j],1,-1))], $preview_dir);
					}
				}
			}
			if ($res != null && $res[$ref["field"]] != "") {
				$thumb_file_name = $res[$ref["field"]];
				if (substr($res[$ref["field"]],-3) == "pdf") {
					$pdf_thumb_format = substr($res[$ref["field"]],0,-3) . "jpg.0";
					$fp = @fopen("$thumb_dir/$pdf_thumb_format", "r");
					if ($fp) {
						$thumb_file_name = $pdf_thumb_format;
						fclose($fp);
					}
				}
				$preview_file_name = $res[$ref["field"]];
			}
			$fp = @fopen("$preview_dir/$preview_file_name", "r");
			if ($fp) {
				$ck_file = 1;
				fclose($fp);
			} else
				$ck_file = 0;
			//echo "[$thumb_dir/$thumb_file_name]";
			//echo "[$preview_dir/$preview_file_name][$ck_file]";
			if ($this->ck_print == 1) {
				if ($res != null && 
					(($ref["ck_qry"] == 1 && $res[$ref["field"]] != "") ||
					 ($ref["ck_qry"] == 0 && $ck_file == 1))) 
					$str .= "<a href=\"$preview_dir/$preview_file_name\" target=_blank><img src=\"$thumb_dir/$thumb_file_name\" border=0></a>"; //<br>".$res[$ref["field"]];
				else
					$str .= "SEM IMAGEM";
			} else {
				// find thumb and preview
				if ($res != null && 
					(($ref["ck_qry"] == 1 && $res[$ref["field"]] != "") ||
					 ($ref["ck_qry"] == 0 && $ck_file == 1))) {
					if (is_file("$thumb_dir/$thumb_file_name")) {
						$ck_file = 1;
						$size = getImageSize("$thumb_dir/$thumb_file_name");
					} else 
						$ck_file = 0;
					if ($ck_file == 1 &&
						($size[2] == 1 || $size[2] == 2 || $size[2] == 3)) {
						$str .= "<span id=\"{$prefix}" . "imagem" . $ref["field"] . "div{$sufix}\">";
						if ($thumb_ref != null) 
							$str .= "<a href=\"$preview_dir/$preview_file_name\" target=_blank><img src=\"$thumb_dir/$thumb_file_name\" border=0></a>"; //<br>".$res[$ref["field"]];
						else
							$str .= "<img src=\"$preview_dir/$preview_file_name\" border=0></a>"; //<br>".$res[$ref["field"]];
						$str .= "</span>";
						$str .= "<br><span id=\"{$prefix}" . "remove" . $ref["field"] . "div{$sufix}\"><input type=\"checkbox\" name=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" value=\"$preview_file_name\">$this->lang_remove_image<br></span>\n";
					} else {
						$str .= "<span id=\"{$prefix}" . "imagem" . $ref["field"] . "div{$sufix}\"><a href=\"$preview_dir/$preview_file_name\" target=_blank>" . $res[$ref["field"]] . "</a>"; 
						$str .= "<span id=\"{$prefix}" . "remove" . $ref["field"] . "div{$sufix}\"><input type=\"checkbox\" name=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" value=\"$preview_file_name\">$this->lang_remove_file<br></span>\n";
					}
				} else {
					$str .= "<span id=\"{$prefix}" . "imagem" . $ref["field"] . "div{$sufix}\" style=display:none></span>\n";
					$str .= "<span id=\"{$prefix}" . "remove" . $ref["field"] . "div{$sufix}\" style=display:none><input type=\"checkbox\" name=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\">$this->lang_remove_image<br></span>\n";
				}
				$str .= "<input type=\"file\" name=\"{$field_name}\" id=\"{$field_name}\" class=\"$class\" $prop_str>\n";
			}
		} else if ($ref["type"] == "textarea") {
			if ($this->ck_print == 1) 
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">" . nl2br($res[$ref["field"]]) . "</span>";
			else
				$str .= "<textarea name=\"{$field_name}\" id=\"{$field_name}\" class=$class $prop_str>" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "</textarea>\n";
		} else if ($ref["type"] == "date") {
			if ($this->ck_print == 1) 
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">" . ($res["dia_".$ref["field"]] != "" ? $res["dia_".$ref["field"]] . "/" . $res["mes_".$ref["field"]] . "/" . $res["ano_".$ref["field"]] : "") . "</span>";
			else {
				$str .= "<input type=text name=\"dia_{$field_name}\" id=\"dia_{$field_name}\" value=\"" . ($res != null ? ($res["dia_".$ref["field"]] != "" ? str_pad($res["dia_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],8,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"mes_{$field_name}\" id=\"mes_{$field_name}\" value=\"" . ($res != null ? ($res["mes_".$ref["field"]] != "" ? str_pad($res["mes_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],5,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"ano_{$field_name}\" id=\"ano_{$field_name}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]] : (isset($ref["default"]) ? substr($ref["default"],0,4) : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)>\n";
			}
			if ($this->ck_print == 0 &&
				$this->use_CalendarPopup == 1) {
				$str .= "<script language=\"JavaScript\" id=\"cal_{$field_name}\">\n";
				$str .= "var cal_{$field_name} = new CalendarPopup(\"cal_{$field_name}_div\");\n";
				$str .= "cal_{$field_name}.setReturnFunction(\"setMultipleValues_{$field_name}\")\n";
				$str .= "function setMultipleValues_{$field_name}(y,m,d) {\n";
				$str .= "	document.getElementById('ano_{$field_name}').value=y;\n";
				$str .= "	document.getElementById('mes_{$field_name}').value=LZ(m);\n";
				$str .= "	document.getElementById('dia_{$field_name}').value=LZ(d);\n";
				$str .= "}\n";
	 			$str .= "</script>\n";
				$str .= "<a href=\"#\" onclick=\"cal_{$field_name}.showCalendar('anchor_{$field_name}'); return false;\" name=\"anchor_{$field_name}\" id=\"anchor_{$field_name}\"><img src=\"$this->img_dir/$this->img_calendar_popup\" border=0></a>\n";
				$str .= "<div id=\"cal_{$field_name}_div\" style=\"position:absolute;visibility:hidden;background-color:white;layer-background-color:white;\"></div>\n";
			}
		} else if ($ref["type"] == "datetime") {
			if ($this->ck_print == 1) 
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">" . ($res["dia_".$ref["field"]] != "" ? str_pad($res["dia_".$ref["field"]],2,'0','LEFT') . "/" . str_pad($res["mes_".$ref["field"]],2,'0','LEFT') . "/" . $res["ano_".$ref["field"]] . " " . str_pad($res["hor_".$ref["field"]],2,'0','LEFT') . ":" . str_pad($res["min_".$ref["field"]],2,'0','LEFT') : "") . "</span>";
			else {
				$str .= "<input type=text name=\"dia_{$field_name}\" id=\"dia_{$field_name}\" value=\"" . ($res != null ? ($res["dia_".$ref["field"]] != "" ? str_pad($res["dia_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],8,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"mes_{$field_name}\" id=\"mes_{$field_name}\" value=\"" . ($res != null ? ($res["mes_".$ref["field"]] != "" ? str_pad($res["mes_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],5,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"ano_{$field_name}\" id=\"ano_{$field_name}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]] : (isset($ref["default"]) ? substr($ref["default"],0,4) : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> - \n";
				$str .= "<input type=text name=\"hor_{$field_name}\" id=\"hor_{$field_name}\" value=\"" . ($res != null ? ($res["hor_".$ref["field"]] != "" ? str_pad($res["hor_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],11,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)>:";
				$str .= "<input type=text name=\"min_{$field_name}\" id=\"min_{$field_name}\" value=\"" . ($res != null ? ($res["min_".$ref["field"]] != "" ? str_pad($res["min_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],14,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)>\n";
			}
		} else if ($ref["type"] == "daterange") {
			if ($this->ck_print == 1) {
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">";
				$str .= ($res["dia_".$ref["field"]."_ini"] != "" ? $res["dia_".$ref["field"]."_ini"] . "/" . $res["mes_".$ref["field"]."_ini"] . "/" . $res["ano_".$ref["field"]."_ini"] : ""); 
				$str .= ($res["dia_".$ref["field"]."_fim"] != "" ? $res["dia_".$ref["field"]."_fim"] . "/" . $res["mes_".$ref["field"]."_fim"] . "/" . $res["ano_".$ref["field"]."_fim"] : ""); 
				$str .= "</span>";
			} else {
				$str .= "<input type=checkbox name=\"{$field_name}\" id=\"{$field_name}\" value=1 onclick=dia_{$prefix}" . $ref["field"] . "_ini{$sufix}.disabled=!this.checked;mes_{$prefix}" . $ref["field"] . "_ini{$sufix}.disabled=!this.checked;ano_{$prefix}" . $ref["field"] . "_ini{$sufix}.disabled=!this.checked;dia_{$prefix}" . $ref["field"] . "_fim{$sufix}.disabled=!this.checked;mes_{$prefix}" . $ref["field"] . "_fim{$sufix}.disabled=!this.checked;ano_{$prefix}" . $ref["field"] . "_fim{$sufix}.disabled=!this.checked " . (isset($ref["default"]) || ($res != null && $res["dia_".$ref["field"]."_ini"] != "") ? "CHECKED" : "") . " " . ($this->modo == "insert" || ($this->modo == "update" && $this->step == 2) ? "style=display:none" : "")  . ">\n";
				$str .= "<input type=text name=\"dia_{$prefix}" . $ref["field"] . "_ini{$sufix}\" id=\"dia_{$prefix}" . $ref["field"] . "_ini{$sufix}\" value=\"" . ($res != null ? $res["dia_".$ref["field"]."_ini"] : (isset($ref["default"]) ? $ref["default"]["dia_ini"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('dia_','').replace('_ini','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"mes_{$prefix}" . $ref["field"] . "_ini{$sufix}\" id=\"mes_{$prefix}" . $ref["field"] . "_ini{$sufix}\" value=\"" . ($res != null ? $res["mes_".$ref["field"]."_ini"] : (isset($ref["default"]) ? $ref["default"]["mes_ini"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('mes_','').replace('_ini','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"ano_{$prefix}" . $ref["field"] . "_ini{$sufix}\" id=\"ano_{$prefix}" . $ref["field"] . "_ini{$sufix}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]."_ini"] : (isset($ref["default"]) ? $ref["default"]["ano_ini"] : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('ano_','').replace('_ini','')).checked=1:void(null)\"> a \n";
				$str .= "<input type=text name=\"dia_{$prefix}" . $ref["field"] . "_fim{$sufix}\" id=\"dia_{$prefix}" . $ref["field"] . "_fim{$sufix}\" value=\"" . ($res != null ? $res["dia_".$ref["field"]."_fim"] : (isset($ref["default"]) ? $ref["default"]["dia_fim"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('dia_','').replace('_fim','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"mes_{$prefix}" . $ref["field"] . "_fim{$sufix}\" id=\"mes_{$prefix}" . $ref["field"] . "_fim{$sufix}\" value=\"" . ($res != null ? $res["mes_".$ref["field"]."_fim"] : (isset($ref["default"]) ? $ref["default"]["mes_fim"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('mes_','').replace('_fim','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"ano_{$prefix}" . $ref["field"] . "_fim{$sufix}\" id=\"ano_{$prefix}" . $ref["field"] . "_fim{$sufix}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]."_fim"] : (isset($ref["default"]) ? $ref["default"]["ano_fim"] : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('ano_','').replace('_fim','')).checked=1:void(null)\">\n";
			}
		} elseif ($ref["type"] == "checkbox") {
			//if ($this->ck_print == 0 || $res[$ref["field"]] == 1) 
			$str .= "<input type=checkbox name=\"{$field_name}\" id=\"{$field_name}\"" . ($res != null && $res[$ref["field"]] == 1 ? " CHECKED" : "") . " $prop_str " . ($this->ck_print == 1 ? "disabled" : "") . "> " . $ref["label"] . "\n";
		} else if ($ref["type"] == "publisher") {
			$str .= "<script language=\"JavaScript\">\n";
			$str .= "{$field_name} = new Publisher(\"{$field_name}\");\n";
			$url_dir = "http://" . $_SERVER["HTTP_HOST"] . substr($_SERVER["PHP_SELF"], 0, strrpos($_SERVER["PHP_SELF"], "/")+1) . $ref["publisher_img_dir"];
			$str .= "{$field_name}.setImgDir(\"$url_dir\",\"" . str_replace("\\", "\\\\", realpath($ref["publisher_img_dir"])) . "\");\n";
			$str .= "{$field_name}.setImgAction(\"" . $ref["publisher_img_action"] . "\");\n";
			if (isset($ref["prop"]["width"])) $str .= "{$field_name}.setWidth(\"" . $ref["prop"]["width"] . "\");\n";
			if (isset($ref["prop"]["height"])) $str .= "{$field_name}.setHeight(\"" . $ref["prop"]["height"] . "\");\n";
			$str .= "{$field_name}.build();\n";
			$str .= "</script>\n";
			if ($res != null) echo "<span id=\"span{$field_name}\" style=\"display:none\">" . $res[$ref["field"]] . "</span>"; 
		} else if ($ref["type"] == "dynamiclist") {
			$str .= "<script language=\"JavaScript\">\n";
			$str .= "{$field_name} = new dynamicList(\"{$field_name}\");\n";
			if (isset($ref["ajaxqry"])) $str .= "{$field_name}.setXmlpath(\"$this->document_name_xml?modo=xml&field=" . $ref["field"] . "\");\n";
			$str .= "{$field_name}.build();\n";
			if ($res != null) {
				$keys = array_keys($ref["xtra_key"]);
				$str_xtra_keys = "";
				for ($i=0; $i<count($keys); $i++) {
					$str_xtra_keys .= $keys[$i] . " = '" . $ref["xtra_key"][$keys[$i]] . "' AND\n";
				}
				$qry = "SELECT " . $ref["field"] . " AS val
					FROM " . $ref["table"] . "
					WHERE $str_xtra_keys " . $ref["key_field"] . " = " . $res["id"] . "
					ORDER BY val";
				$res_dynlist = nc_query($qry);
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				for ($i=0; $i<count($res_dynlist); $i++) {
					$str .= "{$field_name}.addItem(\"" . $res_dynlist[$i]["val"] . "\");\n";
				}
			}
			$str .= "</script>\n";
		} else if ($ref["type"] == "color") {
			$str .= "<script language=\"JavaScript\">fn_BuildColorTable(\"{$field_name}\",\"" . ($res != null ? $res[$ref["field"]] : "gray") . "\")</script>\n";
		} else if ($ref["type"] == "filteredtext") {
			$field = $ref["field"];
			$val = $res[$field];
			if ($res != null && 
				$res[$field] != "" && 
				$res[$field] != "0" &&
				!isset($res["filteredtext"])) {
				if (isset($ref["ref_qry"]) && $ref["ref_qry"] != null) { 
					if (!isset($this->var_bak[$field][$val])) {
						$res_temp = $this->get_ref_query($ref, $res);
						$this->var_bak[$field][$val] = $res_temp[0][$ref["ref_label"]];
					}
					$res["filteredtext"] = $this->var_bak[$field][$val];
				} elseif (isset($ref["ajaxqry"]) && $ref["ajaxqry"] != null) { 
					$sql = $ref["ajaxqry"];
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					for ($i=0; $i<count($match[0]); $i++) {
						$sql = str_replace($match[0][$i], $res[substr($match[0][$i],1,-1)], $sql);
					}
					if ($this->debug == 1) $str .= "<pre style=text-align:left>$sql</pre>";
					$res_ajax = $ref["ajaxfunction"]($sql);
					$res["filteredtext"] = $res_ajax[0][$ref["ajaxlabel"]];
				} else {
					$sql = "SELECT DISTINCT
								" . $ref["ajaxid"] . " AS id,
								" . $ref["ajaxlabel"] . " AS label
							FROM " . $ref["ajaxtable"] . "
							WHERE 
								" . $ref["ajaxid"] . " = '$val'";
					if ($this->debug == 1) $str .= "<pre style=text-align:left>$sql</pre>";

					$res_ajax = $ref["ajaxfunction"]($sql);
					$res["filteredtext"] = $res_ajax[0]["label"];
				}
			}
			if ($this->ck_print == 1)
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$prefix}{$field}{$sufix}\">" . (isset($res["filteredtext"])?$res["filteredtext"]:"") . "</span>";
			else {
				$param = "";
				$ckstr = "";
				if (isset($ref["ajaxqry"])) {
					$sql = $ref["ajaxqry"];
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					//print_r($match);
					for ($i=0; $i<count($match[0]); $i++) {
						$param .= "&" . substr($match[0][$i],1,-1) . "=[" . substr($match[0][$i],1,-1) . "$sufix]";
					}
				}
				if (is_array($ref["ajaxfilter"])) {
					for ($i=0; $i<count($ref["ajaxfilter"]); $i++) {
						if (is_array($ref["ajaxfilter"][$i])) {
							$keys = array_keys($ref["ajaxfilter"][$i]);
							$filter = $keys[0];
							$label = $ref["ajaxfilter"][$i][$keys[0]];
						} else {
							$filter = $ref["ajaxfilter"][$i];
							$label = $ref["ajaxfilter"][$i];
						}
						$param .= "&ck_$filter=[{$prefix}{$field}_{$filter}{$sufix}]";
						$ckstr .= "<input type=checkbox id=\"ck_{$prefix}{$field}_{$filter}{$sufix}\" onclick=document.getElementById(this.id.replace('ck_','')).value=this.checked?1:0 CHECKED>$label\n";
						$ckstr .= "<input type=\"hidden\" name=\"{$prefix}{$field}_{$filter}{$sufix}\" id=\"{$prefix}{$field}_{$filter}{$sufix}\" value=1>\n";
					}
					$ckstr = "filtrar em: $ckstr\n";
				}
				if (isset($ref["ajaxpath"]))
					$url = str_replace(array("[","]"), array("[{$prefix}","{$sufix}]"), $ref["ajaxpath"]) . (strpos($ref["ajaxpath"],"?")>0 ? "&" : "?") . $param;
				else
					$url = "$this->document_name_xml?modo=xml&field={$field}{$param}&obj=$obj";
				$str .= "<script language=\"JavaScript\">\n";
				$str .= "<!--- \n";
				$str .= "obj{$prefix}{$field}{$sufix} = new fieldFilter(\"obj{$prefix}{$field}{$sufix}\", \"{$prefix}{$field}{$sufix}\",\"$url\");\n";
				for ($i=0; $i<count($ref["ajaxaction"]); $i++) {
					$str .= "obj{$prefix}{$field}{$sufix}.add" . ($ref["ajaxaction"][$i]["modo"] == "R" ? "Reset" : "") . "Action(\"" . $ref["ajaxaction"][$i]["action"] . "\");\n";
				}
				for ($i=0; $i<count($ref["ajax_xtrafield"]); $i++) {
					$str .= "obj{$prefix}{$field}{$sufix}.addField(\"{$prefix}" . $ref["ajax_xtrafield"][$i]["field"] . "{$sufix}\",\"" . $ref["ajax_xtrafield"][$i]["xml_label"] . "\");\n";
				}
				if (isset($ref["prop"]["readonly"])) $str .= "obj{$prefix}{$field}{$sufix}.setReadOnly();\n";
				if ($res != null && $res[$field] != "" && $res[$field] != "0") $str .= "obj{$prefix}{$field}{$sufix}.setDefault('" . $res[$field] . "', '" . str_replace("'","\'",$res["filteredtext"]) . "');\n";
				if (isset($size) && is_array($size))
					$str .= "obj{$prefix}{$field}{$sufix}.build(".$size[0].",".$size[1].");\n";
				else if (isset($size) && !is_array($size))
					$str .= "obj{$prefix}{$field}{$sufix}.build($size);\n";
				else
					$str .= "obj{$prefix}{$field}{$sufix}.build(30);\n";
				//$str .= "fn_buildfilteredtext(\"{$prefix}{$field}{$sufix}\",\"$url\",".(isset($size)?$size:30).",1," . ($res != null && $res[$field] != "" && $res[$field] != "0" ? "new Array('" . $res[$field] . "','" . str_replace("'","\'",$res["filteredtext"]) . "')" : "false") . ",".$ref["ajaxaction"].",false," . (isset($ref["prop"]["readonly"])?"true":"false") . ")\n";
				$str .= "// --->\n";
				$str .= "</script>\n";
				if ($ckstr != "") $str .= $ckstr;
			}
		} else if ($ref["type"] == "display") {
			if ($this->ck_print == 1)
				$str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">" . $res[$ref["field"]] . "</span>";
			else 
				$str .= $res[$ref["field"]];
		} elseif ($ref["type"] == "radio" || $ref["type"] == "radio_checkbox") {
			if ($ref["type"] == "radio_checkbox") {
				$str .= "<input type=\"hidden\" name=\"{$field_name}\" id=\"{$field_name}\" value=\"" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "\">\n";
			}
			if (isset($ref["qry"]["sql"])) {
				$sql = $ref["qry"]["sql"];
				$ix = $ref["qry"]["ix"];
				$label = $ref["qry"]["label"];
				$res_aux = nc_query($sql);
				for ($j=0; $j<count($res_aux); $j++) {
					if ($ref["type"] == "radio") {
						if ($this->ck_print == 0 || $res[$ref["field"]] == $res_aux[$j][$ix]) {
							$str .= "<input type=radio name=\"{$field_name}\" id=\"{$field_name}\" value=\"" . $res_aux[$j][$ix] . "\" " . (($res != null && $res[$ref["field"]] == $res_aux[$j][$ix]) || ($res == null && $ref["default"] == $res_aux[$j][$ix]) ? "CHECKED" : "") . " $prop_str>" . $res_aux[$j][$label] . "\n";
						}
					} elseif ($ref["type"] == "radio_checkbox") {
						$str_action = "onclick={$field_name}.value=this.checked?this.value:''";
						for ($k=0; $k<count($res_aux); $k++) {
							if ($k != $j) $str_action .= ";{$prefix}" . $ref["field"] . "$k{$sufix}.checked=false";
						}
						$str .= "<input type=checkbox name=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" id=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" value=\"" . $res_aux[$j][$ix] . "\" " . ($res != null && $res[$ref["field"]] == $res_aux[$j][$ix] ? "CHECKED" : "") . " $str_action>" . $res_aux[$j][$label] . "\n";
					}
					if ($j < count($res_aux)-1) $str .= "<br>\n";
				}
			} else if (isset($ref["list"])) {
				$list = $ref["list"];
				$keys = array_keys($list);
				$len = 0;
				for ($j=0; $j<count($keys); $j++) {
					$len += strlen($list[$keys[$j]]["label"]);
				}
				for ($j=0; $j<count($keys); $j++) {
					if ($ref["type"] == "radio") {
						if ($this->ck_print == 0) {
							$str .= "<input type=radio name=\"{$field_name}\" id=\"{$field_name}\" value=\"" . $keys[$j] . "\" " . (($res != null && $res[$ref["field"]] == $keys[$j]) || ($res == null && isset($ref["default"]) && $ref["default"] == $keys[$j]) ? "CHECKED" : "") . " $prop_str>";
						}
					} elseif ($ref["type"] == "radio_checkbox") {
						$str_action = "onclick={$field_name}.value=this.checked?this.value:''";
						for ($k=0; $k<count($keys); $k++) {
							if ($k != $j) $str_action .= ";{$prefix}" . $ref["field"] . "$k{$sufix}.checked=false";
						}
						$str .= "<input type=checkbox name=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" id=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" value=\"" . $keys[$j] . "\" " . ($res != null && $res[$ref["field"]] == $keys[$j] ? "CHECKED" : "") . " $str_action>";
					}
					if (is_array($list[$keys[$j]])) {
						if ($this->ck_print == 0 || ($res != null && $res[$ref["field"]] == $keys[$j])) {
							$str .= $list[$keys[$j]]["label"];
							if ($list[$keys[$j]]["type"] != null) {
								if ($list[$keys[$j]]["label"] != "")
									$str .= ": ";
								if ($this->modo == "update")
									$str .= $this->get_field("form", $list[$keys[$j]], $res);
								else
									$str .= $this->get_field("form", $list[$keys[$j]]);
							}
						}
						if ($j < count($keys)-1) $str .= "<br>\n";
					} else if ($this->ck_print == 0 || ($res != null && $res[$ref["field"]] == $keys[$j])) {
						$str .= " " . $list[$keys[$j]] . " ";
						if ($len > 30 && $j < count($keys)-1) $str .= "<br>\n";
					}
				}
			}
		} elseif ($ref["type"] == "dropdown") {
			if (isset($ref["ck_qry"]) && 
				$ref["ck_qry"] == 1 && 
				!array_key_exists("multiple", $ref["prop"]) && 
				$res[$ref["field"]] == "")
				$ck_sel = 1;
			else
				$ck_sel = 0;
			if ($this->ck_print == 1) $str .= "<span class=\"{$this->css_text}_relat\" id=\"{$field_name}\">";
			if ($this->ck_print == 0) $str .= "<select name=\"{$field_name}" . (array_key_exists("multiple",$ref["prop"])?"[]":"") . "\" id=\"{$field_name}\" $prop_str class=$class>\n";
			// multiple
			if ($res != null && array_key_exists("multiple", $ref["prop"])) {
				$qry = "SELECT " . $ref["field"] . " AS val
					FROM " . $ref["table"] . " 
					WHERE " . $ref["key_field"] . " = " . $res["id"];
				if (is_array($ref["xtra_key"])) {
					$keys = array_keys($ref["xtra_key"]);
					for ($i=0; $i<count($ref["xtra_key"]); $i++) {
						$qry .= " AND " . $keys[$i] . " = '" . $ref["xtra_key"][$keys[$i]] . "'";
					}
				}
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>\n";
				$res_multiple = nc_query($qry);
				$multiple_ref = array();
				for ($i=0; $i<count($res_multiple); $i++) {
					array_push($multiple_ref, $res_multiple[$i]["val"]);
				}
			}
			// qry
			if (isset($ref["qry"]["sql"])) {
				$sql = $ref["qry"]["sql"];
				$ix = $ref["qry"]["ix"];
				$label = $ref["qry"]["label"];
				$group_label = $ref["qry"]["group_label"];
				if (!isset($ref["qry"]["ajax"]) || $ref["qry"]["ajax"] == 0) {
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					for ($i=0; $i<count($match[0]); $i++) {
						if ($this->modo == "insert" || $this->modo == "complete") {
							$sql = str_replace($match[0][$i], 0, $sql);
						} elseif (isset($this->res_upd[0])) {
							$keys = array_keys($this->res_upd[0]);
							for ($j=0; $j<count($keys); $j++) {
								if (strtolower(substr($match[0][$i],1,-1)) == strtolower($keys[$j])) {
									$sql = str_replace($match[0][$i], $this->res_upd[0][$keys[$j]], $sql);
								}
							}
						}
					}
					$res_aux = nc_query($sql);
				} else {
					$ck_ajax = 0;
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					if ($scope == "form")
						$ck_ref = $this->ref;
					else if ($scope == "filter")
						$ck_ref = $this->ref_filter;
					for ($i=0; $i<count($match[0]); $i++) {
						for ($j=0; $j<count($ck_ref); $j++) {
							if (!is_array($ck_ref[$j]["field"]) &&
								strtolower(substr($match[0][$i],1,-1)) == strtolower($ck_ref[$j]["field"])) {
								$label_origem = $ck_ref[$j]["label"];
								$sql = str_replace($match[0][$i], $res[$ck_ref[$j]["field"]], $sql);
								$ck_ajax = 1;
							} else if (isset($ck_ref[$j]["field_qry"]) &&
								strtolower(substr($match[0][$i],1,-1)) == strtolower($ck_ref[$j]["field_qry"])) {
								$label_origem = $ck_ref[$j]["label"];
								$sql = str_replace($match[0][$i], $res[$ck_ref[$j]["field_qry"]], $sql);
								$ck_ajax = 1;
							}
							if ($ck_ref[$j]["type"] == "entity" &&
								$prefix != null) {
								for ($k=0; $k<count($ck_ref[$j]["field"]); $k++) {
									if (strtolower(substr($match[0][$i],1,-1)) == strtolower($ck_ref[$j]["field"][$k]["field"])) {
										$label_origem = $ck_ref[$j]["field"][$k]["label"];
										$sql = str_replace($match[0][$i], $res[$ck_ref[$j]["field"][$k]["field"]], $sql);
										$ck_ajax = 1;
									}
									if ($ck_ajax == 1) break;
								}
							}
						}
					}
					if ($this->modo == "update" || ($this->modo == "report" && $scope == "filter")) {
						$fn = $ref["ajaxfunction"];
						$res_aux = $fn($sql);
					} else {
						$res_aux = array();
					}
				}
				if ($this->ck_print == 0 && 
					(!isset($ref["qry"]["ajax"]) || $ref["qry"]["ajax"] == 0 || count($res_aux) > 0) && // no dependency option written
					($ref["ck_req"] == 0 || count($res_aux) > 1) &&
					!isset($ref["prop"]["size"])) 
					$str .= "<option value=\"\">--$this->lang_form_dropdown_choose--</option>\n";
				else if ($this->ck_print == 0 && 
					(isset($ref["qry"]["ajax"]) && $ref["qry"]["ajax"] == 1 && count($res_aux) == 0)) 
					$str .= "<option value=\"\">--$this->lang_form_dropdown_choose {$label_origem}--</option>\n";
				for ($j=0; $j<count($res_aux); $j++) {
					if ($group_label != null && 
						($j == 0 ||
						 $res_aux[$j][$group_label] != $res_aux[$j-1][$group_label])) {
						if ($this->ck_print == 0) $str .= "<optgroup label=\"" . $res_aux[$j][$group_label] . "\">\n";
					}
					if ($this->ck_print == 1 && $res[$ref["field"]] == $res_aux[$j][$ix])
						$str .= $res_aux[$j][$label];
					if ($this->ck_print == 0) {
						$xtra_fields = "";
						if (is_array($ref["qry"]["xtra_fields"])) {
							for ($k=0; $k<count($ref["qry"]["xtra_fields"]); $k++) {
								$xtra_fields = $ref["qry"]["xtra_fields"][$k] . "='" . $res_aux[$j]["xtra_fields"][$k] . "'";
							}
						} elseif ($ref["qry"]["xtra_fields"] != "") {
							$xtra_fields = $ref["qry"]["xtra_fields"] . "='" . $res_aux[$j][$ref["qry"]["xtra_fields"]] . "'";
						}
						if (($res != null && array_key_exists("multiple", $ref["prop"]) && in_array($res_aux[$j][$ix], $multiple_ref)) ||
							($res != null && !array_key_exists("multiple", $ref["prop"]) && $res[$ref["field"]] == $res_aux[$j][$ix]) ||
							(isset($ref["default"]) && $ref["default"] == $res_aux[$j][$ix]) ||
							(isset($ref["default"]) && $ref["default"] == $res_aux[$j][$label])) {
							$str .= "<option $xtra_fields SELECTED value=\"" . $res_aux[$j][$ix] . "\">" . $res_aux[$j][$label] . "</option>\n";
							$ck_sel = 1;
						} else
							$str .= "<option $xtra_fields value=\"" . $res_aux[$j][$ix] . "\">" . $res_aux[$j][$label] . "</option>\n";
					}
					if ($group_label != null && 
						($j == count($res_aux)-1 ||
						 $res_aux[$j][$group_label] != $res_aux[$j+1][$group_label])) {
						if ($this->ck_print == 0) $str .= "</optgroup>\n";
					}
				}
				if ($ref["qry"]["ck_new_entry"] == 1) {
					$str .= "<option value=\"NEW\">OUTRO:</option>\n";
				}
			// list
			} else if (isset($ref["list"])) {
				$list = $ref["list"];
				$keys = array_keys($list);
				if ($this->ck_print == 0 &&
					(count($keys) > 1 || $ref["ck_req"] == 0) && 
					!isset($ref["prop"]["size"])) $str .= "<option value=\"\">--$this->lang_form_dropdown_choose--\n";
				$ck_sel = !array_key_exists("multiple", $ref["prop"]) && $res[$ref["field"]] == "" ? 1 : 0;
				for ($j=0; $j<count($keys); $j++) {
					if ($this->ck_print == 1 && $res[$ref["field"]] == $keys[$j])
						$str .= $list[$keys[$j]];
					if ($this->ck_print == 0) {
						if (($res != null && array_key_exists("multiple", $ref["prop"]) && in_array($keys[$j], $multiple_ref)) ||
							($res != null && !array_key_exists("multiple", $ref["prop"]) && $res[$ref["field"]] == $keys[$j])) {
							$ck_sel = 1;
							$str .= "<option SELECTED value=\"" . $keys[$j] . "\">" . $list[$keys[$j]] . "\n";
						} else
							$str .= "<option value=\"" . $keys[$j] . "\">" . $list[$keys[$j]] . "\n";
					}
				}
			}
			// selection not found
			$field = $ref["field"];
			if ($this->ck_print == 0 &&
				$res != null && 
				$res[$field] != "" && 
				$ck_sel == 0) {
				$val = isset($res[$field]) ? $res[$field] : "";
				if (isset($ref["ref_qry"]) && $ref["ref_qry"] != null) {
					$sql = $ref["ref_qry"];
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					$ix = "";
					for ($i=0; $i<count($match[0]); $i++) {
						$sql = str_replace($match[0][$i], $res[substr($match[0][$i],1,-1)], $sql);
						$ix .= $res[substr($match[0][$i],1,-1)];
					}
					if (!isset($this->var_bak[$field][$ix])) {
						if ($this->debug == 1) echo "<pre style=text-align:left>$sql</pre>";
						$res_temp = $ref["ref_function"]($sql);
						$this->var_bak[$field][$ix] = count($res_temp) > 0 ? $res_temp[0][$ref["ref_label"]] : "";
					}
					$str .= "<option SELECTED value=\"$val\">" . $this->var_bak[$field][$ix] . "</option>\n";
				} else if (!array_key_exists("multiple", $ref["prop"]))
					$str .= "<option SELECTED value=\"$val\">$val</option>\n";
			}
			if ($this->ck_print == 0) {
				$str .= "</select>\n";
				if (isset($ref["qry"]) && $ref["qry"]["ck_new_entry"] == 1) {
					$str .= "<input name=\"{$prefix}" . $ref["field"] . "_entry{$sufix}\" id=\"{$prefix}" . $ref["field"] . "_entry{$sufix}\" size=15 style=\"display:none\" class=$class>\n";
				}
			}
			if ($this->ck_print == 1) $str .= "</span>";
		}
		return $str;
	}
	public function build($modo, $step, $vars, $files = array()) {
		// remember vars
		if (($modo == "update" && ($step == 0 || $step == 1)) ||
			($modo == "insert" && $step == 1) ||
			($modo == "complete" && $step == 1) ||
			($modo == "updatedelete" && $step == 1)) 
			$_SESSION["cls_form_vars"] = $vars;
		else if ($modo == "report")
			$_SESSION["cls_form_vars"] = array();
		// reset recursive for delete
		if ($modo == "delete") 
			$this->ck_recursive = 0;
		// use vars[modo] for modo = complete
		if (substr($step,0,7) == "define=") {
			$modo = $vars["modo"];
			$step = substr($step,7);
		} else if (($modo == "complete" || $modo == "updatedelete") &&
			$step != 1) 
			$modo = $vars["modo"];
		$this->modo = $modo;
		$this->step = $step;
		$this->vars = $vars;
		$this->files = $files;
		$this->ck_print = isset($this->vars["ck_print"]) ? 1 : 0;
		if (($modo == "complete" && $step == 1 && count($this->ref_filter) > 0) ||
			($modo == "update" && ($step == 0 || ($step == 1 && $this->use_list_filter == 1)) && count($this->ref_filter) > 0) ||
			($modo == "report" && ($step == 0 || ($step == 1 && $this->use_list_filter == 1)) && count($this->ref_filter) > 0))
			$this->build_filter();
		if (($modo == "insert" && $step == 1) || 
		    ($modo == "update" && $step == 2) ||
		    ($modo == "update" && $step == 0 && count($this->ref_filter) == 0) ||
		    ($modo == "delete" && $step == 0 && count($this->ref_filter) == 0) ||
		    ($modo == "report" && $step == 0 && count($this->ref_filter) == 0) ||
			($modo == "complete" && $this->setup_complete == "integrated" && $step == 1)) 
			$this->build_form();
		if ($modo == "complete") echo "<br>";
		if (($modo == "delete" && $step == 1) || 
		    ($modo == "update" && $step == 1) ||
			($modo == "report" && $step == 1) ||
			($modo == "complete" && $step == 1) ||
			($modo == "updatedelete" && $step == 1)) 
			$this->build_list();
		if ($modo == "insert" && $step == 2) {
			$this->return_pk = "";
			for ($i=0; $i<$this->repeat_insert; $i++) {
				$this->insert(null, $i == $this->repeat_insert-1 ? 1 : 0);
			}
		}
		if ($modo == "update" && $step == 3) 
			$this->update();
		if ($modo == "delete" && $step == 2) 
			$this->delete();
		if ($modo == "xml" && $vars["obj"] == "ck_unique") 
			$this->build_xml_unique();
		if ($modo == "xml") 
			$this->build_xml();
		if ($modo == "csv") 
			$this->build_csv();
	}
	private function build_form($id = null) {
		for ($i=0; $i<count($this->ref); $i++) {
			if ($this->ref[$i]["type"] == "password") { 
				if ($this->modo == "update")
					$this->ref[$i]["ck_req"] = 0;
				if ($this->ref[$i]["ck_qry"] == 1) {
					$this->ref[$i]["prop"] = $this->ref[$i+1]["prop"];
					if ($this->modo == "update")
						$this->ref[$i]["label"] = "$this->lang_password_alter " . $this->ref[$i]["label"];
				}
			}
		}
		if ($this->modo == "update" && $this->step == 2) {
			$this->get_form_data();
		}
		if ($this->modo == "complete" && $this->step == 1) $title = "$this->lang_title_insert $this->ent";
		if ($this->modo == "complete" && $this->step == 2) $title = "$this->lang_title_update $this->ent";
		if ($this->modo == "insert") $title = "$this->lang_title_insert $this->ent";
		if ($this->modo == "report") $title = "$this->lang_title_report $this->ent";
		if ($this->modo == "delete") $title = "$this->lang_title_delete $this->ent";
		if ($this->modo == "update" && $this->ck_print == 0) $title = "$this->lang_title_update $this->ent";
		if ($this->modo == "update" && $this->ck_print == 1) $title = "$this->ent #" . $this->vars["id"];
		echo "<HTML>\n<HEAD>\n<TITLE>$title</TITLE>\n";
		echo $this->get_js();
		// refresh dependency
		for ($i=0; $i<count($this->tab_ref); $i++) {
			if ($this->tab_ref[$i]["table"] != null) {
				$temp = array();
				for ($j=0; $j<count($this->ref); $j++) {
					if ($this->ref[$j]["tab_id"] == $i && 
						$this->ref[$j]["type"] != "entity" && 
						$this->ref[$j]["ck_req"] == 1) {
						$temp[count($temp)] = $j;
					}
				}
				for ($j=0; $j<count($temp); $j++) {
					if (count($this->ref[$temp[$j]]["req_dependency"]) > 0) {
						for ($k=0; $k<count($temp); $k++) {
							$this->ref[$temp[$j]]["req_dependency"][count($this->ref[$temp[$j]]["req_dependency"])] = $this->ref[$temp[$k]]["field"];
						}
					}
				}
			}
		}
		// build ckform
		echo "<script language=\"JavaScript\">\n";
		echo "<!--- \n";
		if ($this->ck_unique == 1) {
			echo $this->get_js_unique();
		}
		if ($this->ck_unlock == 1) {
			echo $this->get_js_unlock();
		}
		if (($this->modo == "insert" && $this->step == 1) ||
			($this->modo == "update" && $this->step == 2) ||
			($this->modo == "update" && $this->step == 0 && count($this->ref_filter) == 0) ||
		    ($this->modo == "delete" && $this->step == 0 && count($this->ref_filter) == 0) ||
		    ($this->modo == "report" && $this->step == 0 && count($this->ref_filter) == 0))
			echo $this->get_js_ckform("form", $this->ref);
		else
			echo $this->get_js_ckform("filter", $this->ref_filter);
		if (count($this->ent_NXN) > 0) {
			echo "function fn_chdisplay_NXN(list) {\n";
			echo "	for (var i=0; i<list.length; i++) {\n";
			echo "		if (document.getElementById(\"table_\"+list[i])) {\n";
			echo "			obj = document.getElementById(\"table_\"+list[i])\n";
			echo "			obj.style.display = obj.style.display == 'none' ? '' : 'none'\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
			echo "function fn_ckall_NXN(ck,list) {\n";
			echo "	for (var i=0; i<list.length; i++) {\n";
			echo "		if (document.getElementById(\"ck_\"+list[i]) && !document.getElementById(\"ck_\"+list[i]).disabled) {\n";
			echo "			document.getElementById(\"ck_\"+list[i]).checked = ck;\n";
			echo "		}\n";
			echo "	}\n";
			echo "	if ((ck && document.getElementById(\"table_\"+list[1]).style.display == '') || (!ck && document.getElementById(\"table_\"+list[1]).style.display == 'none')) fn_chdisplay_NXN(list);\n";
			echo "}\n";
		}
		if (count($this->tab_ref) > 0) {
			echo "function fn_inittab() {\n";
			echo "	tr_ref = new Array();\n";
			for ($i=0; $i<count($this->ref); $i++) {
				$tab_id = $this->ref[$i]["tab_id"];
				if ($i == 0 || 
					$this->ref[$i]["tab_id"] != $this->ref[$i-1]["tab_id"]) 
					echo "	tr_ref[$tab_id] = new Array(); c=0;\n";
				if ($this->ref[$i]["type"] == "entity") {
					echo "	tr_ref[$tab_id][c] = new Array();\n";
					echo "	tr_ref[$tab_id][c][\"ck_hidden\"] = 0;\n";
					echo "	tr_ref[$tab_id][c][\"id\"] = \"{$i}a\"; c++;\n";
					echo "	tr_ref[$tab_id][c] = new Array();\n";
					echo "	tr_ref[$tab_id][c][\"ck_hidden\"] = 0;\n";
					echo "	tr_ref[$tab_id][c][\"id\"] = \"{$i}b\"; c++;\n";
					if ($this->ref[$i]["ck_edicao_global"] == 1) {
						echo "	tr_ref[$tab_id][c] = new Array();\n";
						echo "	tr_ref[$tab_id][c][\"ck_hidden\"] = 0;\n";
						echo "	tr_ref[$tab_id][c][\"id\"] = \"{$i}c\"; c++;\n";
					}
				} else if ($this->ref[$i]["type"] != "hidden" &&
					//$this->ref[$i]["ck_hidden"] == 0 &&
					($this->ref[$i]["field_group"] == null || 
					 $i == 0 ||
					 $this->ref[$i]["field_group"] != $this->ref[$i-1]["field_group"])) {
					echo "	tr_ref[$tab_id][c] = new Array();\n";
					echo "	tr_ref[$tab_id][c][\"ck_hidden\"] = " . $this->ref[$i]["ck_hidden"] . ";\n";
					echo "	tr_ref[$tab_id][c][\"id\"] = $i; c++;\n";
				}
			}
			echo "	ck_inittab = 1\n";
			echo "}\n";
			echo "ck_inittab = 0\n";
			echo "function fn_chtab(tab_id) {\n";
			echo "	if (ck_inittab == 0) fn_inittab();\n";
			echo "	for (var i=0; i<tr_ref.length; i++) {\n";
			echo "		document.getElementById(\"tab\"+i).className = (i == tab_id ? \"{$this->css_label_entity}\" : \"$this->css_label\");\n";
			echo "		for (var j=0; j<tr_ref[i].length; j++) {\n";
			echo "			if (tr_ref[i][j][\"ck_hidden\"] == 1 && document.getElementById(\"tr\"+tr_ref[i][j][\"id\"]).style.display == \"\")\n";
			echo "				tr_ref[i][j][\"ck_hidden\"] = 0;\n";
			echo "			if (tr_ref[i][j][\"ck_hidden\"] == 0)\n";
			echo "				document.getElementById(\"tr\"+tr_ref[i][j][\"id\"]).style.display = (i == tab_id ? \"\" : \"none\")\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
		}
		if (count($this->hidden_ref) > 0) {
			echo "function fn_displayhidden(ck) {\n";
			echo "	var tr_ref = new Array();\n";
			for ($i=0; $i<count($this->hidden_ref); $i++) {
				echo "	tr_ref[$i] = 'tr" . $this->hidden_ref[$i] . "';\n";
			}
			echo "	for (var i=0; i<tr_ref.length; i++) {\n";
			echo "		document.getElementById(tr_ref[i]).style.display = (ck?'':'none');\n";
			echo "	}\n";
			echo "}\n";
		}
		if ($this->ck_print == 0 && 
			$this->ck_global_form == 1) {
			echo "function fn_ckall_globalform(table,ck) {\n";
			echo "	for (var i=0; i<document.getElementById(\"count_\"+table).value; i++) {\n";
			echo "		document.getElementById(\"ck_\"+table+i).checked = ck;\n";
			echo "	}\n";
			echo "}\n";
			echo "function fn_sync_dropdown_globalform(table,field,ix) {\n";
			echo "	if (document.getElementById(table+\"_\"+field+ix).value == \"\") {\n";
			echo "		document.getElementById(\"comment_\"+table+\"_\"+field+ix).innerHTML = \"\";\n";
			echo "		for (var j=document.getElementById(table+\"_\"+field+ix).length-1; j>= 0; j--) {\n";
			echo "			document.getElementById(table+\"_\"+field+ix).remove(j);\n";
			echo "		}\n";
			echo "		for (var j=0; j<document.getElementById(\"global_\"+table+\"_\"+field).length; j++) {\n";
			echo "			var oOption = document.createElement(\"OPTION\");\n";
			echo "			document.getElementById(table+\"_\"+field+ix).options.add(oOption);\n";
			echo "			oOption.value = document.getElementById(\"global_\"+table+\"_\"+field)[j].value;\n";
			echo "			oOption.text = document.getElementById(\"global_\"+table+\"_\"+field)[j].text;\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
			for ($i=0; $i<count($this->ent_1XN); $i++) {
				$c = $this->ent_1XN[$i];
				$ent_table = $c . $this->ref[$c]["table"];
				echo "function fn_ckalterdropdown_$ent_table(field,ix) {\n";
				echo "	var get_field = ''\n";
				echo "	if (document.getElementById(\"{$ent_table}_\"+field+ix).length != document.getElementById(\"global_{$ent_table}_\"+field).length)\n";
				echo "		var get_field = field\n";
				echo "	else {\n";
				echo "		for (var i=0; i<document.getElementById(\"{$ent_table}_\"+field+ix).length ;i++) {\n";
				echo "			if (document.getElementById(\"{$ent_table}_\"+field+ix)[i].value != document.getElementById(\"global_{$ent_table}_\"+field)[i].value) {\n";
				echo "				var get_field = field\n";
				echo "				break;\n";
				echo "			}\n";
				echo "		}\n";
				echo "	}\n";
				echo "	return get_field\n";
				echo "}\n";
				echo "function fn_apply_$ent_table() {\n";
				echo "	for (var i=0; i<document.getElementById(\"count_$ent_table\").value; i++) {\n";
				echo "		if (document.getElementById(\"ck_$ent_table\"+i).checked) {\n";
				$ref = $this->ref[$c]["edicao_global_ref"];
				for ($j=0; $j<count($this->ref[$c]["field"]); $j++) {
					$field = $this->ref[$c]["field"][$j]["field"];
					$type = $this->ref[$c]["field"][$j]["type"];
					$ck_hidden = $this->ref[$c]["field"][$j]["ck_hidden"];
					if ($type != "hidden" &&
						$type != "file" &&
						$ck_hidden == 0 &&
						(count($ref) == 0 || in_array($field, $ref))) {
						echo "			if (document.getElementById(\"ck_global_{$ent_table}_{$field}\").checked) {\n";
						if ($type == "dropdown") { // sincroniza se houve chamadas ajax
							echo "				var x = fn_ckalterdropdown_$ent_table(\"{$field}\",i);\n";
							echo "				if (x != \"\") fn_sync_dropdown_globalform('{$ent_table}',x,i)\n";
						}
						if ($type == "checkbox") {
							echo "				document.getElementById(\"{$ent_table}_{$field}\"+i).checked = document.getElementById(\"global_{$ent_table}_{$field}\").checked?1:0\n";
						} elseif ($type == "date") {
							echo "				document.getElementById(\"dia_{$ent_table}_{$field}\"+i).value = document.getElementById(\"dia_global_{$ent_table}_{$field}\").value\n";
							echo "				document.getElementById(\"mes_{$ent_table}_{$field}\"+i).value = document.getElementById(\"mes_global_{$ent_table}_{$field}\").value\n";
							echo "				document.getElementById(\"ano_{$ent_table}_{$field}\"+i).value = document.getElementById(\"ano_global_{$ent_table}_{$field}\").value\n";
						} elseif ($type == "dropdown" && array_key_exists("multiple", $this->ref[$c]["field"][$j]["prop"])) {
							echo "				for (var j=0; j<document.getElementById(\"global_{$ent_table}_{$field}\").length; j++) {\n";
							echo "					if (document.getElementById(\"global_{$ent_table}_{$field}\")[j].selected) document.getElementById(\"{$ent_table}_{$field}\"+i)[j].selected = true\n";
							echo "					else document.getElementById(\"{$ent_table}_{$field}\"+i)[j].selected = false\n";
							echo "				}\n";
						} else {
							echo "				document.getElementById(\"{$ent_table}_{$field}\"+i).value = document.getElementById(\"global_{$ent_table}_{$field}\").value\n";
						}
						if ($type == "filteredtext") { // sincroniza dados com objeto ajax
							echo "				document.getElementById(\"nome{$ent_table}_{$field}\"+i).value = document.getElementById(\"nomeglobal_{$ent_table}_{$field}\").value\n";
						}
						echo "			}\n";
					}
				}
				echo "		}\n";
				echo "	}\n";
				echo "}\n";
			}
		}
		if ($this->ck_multiple_entry == 1) {
			echo "function fn_request_entity(table) {\n";
			echo "	var x = prompt(\"$this->lang_prompt_entity\",1)\n";
			echo "	if (x && cknum(x)) {\n";
			echo "		for (var i=0; i<x; i++) {\n";
			echo "			fn_edit_item(table);\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
		}
		echo "// --->\n";
		echo "</script>\n";
		echo "<link rel='STYLESHEET' type='text/css' href='$this->css_path'>\n";
		echo "</HEAD>\n";
		$onload_str = "";
		for ($i=0; $i<count($this->onload_action); $i++) {
			$onload_str .= $this->onload_action[$i] . ";";
		}
		echo "<body bgcolor=White " . ($onload_str != "" ? "onload=\"$onload_str\"" : "") . ">\n";
		if ($this->modo == "insert" && 
			$this->ck_return_pk == 1 && 
			isset($this->vars["ck_return_pk"]) &&
			strpos($this->ck_return_use,"I") !== false) {
			echo $this->build_return_pk();
		}
		echo "<form " . ($this->document_name_form != "" ? "action=\"" . $this->document_name_form . "\"" : "") . " name=\"formulario\" method=\"POST\" enctype=\"multipart/form-data\">\n";
		if ($this->tpl_form == "")
			$this->build_form_default("form", $this->ref, $title);
		else
			$this->build_form_custom("form", $this->ref, $this->tpl_form);
		echo "</form>\n";
		if ($this->ck_print == 0 &&
			$this->modo == "update" && 
			count($this->ent_1XN) > 0) {
			echo "<script language=\"JavaScript\">\n";
			echo "<!--- \n";
			echo "trava_delete_aux = new Array();\n";
			for ($i=0; $i<count($this->ent_1XN); $i++) {
				$p = $this->ent_1XN[$i];
				$ent_table = $p . $this->ref[$p]["table"];
				$res_aux = $this->get_res_aux($this->ref[$p],1);
				echo "trava_delete_aux[\"$ent_table\"] = new Array();\n";
				for ($j=0;$j<count($res_aux);$j++) {
					$ck_trava = 0;
					if (isset($this->ref[$p]["entity_trava"])) {
						for ($k=0; $k<count($this->ref[$p]["entity_trava"]); $k++) {
							$field = $this->ref[$p]["entity_trava"][$k]["field"];
							$val = $this->ref[$p]["entity_trava"][$k]["val"];
							if ($res_aux[$j][$field] == $val) $ck_trava = 1;
						}
					}
					if ($ck_trava == 1) echo "trava_delete_aux[\"$ent_table\"][" . $res_aux[$j]["id"] . "] = 1;\n";
					/*
					echo "fn_edit_item(\"$ent_table\");\n";
					echo "document.getElementById(\"id_$ent_table$j\").value = '" . $res_aux[$j]["id"] . "';\n";
					for ($k=0; $k<count($this->ref[$p]["field"]); $k++) {
						$ref = $this->ref[$p]["field"][$k];
						if ($ref["type"] == "checkbox") {
							echo "document.getElementById(\"".$ent_table."_" . $ref["field"] . "$j\").checked = " . ($res_aux[$j][$ref["field"]] == 1 ? "true":"false") . ";\n";
						//elseif ($this->ck_print == 1) 
							//echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").innerHTML = '" . ($res_aux[$j][$ref["field"]] == "" ? "&nbsp;" : $res_aux[$j][$ref["field"]]) . "';\n";
						} elseif ($ref["type"] == "file" && $res_aux[$j][$ref["field"]] != "") {
							echo "document.getElementById(\"{$ent_table}_remove" . $ref["field"] . "div{$j}\").style.display = '';\n";
							echo "document.getElementById(\"{$ent_table}_imagem" . $ref["field"] . "div{$j}\").style.display = '';\n";
							echo "document.getElementById(\"{$ent_table}_imagem" . $ref["field"] . "div{$j}\").innerHTML = '<a href=" . $ref["filedir"] . "/" . $res_aux[$j][$ref["field"]] . " target=_blank><img src=" . $ref["filedirthumb"] . "/" . $res_aux[$j][$ref["field"]] . " border=0></a>';\n";
						} elseif ($ref["type"] == "text" && isset($ref["mask"])) {
							$ini = 0;
							for ($l=0; $l<count($ref["mask"]); $l++) {
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$l$j\").value = '" . substr($res_aux[$j][$ref["field"]], $ini, $ref["mask"][$l]) . "';\n";
								if ($ck_trava == 1) {
									echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$l$j\").readOnly = 1;\n";
									echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$l$j\").style.backgroundColor = 'red';\n";
								}
								$ini = $ref["mask"][$l];
							}
						} else {
							if ($res_aux[$j][$ref["field"]] != "") {
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").value = '" . $res_aux[$j][$ref["field"]] . "';\n";
							}
							if ($ref["type"] == "filteredtext") {
								echo "document.getElementById(\"nome{$ent_table}_" . $ref["field"] . "$j\").value = '" . str_replace("'","\'",$res_aux[$j]["filteredtext"]) . "';\n";
							}
							if ($ck_trava == 1) {
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").readOnly = 1;\n";
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").style.backgroundColor = 'red';\n";
							}
						}
					}
					*/
				}
			}
			echo "// --->\n";
			echo "</script>\n";
		}
		echo "</BODY></HTML>\n";
	}
	private function get_form_data() {
		$str_field = "";
		for ($i=0; $i<count($this->ref); $i++) {
			$field = @$this->ref[$i]["field"];
			$type = @$this->ref[$i]["type"];
			if (isset($this->ref[$i]["table"]) && $this->ref[$i]["table"] != null) {
				$table = $this->ref[$i]["table"];
				$label = $field;
			} elseif (count($this->tab_ref) == 0 || $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] == null) {
				$table = $this->table;
				$label = $field;
			} else {
				$table = $this->tab_ref[$this->ref[$i]["tab_id"]]["table"];
				$label = "{$table}_{$field}";
			}
			if (isset($this->ref[$i]["field_qry"])) {
				$field = $this->ref[$i]["field_qry"];
			} 
			if ($type != "entity" && 
				($this->ref[$i]["ck_qry"] == 1 || isset($this->ref[$i]["field_qry"]))) {
				if ($type == "date") {
					$str_field .= "DAY($table.$field) AS dia_$label, MONTH($table.$field) AS mes_$label, YEAR($table.$field) AS ano_$label,\n";
				} elseif ($type == "datetime") {
					$str_field .= "DAY($table.$field) AS dia_$label, MONTH($table.$field) AS mes_$label, YEAR($table.$field) AS ano_$label, datepart(hh, $table.$field) AS hor_$label, datepart(n, $table.$field) AS min_$label,\n";
				} elseif ($type == "daterange") {
					$str_field .= "DAY($table.{$field}_ini) AS dia_{$label}_ini, MONTH($table.{$field}_ini) AS mes_{$label}_ini, YEAR($table.{$field}_ini) AS ano_{$label}_ini,\n";
					$str_field .= "DAY($table.{$field}_fim) AS dia_{$label}_fim, MONTH($table.{$field}_fim) AS mes_{$label}_fim, YEAR($table.{$field}_fim) AS ano_{$label}_fim,\n";
				} elseif ($this->db == "MSSQL" && ($type == "textarea" || $type == "publisher")) {
					$str_field .= "CONVERT(text, $table.$field) AS $label,\n";
				} elseif ($type != "dynamiclist" &&
					($type != "dropdown" || !array_key_exists("multiple", $this->ref[$i]["prop"]))) {
					$str_field .= "$table.$field AS $label,\n";
				}
				if ($type == "radio" &&
					isset($this->ref[$i]["list"])) {
					$keys = array_keys($this->ref[$i]["list"]);
					for ($j=0; $j<count($keys); $j++) {
						if (is_array($this->ref[$i]["list"][$keys[$j]])) {
							$str_field .= $table . "." . $this->ref[$i]["list"][$keys[$j]]["field"] . ",\n";
						}
					}
				}
			}
			// get fields on dir name
			if (isset($this->ref[$i]["file"])) {
				for ($j=0; $j<count($this->ref[$i]["file"]); $j++) {
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $this->ref[$i]["file"][$j]["dir"]["O"], $match);
					for ($k=0; $k<count($match[0]); $k++) {
						if (strpos($match[0][$k], ".") === false)
							$temp = "$table." . substr($match[0][$k],1,-1);
						else
							$temp = substr($match[0][$k],1,-1);
						if (strpos($str_field, $temp) === false) 
							$str_field .= "$temp,\n";
					}
				}
			}
		}
		for ($i=0; $i<count($this->ref); $i++) {
			if (isset($this->ref[$i]["ref_qry"])) { 
				preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $this->ref[$i]["ref_qry"], $match);
				for ($j=0; $j<count($match[0]); $j++) {
					$ix = substr($match[0][$j],1,-1);
					if (strpos($str_field, $ix) === false) $str_field .= "$ix,\n";
				}
			}
		}
		for ($i=0; $i<count($this->tab_ref); $i++) {
			$table = $this->tab_ref[$i]["table"];
			if ($table != null) $str_field .= "CASE WHEN $table.id IS NOT NULL THEN $table.id ELSE 0 END AS id_$table,\n";
		}
		if (is_array($this->pk)) {
			for ($i=0; $i<count($this->pk); $i++) {
				$str_field .= ($i > 0 ? "," : "") . "$this->table." . $this->pk[$i];
			}
		} else {
			$str_field .= "$this->table.$this->pk AS id";
		}
		// join
		$join_str = "";
		for ($i=0; $i<count($this->related); $i++) {
			if (strpos($this->related[$i]["use"],"F") !== false) $join_str .= $this->related[$i]["sql"] . "\n";
		}
		$keys = array_keys($this->list_param);
		if (isset($this->vars[$keys[0]])) {
			$qry = "SELECT $str_field 
				FROM $this->table 
				$join_str
				WHERE\n";
			if (is_array($this->pk)) {
				for ($i=0; $i<count($this->pk); $i++) {
					$qry .= ($i > 0 ? " AND " : "") . "$this->table." . $this->pk[$i] . " = '" . $this->vars[$this->pk[$i]] . "'";
				}
			} else {
				$qry .= "$this->table.$this->pk = '" . $this->vars[$this->pk] . "'";
			}
			if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
			$this->res_upd = nc_query($qry);
		}
	}
	private function feed_filter_prop() {
		for ($i=0; $i<count($this->ref_filter); $i++) {
			if ($this->ref_filter[$i]["type"] == null) {
				for ($j=0; $j<count($this->ref); $j++) {
					if ($this->ref_filter[$i]["field"] == $this->ref[$j]["field"]) {
						$keys = array_keys($this->ref[$j]);
						for ($k=0; $k<count($keys); $k++) {
							if (isset($this->ref_filter[$i][$keys[$k]]))
								$prop = $this->ref_filter[$i][$keys[$k]];
							else
								$prop = null;
							if ($prop == null ||
								(is_array($prop) && count($prop) == 0))
								$this->ref_filter[$i][$keys[$k]] = $this->ref[$j][$keys[$k]];
						}
						break;
					}
				}
			}
			if ($this->ref_filter[$i]["type"] == "text" &&
				(!isset($this->ref_filter[$i]["mask"]) || count($this->ref_filter[$i]["mask"]) == 0)) {
				$this->ref_filter[$i]["type"] = "findtext";
			}
		}
	}
	private function build_filter() {
		$this->tab_ref = array();
		$this->feed_filter_prop();
		if ($this->modo == "update") $title = "$this->lang_title_update $this->ent";
		if ($this->modo == "complete") $title = "$this->lang_title_complete $this->ent";
		if ($this->modo == "report") $title = "$this->lang_title_report $this->ent";
		echo "<HTML>\n<HEAD>\n<TITLE>$title</TITLE>\n";
		echo "<link rel='STYLESHEET' type='text/css' href='$this->css_path'>\n";
		echo "<script language=\"JavaScript\">\n";
		echo "<!--- \n";
		if ($this->ck_unique == 1) {
			echo $this->get_js_unique();
		}
		if ($this->ck_unlock == 1) {
			echo $this->get_js_unlock();
		}
		echo $this->get_js_ckform("filter",$this->ref_filter);
		echo "// --->\n";
		echo "</script>\n";
		if ($this->step == 0) echo $this->get_js();
		echo "</HEAD>\n";
		echo "<table width=$this->form_width border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
		if ($this->ck_display_title == 1) echo $this->get_list_title($title);
		echo "</table>\n";
		echo "<form name=\"formulario\" method=\"POST\" enctype=\"multipart/form-data\">\n";
		if (!isset($this->tpl_filter) || $this->tpl_filter == "")
			$this->build_form_default("filter",$this->ref_filter);
		else
			$this->build_form_custom("filter",$this->ref_filter, $this->tpl_filter);
		echo "</form>\n";
		if ($this->step == 1) {
			echo "<table width=$this->form_width border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
			echo "<tr><td colspan=2 class=\"$this->css_form_separator\"></td></tr>\n";
			echo "</table>\n";
		}
	}
	private function build_form_default($scope,$ref,$title="") {
		echo "<table width=$this->form_width border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
		if ($this->ck_display_title == 1 && $title != "") {
			echo "<tr><td colspan=2 style=\"padding:0\"><table border=0 cellpadding=0 cellspacing=0 width=\"" . (isset($this->title_width) ? $this->title_width : $this->form_width) . "\"><tr class=\"{$this->css_label_entity}\"><td class=\"$this->css_title_pg\">" . ($this->use_required_position == "right" ? "<span class=\"$this->css_required\" style=\"float:right; line-height:12pt\">$this->str_required $this->lang_label_required</span>" : "") . "$title</td></tr></table></td></tr>\n";
		}
		if ($this->ck_print == 0 && $scope == "form" && $this->use_required_position == "down") {
			echo "<tr><td colspan=2 class=\"$this->css_list_separator\"></td></tr>\n";
			echo "<tr class=\"{$this->css_label_entity}\"><td colspan=2>$this->str_required=$this->lang_label_required</td></tr>\n";
		}
		if ($scope == "form")
			echo "<tr><td colspan=2 class=\"$this->css_form_separator\"></td></tr>\n";
		if (count($this->tab_ref) > 0) {
			echo "<tr><td colspan=2 style=padding:0;border:0>\n";
			echo "<table width=100% border=0 cellspacing=0 cellpadding=0><tr>\n";
			for ($i=0; $i<count($this->tab_ref); $i++) {
				if ($i>0) echo "<td style=\"width:3px\"></td>\n";
				echo "<td id=\"tab$i\" align=center class=\"$this->css_label" . ($i==0?"b":"") . "\" onclick=fn_chtab($i) style=\"cursor:pointer;padding:5px;border-bottom:0;\">" . $this->tab_ref[$i]["label"] . "</td>\n";
			}
			echo "</tr></table>\n";
			echo "</td>\n";
			echo "</tr>\n";
		}
		for ($i=0; $i<count($ref); $i++) {
			$ck_hidden = 0;
			if ($ref[$i]["tab_id"] > 0) $ck_hidden = 1;
			else if ($ref[$i]["ck_hidden"] == 1) {
				if (isset($ref[$i]["ck_hidden_condition"])) {
					for ($j=0; $j<count($ref); $j++) {
						if ($ref[$j]["field"] == $ref[$i]["ck_hidden_condition"]["field"]) {
							if ($this->modo == "insert" && (!isset($ref[$j]["default"]) || $ref[$j]["default"] == $ref[$i]["ck_hidden_condition"]["val"]))
								$ck_hidden = 1;
							else if ($this->modo == "update" && $this->res_upd[0][$ref[$j]["field"]] == $ref[$i]["ck_hidden_condition"]["val"])
								$ck_hidden = 1;
							break;
						}
					}
				} else
					$ck_hidden = 1;
			}
			if ($ref[$i]["type"] == "entity" && $ref[$i]["rel"] == "1XN") {
				for ($j=0; $j<count($this->ent_1XN); $j++) {
					if ($this->ent_1XN[$j] == $i) break;
				}
				$ent_table = $j . $ref[$i]["table"];
				$table = $i . $ref[$i]["table"];
				if ($this->ck_print == 0) {
					echo "<tr id=\"tr{$i}a\" " . ($ref[$i]["tab_id"] > 0 || $ck_hidden == 1 ? "style=display:none" : "") . ">\n";
					echo "<td colspan=2 style=padding:0>\n";
					echo "<table width=100% border=0 cellspacing=0 cellpadding=5>\n";
					echo "<tr class=\"$this->css_label\">\n";
					echo "<td valign=top class=\"$this->css_label\">" . $ref[$i]["label"] . ":</td>\n";
					if ($ref[$i]["ck_multiple_entry"] == 1)
						$action_str = "fn_request_entity(\"{$table}\")";
					else
						$action_str = "fn_edit_item(\"{$table}\")";
					if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
					echo "<td width=20 nowrap><a class=\"$this->css_link_general\" href=javascript:$action_str>[+]</a></td>\n";
					echo "</tr>\n";
					echo "</table>\n";
					echo "</td></tr>\n";
				}
				if ($this->ck_print == 0 && $ref[$i]["ck_edicao_global"] == 1) {
					$global_ref = $ref[$i]["edicao_global_ref"];
					echo "<tr id=\"tr{$i}c\" " . ($ref[$i]["tab_id"] > 0 || $ck_hidden == 1 ? "style=display:none" : "") . " class=\"$this->css_label\">\n";
					echo "<td colspan=2>\n";
					echo "<img src=\"$this->img_dir/$this->img_bullet\" width=23 height=11 border=0><a href=javascript:void(null) onclick=document.getElementById(\"indexacao_global_$table\").style.display=document.getElementById(\"indexacao_global_$table\").style.display=='none'?'':'none' class=\"$this->css_link_general\">$this->lang_global_edition:</a><br>\n";
					echo "<table id=\"indexacao_global_$table\" width=100% border=0 cellspacing=0 cellpadding=5 style=display:none>\n";
					echo "<tr class=\"$this->css_text\">\n";
					$count = count($global_ref) == 0 ? count($ref[$i]["field"]) : count($global_ref);
					// check split point
					$c = 0;
					for ($j=0; $j<$count; $j++) {
						if ($ref[$i]["field"][$j]["type"] != "hidden" &&
							$ref[$i]["field"][$j]["type"] != "file" &&
							$ref[$i]["field"][$j]["ck_hidden"] == 0 &&
							(count($global_ref) == 0 || in_array($ref[$i]["field"][$j]["field"], $global_ref))) $c++;
					}
					if (count($global_ref) == 0)
						$split = ceil($c/2);
					// draw form

					$c = 0;
					for ($j=0; $j<$count; $j++) {
						if ($j == 0 ||
							$c == $split) echo "<td width=50% valign=top>\n";
						if (count($global_ref) == 0) 
							$ix = $j;
						else {
							for ($k=0; $k<count($ref[$i]["field"]); $k++) {
								if ($global_ref[$j] == $ref[$i]["field"][$k]["field"]) {
									$ix = $k;
									break;
								}
							}
						}
						$field = $ref[$i]["field"][$ix]["field"];
						$label = $ref[$i]["field"][$ix]["label"];
						if ($ref[$i]["field"][$ix]["type"] != "hidden" &&
							$ref[$i]["field"][$ix]["type"] != "file" &&
							$ref[$i]["field"][$ix]["ck_hidden"] == 0 &&
							(count($global_ref) == 0 || in_array($field, $global_ref))) {
							$c++;
							echo "<input type=checkbox id=\"ck_global_{$table}_{$field}\" name=\"ck_global_{$table}_{$field}\" value=1 onclick=document.getElementById('{$field}_{$table}div').style.display=this.checked?'':'none' " . (count($global_ref) == 1 ? "style=\"display:none\" CHECKED" : "") . ">$label<br>\n";
							echo "<div id=\"{$field}_{$table}div\" " . (count($global_ref) != 1 ? "style=\"padding-left:4px;display:none\"" : "") . ">\n";
							if (isset($ref[$i]["field"][$ix]["comment_before"])) echo $ref[$i]["field"][$ix]["comment_before"] . "\n";
							echo $this->get_field($scope,$ref[$i]["field"][$ix], null, "global_{$table}_");
							echo "<span id=\"comment_global_{$table}_{$field}\">";
							if (isset($ref[$i]["field"][$ix]["comment"])) echo $ref[$i]["field"][$ix]["comment"];
							echo "</span>\n";
							echo "<br>";
							echo "</div>\n";
						}
						if ($j == $count-1 ||
							$c == $split) echo "</td>\n";
					}
					echo "</tr>\n";
					echo "<tr>\n";
					echo "	<td valign=top class=\"$this->css_text\">\n";
					echo "	<input type=checkbox onclick=fn_ckall_globalform('$table',this.checked) CHECKED>MARCAR/DESMARCAR TODAS\n";
					echo "	<input type=button class=\"$this->css_button\" value=\"Aplicar\" style=width:50px onclick=fn_apply_$table()>\n";
					echo "	</td>\n";
					echo "</tr>\n";
					echo "</table>\n";
					echo "</td></tr>\n";
				} // if ($this->ck_print == 0 && $ref[$i]["ck_edicao_global"] == 1) {
				echo "<tr id=\"tr{$i}b\" " . ($ref[$i]["tab_id"] > 0 || $ck_hidden == 1 ? "style=display:none" : "") . "><td colspan=2 style=padding:0>\n";
				echo "<div id=\"readroot_{$table}\" style=\"" . ($ref[$i]["path"] != null ? "padding-bottom:3px;" : "") . "display:" . ($this->ck_print == 0 ? "none" : "") . "\">\n";
				if ($this->ck_print == 0 && $ref[$i]["ck_edicao_global"] == 1) {
					echo "<table border=0 cellspacing=0 cellpadding=0><tr>\n";
					echo "<td valign=top><input id=\"ck_{$table}\" type=checkbox CHECKED></td><td>\n";
				}
				if ($ref[$i]["path"] != null) {
					$temp = file($ref[$i]["path"]);
					$tableaux_str = "";
					for ($j=0; $j<count($temp); $j++) {
						$tableaux_str .= $temp[$j];
					}
					if ($this->ck_print == 0) {
						$str = $tableaux_str;
						for ($j=0; $j<count($ref[$i]["field"]); $j++) {
							$field = $ref[$i]["field"][$j]["field"];
							if ($ref[$i]["field"][$j]["type"] == "hidden")
								$str = str_replace("[$field]", $this->get_field($scope,$ref[$i]["field"][$j], null, $table . "_"), $str);
							else {
								$temp = "";
								if (isset($ref[$i]["field"][$j]["comment_before"])) $temp .= $ref[$i]["field"][$j]["comment_before"] . "\n";
								$temp .= $this->get_field($scope,$ref[$i]["field"][$j], null, $table . "_");
								$temp .= "<span id=\"comment_{$table}_{$field}\">";
								if (isset($ref[$i]["field"][$j]["comment"])) $temp .= $ref[$i]["field"][$j]["comment"];
								$temp .= "</span>";
								$str = str_replace("[$field]", $temp, $str);
							}
						}
						$action_str = "fn_delete_item('$table',this.id.replace('delete',''))";
						if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
						$str = str_replace("[DELETE]", "<input type=button id=\"delete\" onclick=$action_str value=[-] class=\"$this->css_button_remove\">", $str);
					} else {
						$key_field = $ref[$i]["key_field"];
						$str_field = "";
						for ($k=0; $k<count($ref[$i]["field"]); $k++) {
							$str_field .= ($k>0?",":"") . $ref[$i]["field"][$k]["field"];
						}
						if (isset($ref[$i]["entity_trava"])) {
							for ($k=0; $k<count($ref[$i]["entity_trava"]); $k++) {
								$str_field .= "," . $ref[$i]["entity_trava"][$k]["field"];
							}
						}
						$qry = "SELECT id, $str_field FROM " . $ref[$i]["table"] . " WHERE $key_field = " . $this->vars["id"];
						if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
						$res_aux = nc_query($qry);
						for ($j=0; $j<count($res_aux); $j++) {
							for ($k=0; $k<count($ref[$i]["field"]); $k++) {
								if ($ref[$i]["field"][$k]["type"] != "hidden") {
									$field = $ref[$i]["field"][$k]["field"];
									$str = str_replace("[$field]", $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $ref[$i]["table"] . "_", null), $str);
								}
							}
						}
					} // if ($ref[$i]["path"] != null) {
					echo $str;
				} else { // if ($ref[$i]["path"] != null) {
					echo "<table border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
					if ($ref[$i]["entity_layout"] == "H") {
						echo "<tr id=\"titulo_{$table}\" style=\"display:" . ($this->ck_print == 0 ? "none" : "") . "\">\n";
						$c = 0;
						for ($j=0; $j<count($ref[$i]["field"]); $j++) {
							$c++;
							if ($j == count($ref[$i]["field"])-1 || 
								$ref[$i]["field"][$j]["label"] != $ref[$i]["field"][$j+1]["label"]) {
								echo "<td colspan=$c class=" . ($this->ck_print == 1 ? "\"{$this->css_label}_relat\" style=padding-left:2px" : "\"{$this->css_label_entity}\"") . " " . ($c > 1 ? "align=center" : "") . " " . ($ref[$i]["field"][$j]["title"] != null ? "title=\"" . $ref[$i]["field"][$j]["title"] . "\"" : "") . ">" . $ref[$i]["field"][$j]["label"] . "</td>\n";
								$c = 0;
							}
						}
						echo "</tr>\n";
						if ($this->ck_print == 0) {
							echo "<tr>\n";
							for ($j=0; $j<count($ref[$i]["field"]); $j++) {
								if ($ref[$i]["field"][$j]["type"] == "hidden")
									echo $this->get_field($scope,$ref[$i]["field"][$j], null, $table . "_");
								else {
									echo "<td class={$this->css_text_entity} " . ($ref[$i]["field"][$j]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top nowrap>\n";
									if (isset($ref[$i]["field"][$j]["comment_before"])) echo $ref[$i]["field"][$j]["comment_before"] . "\n";
									echo $this->get_field($scope,$ref[$i]["field"][$j], null, $table . "_");
									if (isset($ref[$i]["field"][$j]["comment"])) echo $ref[$i]["field"][$j]["comment"];
									echo "</td>\n";
								}
							}
							$action_str = "fn_delete_item('$table',this.id.replace('delete',''))";
							if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
							if ($this->ck_print == 0) {
								echo "<td nowrap class={$this->css_text_entity} valign=top width=30><input type=button id=\"delete\" onclick=$action_str value=[-] class=\"$this->css_button_remove\"></td>\n";
							}
							echo "</tr>\n";
						} else {
							$key_field = $ref[$i]["key_field"];
							$str_field = "";
							for ($k=0; $k<count($ref[$i]["field"]); $k++) {
								$str_field .= ($k>0?",":"") . $ref[$i]["field"][$k]["field"];
							}
							if (isset($ref[$i]["entity_trava"])) {
								for ($k=0; $k<count($ref[$i]["entity_trava"]); $k++) {
									$str_field .= "," . $ref[$i]["entity_trava"][$k]["field"];
								}
							}
							$qry = "SELECT id, $str_field FROM " . $ref[$i]["table"] . " WHERE $key_field = " . $this->vars["id"];
							if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
							$res_aux = nc_query($qry);
							for ($j=0; $j<count($res_aux); $j++) {
								echo "<tr>\n";
								for ($k=0; $k<count($ref[$i]["field"]); $k++) {
									if ($ref[$i]["field"][$k]["type"] != "hidden") {
										echo "<td class={$this->css_text_entity} valign=top style=padding-left:0 nowrap>\n";
										echo $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $ref[$i]["table"] . "_", null);
										echo "</td>\n";
									}
								}
								echo "</tr>\n";
							}
						} // if ($ref[$i]["path"] != null) {
					} else if ($ref[$i]["entity_layout"] == "V") {
						if ($this->ck_print == 0) {
							for ($j=0; $j<count($ref[$i]["field"]); $j++) {
								echo "<tr>\n";
								if ($ref[$i]["field"][$j]["type"] == "hidden")
									echo $this->get_field($scope,$ref[$i]["field"][$j], null, $table . "_");
								else {
									echo "<td class=\"$this->css_label\" valign=top width=130>\n";
									if ($ref[$i]["field"][$j]["type"] == "checkbox") 
										echo "&nbsp;";
									else
										echo $ref[$i]["field"][$j]["label"];
									echo "</td>\n";
									echo "<td class=\"$this->css_text\" " . ($ref[$i]["field"][$j]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top width=400 nowrap>\n";
									if (isset($ref[$i]["field"][$j]["comment_before"])) echo $ref[$i]["field"][$j]["comment_before"] . "\n";
									echo $this->get_field($scope,$ref[$i]["field"][$j], null, $table . "_");
									if (isset($ref[$i]["field"][$j]["comment"])) echo $ref[$i]["field"][$j]["comment"];
									echo "</td>\n";
								}
								if ($j == 0 && $this->ck_print == 0) {
									$action_str = "fn_delete_item('$table',this.id.replace('delete',''))";
									if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
									echo "<td nowrap valign=top width=30><input type=button id=\"delete\" onclick=$action_str value=[-] class=\"$this->css_button_remove\"></td>\n";
								}
								echo "</tr>\n";
							}
						} // if ($ref[$i]["path"] != null) {
					}
					echo "</table>\n";
				} // if ($ref[$i]["path"] != null) {
				echo "<input type=\"hidden\" name=\"id_{$table}\" id=\"id_{$table}\" value=0>\n";
				if ($this->ck_print == 0 && $ref[$i]["ck_edicao_global"] == 1) {
					echo "</td></tr></table>\n";
				}
				echo "</div>\n";
				if ($this->modo == "update" && $this->ck_print == 0) {
					$res_aux = $this->get_res_aux($ref[$i]);
					for ($j=0; $j<count($res_aux); $j++) {
						$ck_trava = 0;
						if (isset($ref[$i]["entity_trava"])) {
							for ($k=0; $k<count($ref[$i]["entity_trava"]); $k++) {
								$field = $ref[$i]["entity_trava"][$k]["field"];
								$val = $ref[$i]["entity_trava"][$k]["val"];
								if ($res_aux[$j][$field] == $val) $ck_trava = 1;
							}
						}
						echo "<span id=\"$table$j\" " . ($ref[$i]["path"] != null ? "style=\"padding-bottom:3px\"" : "") . ">\n";
						if ($this->ck_print == 0 && $ref[$i]["ck_edicao_global"] == 1) {
							echo "<table border=0 cellspacing=0 cellpadding=0>\n";
							echo "<tr><td valign=top class=\"$this->css_text\" style=\"padding:0; border-top:5px white solid\"><input id=\"ck_{$table}{$j}\" name=\"ck_{$table}{$j}\" type=checkbox CHECKED><span class=spantexto>" . (is_numeric($res_aux[$j][$this->pk]) ? str_pad($res_aux[$j][$this->pk],7,'0','LEFT') : $res_aux[$j][$this->pk]) . "</span></td></tr>\n";
							echo "<tr><td>\n";
						}
						if ($ref[$i]["path"] != null) {
							if ($this->ck_print == 0) {
								$str = $tableaux_str;
								$str = ereg_replace("id=[a-zA-Z0-9_]+", "\\0".$j, $str);
								$str = ereg_replace("id=\\\"[a-zA-Z0-9_]+", "\\0".$j, $str);
								$str = ereg_replace("id=\\'[a-zA-Z0-9_]+", "\\0".$j, $str);
								for ($k=0; $k<count($ref[$i]["field"]); $k++) {
									$field = $ref[$i]["field"][$k]["field"];
									if ($ref[$i]["field"][$k]["type"] == "hidden")
										$str = str_replace("[$field]", $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $table . "_", $j), $str);
									else {
										$temp = "";
										if (isset($ref[$i]["field"][$k]["comment_before"])) $temp .= $ref[$i]["field"][$k]["comment_before"] . "\n";
										$temp .= $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $table . "_", $j);
										$temp .= "<span id=\"comment_{$table}_{$field}{$j}\">";
										if (isset($ref[$i]["field"][$k]["comment"])) $temp .= $ref[$i]["field"][$k]["comment"];
										$temp .= "</span>";
										$str = str_replace("[$field]", $temp, $str);
									}
								}
								$action_str = "fn_delete_item('$table',this.id.replace('delete',''))";
								if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
								$str = str_replace("[DELETE]", "<input type=button id=\"delete{$j}\" onclick=$action_str value=[-] class=\"$this->css_button_remove\">", $str);
							} else {
								$key_field = $ref[$i]["key_field"];
								$str_field = "";
								for ($k=0; $k<count($ref[$i]["field"]); $k++) {
									$str_field .= ($k>0?",":"") . $ref[$i]["field"][$k]["field"];
								}
								if (isset($ref[$i]["entity_trava"])) {
									for ($k=0; $k<count($ref[$i]["entity_trava"]); $k++) {
										$str_field .= "," . $ref[$i]["entity_trava"][$k]["field"];
									}
								}
								$qry = "SELECT id, $str_field FROM " . $ref[$i]["table"] . " WHERE $key_field = " . $this->vars["id"];
								if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
								$res_aux = nc_query($qry);
								for ($k=0; $k<count($res_aux); $k++) {
									for ($l=0; $l<count($ref[$i]["field"]); $l++) {
										if ($ref[$i]["field"][$l]["type"] != "hidden") {
											$field = $ref[$i]["field"][$l]["field"];
											$str = str_replace("[$field]", $this->get_field($scope,$ref[$i]["field"][$l], $res_aux[$j], $ref[$i]["table"] . "_", $j), $str);
										}
									}
								}
							} // if ($ref[$i]["path"] != null) {
							echo $str;
						} else {
							echo "<table border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
							if ($ref[$i]["entity_layout"] == "H") {
								echo "<tr id=\"titulo_{$table}{$j}\" style=\"display:" . ($this->ck_print == 0 && $j > 0 ? "none" : "") . "\">\n";
								$c = 0;
								for ($k=0; $k<count($ref[$i]["field"]); $k++) {
									$c++;
									if ($k == count($ref[$i]["field"])-1 || 
										$ref[$i]["field"][$k]["label"] != $ref[$i]["field"][$k+1]["label"]) {
										echo "<td colspan=$c class=" . ($this->ck_print == 1 ? "\"{$this->css_label}_relat\" style=padding-left:2px" : "\"{$this->css_label_entity}\"") . " " . ($c > 1 ? "align=center" : "") . " " . ($ref[$i]["field"][$k]["title"] != null ? "title=\"" . $ref[$i]["field"][$k]["title"] . "\"" : "") . ">" . $ref[$i]["field"][$k]["label"] . "</td>\n";
										$c = 0;
									}
								}
								echo "</tr>\n";
								if ($this->ck_print == 0) {
									echo "<tr>\n";
									for ($k=0; $k<count($ref[$i]["field"]); $k++) {
										if ($ref[$i]["field"][$k]["type"] == "hidden")
											echo $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $table . "_", $j);
										else {
											echo "<td class={$this->css_text_entity} " . ($ref[$i]["field"][$k]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top nowrap>\n";
											if (isset($ref[$i]["field"][$k]["comment_before"])) echo $ref[$i]["field"][$k]["comment_before"] . "\n";
											echo $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $table . "_", $j);
											if (isset($ref[$i]["field"][$k]["comment"])) echo $ref[$i]["field"][$k]["comment"] . "\n";
											echo "</td>\n";
										}
									}
									$action_str = "fn_delete_item('$table',this.id.replace('delete',''))";
									if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
									if ($this->ck_print == 0) {
										echo "<td nowrap class=\"{$this->css_text_entity}\" valign=top width=30><input type=button id=\"delete{$j}\" onclick=$action_str value=[-] class=\"$this->css_button_remove\"></td>\n";
									}
									echo "</tr>\n";
								}
							} else if ($ref[$i]["entity_layout"] == "V") {
								for ($k=0; $k<count($ref[$i]["field"]); $k++) {
									if ($ref[$i]["field"][$k]["type"] == "hidden")
										echo $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $table . "_", $j);
									else {
										echo "<tr>\n";
										//echo "<td width=130 class=\"$this->css_label" . ($this->ck_print == 1 ? "_relat" : "") . "\" valign=top>\n";
										echo "<td width=130 valign=top class=\"$this->css_label" . ($this->ck_print == 1 ? "_relat" : "") . "\" " . ($ref[$i]["field"][$k] == 1 ? "style=text-indent:-20px;padding-left:25px" : "") . ">" . ($ref[$i]["field"][$k]["type"] != "checkbox" ? ($ref[$i]["field"][$k]["ck_req"] == 1 && $this->ck_print == 0 && $scope == "form" ? "$this->str_required " : "") . $ref[$i]["field"][$k]["label"] . ":" : "&nbsp;");
										echo "</td>\n";
										echo "<td class=\"$this->css_text\" " . ($ref[$i]["field"][$k]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top width=400 nowrap>\n";
										if (isset($ref[$i]["field"][$k]["comment_before"])) echo $ref[$i]["field"][$k]["comment_before"] . "\n";
										echo $this->get_field($scope,$ref[$i]["field"][$k], $res_aux[$j], $table . "_", $j);
										if (isset($ref[$i]["field"][$k]["comment"])) echo $ref[$i]["field"][$k]["comment"];
										echo "</td>\n";
										if ($k == 0 && $this->ck_print == 0) {
											$action_str = "fn_delete_item('$table',this.id.replace('delete',''))";
											if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
											echo "<td nowrap valign=top width=30><input type=button id=\"delete$j\" onclick=$action_str value=[-] class=\"$this->css_button_remove\"></td>\n";
										}
										echo "</tr>\n";
									}
								}
							}
							echo "</table>\n";
						}
						if ($this->ck_print == 0 && $ref[$i]["ck_edicao_global"] == 1) {
							echo "</td></tr></table>\n";
						}
						echo "<input type=\"hidden\" name=\"id_{$table}{$j}\" id=\"id_{$table}{$j}\" value=\"" . $res_aux[$j][$ref[$i]["pk"]] . "\">\n";
						echo "</span>\n";
					} // for ($j=0;$j<count($res_aux);$j++) {
				} // if ($this->modo == "update") {
				echo "<span id=\"tableaux_{$table}\"></span>\n";
				echo "<input type=\"hidden\" name=\"count_{$table}\" id=\"count_{$table}\" value=" . ($this->modo == "insert" ? 0 : count($res_aux)) . ">\n";
				echo "<input type=\"hidden\" name=\"delete_list_{$table}\" id=\"delete_list_{$table}\" value=0>\n";
				echo "</td></tr>\n";
			} elseif ($ref[$i]["type"] == "entity" && $ref[$i]["rel"] == "NXN") { // } if 1XN
				$table = $i . $ref[$i]["table"];
				$label = $ref[$i]["entity_label"];
				$cols = $ref[$i]["entity_cols"];
				preg_match_all("[\[([a-zA-Z0-9_])+\]]", $ref[$i]["entity_qry"], $match);
				$qry = $ref[$i]["entity_qry"];
				for ($k=0; $k<count($match[0]); $k++) {
					$ix = substr($match[0][$k],1,-1);
					if (isset($this->res_upd)) {
						if ($ix == "id" && count($this->tab_ref) > 0 && $this->tab_ref[$ref[$i]["tab_id"]]["table"] != null)
							$val = $this->res_upd[0]["id_" . $this->tab_ref[$ref[$i]["tab_id"]]["table"]];
						else
							$val = $this->res_upd[0][$ix];
					} else if ($ix == "id")
						$val = 0;
					else 
						$val = "";
					$qry = str_replace($match[0][$k], $val, $qry);
				}
				//$qry = str_replace("[id]", ($this->modo == "insert" || $this->vars[$this->pk] == "" ? 0 : $this->vars[$this->pk]), $ref[$i]["entity_qry"]);
				//$field_list = $ref[$i]["entity_field"];
				$field_list = $ref[$i]["field"];
				if (isset($ref[$i]["entity_group"])) {
					$entity_group = $ref[$i]["entity_group"];
					$ck_group = 1;
				} else {
					$ck_group = 0;
				}
				$entity_groupby_ck = $ref[$i]["entity_group"] != "" ? 1 : 0;
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				$res_aux = nc_query($qry);
				echo "<tr id=\"tr{$i}a\" " . ($ref[$i]["tab_id"] > 0 || $ck_hidden == 1 ? "style=display:none" : "") . ">\n";
				echo "<td colspan=2 class=\"$this->css_label" . ($this->ck_print == 1 ? "_relat" : "") . "\">" . $ref[$i]["label"] . ":</td>\n";
				echo "</tr>\n";
				echo "<tr id=\"tr{$i}b\" " . ($ref[$i]["tab_id"] > 0 || $ck_hidden == 1 ? "style=display:none" : "") . ">\n";
				echo "<td class={$this->css_text_entity} valign=top colspan=2 style=padding:0>\n";
				echo "<table width=100% border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
				$c = 0;
				$group_bak = "";
				for ($j=0; $j<count($res_aux); $j++) {
					if ($this->ck_print == 0 || $res_aux[$j]["ck"] == 1) {
						if ($ck_group == 1 && 
							$entity_groupby_ck == 1 && 
							 ($j==0 || 
							  $res_aux[$j]["ck"] != $res_aux[$j-1]["ck"] || 
							  $res_aux[$j][$entity_group] != $group_bak)) {
							$group_bak = $res_aux[$j][$entity_group];
							$list = "0";
							for ($k=$j; $k<count($res_aux); $k++) {
								if ($res_aux[$j][$entity_group] != $res_aux[$k][$entity_group] ||
									$res_aux[$j]["ck"] != $res_aux[$k]["ck"]) break;
								$list .= ",'$table$k'";
							}
							$action_str = "fn_ckall_NXN(this.checked, new Array($list))";
							if (isset($ref[$i]["prop"]["onclick"])) $action_str .= ";" . $ref[$i]["prop"]["onclick"];
							echo "<tr style=cursor:pointer onclick=\"fn_chdisplay_NXN(new Array($list))\">\n";
							echo "<td class=\"$this->css_text" . ($this->ck_print == 1 ? "_relat" : "") . "\" colspan=$cols>\n";
							if ($this->ck_print == 0) echo "<input type=checkbox onclick=\"$action_str\">";
							echo $res_aux[$j][$entity_group];
							if ($res_aux[$j]["ck"] == 0 && $this->modo == "update" && $entity_groupby_ck == 1) echo " ($this->lang_label_no_select_NXN)\n";
							echo "</td>\n";
							echo "</tr>\n";
							$c = 0;
						}
						$ck_hidden = (($this->modo == "update" || $this->modo == "complete" || $this->modo == "updatedelete") && $res_aux[$j]["ck"] == 0 && $ck_group == 1 && $entity_groupby_ck == 1 ? 1 : 0);
						if ($c%$cols == 0) echo "<tr " . ($ck_hidden == 1 ? "style=display:none" : "") . " id=\"table_$table$j\">\n";
						echo "<td valign=top class=" . ($this->ck_print == 1 ? "\"{$this->css_text}_relat\"" : "\"{$this->css_text_entity}\"") . " valign=top style=\"text-indent:-20px;padding-left:25px\" width=" . round(100/$cols) . "%>\n";
						$ck_trava = 0;
						if (isset($ref[$i]["entity_trava"])) {
							for ($k=0; $k<count($ref[$i]["entity_trava"]); $k++) {
								$field = $ref[$i]["entity_trava"][$k]["field"];
								$val = $ref[$i]["entity_trava"][$k]["val"];
								if ($res_aux[$j][$field] == $val) $ck_trava = 1;
							}
						}
						$prop_str = "";
						if ($res_aux[$j]["ck"] == 1) 
							$prop_str .= " CHECKED";
						if ($ck_trava == 1 || $this->ck_print == 1)
							$prop_str .= " disabled";
						else if (isset($ref[$i]["prop"]["onclick"])) 
							$prop_str .= " onclick=\"".$ref[$i]["prop"]["onclick"]."\"";
						if ($res_aux[$j][$field_list[0]["field"]] == "") 
							$prop_str .= " disabled";
						echo "<input type=checkbox name=\"{$table}{$j}\" id=\"ck_$table$j\" value=1 $prop_str><span id=\"comment_$table$j\">" . $res_aux[$j][$label] . "</span>\n";
						if ($ck_trava == 1 && $res_aux[$j]["ck"] == 1) echo "<input type=\"hidden\" name={$table}{$j} value=1>\n";
						echo "<input type=\"hidden\" name={$table}_bak{$j} value=" . $res_aux[$j]["ck"] . ">\n";
						for ($k=0; $k<count($field_list); $k++) {
							$field = $field_list[$k]["field"];
							echo "<input type=\"hidden\" name=\"{$table}_{$field}{$j}\" id=\"{$table}_{$field}{$j}\" value=\"" . $res_aux[$j][$field] . "\">\n";
						}
						echo "</td>\n";
						if ($j == count($res_aux)-1 || $c%$cols == $cols-1) echo "</tr>\n";
						$c++;
					}
				} // for ($j=0; $j<count($res_aux); $j++) {
				if ($c == 0) {
					echo "<tr>\n";
					echo "<td class=\"$this->css_text" . ($this->ck_print == 1 ? "_relat" : "b") . "\" valign=top colspan=$cols>\n";
					if ($this->ck_print == 1) 
						echo "Nenhum evento selecionado\n";
					elseif ($this->ck_print == 0) 
						echo $this->lang_label_no_events_1XN;
					echo "</td>\n";
					echo "</tr>\n";
				}
				echo "</table>\n";
				echo "<input type=\"hidden\" name=\"count_{$table}\" id=\"count_{$table}\" value=" . count($res_aux) . ">\n";
				echo "</td></tr>\n";
			} else if ($ref[$i]["type"] != "dbfield") {
				if ($ref[$i]["type"] == "hidden") {
					echo $this->get_field($scope,$ref[$i]);
				} else {
					// nao mostra td label se todos os campos do tab sao checkbox
					$ck_td_label = 1;
					if (count($this->tab_ref) > 0) {
						$ck_td_label = 0;
						for ($j=0; $j<count($ref); $j++) {
							if ($ref[$j]["tab_id"] == $ref[$i]["tab_id"] &&
								$ref[$j]["type"] != "checkbox") {
								$ck_td_label = 1;
								break;
							}
						}
					}
					echo "<tr id=\"tr$i\" " . ($ref[$i]["tab_id"] > 0 || ($ck_hidden == 1 && ($this->modo == "insert" || $this->modo == "report" || ($this->modo == "update" && $this->res_upd[0][$ref[$j]["field"]] != ""))) ? "style=display:none" : "") . ">\n";
					if ($ck_td_label == 1) {
						echo "<td width=130 valign=top class=\"$this->css_label" . ($this->ck_print == 1 ? "_relat" : "") . "\" " . ($ref[$i]["ck_req"] == 1 ? "style=\"text-indent:-15px;padding-left:20px\"" : "") . ">" . ($ref[$i]["type"] != "checkbox" || $ref[$i]["field_group"] != null ? ($ref[$i]["ck_req"] == 1 && $this->ck_print == 0 && $scope == "form" ? "$this->str_required " : "") . ($ref[$i]["field_group"] == null ? $ref[$i]["label"] : $ref[$i]["field_group"]) . ":" : "&nbsp;");
						if ($ref[$i]["type"] == "publisher") echo "<br><br><br><input class=\"form1\" name=\"ck" . $ref[$i]["field"] . "\" value=\"" . $ref[$i]["field"] . "\" type=\"checkbox\" onclick=\"setMode(this.value,this.checked);\">HTML";
						echo  "</td>\n";
					}
					echo "<td width=460 class=\"$this->css_text" . ($this->ck_print == 1 ? "_relat" : "") . "\" " . ($ref[$i]["type"] == "checkbox" && $ref[$i]["field_group"] == null ? "style=\"text-indent:-20px;padding-left:25px\"" : "") . ">\n";
					for ($j=$i; $j<count($ref); $j++) {
						if ($ref[$j]["field_group"] != null && $ref[$j]["type"] != "checkbox") echo $ref[$j]["label"] . ":";
						echo "<span id=\"comment_before_" . $ref[$j]["field"] . "\">" . (isset($ref[$j]["comment_before"]) ? $ref[$j]["comment_before"] : "") . "</span>\n";
						if ($this->modo == "update" && $this->step == 2)
							echo $this->get_field($scope,$ref[$j], $this->res_upd[0]);
						else if (($this->modo == "update" || $this->modo == "report") && $this->step == 1 && count($this->ref_filter) > 0)
							echo $this->get_field($scope,$ref[$j], $this->vars);
						else
							echo $this->get_field($scope,$ref[$j]);
						echo "<span id=\"comment_" . $ref[$j]["field"] . "\">" . (isset($ref[$j]["comment"]) ? $ref[$j]["comment"] : "") . "</span><br>\n";
						if ($ref[$i]["field_group"] == null ||
							$j == count($ref)-1 ||
							$ref[$j]["field_group"] != $ref[$j+1]["field_group"]) break;
					}
					$i = $j;
					echo "</td></tr>\n";
				}
			}
			if ($ref[$i]["ck_separator"] == 1) {
				echo "<tr><td colspan=2 class=\"$this->css_form_separator\"></td></tr>\n";
			}
		} // for ($i=0; $i<count($ref); $i++) {
		if ($this->ck_print == 0) {
			echo "<tr><td colspan=2 class=\"$this->css_form_separator\"></td></tr>\n";
			echo "<tr><td colspan=2 align=\"$this->button_align\">\n";
			echo $this->get_form_button($scope);
			if ($this->use_print_back == 1) echo $this->get_form_back();
			echo "</td></tr>\n";
		} else if ($this->use_print_close == 1 || $this->use_print_button == 1) {
			echo "<tr><td colspan=2 class=\"$this->css_form_separator\"></td></tr>\n";
			echo "<tr><td colspan=2 align=\"$this->button_align\">\n";
			if ($this->use_print_close == 1) echo $this->get_form_close();
			if ($this->use_print_button == 1) echo $this->get_form_print();
			echo "</td></tr>\n";
		}
		echo "</table>\n";
	}
	private function build_form_custom($scope,$ref, $tpl) {
		$tpl = file($tpl);
		$htm = "";
		for ($i=0; $i<count($tpl); $i++) {
			$htm .= $tpl[$i];
		}
		for ($i=0; $i<count($ref); $i++) {
			if ($ref[$i]["type"] != "entity") {
				if (stripos($htm, "[".$ref[$i]["field"]."]") === false) {
					exit("Field " . $ref[$i]["field"] . " not found on template");
				}
				if ($this->modo == "update" && $this->step == 2)
					$htm = str_ireplace("[".$ref[$i]["field"]."]", $this->get_field($scope,$ref[$i], $this->res_upd[0]), $htm);
				else if (($this->modo == "update" || $this->modo == "report" || $this->modo == "complete") && $this->step == 1 && count($this->ref_filter) > 0)
					$htm = str_ireplace("[".$ref[$i]["field"]."]", $this->get_field($scope,$ref[$i], $this->vars), $htm);
				else
					$htm = str_ireplace("[".$ref[$i]["field"]."]", $this->get_field($scope,$ref[$i]), $htm);
			}
		}
		if (isset($this->tpl_val)) {
			$keys = array_keys($this->tpl_val);
			for ($i=0; $i<count($keys); $i++) {
				$htm = str_ireplace("[".$keys[$i]."]", $this->tpl_val[$keys[$i]], $htm);
			}
		}
		$htm = str_ireplace("[submit]", $this->get_form_button($scope), $htm);
		if ($this->use_print_back == 1) $htm = str_ireplace("[back]", $this->get_form_back(), $htm);
		echo $this->get_js();
		echo $htm;
	}
	private function build_return_pk() {
		if ($this->modo == "insert")
			$tpl = $this->tpl_return_insert_pk;
		else if ($this->modo == "update")
			$tpl = $this->tpl_return_update_pk;
		if ($tpl == "") {
			echo "<iframe id=\"iframe_prompt\" scrolling=no style=\"position:absolute;\n";
			echo "	left:200;\n";
			echo "	top:140;\n";
			echo "	width:180;\n";
			echo "	height:180;\n";
			echo "	background-color:white;\n";
			echo "	border:0;\n";
			echo "	z-index:1\"></iframe>\n";
			echo "<div id=\"div_prompt\" class=dragme style=\"position:absolute;\n";
			echo "	left:200;\n";
			echo "	top:140;\n";
			echo "	width:180;\n";
			echo "	height:180;\n";
			echo "	background-color:silver;\n";
			echo "	border:1px solid black;\n";
			echo "	padding:0;\n";
			echo "	z-index:2\">\n";
			echo "<table width=100% height=100% border=0 cellspacing=0 cellpadding=5 class=\"$this->css_label\">\n";
			echo "<tr height=11>\n";
			echo "<td width=100%></td>\n";
			echo "<td><a href=javascript:void(null) onclick=document.getElementById(\"iframe_prompt\").style.display='none';document.getElementById(\"div_prompt\").style.display='none'><img src=\"$this->img_dir/fechar.gif\" width=11 height=11 border=0></a></td>\n";
			echo "</tr>\n";
			echo "<tr>\n";
			echo "<td colspan=2 width=100% align=center><b>$this->lang_return_pk<br> " . strtoupper($this->ck_return_entity == "default" ? $this->ent : $this->ck_return_entity) . ":<br><font color=red>" . $this->vars["ck_return_pk"] . "</font><br>&nbsp;</b></td>\n";
			echo "</tr>\n";
			echo "</table>\n";
			echo "</div>\n";
		} else {
			$tpl = file($tpl);
			$htm = "";
			for ($i=0; $i<count($tpl); $i++) {
				$htm .= $tpl[$i];
			}
			$htm = str_replace("[PK]", $this->vars["ck_return_pk"], $htm);
			echo $htm;
		}
	}
	private function build_list() {
		if (isset($this->vars["count"])) {
			$this->update_list();
			if (is_array($this->table)) {
				$url = $_SERVER["SCRIPT_NAME"] . "?" . $_SERVER["QUERY_STRING"];
				$keys = array_keys($this->vars);
				for ($i=0; $i<count($keys); $i++) {
					if ($keys[$i] != "count") $url .= "&" . $keys[$i] . "=" . $this->vars[$keys[$i]];
				}
				echo "<META HTTP-EQUIV=Refresh content=\"1;url=$url\">\n";
				exit;
			}
		}
		if (is_array($this->table)) {
			$this->res_list = $this->table;
		} else {
			/* disabled on 07/08/2008
			// label edition
			if (isset($_SESSION["cls_form_vars"])) {
				$keys = array_keys($_SESSION["cls_form_vars"]);
				for ($i=0; $i<count($keys); $i++) {
					if ($keys[$i] != "modo" &&
						$keys[$i] != "step" &&
						$keys[$i] != "id") {
						$var = $keys[$i];
						$$var = $_SESSION["cls_form_vars"][$keys[$i]];
					}
				}
			}
			*/
			// add filter condition
			if (count($this->ref_filter) > 0) {
				$ck_session = 0;
				if (isset($this->vars["get_session_filter"])) {
					$this->vars = $_SESSION["vars_bak"];
					session_unregister("vars_bak");
					$ck_session = 1;
				}
				$this->feed_filter_prop();
				for ($i=0; $i<count($this->ref_filter); $i++) {
					$field = $this->ref_filter[$i]["field"];
					$qry_field = $this->ref_filter[$i]["qry_field"];
					if (isset($this->ref_filter[$i]["mask"])) {
						$val = "";
						$c = 0;
						$mask = $this->ref_filter[$i]["mask"];
						for ($j=0; $j<count($mask); $j++) {
							if (is_numeric($mask[$j])) {
								$val .= $this->vars[$field.$c];
								$c++;
							} else if ($this->ref_filter[$i]["write_mask"] == 1) 
								$val .= $mask[$j];
						}
					} else if (isset($this->vars[$field])) {
						$val = $this->vars[$field];
					} else {
						$val = "";
					}
					if ($val != "") {
						$val = $this->get_val($this->ref_filter[$i]);
						if ($this->ref_filter[$i]["type"] == "daterange") {
							$this->add_condition("$qry_field >= " . $val["ini"]); 
							$this->add_condition("$qry_field <= " . $val["fim"]); 
							$this->add_header("<b>" . $this->ref_filter[$i]["label"] . "</b>: " . $val["ini"] . " a " . $val["fim"]); 
						} else if ($this->ref_filter[$i]["type"] == "findtext") {
							if (isset($this->ref_filter[$i]["keyword_ref"]) && count($this->ref_filter[$i]["keyword_ref"]) > 0) {
								$str = "";
								for ($j=0; $j<count($this->ref_filter[$i]["keyword_ref"]); $j++) {
									$keyword_ref = $this->ref_filter[$i]["keyword_ref"][$j];
									if (isset($this->vars["ck_".$this->get_field_label($keyword_ref)]))
										$str .= ($str != "" ? " OR " : "") . $this->get_field_index($keyword_ref) . " LIKE " . ($this->db == "MYSQL" ? "_utf8" : "") . "'%" . str_replace("'","",$val) . "%'" . ($this->db == "MYSQL" ? "COLLATE utf8_unicode_ci" : "");
								}
								$this->add_condition("($str)"); 
							} else
								$this->add_condition("$qry_field LIKE " . ($this->db == "MYSQL" ? "_utf8" : "") . "'%" . str_replace("'","",$val) . "%'" . ($this->db == "MYSQL" ? "COLLATE utf8_unicode_ci" : "")); 
							$this->add_header("<b>" . $this->ref_filter[$i]["label"] . "</b>: " . $this->vars[$field]); 
						} else {
							$this->add_condition("$qry_field = $val");
							if (isset($this->ref_filter[$i]["ref_qry"])) {
								$res_temp = $this->get_ref_query($this->ref_filter[$i], $this->vars);
								$this->add_header("<b>" . $this->ref_filter[$i]["label"] . "</b>: " . $res_temp[0][$this->ref_filter[$i]["ref_label"]]); 
							} else if (isset($this->ref_filter[$i]["qry"])) {
								$sql = $this->ref_filter[$i]["qry"]["sql"];
								if (strpos($sql, "ORDER BY") !== false)
									$sql = substr($sql, 0, strpos($sql, "ORDER BY"));
								$sql .= " AND " . $this->ref_filter[$i]["qry"]["ix"] . " = '" . $this->vars[$field] . "'";
								$res_temp = nc_query($sql);
								$this->add_header("<b>" . $this->ref_filter[$i]["label"] . "</b>: " . $res_temp[0][$this->ref_filter[$i]["qry"]["label"]]); 
							} else if (isset($this->ref_filter[$i]["list"])) {
								$this->add_header("<b>" . $this->ref_filter[$i]["label"] . "</b>: " . $this->ref_filter[$i]["list"][$this->vars[$field]]); 
							} else if ($this->ref_filter[$i]["type"] == "checkbox") {
								$this->add_header($this->ref_filter[$i]["label"]); 
							} else
								$this->add_header("<b>" . $this->ref_filter[$i]["label"] . "</b>: " . $this->vars[$field]); 
						}
					}
				}
				if (isset($this->setup_complete) &&
					$this->setup_complete == "linked" && 
					$ck_session == 0)
					$_SESSION["vars_bak"] = $this->vars;
			}
			$group_key_str = "";
			$group_str = "";
			$order_str = "";
			$where_str = "";
			$join_str = "";
			$label_str = "";
			for ($i=0; $i<count($this->group_key); $i++) {
				if ($this->list_modo == "custom") {
					$temp = explode(".",$this->group_key[$i]["field"]);
					$label = $temp[count($temp)-1];
				} else if ($this->list_modo == "auto") {
					$label = "group$i";
				}
				$group_key_str .= $this->group_key[$i]["field"] . " AS $label,\n";
				$group_key_str .= $this->group_key[$i]["order"] . " AS order$label,\n";
				if (count($this->order) == 0)
					$order_str .= ($order_str != "" ? "," : "") . $this->group_key[$i]["order"] . " " . $this->group_key[$i]["direction"] . "\n";
			}
			for ($i=0; $i<count($this->order); $i++) {
				$ck = 0;
				for ($j=0; $j<count($this->label); $j++) {
					if ($this->order[$i]["field"] == $this->label[$j]["field"]) {
						$ck = 1;
						break;
					}
				}
				if ($ck == 0) $label_str .= $this->order[$i]["field"] . " AS order$i,\n";
				$order_str .= ($order_str != "" ? "," : "") . $this->order[$i]["field"] . " " . $this->order[$i]["direction"] . "\n";
			}
			for ($i=0; $i<count($this->group); $i++) {
				$group_str .= ($group_str != "" ? "," : "") . $this->group[$i]["field"] . "\n";
			}
			for ($i=0; $i<count($this->label); $i++) {
				$label_str .= $this->label[$i]["field"] . ",\n";
				if ($this->label[$i]["ck_update"] == 1 && 
					($this->label[$i]["type"] == "date" || $this->label[$i]["type"] == "datetime")) {
					$field_label = $this->get_field_label($this->label[$i]["field"]);
					$field_index = $this->get_field_index($this->label[$i]["field"]);
					$label_str .= "DAY($field_index) AS dia_$field_label, MONTH($field_index) AS mes_$field_label, YEAR($field_index) AS ano_$field_label,\n";
					if ($this->label[$i]["type"] == "datetime")
						$label_str .= "DATEPART(hh, $field_index) AS hor_$field_label, DATEPART(n, $field_index) AS min_$field_label,\n";
				}
				if ($this->label[$i]["orderby"] != null) {
					$field_index = $this->label[$i]["orderby"];
				} else {
					if ($this->ck_recursive == 1 || $this->pageby != null) {
						$field_index = $this->get_field_label($this->label[$i]["field"]);
					} else {
						$field_index = $this->get_field_index($this->label[$i]["field"]);
					}
				}
				if (count($this->order) == 0 &&
					!is_numeric(trim($field_index)) && 
					strtoupper(substr($field_index, 0, 6)) != "COUNT(" && 
					strtoupper(substr($field_index, 0, 4)) != "SUM(" && 
					strtoupper(substr($field_index, 0, 4)) != "MAX(" && 
					strtoupper(substr($field_index, 0, 4)) != "MIN(" && 
					strtoupper(substr($field_index, 0, 4)) != "AVG(") {
					$order_str .= ($order_str != "" ? "," : "") . $field_index . "\n";
				}
			}
			for ($j=0; $j<count($this->link_ref); $j++) {
				preg_match_all("[\[([a-zA-Z0-9_.])+\]]", $this->link_ref[$j]["url"], $match);
				for ($k=0; $k<count($match[0]); $k++) {
					$str = (strpos($match[0][$k], ".") == 0 ? $this->table."." : "") . substr($match[0][$k],1,-1);
					if (strpos($label_str, $str) == 0) 
						$label_str .= "$str,\n";
				}
			}
			for ($i=0; $i<count($this->color_ref); $i++) {
				$label_str .= $this->color_ref[$i]["param"] . ",";
			}
			for ($i=0; $i<count($this->related); $i++) {
				if (strpos($this->related[$i]["use"],"L") !== false) $join_str .= $this->related[$i]["sql"] . "\n";
			}
			$ck_delete_str = "";
			if ($this->modo == "delete" || $this->modo == "complete" || $this->modo == "updatedelete") {
				for ($i=0; $i<count($this->dependency); $i++) {
					$table = $this->dependency[$i]["table"];
					if (strpos($this->dependency[$i]["table"], " "))
						$table_id = trim(substr($this->dependency[$i]["table"], strpos($this->dependency[$i]["table"], " ")));
					else 
						$table_id = $table;
					$ix = $this->dependency[$i]["ix"];
					if ($this->ck_recursive == 1) {
						$where_str .= "$this->table.$this->pk NOT IN (SELECT $ix FROM $table WHERE $ix IS NOT NULL) AND\n";
					} else if ($this->ck_recursive == 0) {
						$join_str .= "LEFT JOIN $table ON $table_id.$ix = $this->table.$this->pk\n";
						if ($this->modo == "delete") 
							$where_str .= "$table_id.$ix IS NULL AND\n";
						else
							$ck_delete_str .= "WHEN $table_id.$ix IS NOT NULL THEN 0\n";
					}
				}
			}
			if ($ck_delete_str == "") 
				$label_str .= "1 AS ck_delete,\n";
			else
				$label_str .= "CASE $ck_delete_str ELSE 1 END AS ck_delete,\n";
			for ($i=0; $i<count($this->condition); $i++) {
				$where_str .= $this->condition[$i] . " AND\n";
			}
			// define table
			$temp = explode(" ", $this->table);
			$qry_table = $temp[count($temp)-1];
			if (is_array($this->pk)) {
				$pk_str = "";
				for ($i=0; $i<count($this->pk); $i++) {
					$pk_str .= ($i>0 ? "," : "") . "$qry_table." . $this->pk[$i];
				}
			} else {
				$pk_str = "$qry_table.$this->pk";
			}
			if (isset($this->list_qry)) {
				if ($this->debug == 1) echo "<pre style=text-align:left>$this->list_qry</pre>";
				$this->res_list = nc_query($this->list_qry);
			} else if ($this->pageby != null) {
				// find paging for DESC order
				$qry = "SELECT 
						COUNT(DISTINCT $pk_str) AS total
					FROM $this->table
					$join_str
					WHERE
						$where_str
						1 = 1";
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				$this->res_tot = nc_query($qry);
				$temp = explode(",", $order_str);
				if (!isset($this->vars["pagina"])) $this->vars["pagina"] = 1;
				if (strtoupper(substr(trim($temp[0]),-4)) == "DESC" && $this->db == "MSSQL") {
					$ini = max($this->res_tot[0]["total"] - ($this->vars["pagina"])*$this->pageby, 0);
					$fim = $this->res_tot[0]["total"] - ($this->vars["pagina"]-1)*$this->pageby;
				} else {
					$ini = ($this->vars["pagina"]-1)*$this->pageby;
					$fim = ($this->vars["pagina"])*$this->pageby;
				}
				// exec query
				if ($this->db == "MSSQL") {
					$qry = "SELECT * FROM (
							SELECT DISTINCT
								DENSE_RANK() OVER(ORDER BY $qry_table.$this->pk) AS rownum, 
								--ROW_NUMBER() OVER(ORDER BY $qry_table.$this->pk) AS rownum, 
								--COUNT($qry_table.$this->pk) OVER(PARTITION BY 0) AS total,
								" . ($this->ck_active == 1 ? "$this->active_field AS ativo," : "") . "
								$group_key_str
								$label_str
								$pk_str
							FROM $this->table
							$join_str
							WHERE
								$where_str
								1 = 1) rs
						WHERE 
							rownum > $ini AND 
							rownum <= $fim
						" . ($group_str != "" ? "
						GROUP BY
							$group_str
						" : "") . "
						ORDER BY
							" . ($this->ck_active == 1 ? "ativo DESC," : "") . "
							$order_str";
				} else if ($this->db == "MYSQL") {
					$qry = "SELECT DISTINCT
							" . ($this->ck_active == 1 ? "$this->active_field AS ativo," : "") . "
							$group_key_str
							$label_str
							$pk_str
						FROM $this->table
						$join_str
						WHERE
							$where_str
							1 = 1
						" . ($group_str != "" ? "
						GROUP BY
							$group_str
						" : "") . "
						ORDER BY
							" . ($this->ck_active == 1 ? "ativo DESC," : "") . "
							$order_str
						LIMIT
							$ini, $this->pageby";
				}
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				$this->res_list = nc_query($qry);
			} else if ($this->ck_recursive == 1) {
				$temp = explode(",", $label_str);
				$recursive_str = "";
				for ($i=0; $i<count($temp); $i++) {
					if (trim($temp[$i]) != "") {
						$recursive_str .= $this->get_field_label($temp[$i]) . ",";
					}
				}
				$qry = "WITH tree (
						" . ($this->ck_active == 1 ? "ativo," : "") . " 
						$recursive_str 
						id_tree, 
						level, 
						pathstr)
					AS (SELECT
						" . ($this->ck_active == 1 ? "$this->active_field AS ativo," : "") . "
						$label_str
						$pk_str,
						0 AS level,
						CAST(" . $this->get_field_index($this->label[0]["field"]) . " AS VARCHAR(MAX))
					FROM $this->table
					WHERE 
						$where_str
						$this->recursive_index IS NULL
					UNION ALL
					SELECT
						" . ($this->ck_active == 1 ? "$this->active_field AS ativo," : "") . "
						$label_str
						$pk_str,
						tree.level + 1 AS level,
						tree.pathstr + ',' + " . $this->label[0]["field"] . "
					FROM $this->table
					INNER JOIN tree ON tree.id_tree = $qry_table.$this->recursive_index
					$join_str
					WHERE
						$where_str
						1 = 1)
					SELECT 
						" . ($this->ck_active == 1 ? "ativo," : "") . " 
						$recursive_str 
						id_tree AS $this->pk, 
						level, 
						pathstr
					FROM tree
					ORDER BY
						" . ($this->ck_active == 1 ? "ativo DESC," : "") . "
						pathstr,
						$order_str";
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				$this->res_list = nc_query($qry, $method = "QUERY"); // check if nc_query version accepts $method = "QUERY"
			} else {
				$qry = "SELECT DISTINCT
						" . ($this->ck_active == 1 ? "$this->active_field AS ativo," : "") . "
						$group_key_str
						$label_str
						$pk_str
					FROM $this->table
					$join_str
					WHERE
						$where_str
						1 = 1
					" . ($group_str != "" ? "
					GROUP BY
						$group_str
					" : "") . "
					ORDER BY
						" . ($this->ck_active == 1 ? "ativo DESC," : "") . "
						$order_str";
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				$this->res_list = nc_query($qry);
			}
		}
		if ($this->modo == "report" && count($this->res_list) > 0 && $this->pageby == null) $this->add_header("<b>Total:</b> ".count($this->res_list));
		if ($this->modo == "report" && count($this->res_list) > 0 && $this->pageby != null) $this->add_header("<b>Total:</b> ".$this->res_tot[0]["total"]);
		if ($this->modo == "delete") $title = "$this->lang_title_delete $this->ent";
		if ($this->modo == "update") $title = "$this->lang_title_update $this->ent";
		if ($this->modo == "complete" || $this->modo == "updatedelete") $title = "$this->lang_title_complete $this->ent";
		if ($this->modo == "report") $title = "$this->lang_title_report $this->ent";
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>$title</TITLE>\n";
		echo "<link rel=\"STYLESHEET\" type=\"text/css\" href=\"$this->css_path\">\n";
		echo $this->get_js();
		echo "<script language=\"JavaScript\">\n";
		echo "<!--- \n";
		if ($this->ck_collapse == 1 || $this->ck_recursive == 1) {
			echo "function fn_chdisplay(list) {\n";
			echo "	for (var i=0; i<list.length; i++) {\n";
			echo "		if (document.getElementById(list[i])) {\n";
			echo "			obj = document.getElementById(list[i])\n";
			echo "			obj.style.display = obj.style.display == '' ? 'none' : ''\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
		}
		if ($this->ck_flag_mode == 1) {
			echo "function fn_ckall_flag(ck,field) {\n";
			echo "	for (var i=0; i<document.getElementById(\"count\").value; i++) {\n";
			echo "		document.getElementById(field+i).checked = ck;\n";
			echo "	}\n";
			echo "}\n";
		}
		echo $this->get_js_ckform("list", $this->flag_mode_ref);
		echo "// --->\n";
		echo "</script>\n";
		echo "</HEAD>\n";
		if ($this->modo == "update" && 
			$this->ck_return_pk == 1 && 
			isset($this->vars["ck_return_pk"]) &&
			strpos($this->ck_return_use,"U") !== false) {
			echo $this->build_return_pk();
		}
		echo "<body bgcolor=White>\n";
		//echo "<table " . (count($this->label) <= 2 || count($this->res_list) == 0 ? "width=$this->form_width" : "") . " border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
		echo "<table width=$this->form_width border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
		if ($this->ck_recursive == 1)
			$colspan = 2;
		elseif (is_array($this->label))
			$colspan = count($this->label);
		else
			$colspan = 1;
		if ($this->modo == "complete" || $this->modo == "updatedelete") 
			$colspan++;
		if ($this->modo == "delete") {
			for ($i=0; $i<count($this->dependency); $i++) {
				$this->header[count($this->header)] = "$this->lang_delete_dependency \"" . $this->dependency[$i]["label"] . "\"";
			}
		}
		if (count($this->res_list) == 0) {
			$this->header[count($this->header)] = $this->lang_not_found . ($this->modo == "delete" ? " (que no esteja relacionado em outras tabelas)" : "");
		}
		if (($this->modo == "updatedelete" || $this->modo == "complete") && count($this->ref_filter) > 0) $this->ck_display_title == 0;
		if ($this->ck_display_title == 1) {
			$add_separator = (count($this->res_list) == 0 || count($this->header) > 0) ? 1 : 0;
			echo $this->get_list_title($title, $colspan, $add_separator);
		}
		if ($this->modo == "complete" && 
			$this->setup_complete == "linked" && 
			$this->step == 1) {
			echo "<form method=get>\n";
			echo "<tr><td colspan=$colspan class=$this->css_complete_insert_button_space align=\"center\" valign=top>";
			echo "<input type=\"submit\" class=\"$this->css_button\" value=\"$this->lang_title_insert\">\n";
			echo "<input type=\"hidden\" name=\"modo\" value=\"insert\">\n";
			echo "<input type=\"hidden\" name=\"step\" value=\"define=1\">\n";
			$vars = array_merge($_GET);
			$keys = array_keys($vars);
			for ($i=0; $i<count($keys); $i++) {
				if ($keys[$i] != "pagina" &&
					$keys[$i] != "modo" &&
					$keys[$i] != "step")
					echo "<input type=\"hidden\" name=\"" . $keys[$i] . "\" value=\"" . $vars[$keys[$i]] . "\">\n";
			}
			echo "</td></tr>\n";
			echo "<tr><td colspan=2 class=\"$this->css_list_separator\"></td></tr>\n";
			echo "</form>\n";
		}
		if (count($this->header) > 0) {
			echo "<tr><td colspan=$colspan class={$this->css_text_entity} valign=top>\n";
			for ($i=0; $i<count($this->header); $i++) {
				echo $this->header[$i] . "<br>\n";
			}
			echo "</td></tr>\n";
		}
		if (count($this->graph) > 0)
			$this->build_graph_list($colspan); // demo
		else
			$this->build_default_list($colspan);
		echo "</table>\n";
		echo "</body></html>\n";
	}
	private function build_default_list($colspan) {
		if ($this->pageby != null && 
			$this->res_tot[0]["total"] > $this->pageby &&
			strpos($this->pageby_pos, "U") !== false) {
			echo $this->get_paging($this->res_tot[0]["total"], $colspan);
		}
		if ($this->modo == "delete" || $this->modo == "complete" || $this->modo == "updatedelete" || $this->ck_flag_mode == 1) {
			echo "<form name=formulario method=POST>\n";
		}
		if ($this->use_list_header_separator == 1 && count($this->group_key) == 0)
			echo "<tr><td colspan=$colspan class=\"$this->css_list_separator\"></td></tr>\n";
		if (count($this->group_key) == 0 &&
			count($this->label) > 1 &&
			count($this->res_list) > 0) {
			echo "<tr class=\"$this->css_list_title\">\n";
			for ($i=0; $i<count($this->label); $i++) {
				for ($j=$ini=$i; $j<count($this->label); $j++) {
					if ($this->label[$i]["label"] != $this->label[$j]["label"]) break;
					$i = $j;
				}
				if ($this->list_title_mode == "V") 
					$nowrap = "NOWRAP";
				elseif ($this->label[$i]["type"]=="checkbox" && $this->label[$i]["ck_update"]==1) 
					$nowrap = "NOWRAP";
				else
					$nowrap = "";
				echo "<td class=\"$this->css_list_title\" colspan=" . ($j-$ini) . " " . ($this->list_title_mode == "V" ? "style=\"direction:rtl; writing-mode:tb-rl\" align=right" : "valign=top align=".$this->label[$i]["alignment"]) . " $nowrap>" . ($this->label[$i]["type"]=="checkbox" && $this->label[$i]["ck_update"]==1 ? "<input type=checkbox onclick=fn_ckall_flag(this.checked,'".$this->get_field_label($this->label[$i]["field"])."')> " : "") . $this->label[$i]["label"] . ($this->label[$i]["mode"] == "NUM" ? " (".$this->label[$i]["un"].")" : "") . "</td>";
				//if ($j > $i+1) $i = $j-1;
			}
			if ($this->modo == "complete" || $this->modo == "updatedelete")
				echo "<td>&nbsp;</td>";
			echo "</tr>\n";
		}
		// list loop
		$c = 0;
		for ($i=0; $i<count($this->res_list); $i++) {
			// color
			$bgcolor = "";
			if ($this->ck_active == 1 && $this->res_list[$i]["ativo"] == 0)
				$bgcolor = "FFFFAA";
			else {
				for ($j=0; $j<count($this->color_ref); $j++) {
					$param = $this->color_ref[$j]["param"];
					$val = $this->color_ref[$j]["param_var"];
					$condition = $this->color_ref[$j]["param_condition"];
					if (strpos($param, ".") > 0) $param = substr($param, strpos($param, ".")+1);
					if (strpos($param, "AS ") > 0) $param = substr($param, strpos($param, "AS ")+3);
					if (($condition == "==" && $this->res_list[$i][$param] == $val) || 
						($condition == "!=" && $this->res_list[$i][$param] != $val) || 
						($condition == ">=" && $this->res_list[$i][$param] >= $val) || 
						($condition == "<=" && $this->res_list[$i][$param] <= $val) || 
						($condition == ">" && $this->res_list[$i][$param] > $val) || 
						($condition == "<" && $this->res_list[$i][$param] < $val)) {
						$bgcolor = $this->color_ref[$j]["color"];
					}
				}
			}
			// group
			if (count($this->group_key) > 0) {
				for ($j=0; $j<count($this->group_key); $j++) {
					if ($this->list_modo == "custom") {
						$label = $this->get_field_label($this->group_key[$j]["field"]);
					} else if ($this->list_modo == "auto") {
						$label = "group$j";
					}
					if ($j == 0) $label_bak = $label;
					if ($i==0 || 
						$this->res_list[$i][$label] != $this->res_list[$i-1][$label] || 
						$this->res_list[$i][$label_bak] != $this->res_list[$i-1][$label_bak] ||
						($this->ck_active == 1 && $this->res_list[$i]["ativo"] != $this->res_list[$i-1]["ativo"])) {
						$ck_start = $i;
						if ($j == count($this->group_key)-1) 
							$str = "'trtitulo$i'";
						else
							$str = "";
						for ($k=$i; $k<count($this->res_list); $k++) {
							if ($j == count($this->group_key)-1) {
								if ($this->res_list[$i][$label] != $this->res_list[$k][$label]) break;
								if ($this->ck_active == 1 && $this->res_list[$i]["ativo"] != $this->res_list[$k]["ativo"]) break;
								$str .= ($str != "" ? "," : "") . "'tr$k'";
							} else {
								if ($this->res_list[$i][$label] != $this->res_list[$k][$label]) break;
								if ($this->ck_active == 1 && $this->res_list[$i]["ativo"] != $this->res_list[$k]["ativo"]) break;
								$str .= ($str != "" ? "," : "") . "'trlabel" . ($j+1) . "_{$k}'";
							}
						}
						if ($j == 0) {
							$str .= ",'trseparador$k'";
							echo "<tr id=\"trseparador$i\" " . ($this->ck_collapse == 1 && $i > 0 ? "style=display:none" : "") . "><td colspan=$colspan class=\"$this->css_list_separator\"></td></tr>\n";
						}
						echo "<tr id=\"trlabel{$j}_{$i}\" " . ($this->ck_collapse == 1 ? "style=cursor:pointer" . ($j>0?";display:none":"") . " onclick=\"fn_chdisplay(new Array($str))\"" : "") . " class=\"$this->css_list_group\">";
						echo "<td valign=TOP colspan=$colspan  class=\"$this->css_list_group\" " . ($this->ck_collapse == 1 ? "width=$this->form_width" : "") . " " . ($this->ck_active == 1 && $this->res_list[$i]["ativo"] == 0 ? "style=background-color:#$bgcolor" : "") . ">";
						echo $this->res_list[$i][$label] . " " . ($this->ck_active == 1 && $this->res_list[$i]["ativo"] == 0 ? "($this->lang_label_non_active)" : "");
						echo "</td>";
						echo "</tr>\n";
						$c = 0;
						//if ($j == count($this->group_key)-1 && $this->ck_collapse == 1) {
						if ($j == count($this->group_key)-1) {
							if (count($this->label) > 1 &&
								count($this->res_list) > 0) {
								$bgcolor = "";
								if ($this->ck_active == 1 && $this->res_list[$i]["ativo"] == 0)
									$bgcolor = "FFFFAA";
								echo "<tr id=\"trtitulo$i\" " . ($this->ck_collapse == 1 ? "style=\"display:none\"" : "") . " class=\"$this->css_list_title\">";
								for ($k=0; $k<count($this->label); $k++) {
									echo "<td bgcolor=\"$bgcolor\" " . ($this->list_title_mode == "V" ? "nowrap style=\"direction:rtl; writing-mode:tb-rl\" align=right" : "align=".$this->label[$k]["alignment"]) . ">" . $this->label[$k]["label"] . "</td>";
								}
								echo "</tr>\n";
							}
						}
					}
					$label_bak = $label;
				} // for ($j=0; $j<count($this->group_key); $j++) {
			} else if ($this->ck_active == 1) {
				if (($i==0 || $this->res_list[$i]["ativo"] != $this->res_list[$i-1]["ativo"]) && $this->res_list[$i]["ativo"] == 0) {
					if ($i > 0) echo "<tr><td colspan=$colspan class=\"$this->css_list_separator\"></td></tr>";
					echo "<tr class=\"$this->css_list_title\">\n";
					echo "<td bgcolor=\"$bgcolor\" valign=TOP colspan=$colspan " . ($this->ck_active == 1 && $this->res_list[$i]["ativo"] == 0 ? "style=background-color:#00FFFFAA" : "") . ">\n";
					echo ($this->ck_active == 1 && $this->res_list[$i]["ativo"] == 0 ? "($this->lang_label_non_active)" : "" );
					echo "</td>";
					$c = 0;
				}
			}
			$c++;
			if (isset($this->css_list_even) && $this->css_list_even != "" && $c%2 == 0)
				$class = $this->css_list_even;
			else if (isset($this->css_list_text))
				$class = $this->css_list_text;
			else
				$class = $this->css_text;
			echo "<tr id=\"tr$i\" valign=top class=\"$class\" " . ($this->ck_collapse == 1 || ($this->ck_recursive == 1 && $this->res_list[$i]["level"] != 0) ? "style=display:none" : "") . ">\n";
			if ($this->ck_recursive == 1) {
				$str = "";
				for ($j=$i; $j<count($this->res_list); $j++) {
					if ($j != $i && $this->res_list[$i]["level"] == $this->res_list[$j]["level"]) break;
					if ($this->res_list[$j]["level"] == $this->res_list[$i]["level"]+1) $str .= ($str != "" ? "," : "") . "'tr$j'";
				}
				if ($this->res_list[$i]["level"] < $this->res_list[$j-1]["level"])
					echo "<td><a href=\"javascript:fn_chdisplay(new Array($str))\" class=\"$this->css_link_general\">[+]</a></td>\n";
				else
					echo "<td bgcolor=white></td>\n";
			}
			$params = "";
			if ($this->modo == "update" || $this->modo == "complete" || $this->modo == "updatedelete" || $this->modo == "report") {
				$keys = array_keys($this->list_param);
				for ($j=0; $j<count($keys); $j++) {
					if (strtoupper($this->list_param[$keys[$j]]) == "GETFROMQRY")
						$val = $this->res_list[$i][$keys[$j]];
					else
						$val = $this->list_param[$keys[$j]];
					$params .= ($params != "" ? "&" : "") . $keys[$j] . "=" . urlencode($val);
				}
				$keys = array_keys($_GET);
				for ($j=0; $j<count($keys); $j++) {
					$ck = 0;
					for ($k=0; $k<count($this->ref_filter); $k++) {
						if ($keys[$j] == $this->ref_filter[$k]["field"]) {
							$ck = 1;
							break;
						}
					}
					if ($keys[$j] != "modo" && $keys[$j] != "step")
						$params .= ($params != "" ? "&" : "") . $keys[$j] . "=" . urlencode($_GET[$keys[$j]]);
				}
			}
			// rowspan
			if ($this->ck_repeat_row == 1 &&
				$i < count($this->res_list)-1) {
				$rowspan = 0;
				for ($j=$i; $j<count($this->res_list); $j++) {
					if ($this->res_list[$i][$this->pk] != $this->res_list[$j][$this->pk]) break;
					$rowspan++;
				}
			} else
				$rowspan = 1;
			for ($j=0; $j<count($this->label); $j++) {
				echo $this->get_list_td($i, $j, $this->label[$j], $this->res_list[$i], $rowspan, $bgcolor, $params, $class);
			}
			for ($j=0; $j<count($this->link_ref); $j++) {
				preg_match_all("[\[([a-zA-Z0-9_.])+\]]", $this->link_ref[$j]["url"], $match);
				$url = $this->link_ref[$j]["url"];
				for ($k=0; $k<count($match[0]); $k++) {
					$url = str_replace($match[0][$k], urlencode($this->res_list[$i][$this->get_field_label(substr($match[0][$k],1,-1))]), $url);
				}
				$target = $this->link_ref[$j]["target"];
				$param = $this->link_ref[$j]["param"];
				$val = $this->link_ref[$j]["param_var"];
				$condition = $this->link_ref[$j]["param_condition"];
				if ($this->link_ref[$j]["receiver"] != null) {
					echo "<td width=22 valign=top style=background-color:white>";
					if ($param == null || 
						($condition == "==" && $this->res_list[$i][$param] == $val) || 
						($condition == "!=" && $this->res_list[$i][$param] != $val) || 
						($condition == ">=" && $this->res_list[$i][$param] >= $val) || 
						($condition == "<=" && $this->res_list[$i][$param] <= $val) || 
						($condition == ">" && $this->res_list[$i][$param] > $val) || 
						($condition == "<" && $this->res_list[$i][$param] < $val)) {
						if ($this->link_ref[$j]["popup"] == 1)
							echo "<a href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,menubar=yes,scrollbars=yes')\"><img src=\"" . $this->link_ref[$j]["receiver"] . "\" width=22 height=22 border=0 title=\"" . $this->link_ref[$j]["name"] . "\"></a>";
						else
							echo "<a target=\"$target\" href=\"$url\"><img src=\"" . $this->link_ref[$j]["receiver"] . "\" width=22 height=22 border=0 title=\"" . $this->link_ref[$j]["name"] . "\"></a>";
					}
					echo "</td>\n";
				} else {
					echo "<td valign=top width=" . (strlen($this->link_ref[$j]["name"])*8) . " nowrap>";
					if ($param == null || 
						($condition == "==" && $this->res_list[$i][$param] == $val) || 
						($condition == "!=" && $this->res_list[$i][$param] != $val)) {
						if ($this->link_ref[$j]["popup"] == 1)
							echo "<a href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,menubar=yes,scrollbars=yes')\">[" . $this->link_ref[$j]["name"] . "]</a>";
						else
							echo "<a target=\"$target\" class=\"$this->css_link_general\" href=\"$url\">[" . $this->link_ref[$j]["name"] . "]</a>";
					}
					echo "</td>\n";
				}
			}
			if ($this->add_print == 1) {
				echo "<td class=\"$this->css_print_option\" valign=top>\n";
				$url = $_SERVER["SCRIPT_NAME"] . "?modo=update&step=2&id=" . $this->res_list[$i]["id"] . "&ck_print=1&$params";
				if ($this->add_print_popup == 1)
					echo "<a href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,scrollbars=yes')\"><img src=\"$this->img_dir/$this->img_print\" border=0 title=\"$this->lang_print_label\"></a>\n";
				else
					echo "<a target=\"_blank\" href=\"$url\"><img src=\"$this->img_dir/$this->img_print\" border=0 title=\"$this->lang_print_label\"></a>\n";
				echo "</td>\n";
			} 
			echo "</tr>\n";
			if ($this->ck_repeat_row == 1 &&
				$i < count($this->res_list)-1 &&
				$this->res_list[$i][$this->pk] == $this->res_list[$i+1][$this->pk]) {
				$i++;
				for ($j=$i; $j<count($this->res_list); $j++) {
					if ($this->res_list[$i][$this->pk] == $this->res_list[$j][$this->pk]) {
						echo "<tr id=\"tr$j\" valign=top class=\"$this->css_text\" " . ($this->ck_collapse == 1 ? "style=display:none" : "") . ">\n";
						for ($k=0; $k<count($this->label); $k++) {
							if ($this->label[$k]["repeat"] == 1)
								echo $this->get_list_td($i, $k, $this->label[$k], $this->res_list[$j], 1, $bgcolor, $params, $class);
						}
						echo "</tr>\n";
					} else
						break;
				}
				$i = $j-1;
			} // if ($this->ck_repeat_row == 1) {
		} // for ($i=0; $i<count($this->res_list); $i++) {
		if (is_array($this->label) &&
			count($this->res_list) > 0 && 
			count($this->group_key) == 0) {
			echo "<tr class=\"$this->css_label\">\n";
			$ck_total = 0;
			for ($i=0; $i<count($this->label); $i++) {
				if ($this->label[$i]["mode"] == "NUM") $ck_total = 1;
			}
			if ($ck_total == 1) {
				for ($i=0; $i<count($this->label); $i++) {
					if ($this->label[$i]["mode"] == "NUM" && isset($this->label[$i]["ck_show_total"]))
						echo "<td align=right nowrap>" . /* $this->label[$i]["un"] . " " . */ number_format($this->label[$i]["total"], 2, ",", ".") . "</td>";
					else {
						$c = 0;
						for ($j=$i; $j<count($this->label); $j++) {
							if ($this->label[$j]["mode"] == "NUM" && isset($this->label[$j]["ck_show_total"])) break;
							$c++;
						}
						echo "<td colspan=$c>" . ($i == 0 ? "TOTAL" : "") . "</td>";
						$i = $j-1;
					}
				}
			}
			echo "</tr>\n";
		}
		if ($this->modo == "delete" || $this->modo == "complete" || $this->modo == "updatedelete" || $this->ck_flag_mode == 1) {
			echo "<tr><td colspan=$colspan class=\"$this->css_list_separator\"></td></tr>\n";
			echo "<tr><td colspan=$colspan align=\"$this->button_align\" class=\"$this->css_edit_list\">\n";
			echo "<input type=\"hidden\" name=\"count\" id=\"count\" value=" . count($this->res_list) . ">\n";
			echo "<input type=\"hidden\" name=\"step\" id=\"step\" value=" . ($this->modo == "update" || $this->modo == "report" ? 1 : 2) . ">\n";
			if (($this->modo == "complete" || $this->modo == "updatedelete") && $this->step == 1)
				echo "<input type=\"hidden\" name=\"modo\" id=\"modo\" value=\"delete\">\n";
			else
				echo "<input type=\"hidden\" name=\"modo\" id=\"modo\" value=\"" . $this->modo . "\">\n";
			for ($i=0; $i<count($this->ref); $i++) {
				$field = $this->ref[$i]["field"];
				if ($this->ref[$i]["type"] != "entity" && isset($this->vars[$field])) {
					echo "<input type=\"hidden\" name=$field id=$field value=\"" . $this->vars[$field] . "\">\n";
					if ($this->ref[$i]["type"] == "daterange") {
						echo "<input type=\"hidden\" name=dia_{$field}_ini id=dia_{$field}_ini value=\"" . $this->vars["dia_{$field}_ini"] . "\">\n";
						echo "<input type=\"hidden\" name=mes_{$field}_ini id=mes_{$field}_ini value=\"" . $this->vars["mes_{$field}_ini"] . "\">\n";
						echo "<input type=\"hidden\" name=ano_{$field}_ini id=ano_{$field}_ini value=\"" . $this->vars["ano_{$field}_ini"] . "\">\n";
						echo "<input type=\"hidden\" name=dia_{$field}_fim id=dia_{$field}_fim value=\"" . $this->vars["dia_{$field}_fim"] . "\">\n";
						echo "<input type=\"hidden\" name=mes_{$field}_fim id=mes_{$field}_fim value=\"" . $this->vars["mes_{$field}_fim"] . "\">\n";
						echo "<input type=\"hidden\" name=ano_{$field}_fim id=ano_{$field}_fim value=\"" . $this->vars["ano_{$field}_fim"] . "\">\n";
					}
					if (isset($this->ref[$i]["comment"]) && $this->ref[$i]["comment"] != "") {
						preg_match_all("[name=([A-Za-z0-9_])+]", $this->ref[$i]["comment"], $match);
						for ($j=0; $j<count($match[0]); $j++) {
							$match[0][$j] = str_replace("name=","",$match[0][$j]);
							if (isset($this->vars[$match[0][$j]])) echo "<input type=\"hidden\" name=" . $match[0][$j] . " id=" . $match[0][$j] . " value=\"" . $this->vars[$match[0][$j]] . "\">\n";
						}
					}
				}
			}
			//$this->flag_mode_action
			//if (count($this->flag_mode_ref) > 0) {
				for ($i=0; $i<count($this->flag_mode_ref); $i++) {
					echo $this->flag_mode_ref[$i]["label"].": ";
					echo $this->get_field("form",$this->flag_mode_ref[$i]);
					echo "&nbsp;&nbsp;&nbsp;";
				}
			//}
			echo "<span class=\"$this->css_text\" id=\"botao\">";
			if (count($this->flag_mode_action) == 0)
				echo "<input type=button value=\"$this->lang_button_label\" onclick=ckform_list(this.form) name=ok class=\"$this->css_button\">";
			else {
				for ($i=0; $i<count($this->flag_mode_action); $i++) {
					$str_action = "";
					preg_match_all("[step=([0-9])+]", $this->flag_mode_action[$i]["url"], $match);
					if (count($match[0]) > 0) $str_action .= "step.value='" . str_replace("step=","",$match[0][0]) . "';";
					preg_match_all("[modo=([a-zA-Z0-9_])+]", $this->flag_mode_action[$i]["url"], $match);
					if (count($match[0]) > 0) $str_action .= "modo.value='" . str_replace("modo=","",$match[0][0]) . "';";
					$str_action .= "this.form.action='" . $this->flag_mode_action[$i]["url"] . "';";
					$str_action .= "ck_action$i.value=1;";
					$str_action .= $this->flag_mode_action[$i]["function"];
					echo "<span id=botao><input name=ok type=button value=\"" . $this->flag_mode_action[$i]["label"] . "\" style=width:" . (strlen($this->flag_mode_action[$i]["label"])*10) . " onclick=$str_action class=\"$this->css_button\"></span>\n";
					echo "<input type=\"hidden\" name=\"ck_action$i\" name=\"ck_action$i\" value=\"0\">\n";
				}
			}
			$keys = array_keys($this->vars);
			for ($i=0; $i<count($keys); $i++) {
				if ($keys[$i] != "count" &&
					$keys[$i] != "step" &&
					$keys[$i] != "modo") {
					$ck_add = 1;
					for ($j=0; $j<count($this->flag_mode_ref); $j++) {
						$field = $this->flag_mode_ref[$j]["field"];
						if ($field == substr($keys[$i], 0, strlen($field))) {
							$ck_add = 0;
							break;
						}
					}
					if ($ck_add == 1)
						echo "<input type=\"hidden\" name=\"" . $keys[$i] . "\" value=\"" . $this->vars[$keys[$i]] . "\">\n";
				}
			}
			echo "</span>\n";
			echo "</td></tr>\n";
			echo "</form>\n";
		}
		if ($this->pageby != null && 
			$this->res_tot[0]["total"] > $this->pageby &&
			strpos($this->pageby_pos, "D") !== false) {
			if ($this->modo == "update" ||
				$this->modo == "delete" ||
				$this->modo == "updatedelete" ||
				$this->modo == "complete")
			echo "<tr><td colspan=2 class=\"$this->css_list_separator\"></td></tr>\n";
			echo $this->get_paging($this->res_tot[0]["total"], $colspan);
		}
	}
	private function build_graph_list($colspan) { // incompleta
		for ($i=0; $i<count($this->graph); $i++) {
			$label_ref = array();
			for ($j=0; $j<count($this->graph[$i]["fields"]); $j++) {
				for ($k=0; $k<count($this->label); $k++) {
					if (strtolower($this->get_field_label($this->label[$k]["field"])) == strtolower($this->graph[$i]["fields"][$j])) {
						$label_ref[count($label_ref)] = $this->label[$k];
						break;
					}
				}
			}
			if (count($this->group_key) == 0 &&
				count($label_ref) > 1 &&
				count($this->res_list) > 0) {
				echo "<tr class=\"$this->css_list_title\">\n";
				for ($j=0; $j<count($label_ref); $j++) {
					for ($k=$jni=$j; $k<count($label_ref); $k++) {
						if ($label_ref[$j]["label"] != $label_ref[$k]["label"]) break;
						$j = $k;
					}
					if ($this->list_title_mode == "V") 
						$nowrap = "NOWRAP";
					elseif ($label_ref[$j]["type"]=="checkbox" && $label_ref[$j]["ck_update"]==1) 
						$nowrap = "NOWRAP";
					else
						$nowrap = "";
					echo "<td class=\"$this->css_list_title\" colspan=" . ($k-$jni) . " " . ($this->list_title_mode == "V" ? "style=\"direction:rtl; writing-mode:tb-rl\" align=right" : "valign=top align=".$label_ref[$j]["alignment"]) . " $nowrap>" . ($label_ref[$j]["type"]=="checkbox" && $label_ref[$j]["ck_update"]==1 ? "<input type=checkbox onclick=fn_ckall_flag(this.checked,'".$this->get_field_label($label_ref[$j]["field"])."')> " : "") . $label_ref[$j]["label"] . ($label_ref[$j]["mode"] == "NUM" ? " (".$label_ref[$j]["un"].")" : "") . "</td>";
					//if ($k > $j+1) $j = $k-1;
				}
				if ($this->modo == "complete" || $this->modo == "updatedelete")
					echo "<td>&nbsp;</td>";
				echo "</tr>\n";
			}
			// list loop
			$c = 0;
			for ($j=0; $j<count($this->res_list); $j++) {
				// color
				$bgcolor = "";
				if ($this->ck_active == 1 && $this->res_list[$j]["ativo"] == 0)
					$bgcolor = "FFFFAA";
				else {
					for ($k=0; $k<count($this->color_ref); $k++) {
						$param = $this->color_ref[$k]["param"];
						$val = $this->color_ref[$k]["param_var"];
						$condition = $this->color_ref[$k]["param_condition"];
						if (strpos($param, ".") > 0) $param = substr($param, strpos($param, ".")+1);
						if (strpos($param, "AS ") > 0) $param = substr($param, strpos($param, "AS ")+3);
						if (($condition == "==" && $this->res_list[$j][$param] == $val) || 
							($condition == "!=" && $this->res_list[$j][$param] != $val) || 
							($condition == ">=" && $this->res_list[$j][$param] >= $val) || 
							($condition == "<=" && $this->res_list[$j][$param] <= $val) || 
							($condition == ">" && $this->res_list[$j][$param] > $val) || 
							($condition == "<" && $this->res_list[$j][$param] < $val)) {
							$bgcolor = $this->color_ref[$k]["color"];
						}
					}
				}
				$c++;
				if (isset($this->css_list_even) && $this->css_list_even != "" && $c%2 == 0)
					$class = $this->css_list_even;
				else if (isset($this->css_list_text))
					$class = $this->css_list_text;
				else
					$class = $this->css_text;
				echo "<tr id=\"tr$j\" valign=top class=\"$class\" " . ($this->ck_collapse == 1 || ($this->ck_recursive == 1 && $this->res_list[$j]["level"] != 0) ? "style=display:none" : "") . ">\n";
				$params = "";
				if ($this->modo == "update" || 
					$this->modo == "complete" || 
					$this->modo == "updatedelete" || 
					$this->modo == "report") {
					$keys = array_keys($this->list_param);
					for ($k=0; $k<count($keys); $k++) {
						if (strtoupper($this->list_param[$keys[$k]]) == "GETFROMQRY")
							$val = $this->res_list[$j][$keys[$k]];
						else
							$val = $this->list_param[$keys[$k]];
						$params .= ($params != "" ? "&" : "") . $keys[$k] . "=" . urlencode($val);
					}
					$keys = array_keys($_GET);
					for ($k=0; $k<count($keys); $k++) {
						$ck = 0;
						for ($l=0; $l<count($this->ref_filter); $l++) {
							if ($keys[$k] == $this->ref_filter[$l]["field"]) {
								$ck = 1;
								break;
							}
						}
						if ($ck == 0 && $keys[$k] != "modo" && $keys[$k] != "step")
							$params .= ($params != "" ? "&" : "") . $keys[$k] . "=" . urlencode($_GET[$keys[$k]]);
					}
				}
				// rowspan
				if ($this->ck_repeat_row == 1 &&
					$j < count($this->res_list)-1) {
					$rowspan = 0;
					for ($k=$j; $k<count($this->res_list); $k++) {
						if ($this->res_list[$j][$this->pk] != $this->res_list[$k][$this->pk]) break;
						$rowspan++;
					}
				} else
					$rowspan = 1;
				for ($k=0; $k<count($label_ref); $k++) {
					echo $this->get_list_td($j, $k, $label_ref[$k], $this->res_list[$j], $rowspan, $bgcolor, $params, $class);
				}
				/* for ($k=0; $k<count($this->link_ref); $k++) { // link_ref not added on graph_list
					...
				} */
				echo "</tr>\n";
				if ($this->ck_repeat_row == 1 &&
					$j < count($this->res_list)-1 &&
					$this->res_list[$j][$this->pk] == $this->res_list[$j+1][$this->pk]) {
					$j++;
					for ($k=$j; $k<count($this->res_list); $k++) {
						if ($this->res_list[$j][$this->pk] == $this->res_list[$k][$this->pk]) {
							echo "<tr id=\"tr$k\" valign=top class=\"$this->css_text\" " . ($this->ck_collapse == 1 ? "style=display:none" : "") . ">\n";
							for ($l=0; $l<count($label_ref); $l++) {
								if ($label_ref[$l]["repeat"] == 1)
									echo $this->get_list_td($j, $l, $label_ref[$l], $this->res_list[$k], 1, $bgcolor, $params, $class);
							}
							echo "</tr>\n";
						} else
							break;
					}
					$j = $k-1;
				} // if ($this->ck_repeat_row == 1) {
			} // for ($j=0; $j<count($this->res_list); $j++) {
			if (is_array($label_ref) &&
				count($this->res_list) > 0 && 
				count($this->group_key) == 0) {
				echo "<tr class=\"$this->css_label\">\n";
				$ck_total = 0;
				for ($j=0; $j<count($label_ref); $j++) {
					if ($label_ref[$j]["mode"] == "NUM") $ck_total = 1;
				}
				if ($ck_total == 1) {
					for ($j=0; $j<count($label_ref); $j++) {
						if ($label_ref[$j]["mode"] == "NUM")
							echo "<td align=right nowrap>" . /* $label_ref[$j]["un"] . " " . */ number_format($label_ref[$j]["total"], 2, ",", ".") . "</td>";
						else {
							$c = 0;
							for ($k=$j; $k<count($label_ref); $k++) {
								if ($label_ref[$k]["mode"] == "NUM") break;
								$c++;
							}
							echo "<td colspan=$c>" . ($j == 0 ? "TOTAL" : "") . "</td>";
							$j = $k-1;
						}
					}
				}
				echo "</tr>\n";
			}
		if ($i < count($this->graph)-1)
			echo "<tr><td colspan=$colspan class=\"$this->css_list_separator\"></td></tr>\n";
		}
	}
	private function update_list() {
		$qry_str = "";
		for ($i=0; $i<$this->vars["count"]; $i++) {
			$str_val = array();
			for ($j=0; $j<count($this->label); $j++) {
				if ($this->label[$j]["ck_update"] == 1) {
					$update_key = $this->label[$j]["update_key"];
					if (is_array($update_key)) $update_key = implode(",",$update_key);
					$tbl_val[$update_key] = $this->label[$j]["table"];
					$field = $this->get_field_label($this->label[$j]["field"]);
					$var = "$field$i";
					$var_bak = "{$field}_bak{$i}";
					$val = "";
					if (!isset($str_val[$update_key])) $str_val[$update_key] = "";
					if ($this->label[$j]["type"] == "checkbox") {
						$this->vars[$var] = isset($this->vars[$var])?1:0;
						if ($this->vars[$var] != $this->vars[$var_bak]) {
							$val = $this->vars[$var];
						}
						unset($this->vars[$var]);
						unset($this->vars[$var_bak]);
					} else if ($this->label[$j]["type"] == "date") {
						if (($this->vars["dia_$var"] != $this->vars["dia_$var_bak"]) ||
							($this->vars["mes_$var"] != $this->vars["mes_$var_bak"]) ||
							($this->vars["ano_$var"] != $this->vars["ano_$var_bak"])) {
							$val = $this->get_val($this->label[$j], "", $i);
						}
						unset($this->vars["dia_$var"]);
						unset($this->vars["mes_$var"]);
						unset($this->vars["ano_$var"]);
						unset($this->vars["dia_$var_bak"]);
						unset($this->vars["mes_$var_bak"]);
						unset($this->vars["ano_$var_bak"]);
					} else if ($this->label[$j]["type"] == "datetime") {
						if (($this->vars["dia_$var"] != $this->vars["dia_$var_bak"]) ||
						  	($this->vars["mes_$var"] != $this->vars["mes_$var_bak"]) ||
						  	($this->vars["ano_$var"] != $this->vars["ano_$var_bak"]) ||
						  	($this->vars["hor_$var"] != $this->vars["hor_$var_bak"]) ||
						  	($this->vars["min_$var"] != $this->vars["min_$var_bak"])) {
							$val = $this->get_val($this->label[$j], "", $i);
						}
						unset($this->vars["dia_$var"]);
						unset($this->vars["mes_$var"]);
						unset($this->vars["ano_$var"]);
						unset($this->vars["hor_$var"]);
						unset($this->vars["min_$var"]);
						unset($this->vars["dia_$var_bak"]);
						unset($this->vars["mes_$var_bak"]);
						unset($this->vars["ano_$var_bak"]);
						unset($this->vars["hor_$var_bak"]);
						unset($this->vars["min_$var_bak"]);
					} else if ($this->label[$j]["type"] == "text") {
						if ($this->vars[$var] != $this->vars[$var_bak]) {
							$val = $this->get_val($this->label[$j], "", $i);
						}
						unset($this->vars[$var]);
						unset($this->vars[$var_bak]);
					}
					if (strlen($val) > 0) {
						$str_val[$update_key] .= ($str_val[$update_key] != "" ? "," : "") . "$field = $val";
					}
				}
			}
			$keys = array_keys($str_val);
			for ($j=0; $j<count($keys); $j++) {
				if ($str_val[$keys[$j]] != "") {
					// add xtra_field values
					for ($k=0; $k<count($this->flag_mode_action); $k++) {
						if ($this->vars["ck_action$k"] == 1) {
							for ($l=0; $l<count($this->flag_mode_action[$k]["xtra_field"]); $l++) {
								$field = $this->flag_mode_action[$k]["xtra_field"][$l]["field"];
								$val = $this->flag_mode_action[$k]["xtra_field"][$l]["val"];
								$str_val[$keys[$j]] .= ", $field = $val";
							}
						}
					}
					for ($k=0; $k<count($this->flag_mode_ref); $k++) {
						$field = $this->flag_mode_ref[$k]["field"];
						$val =  $this->get_val($this->flag_mode_ref[$k]);
						$str_val[$keys[$j]] .= ", $field = $val";
					}
					$temp = explode(",", $keys[$j]);
					$str_where = "";
					$str_ins_field = $field;
					$str_ins_val = $val;
					for ($k=0; $k<count($temp); $k++) {
						$str_where .= ($k > 0 ? " AND " : "") . $temp[$k] . " = '" . $this->vars[$temp[$k].$i] . "'";
						$str_ins_field .= ", " . $temp[$k];
						$str_ins_val .= ", '" . $this->vars[$temp[$k].$i] . "'";
					}
					if ($this->db == "MSSQL" && $tbl_val[$keys[$j]] != $this->table && $val == "NULL") {
						$qry = "DELETE FROM " . $tbl_val[$keys[$j]] . "
							WHERE $str_where";
					} else {
						$qry = "UPDATE " . $tbl_val[$keys[$j]] . "
							SET " . $str_val[$keys[$j]] . "
							WHERE $str_where";
					}
					$qry_str .= "$qry;\n";
					if ($this->db == "MSSQL" && $tbl_val[$keys[$j]] != $this->table && $val != "NULL") {
						$qry = "IF (@@ROWCOUNT = 0)
							INSERT INTO " . $tbl_val[$keys[$j]] . " ($str_ins_field)
							VALUES ($str_ins_val)";
						$qry_str .= "$qry;\n";
					}
					if ($this->db == "MYSQL") nc_query($qry);
				}
				$temp = explode(",", $keys[$j]);
				for ($k=0; $k<count($temp); $k++) {
					unset($this->vars[$temp[$k].$i]);
				}
			}
		}
		if ($this->debug == 1) echo "<pre style=text-align:left>$qry_str</pre>";
		if ($qry_str != "" && $this->db == "MSSQL") nc_query($qry_str,"NONQUERY");
	}
	private function get_js() {
		$str = "";
		for ($i=0; $i<count($this->js_ref); $i++) {
			$str .= "<script language=\"JavaScript\" src=\"$this->js_dir/" . $this->js_ref[$i] . (strpos($this->js_ref[$i],"?")?"&":"?") . "rand=" . rand(1,1000) . "\"></script>\n";
		}
		return $str;
	}
	private function get_js_unique() {
		$str  = "function fn_ck_unique(ix,fields) {\n";
		$str .= "	var xmlhttp =  new XMLHttpRequest();\n";
		$str .= "	var url = \"$this->document_name_xml?modo=xml&obj=ck_unique&step=define=1&" . ($this->modo == "update" ? "pk=$this->pk&val=" . $this->vars[$this->pk] . "&" : "") . "fields=\" + fields\n";
		$str .= "	for (var i=0; i<fields.length; i++) {\n";
		$str .= "		if (document.getElementById(fields[i]).type == \"radio\") \n";
		$str .= "			url += \"&\" + fields[i] + \"=\" + fn_get_radio_value(fields[i]) + \"\"\n";
		$str .= "		else\n";
		$str .= "			url += \"&\" + fields[i] + \"=\" + document.getElementById(fields[i]).value + \"\"\n";
		$str .= "	}\n";
		//$str .= "	window.open(url,'_blank');\n";
		$str .= "	xmlhttp.open('POST', url, true);\n";
		$str .= "	xmlhttp.onreadystatechange = function() {\n";
		$str .= "		if (xmlhttp.readyState == 4) {\n";
		$str .= "			var objxml = xmlhttp.responseXML.getElementsByTagName('data');\n";
		$str .= "			var ck = getNodeValue(objxml[0], 'ck');\n";
		$str .= "			document.getElementById(\"ck_unique\"+ix).value = ck;\n";
		$str .= "		}\n";
		$str .= "	}\n";
		$str .= "	xmlhttp.send(null);\n";
		$str .= "}\n";
		return $str;
	}
	private function get_js_unlock() {
		$str  = "function fn_toggle_lock(ix,p,mask) {\n";
		$str .= "	if (document.getElementById(\"mask_\"+ix+p).style.display == 'none') {\n";
		$str .= "		var pat = \"\";\n";
		$str .= "		for (var i=0; i<mask.length; i++) {\n";
		$str .= "			pat += cknum(mask[i]) ? \"[0-9A-Za-z]{\"+mask[i]+\"}\" : mask[i];\n";
		$str .= "		}\n";
		$str .= "		pat = \"^\" + pat + \"$\";\n";
		$str .= "		ER = new RegExp(pat);\n";
		$str .= "		if (document.getElementById(ix+\"_\"+p).value != \"\" && !ER.test(document.getElementById(ix+\"_\"+p).value)) {\n";
		$str .= "			alert(\"O valor no coincide com a mscara.\")\n";
		$str .= "		} else {\n";
		$str .= "			var p_str = 0;\n";
		$str .= "			var c = 0;\n";
		$str .= "			for (var i=0; i<mask.length; i++) {\n";
		$str .= "				if (cknum(mask[i])) {\n";
		$str .= "					document.getElementById(ix+c+p).value = document.getElementById(ix+\"_\"+p).value.substring(p_str, p_str+mask[i]);\n";
		$str .= "					p_str += mask[i];\n";
		$str .= "					c++;\n";
		$str .= "				} else {\n";
		$str .= "					p_str += mask[i].length;\n";
		$str .= "				}\n";
		$str .= "			}\n";
		$str .= "			document.getElementById(ix+\"_\"+p).value = val;\n";
		$str .= "			document.getElementById(\"toggle_\"+ix+p).src = \"$this->img_dir/$this->img_lock\";\n";
		$str .= "			document.getElementById(\"mask_\"+ix+p).style.display = '';\n";
		$str .= "			document.getElementById(\"field_\"+ix+p).style.display = 'none';\n";
		$str .= "			document.getElementById(ix+\"_\"+p).disabled = true;\n";
		$str .= "		} \n";
		$str .= "	} else {\n";
		$str .= "		var val = \"\";\n";
		$str .= "		var c = 0;\n";
		$str .= "		for (var i=0; i<mask.length; i++) {\n";
		$str .= "			if (cknum(mask[i])) {\n";
		$str .= "				val += document.getElementById(ix+c+p).value;\n";
		$str .= "				c++;\n";
		$str .= "			} else if (val != \"\") {\n";
		$str .= "				val += mask[i];\n";
		$str .= "			}\n";
		$str .= "		}\n";
		$str .= "		document.getElementById(ix+\"_\"+p).value = val;\n";
		$str .= "		document.getElementById(\"toggle_\"+ix+p).src = \"$this->img_dir/$this->img_unlock\";\n";
		$str .= "		document.getElementById(\"mask_\"+ix+p).style.display = 'none';\n";
		$str .= "		document.getElementById(\"field_\"+ix+p).style.display = '';\n";
		$str .= "		document.getElementById(ix+\"_\"+p).disabled = false;\n";
		$str .= "	} \n";
		$str .= "}\n";
		return $str;
	}
	private function get_js_ckform($scope, $ref) {
		$function_sufix = ($scope == "list" ? "_list" : "");
		$str  = "function ckform{$function_sufix}(form) {\n";
		for ($i=0; $i<count($this->onsubmit_action); $i++) {
			$str .= "	" . $this->onsubmit_action[$i] . ";\n";
		}
		if ($scope == "form" &&
			count($this->publisher_ref) > 0)
			$str .= "	feedPublisherContent(this.form);\n";
		if ($this->ck_verify_email == 1)
			$str .= "	mail_reg = new RegExp(\"^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]{2,64}(\.[a-z0-9-]{2,64})*\.[a-z]{2,4}\$\");\n";
		$str .= "	msg = \"\";\n";
		for ($i=0; $i<count($this->form_rule); $i++) {
			if ($this->form_rule[$i]["scope"] == $scope) {
				$str .= "	if (" . $this->form_rule[$i]["condition"] . ") \n";
				$str .= "		msg += \"" . $this->form_rule[$i]["msg"] . "\\n\";\n";
			}
		}
		if ($scope == "form" || $scope == "list") {
			// define ref field
			if (count($this->tab_ref) > 0) {
				for ($i=0; $i<count($ref); $i++) {
					if ($ref[$i]["type"] != "entity") {
						if ($this->tab_ref[$ref[$i]["tab_id"]]["table"] != null) $ref[$i]["field"] = $this->tab_ref[$ref[$i]["tab_id"]]["table"] . "_" . $ref[$i]["field"];
						$ref[$i]["label"] .= " (" . $this->tab_ref[$ref[$i]["tab_id"]]["label"] . ")";
					} else {
						for ($j=0; $j<count($ref[$i]["field"]); $j++) {
							if ($this->tab_ref[$ref[$i]["tab_id"]]["table"] != null) $ref[$i]["field"][$j]["field"] = $this->tab_ref[$ref[$i]["tab_id"]]["table"] . "_" . $ref[$i]["field"][$j]["field"];
							$ref[$i]["field"][$j]["label"] .= " (" . $this->tab_ref[$ref[$i]["tab_id"]]["label"] . ")";
						}
					}
				}
			}
			for ($i=0; $i<count($ref); $i++) {
				// check req dependency
				$tab_id = $ref[$i]["tab_id"];
				if (count($ref[$i]["req_dependency"]) > 0) {
					//print_r($ref[$i]["req_dependency"]);
					$str .= "	if (";
					if (count($ref[$i]["req_dependency"]) > 0) {
						for ($k=0; $k<count($ref[$i]["req_dependency"]); $k++) {
							for ($l=0; $l<count($ref); $l++) {
								if ($ref[$i]["req_dependency"][$k] == $ref[$l]["field"] ||
									($ref[$i]["req_dependency"][$k] == "tab" && $ref[$i]["tab_id"] == $ref[$l]["tab_id"])) {
									if ($ref[$l]["type"] == "checkbox") {
										$str .= "form." . $ref[$l]["field"] . ".checked || ";
									} else if ($ref[$l]["type"] == "text" && isset($ref[$l]["mask"])) {
										$c = 0;
										if ($ref[$l]["unlock_mask"] == 1) $str .= "form." . $ref[$l]["field"] . "_.disabled == true && ";
										for ($m=0; $m<count($ref[$l]["mask"]); $m++) {
											if (is_numeric($ref[$l]["mask"][$m])) {
												$str .= "form." . $ref[$l]["field"] . "$c.value != \"\" || ";
												$c++;
											}
										}
									} else if ($ref[$l]["type"] == "radio") {
										$str .= "fn_get_radio_value(\"" . $ref[$l]["field"] . "\") != \"\" || ";
									} else {
										$str .= "form." . $ref[$l]["field"] . ".value != \"\" || ";
									}
								}
							}
						}
					}
					$str .= "1 == 0) { // req dependency\n";
				}
				if ($ref[$i]["type"] == "entity" && $ref[$i]["rel"] == "1XN") {
					for ($j=0; $j<count($this->ent_1XN); $j++) {
						if ($this->ent_1XN[$j] == $i) break;
					}
					$ent_table = $i . $ref[$i]["table"];
					$str .= "	for (var i=0; i<form.count_$ent_table.value; i++) {\n";
					for ($j=0; $j<count($ref[$i]["field"]); $j++) {
						if ($ref[$i]["field"][$j]["type"] != "dbfield" &&
							$ref[$i]["field"][$j]["type"] != "checkbox" && 
							$ref[$i]["field"][$j]["ck_req"] == 1) {
							$ref_entity = $ref[$i]["field"][$j];
							if ($ref_entity["type"] == "text" && isset($ref_entity["mask"])) {
								$str .= "		if (";
								$c = 0;
								if ($ref_entity["unlock_mask"] == 1) $str .= "document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "_\"+i).disabled == true && ";
								$str .= "(";
								for ($k=0; $k<count($ref_entity["mask"]); $k++) {
									if (is_numeric($ref_entity["mask"][$k])) {
										$str .= ($c>0?" || ":"") . "document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "$c\"+i).value.length != " . $ref_entity["mask"][$k];
										$c++;
									}
								}
								$str .= "))\n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " $this->lang_js_format.\\n\";\n";
							} elseif ($ref_entity["type"] == "radio") {
								$str .= "		var ck = 0\n";
								$str .= "		for (var i=0; i<document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i).length; i++) {\n";
								$str .= "			if (document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i)[i].checked == true) \n";
								$str .= "				ck = 1;\n";
								$str .= "		}\n";
								$str .= "		if (ck == 0) \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " $this->lang_js_req.\\n\";\n";
							} elseif ($ref_entity["type"] == "date" || $ref_entity["type"] == "datetime") {
								$str .= "		if (" . ($ref_entity["ck_req"] == 0 ? "(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "\"+i).value != \"\" || document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "\"+i).value != \"\" || document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "\"+i).value != \"\") && " : "") . "!ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "\"+i).value)) \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " " . ($ref_entity["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
							} elseif ($ref_entity["type"] == "daterange") {
								$str .= "		if (" . ($ref_entity["ck_req"] == 0 ? "(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i)\"+i).value != \"\" || document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value != \"\" || document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value != \"\") && " : "") . "(document.getElementById(\"" . $ent_table."_".$ref_entity["field"] . ".checked && (!ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value)))) \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " " . ($ref_entity["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
								$str .= "		if (" . ($ref_entity["ck_req"] == 0 ? "(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i)\"+i).value != \"\" || document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value != \"\" || document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value != \"\") && " : "") . "(document.getElementById(\"" . $ent_table."_".$ref_entity["field"] . ".checked && (!ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value) || !ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value)))) \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " " . ($ref_entity["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
							} elseif ($ref_entity["type"] == "dropdown") {
								$str .= "		if (document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i).value == \"\") \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " $this->lang_js_req.\\n\";\n";
							} else {
								$str .= "		if (document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i).value == \"\") \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $ref_entity["label"] . "\\\" $this->lang_js_line \" + (i+1) + \" de " . $ref[$i]["label"] . " $this->lang_js_req.\\n\";\n";
							}
						}
					}
					$str .= "	}\n";
				} elseif ($ref[$i]["type"] != "entity" && 
					$ref[$i]["type"] != "dbfield" &&
					$ref[$i]["type"] != "checkbox" && 
					$ref[$i]["type"] != "date" && 
					$ref[$i]["type"] != "datetime" && 
					($this->modo == "insert" || $ref[$i]["type"] != "file") &&
					$ref[$i]["ck_req"] == 1) {
					if ($ref[$i]["type"] == "text" && isset($ref[$i]["mask"])) {
						$str .= "	if (";
						$c = 0;
						if ($ref[$i]["unlock_mask"] == 1) $str .= "form." . $ref[$i]["field"] . "_.disabled == true && ";
						$str_req = "";
						$str_len = "";
						$str_fill = "";
						for ($k=0; $k<count($ref[$i]["mask"]); $k++) {
							if (is_numeric($ref[$i]["mask"][$k])) {
								$str_req .= ($c>0 ? " || " : "") . "form." . $ref[$i]["field"] . "$c.value == ''";
								$str_len .= ($c>0 ? " && " : "") . "form." . $ref[$i]["field"] . "$c.value != ''";
								$str_fill .= ($c>0 ? " || ":"") . "form." . $ref[$i]["field"] . "$c.value.length != " . $ref[$i]["mask"][$k];
								$c++;
							}
						}
						if ($ref[$i]["ck_req"] == 1)
							$str .= "($str_req || ($str_len && ($str_fill))))\n";
						else
							$str .= "($str_len && ($str_fill)))\n";
						$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" $this->lang_js_format.\\n\";\n";
					} elseif ($ref[$i]["type"] == "radio") {
						$str .= "	var ck = 0\n";
						$str .= "	for (var i=0; i<form." . $ref[$i]["field"] . ".length; i++) {\n";
						$str .= "	if (form." . $ref[$i]["field"] . "[i].checked == true) \n";
						$str .= "		ck = 1;\n";
						$str .= "	}\n";
						$str .= "	if (ck == 0) \n";
						$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" $this->lang_js_req.\\n\";\n";
						$list = $ref[$i]["list"];
						$keys = array_keys($list);
						for ($k=0; $k<count($keys); $k++) {
							if (is_array($list[$keys[$k]]) && $list[$keys[$k]]["type"] == "dropdown") {
								$str .= "		if (form." . $ref[$i]["field"] . "[$k].checked && form." . $list[$keys[$k]]["field"] . ".selectedIndex == 0) \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $list[$keys[$k]]["label"] . "\\\" $this->lang_js_req.\\n\";\n";
							}
							if (is_array($list[$keys[$k]]) && $list[$keys[$k]]["type"] == "text") {
								$str .= "		if (form." . $ref[$i]["field"] . "[$k].checked && form." . $list[$keys[$k]]["field"] . ".selectedIndex == \"\") \n";
								$str .= "			msg += \"$this->lang_js_field \\\"" . $list[$keys[$k]]["label"] . "\\\" $this->lang_js_req.\\n\";\n";
							}
						}
					} elseif ($ref[$i]["type"] == "dropdown") {
						$str .= "	if (form." . $ref[$i]["field"] . ".value == \"\") \n";
						$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" $this->lang_js_req.\\n\";\n";
					} elseif ($ref[$i]["type"] == "publisher") {
						$str .= "	if (document.getElementById(\"obj" . $ref[$i]["field"] . "\").contentWindow.document.body.innerText) // IE, Safari\n";
						$str .= "		var publisher_text = document.getElementById(\"obj" . $ref[$i]["field"] . "\").contentWindow.document.body.innerText;\n";
						$str .= "	else // Firefox\n";
						$str .= "		var publisher_text = document.getElementById(\"obj" . $ref[$i]["field"] . "\").contentWindow.document.body.textContent;\n";
						$str .= "	if (publisher_text == \"\")\n";
						$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" $this->lang_js_req.\\n\";\n";
					} else {
						$str .= "	if (form." . $ref[$i]["field"] . ".value == \"\") \n";
						$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" $this->lang_js_req.\\n\";\n";
					}
				} elseif ($ref[$i]["type"] == "date" || $ref[$i]["type"] == "datetime") {
					$str .= "	if (" . ($ref[$i]["ck_req"] == 0 ? "(form.dia_" . $ref[$i]["field"] . ".value != \"\" || form.mes_" . $ref[$i]["field"] . ".value != \"\" || form.ano_" . $ref[$i]["field"] . ".value != \"\") && " : "") . "!ckdata(form.dia_" . $ref[$i]["field"] . ".value,form.mes_" . $ref[$i]["field"] . ".value,form.ano_" . $ref[$i]["field"] . ".value)) \n";
					$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" " . ($ref[$i]["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
				} elseif ($ref[$i]["type"] == "daterange") {
					$str .= "	if (" . ($ref[$i]["ck_req"] == 0 ? "(form.dia_" . $ref[$i]["field"] . "_ini.value != \"\" || form.mes_" . $ref[$i]["field"] . "_ini.value != \"\" || form.ano_" . $ref[$i]["field"] . "_ini.value != \"\") && " : "") . "(form." . $ref[$i]["field"] . ".checked && (!ckdata(form.dia_" . $ref[$i]["field"] . "_ini.value,form.mes_" . $ref[$i]["field"] . "_ini.value,form.ano_" . $ref[$i]["field"] . "_ini.value)))) \n";
					$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" " . ($ref[$i]["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
					$str .= "	if (" . ($ref[$i]["ck_req"] == 0 ? "(form.dia_" . $ref[$i]["field"] . "_fim.value != \"\" || form.mes_" . $ref[$i]["field"] . "_fim.value != \"\" || form.ano_" . $ref[$i]["field"] . "_fim.value != \"\") && " : "") . "(form." . $ref[$i]["field"] . ".checked && (!ckdata(form.dia_" . $ref[$i]["field"] . "_ini.value,form.mes_" . $ref[$i]["field"] . "_ini.value,form.ano_" . $ref[$i]["field"] . "_ini.value) || !ckdata(form.dia_" . $ref[$i]["field"] . "_fim.value,form.mes_" . $ref[$i]["field"] . "_fim.value,form.ano_" . $ref[$i]["field"] . "_fim.value)))) \n";
					$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" " . ($ref[$i]["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
				}
				if (count($ref[$i]["req_dependency"]) > 0) {
					$str .= "	}\n";
				}
			} // for ($i=0; $i<count($ref); $i++) {
		} else if ($scope == "filter" && 
			$this->step == 1 && 
			count($ref) > 0) {
			for ($i=0; $i<count($ref); $i++) {
				if ($ref[$i]["type"] == "date" || $ref[$i]["type"] == "datetime") {
					$str .= "	if (" . ($ref[$i]["ck_req"] == 0 ? "(form.dia_" . $ref[$i]["field"] . "_ini.value != \"\" || form.mes_" . $ref[$i]["field"] . "_ini.value != \"\" || form.ano_" . $ref[$i]["field"] . "_ini.value != \"\") && " : "") . "(form." . $ref[$i]["field"] . ".checked && (!ckdata(form.dia_" . $ref[$i]["field"] . "_ini.value,form.mes_" . $ref[$i]["field"] . "_ini.value,form.ano_" . $ref[$i]["field"] . "_ini.value)))) \n";
					$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" " . ($ref[$i]["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
					$str .= "	if (" . ($ref[$i]["ck_req"] == 0 ? "(form.dia_" . $ref[$i]["field"] . "_fim.value != \"\" || form.mes_" . $ref[$i]["field"] . "_fim.value != \"\" || form.ano_" . $ref[$i]["field"] . "_fim.value != \"\") && " : "") . "(form." . $ref[$i]["field"] . ".checked && (!ckdata(form.dia_" . $ref[$i]["field"] . "_ini.value,form.mes_" . $ref[$i]["field"] . "_ini.value,form.ano_" . $ref[$i]["field"] . "_ini.value) || !ckdata(form.dia_" . $ref[$i]["field"] . "_fim.value,form.mes_" . $ref[$i]["field"] . "_fim.value,form.ano_" . $ref[$i]["field"] . "_fim.value)))) \n";
					$str .= "		msg += \"$this->lang_js_field \\\"" . $ref[$i]["label"] . "\\\" " . ($ref[$i]["ck_req"] == 1 ? "$this->lang_js_req," : "") . " $this->lang_js_format.\\n\";\n";
				}
			} // for ($i=0; $i<count($ref); $i++) {
		}
		$str .= "	if (msg != \"\") {\n";
		$str .= "		alert(msg);\n";
		$str .= "	} else {\n";
		$str .= "		Aguarde{$function_sufix}(form);\n";
		$str .= "		form.submit();\n";
		$str .= "	}\n";
		$str .= "}\n";
		$str .= "function Aguarde{$function_sufix}(form){\n";
		$str .= "	form.ok.disabled=true;\n";
		$str .= "	document.getElementById(\"botao\").innerHTML = \"<span class=aguarde>Aguarde ..</span>\";\n";
		$str .= "	return true;\n";
		$str .= "}\n";
		return $str;
	}
	private function get_paging($total, $colspan) {
		if (isset($this->css_page_by))
			$class = $this->css_page_by;
		else
			$class = "spantexto";
		$str  = "<form method=" . $this->pageby_method . ">\n";
		$str .= "<tr><td colspan=$colspan class=$class align=\"$this->pageby_align\" valign=top>";
		$str .= "Pgina <select name=pagina class=formpeq onchange=submit()>\n";
		for ($i=0; $i<ceil($total/$this->pageby); $i++) {
			$str .= "<option " . ($this->vars["pagina"] == $i+1 ? "SELECTED" : "") . " value=" . ($i+1) . ">" . ($i+1) . "\n";
		}
		$str .= "</select> de " . ceil($total/$this->pageby) . "\n";
		$vars = array_merge($this->vars, $_GET);
		$keys = array_keys($vars);
		for ($i=0; $i<count($keys); $i++) {
			if ($keys[$i] != "pagina" &&
				$keys[$i] != "get_session_filter")
				$str .= "<input type=\"hidden\" name=\"" . $keys[$i] . "\" value=\"" . $vars[$keys[$i]] . "\">\n";
		}
		$str .= "</td></tr>\n";
		$str .= "</form>\n";
		return $str;
	}
	private function get_form_button($scope) {
		if ($this->ck_print == 1) {
			$str = "";
			if ($this->use_print_close == 1) $str .= "<span id=\"botao\"><input type=button value=\"$this->lang_close_button_label\" onclick=javascript:self.close() name=ok class=\"$this->css_button\"></span>\n";
			if ($this->use_print_button == 1) $str .= "<span id=\"botao\"><input type=button value=\"$this->lang_print_button_label\" onclick=javascript:self.print() name=ok class=\"$this->css_button\"></span>\n";
			return $str;
		} else {
			if ($scope == "form")
				$str  = "<span id=\"botao\"><input type=button value=\"$this->lang_button_label\" onclick=ckform(this.form) name=ok class=\"$this->css_button\"></span>\n";
			else if ($scope == "filter")
				$str  = "<span id=\"botao\"><input type=button value=\"$this->lang_search_button_label\" onclick=ckform(this.form) name=ok class=\"$this->css_button\"></span>\n";
			if (($this->modo == "update" && $this->step == 1 && count($this->ref_filter) > 0) ||
				($this->modo == "complete" && $this->step == 1 && count($this->ref_filter) > 0) ||
				($this->modo == "report" && $this->step == 1 && count($this->ref_filter) > 0))
				$str .= "<input type=\"hidden\" name=\"step\" id=\"step\" value=\"1\">\n";
			else
				$str .= "<input type=\"hidden\" name=\"step\" id=\"step\" value=\"" . ($this->step+1) . "\">\n";
			for ($i=0; $i<$this->ck_unique; $i++) {
				$str .= "<input type=\"hidden\" name=\"ck_unique$i\" id=\"ck_unique$i\" value=\"0\">\n";
			}
			if ($this->modo == "complete" && $this->step == 1 && $scope == "form")
				$str .= "<input type=\"hidden\" name=\"modo\" id=\"modo\" value=\"insert\">\n";
			elseif ($this->modo == "complete" && $this->step == 2 && $scope == "form")
				$str .= "<input type=\"hidden\" name=\"modo\" id=\"modo\" value=\"update\">\n";
			else
				$str .= "<input type=\"hidden\" name=\"modo\" id=\"modo\" value=\"" . $this->modo . "\">\n";
			if ($this->modo == "update" && 
				$this->step == 2 &&
				isset($this->res_upd)) {
				if (is_array($this->pk)) {
					for ($i=0; $i<count($this->pk); $i++) {
						$str .= "<input type=\"hidden\" name=\"id\" id=\"id\" value=\"" . $this->res_upd[0][$this->pk[$i]] . "\">\n";
					}
				} else {
					$str .= "<input type=\"hidden\" name=\"id\" id=\"id\" value=\"" . $this->res_upd[0]["id"] . "\">\n";
				}
				for ($i=0; $i<count($this->tab_ref); $i++) {
					$table = $this->tab_ref[$i]["table"];
					if ($table != null) $str .= "<input type=\"hidden\" name=\"id_$table\" value=\"" . $this->res_upd[0]["id_$table"] . "\">\n";
				}
			}
			return $str;
		}
	}
	private function get_form_back() {
		$str  = "<span id=\"botao\"><input type=button value=\"$this->lang_back_button_label\" onclick=\"javascript:window.open('" . $_SERVER["HTTP_REFERER"] . (strpos($_SERVER["HTTP_REFERER"], "?") === false ? "?" : "&" . "get_session_filter=1") . "','_self');\" name=ok class=\"$this->css_button\"></span>\n";
		$str .= "<input type=\"hidden\" name=\"pag\" id=\"pag\" value=\"" . $_GET["pag"] . "\">\n";
		return $str;
	}
	private function get_form_close() {
		$str  = "<span id=\"botao\"><input type=button value=\"$this->lang_close_button_label\" onclick=\"javascript:window.close();\" name=ok class=\"$this->css_button\"></span>\n";
		$str .= "<input type=\"hidden\" name=\"pag\" id=\"pag\" value=\"" . $_GET["pag"] . "\">\n";
		return $str;
	}
	private function get_form_print() {
		$str  = "<span id=\"botao\"><input type=button value=\"$this->lang_print_button_label\" onclick=javascript:self.print() name=ok class=\"$this->css_button\"></span>\n";
		$str .= "<input type=\"hidden\" name=\"pag\" id=\"pag\" value=\"" . $_GET["pag"] . "\">\n";
		return $str;
	}
	private function get_list_title($title, $colspan=1, $add_separator=1) {
		if ($this->ck_csv_export == 1) {
			$str  = "<tr><td colspan=$colspan>\n";
			$str .= "<table border=0 cellspacing='0' cellpadding='0'>\n";
			$str .= "<tr>\n";
			$str .= "<td style=\"padding:0\"><table cellpadding=0 cellspacing=0 width=\"" . (isset($this->title_width) ? $this->title_width : $this->form_width) . "\"><tr><td class=\"$this->css_title_pg\">$title</td></tr></table></td>\n";
			$str .= "<td class='update' align=right nowrap><a target=_blank href=\"?modo=csv\" class=\"update\">Salvar relatrio<br>em formato Excel</a></td>\n";
			$str .= "<td align=\"right\" valign=\"middle\"><img src=\"$this->img_dir/excel.gif\" width=\"31\" height=\"30\" border=\"0\" hspace=\"2\"></td>\n";
			$str .= "</tr>\n";
			$str .= "</table>\n";
			$str .= "</td></tr>\n";
		} else 
			$str = "<tr><td colspan=$colspan style=\"padding:0\"><table cellpadding=0 cellspacing=0 width=\"" . (isset($this->title_width) ? $this->title_width : $this->form_width) . "\"><tr><td class=\"$this->css_title_pg\">$title</td></tr></table></td></tr>\n";
		if ($add_separator == 1) 
			$str .= "<tr><td colspan=$colspan class=\"$this->css_list_separator\"></td></tr>\n";
		return $str;
	}
	private function get_val($ref, $prefix=null, $c=null) {
		//if ($_SESSION["user_quality"] == "chico") echo "<pre style=text-align:left>"; print_r($ref); echo "</pre>"; 
		if (count($this->tab_ref) == 0 || 
			!isset($ref["tab_id"]) || 
			$this->tab_ref[$ref["tab_id"]]["table"] == null) {
			$field = $prefix . $this->get_field_label($ref["field"]);
		} else {
			$table = $this->tab_ref[$ref["tab_id"]]["table"];
			$field = $prefix . $table . "_" . $this->get_field_label($ref["field"]);
		}
		if ($ref["type"] == "dbfield" && is_numeric($ref["value"]))
			return $ref["value"];
		elseif ($ref["type"] == "dbfield" && !is_numeric($ref["value"]))
			return "'".$ref["value"]."'";
		elseif ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"]) && !isset($this->vars[$field.$c]))
			return array();
		elseif ($ref["type"] == "dropdown" && !array_key_exists("multiple",$ref["prop"]) && $this->vars[$field.$c] == "")
			return "NULL";
		elseif ($ref["type"] == "checkbox" && isset($this->vars[$field.$c]))
			return 1;
		elseif ($ref["type"] == "checkbox" && !isset($this->vars[$field.$c]))
			return 0;
		elseif ($ref["type"] == "radio" && !isset($this->vars[$field.$c]))
			return "NULL";
		elseif ($ref["type"] == "date" && 
			$this->db == "MSSQL" && 
			$this->vars["dia_".$field.$c] != "" && 
			$this->vars["mes_".$field.$c] != "" && 
			$this->vars["ano_".$field.$c] != "")
			return "CONVERT(datetime, '".$this->vars["ano_".$field.$c]."-".$this->vars["mes_".$field.$c]."-".$this->vars["dia_".$field.$c]." 00:00:00', 120)";
		elseif ($ref["type"] == "datetime" && 
			$this->db == "MSSQL" && 
			$this->vars["dia_".$field.$c] != "" && 
			$this->vars["mes_".$field.$c] != "" && 
			$this->vars["ano_".$field.$c] != "")
			return "CONVERT(datetime, '".$this->vars["ano_".$field.$c]."-".$this->vars["mes_".$field.$c]."-".$this->vars["dia_".$field.$c]." ".$this->vars["hor_".$field.$c].":".$this->vars["min_".$field.$c].":00', 120)";
		elseif ($ref["type"] == "date" && 
			$this->db == "MYSQL" && 
			$this->vars["dia_".$field.$c] != "" && 
			$this->vars["mes_".$field.$c] != "" && 
			$this->vars["ano_".$field.$c] != "")
			return "'".$this->vars["ano_".$field.$c]."-".$this->vars["mes_".$field.$c]."-".$this->vars["dia_".$field.$c]."'";
		elseif ($ref["type"] == "datetime" && 
			$this->db == "MYSQL" && 
			$this->vars["dia_".$field.$c] != "" && 
			$this->vars["mes_".$field.$c] != "" && 
			$this->vars["ano_".$field.$c] != "")
			return "'".$this->vars["ano_".$field.$c]."-".$this->vars["mes_".$field.$c]."-".$this->vars["dia_".$field.$c]." ".$this->vars["hor_".$field.$c].":".$this->vars["min_".$field.$c].":00'";
		elseif (($ref["type"] == "date" || $ref["type"] == "datetime") && ($this->vars["dia_".$field.$c] == "" || $this->vars["mes_".$field.$c] == "" || $this->vars["ano_".$field.$c] == ""))
			return "NULL";
		elseif ($ref["type"] == "daterange" && 
			$this->db == "MSSQL" && 
			$this->vars["dia_".$field."_ini".$c] != "" && 
			$this->vars["mes_".$field."_ini".$c] != "" && 
			$this->vars["ano_".$field."_ini".$c] != "" && 
			$this->vars["dia_".$field."_fim".$c] == "" && 
			$this->vars["mes_".$field."_fim".$c] == "" && 
			$this->vars["ano_".$field."_fim".$c] == "")
			return array(
				"ini" => "CONVERT(datetime, '".$this->vars["ano_".$field."_ini".$c]."-".$this->vars["mes_".$field."_ini".$c]."-".$this->vars["dia_".$field."_ini".$c]." 00:00:00', 120)",
				"fim" => "NULL"
			);
		elseif ($ref["type"] == "daterange" && 
			$this->db == "MYSQL" && 
			$this->vars["dia_".$field."_ini".$c] != "" && 
			$this->vars["mes_".$field."_ini".$c] != "" && 
			$this->vars["ano_".$field."_ini".$c] != "" && 
			$this->vars["dia_".$field."_fim".$c] == "" && 
			$this->vars["mes_".$field."_fim".$c] == "" && 
			$this->vars["ano_".$field."_fim".$c] == "")
			return array(
				"ini" => "'".$this->vars["ano_".$field."_ini".$c]."-".$this->vars["mes_".$field."_ini".$c]."-".$this->vars["dia_".$field."_ini".$c]."'",
				"fim" => "NULL"
			);
		elseif ($ref["type"] == "daterange" && 
			$this->db == "MSSQL" && 
			$this->vars["dia_".$field."_ini".$c] != "" && 
			$this->vars["mes_".$field."_ini".$c] != "" && 
			$this->vars["ano_".$field."_ini".$c] != "" && 
			$this->vars["dia_".$field."_fim".$c] != "" && 
			$this->vars["mes_".$field."_fim".$c] != "" && 
			$this->vars["ano_".$field."_fim".$c] != "")
			return array(
				"ini" => "CONVERT(datetime, '".$this->vars["ano_".$field."_ini".$c]."-".$this->vars["mes_".$field."_ini".$c]."-".$this->vars["dia_".$field."_ini".$c]." 00:00:00', 120)",
				"fim" => "CONVERT(datetime, '".$this->vars["ano_".$field."_fim".$c]."-".$this->vars["mes_".$field."_fim".$c]."-".$this->vars["dia_".$field."_fim".$c]." 00:00:00', 120)"
			);
		elseif ($ref["type"] == "daterange" && 
			$this->db == "MYSQL" && 
			$this->vars["dia_".$field."_ini".$c] != "" && 
			$this->vars["mes_".$field."_ini".$c] != "" && 
			$this->vars["ano_".$field."_ini".$c] != "" && 
			$this->vars["dia_".$field."_fim".$c] != "" && 
			$this->vars["mes_".$field."_fim".$c] != "" && 
			$this->vars["ano_".$field."_fim".$c] != "")
			return array(
				"ini" => "'".$this->vars["ano_".$field."_ini".$c]."-".$this->vars["mes_".$field."_ini".$c]."-".$this->vars["dia_".$field."_ini".$c]."'",
				"fim" => "'".$this->vars["ano_".$field."_fim".$c]."-".$this->vars["mes_".$field."_fim".$c]."-".$this->vars["dia_".$field."_fim".$c]."'"
			);
		elseif ($ref["type"] == "daterange" && 
			($this->vars["dia_".$field."_ini".$c] == "" || 
			 $this->vars["mes_".$field."_ini".$c] == "" || 
			 $this->vars["ano_".$field."_ini".$c] == "" || 
			 $this->vars["dia_".$field."_fim".$c] == "" || 
			 $this->vars["mes_".$field."_fim".$c] == "" || 
			 $this->vars["ano_".$field."_fim".$c] == ""))
			return array("ini" => "NULL", "fim" => "NULL");
		elseif ($ref["type"] == "text" && isset($ref["mask"])) {
			if ($ref["unlock_mask"] == 0 || !isset($this->vars[$field."_".$c])) {
				$str = "";
				$c_mask = 0;
				for ($i=0; $i<count($ref["mask"]); $i++) {
					if ($this->vars[$field.$c_mask.$c] != "") {
						if (is_numeric($ref["mask"][$i])) {
							$str .= str_pad($this->vars[$field.$c_mask.$c], $ref["mask"][$i], '0');
							$c_mask++;
						} else if ($ref["write_mask"] == 1)
							$str .= $ref["mask"][$i];
					}
				}
			} else {
				$str = $this->vars[$field."_".$c];
			}
			if ($str != "") {
				if ($this->db == "MSSQL")
					return "'" . str_replace(array('\"',"\'"), array('"',"''"), $str) . "'";
				elseif ($this->db == "MYSQL" && strpos($str, "\'") === false)
					return "'" . str_replace("'", "\'", $str) . "'";
				elseif ($this->db == "MYSQL" && strpos($str, "\'") !== false)
					return "'" . $str . "'";
			} else
				return "NULL";
		} elseif ($ref["type"] == "file" && $this->files[$field.$c] != "" && $this->files[$field.$c] != "none") {
			if ($this->files[$field.$c]["tmp_name"] != "" && isset($this->vars["id"])) {
				return "'" . $this->add_file($this->vars["id"], $ref) . "'";
			} else if ($this->files[$field.$c]["tmp_name"] != "" && !isset($this->vars["id"])) {
				$qry = "SELECT CASE WHEN MAX($this->pk) IS NOT NULL THEN MAX($this->pk) + 1 ELSE 1 END AS id FROM $this->table";
				$res = nc_query($qry);
				return "'" . $this->add_file($res[0]["id"], $ref) . "'";
			} else
				return "NULL";
			//return "'" . $this->files[$field.$c]["name"] . "'";
		} elseif ($ref["type"] == "dropdown" && 
			isset($ref["qry"]) && 
			$ref["qry"]["ck_new_entry"] == 1 && 
			$this->vars[$field.$c] == "NEW") { // new entry
			$this->ck_redirect = 0;
			$new_entry_table = $ref["qry"]["new_entry_table"];
			$new_entry_field = $ref["qry"]["new_entry_field"];
			$new_entry_url = $ref["qry"]["new_entry_url"];
			$new_entry_pk = $ref["qry"]["new_entry_pk"];
			$qry = "INSERT INTO $new_entry_table ($new_entry_field) VALUES ('" . $this->vars[$field."_entry".$c] . "')";
			if ($this->db == "MSSQL") {
				$qry_str  = "$qry;\n";
				$qry_str .= "SELECT @@identity AS id;\n";
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry_str</pre>";
				$res_new_entry = nc_query($qry_str, "QUERY");
			} elseif ($this->db == "MYSQL") {
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				nc_query($qry);
				$qry = "SELECT MAX($new_entry_pk) AS id FROM $new_entry_table";
				if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
				$res_new_entry = nc_query($qry);
			}
			$this->ck_new_ref[count($this->ck_new_ref)] = array(
				"dir" => $new_entry_table,
				"id" => $res_new_entry[0]["id"],
				"nome" => $this->vars[$field."_entry".$c],
				"url" => str_replace("[id]", $res_new_entry[0]["id"], $new_entry_url)
			); 
			return $res_new_entry[0]["id"];
		} elseif ($ref["type"] == "filteredtext" && $this->vars[$field.$c] == "")
			return "NULL";
		elseif ($ref["type"] == "text" && $this->vars[$field.$c] == "")
			return "NULL";
		elseif ($ref["type"] == "publisher") {
			if ($this->db == "MSSQL")
				return "'" . str_replace(array('\"',"\'"), array('"',"''"), $this->vars["content".$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars["content".$field.$c], "\'") === false)
				return "'" . str_replace("'", "\'", $this->vars["content".$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars["content".$field.$c], "\'") !== false)
				return "'" . $this->vars["content".$field.$c] . "'";
		} elseif ($ref["type"] == "dropdown" && is_array($this->vars[$field.$c])) // multiple
			return $this->vars[$field.$c];
		elseif ($ref["type"] == "dynamiclist")
			return $this->vars["val".$field.$c];
		else {
			if ($this->db == "MSSQL")
				return "'" . str_replace(array('\"',"\'"), array('"',"''"), $this->vars[$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars[$field.$c], "\'") === false)
				return "'" . str_replace("'", "\'", $this->vars[$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars[$field.$c], "\'") !== false)
				return "'" . $this->vars[$field.$c] . "'";
		}
	}
	private function get_ref_query($ref, $res) {
		$sql = $ref["ref_qry"];
		preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
		for ($i=0; $i<count($match[0]); $i++) {
			$sql = str_replace($match[0][$i], $res[substr($match[0][$i],1,-1)], $sql);
		}
		if ($this->debug == 1) $str .= "<pre style=text-align:left>$sql</pre>";
		return $ref["ref_function"]($sql);
	}
	private function get_list_td($i, $j, $label, $val, $rowspan, $bgcolor, $params, $class) {
		$class = ""; // $class reseted to preserve rollover
		// index
		$ix = $this->get_field_label($label["field"]);
		$str = "";
		// td
		if ($label["repeat"] == 1) $rowspan = 1;
		if ($this->modo == "update" || $this->modo == "complete" || $this->modo == "updatedelete") {
			$str .= "<td class=\"$class\" " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " align=" . $label["alignment"] . " " . ($label["nowrap"] == 1 ? "nowrap" : "") . " style=\"" . ($label["ck_update"] == 0 ? "cursor:pointer;":"") . ($bgcolor != "" ? "background-color:$bgcolor;" : "") . ($this->ck_recursive == 1 ? "padding-left:" . ($val["level"]*20) . ";width:100%" : "") . "\" " . ($label["ck_update"] == 0 ? "onclick=window.location=\"$this->document_name_list?$params&modo=update&step=2\" onmouseover=document.getElementById(\"tr$i\").style.color=\"silver\" onmouseout=document.getElementById(\"tr$i\").style.color=\"black\"" : "") . ($j == 0 ? " nowrap" : "") . ">";
			if ($j == 0) $str .= "<img src=\"$this->img_dir/$this->img_bullet\" width=23 height=11 border=0>";
		} else if ($this->modo == "delete") {
			$str .= "<td class=\"$class\" " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " align=" . $label["alignment"] . " " . ($label["nowrap"] == 1 ? "nowrap" : "") . " " . ($bgcolor != "" ? "style=background-color:$bgcolor" : "") . ($this->ck_recursive == 1 ? ";padding-left:" . ($val["level"]*20) : "") . " " . ($j == 0 ? "nowrap" : "") . ">";
			if ($j == 0) $str .= "<input type=checkbox name=id$i value=" . $val["id"] . ">";
		} else if ($this->modo == "report") {
			$str .= "<td class=\"$class\" " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " align=" . $label["alignment"] . " " . ($label["nowrap"] == 1 ? "nowrap" : "") . " " . ($bgcolor != "" ? "style=background-color:$bgcolor" : "") . ($this->ck_recursive == 1 ? ";padding-left:" . ($val["level"]*20) : "") . ">";
		}
		if (isset($label["link"]) &&
			($label["link"]["param"] == null ||
			($label["link"]["param_condition"] == "==" && $val[$label["link"]["param"]] == $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == "!=" && $val[$label["link"]["param"]] != $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == ">=" && $val[$label["link"]["param"]] >= $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == "<=" && $val[$label["link"]["param"]] <= $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == ">" && $val[$label["link"]["param"]] > $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == "<" && $val[$label["link"]["param"]] < $label["link"]["param_var"]))) {
			preg_match_all("[\[([a-zA-Z0-9_.])+\]]", $label["link"]["url"], $match);
			$url = $label["link"]["url"];
			for ($i=0; $i<count($match[0]); $i++) {
				$url = str_replace($match[0][$i], urlencode($val[$this->get_field_label(substr($match[0][$i],1,-1))]), $url);
			}
			if ($label["link"]["popup"] == 1)
				$str .= "<a class=\"$this->css_link_general\" href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,menubar=yes,scrollbars=yes')\">";
			else
				$str .= "<a class=\"$this->css_link_general\" href=\"$url\">";
		}
		if ($label["ck_update"] == 1) {
			$update_key = $label["update_key"];
			//$str .= "<input type=checkbox name={$ix}{$i} value=1 " . ($val[$ix] == 1 ? "CHECKED" : "") . ">\n";
			$str .= $this->get_field("form",$label, $val, "", $i, "formpeq");
			if (isset($label["comment_before"])) $str .= (substr($label["comment_before"], 0, 1) == "[" ? $val[substr($label["comment_before"],1,-1)] : $label["comment_before"]) . "\n";
			if ($label["type"] == "date" || $label["type"] == "datetime") {
				$str .= "<input type=\"hidden\" name=dia_{$ix}_bak{$i} id=dia_{$ix}_bak{$i} value=\"" . $val["dia_$ix"] . "\">\n";
				$str .= "<input type=\"hidden\" name=mes_{$ix}_bak{$i} id=mes_{$ix}_bak{$i} value=\"" . $val["mes_$ix"] . "\">\n";
				$str .= "<input type=\"hidden\" name=ano_{$ix}_bak{$i} id=ano_{$ix}_bak{$i} value=\"" . $val["ano_$ix"] . "\">\n";
				if ($label["type"] == "datetime") {
					$str .= "<input type=\"hidden\" name=hor_{$ix}_bak{$i} id=hor_{$ix}_bak{$i} value=\"" . $val["hor_$ix"] . "\">\n";
					$str .= "<input type=\"hidden\" name=min_{$ix}_bak{$i} id=min_{$ix}_bak{$i} value=\"" . $val["min_$ix"] . "\">\n";
				}
			} else {
				$str .= "<input type=\"hidden\" name={$ix}_bak{$i} id={$ix}_bak{$i} value=\"" . $val[$ix] . "\">\n";
			}
			if (isset($label["comment"])) $str .= (substr($label["comment"], 0, 1) == "[" ? $val[substr($label["comment"],1,-1)] : $label["comment"]) . "\n";
			if (is_array($update_key)) {
				for ($j=0; $j < count($update_key); $j++) {
					$str .= "<input type=\"hidden\" name={$update_key[$j]}{$i} id={$update_key[$j]}{$i} value=\"" . $val[$update_key[$j]] . "\">\n";
				}
			} else
				$str .= "<input type=\"hidden\" name={$update_key}{$i} id={$update_key}{$i} value=\"" . $val[$update_key] . "\">\n";
		} else if ($label["mode"] == "NUM") {
			$str .= /*$label["un"] . " " .*/ number_format($val[$ix], 2, ",", "."); 
			$this->label[$j]["total"] += $val[$ix];
		} else if ($label["mode"] == "NUM") {
			$str .= /*$label["un"] . " " .*/ number_format($val[$ix], 2, ",", "."); 
		} else if ($label["mode"] == "flag" && $label["ck_update"] == 0) {
			$str .= $val[$ix] == 0 ? "" : "X";
		} else {
			$str .= "".nl2br($val[$ix]);
		} 
		if ($label["ck_hidden"] == 1) {
			$str .= "<input type=\"hidden\" name={$ix}{$i} value=\"" . $val[$ix] . "\">\n";
		}
		if (isset($label["link"])) {
			$str .= "</a>";
		}
		$str .= "</td>\n";
		if (($this->modo == "complete" || $this->modo == "updatedelete") && 
			$j == count($this->label) - 1) {
			$str .= "<td  class=\"$class\" " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " align=center " . ($bgcolor != "" ? "style=background-color:$bgcolor" : "") . " nowrap>";
			if (is_array($this->pk)) {
				$pk_str = "";
				for ($k=0; $k<count($this->pk); $k++) {
					$pk_str .= ($k>0 ? "|" : "") . $val[$this->pk[$k]];
				}
			} else {
				$pk_str = $val[$this->pk];
			}
			$str .= "<input type=\"checkbox\" name=\"id$i\" value=\"" . $pk_str . "\" " . ($val["ck_delete"] == 0 ? "DISABLED" : "") . ">$this->lang_title_delete";
			$str .= "</td>\n";
		}
		return $str;
	}
	public function add_qry_default_value($field, $value) {
		$c = count($this->ref); // new index
		$this->ref[$c] = array(
			"type" => "dbfield", 
			"field" => $field, 
			"value" => $value, 
			"ck_qry" => 1, 
			"ck_separator" => 0); 
	}
	private function build_xml() {
		if ($this->vars["obj"] == "filter")
			$ref = $this->ref_filter;
		else
			$ref = $this->ref;
		for ($i=0; $i<count($ref); $i++) {
			if ($ref[$i]["type"] != "entity" &&
				strtolower($ref[$i]["field"]) == strtolower($this->vars["field"])) {
				$ref = $ref[$i];
				break;
			}
			if ($ref[$i]["type"] == "entity") {
				$ck = 0;
				for ($j=0; $j<count($ref[$i]["field"]); $j++) {
					if (strtolower($ref[$i]["field"][$j]["field"]) == strtolower($this->vars["field"])) {
						$ref = $ref[$i]["field"][$j];
						$ck = 1;
					}
					if ($ck == 1) break;
				}
				if ($ck == 1) break;
			}
		}
		//echo "<pre style=text-align:left>"; print_r($ref); echo "</pre>";
		if (isset($this->vars["pchave"])) {
			if (isset($ref["ajaxtable"])) {
				$table = $ref["ajaxtable"];
				$id = $ref["ajaxid"];
				$label = $ref["ajaxlabel"];
				$filter = $ref["ajaxfilter"];
				$condition = "";
				if (is_array($filter)) {
					$condition .= "(\n";
					for ($i=0; $i<count($filter); $i++) {
						if (is_array($filter[$i])) {
							$keys = array_keys($filter[$i]);
							$ix = $keys[0];
						} else {
							$ix = $filter[$i];
						}
						if ($this->vars["ck_$ix"] == 1)
						$condition .= "$ix LIKE '%" . $this->vars["pchave"] . "%' OR\n";
					}
					$condition .= "1=0) AND\n";
				} else {
					$condition .= "$filter LIKE '%" . $this->vars["pchave"] . "%' AND\n";
				}
				//if ($ref["condition"] != "") $condition .= $ref["condition"] . " AND\n";
				$sql = "SELECT DISTINCT
						$table.$id AS id,
						$label AS label
					FROM $table
					WHERE 
						$condition
						1 = 1 
					ORDER BY 
						$label";
				$ref["qry"]["ix"] = "id";
				$ref["qry"]["label"] = "label";
			} elseif (isset($ref["ajaxqry"])) {
				$sql = $ref["ajaxqry"];
				preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
				for ($i=0; $i<count($match[0]); $i++) {
					$sql = str_replace($match[0][$i], $this->vars[substr($match[0][$i],1,-1)], $sql);
				}
				$ref["qry"]["ix"] = $ref["ajaxid"];
				$ref["qry"]["label"] = $ref["ajaxlabel"];
			}
			$function = $ref["ajaxfunction"];
			$res = $function($sql);
		} else if (isset($ref["qry"])) {
			$sql = ereg_replace("\[[a-zA-Z0-9_]+\]", $this->vars["id_ref"], $ref["qry"]["sql"]);
			$function = $ref["ajaxfunction"];
			$res = $function($sql);
		} else if (isset($ref["list"])) {
			$res = array();
			$keys = array_keys($ref["list"]);
			for ($i=0; $i<count($keys); $i++) {
				$res[count($res)] = array(
					"id" => $keys[$i], 
					"label" => $ref["list"][$keys[$i]]
				);
			}
			$ref["qry"]["ix"] = "id";
			$ref["qry"]["label"] = "label";
		}
		//echo "<pre style=text-align:left>$sql</pre>"; 
		header("Content-type: text/xml");
		echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
		echo "<xmlresponse>\n";
		for ($j=0; $j<count($res); $j++) { 
			echo "<data>\n";
			echo "<id>" . $res[$j][$ref["qry"]["ix"]] . "</id>\n";
			echo "<text><![CDATA[" . $res[$j][$ref["qry"]["label"]] . "]]></text>\n";
			echo "</data>\n";
		}
		echo "</xmlresponse>\n";
	}
	private function build_xml_unique() {
		$temp = explode(",", $this->vars["fields"]);
		$str = "";
		for ($i=0; $i<count($temp); $i++) {
			$str .= $temp[$i] . " = '" . $this->vars[$temp[$i]] . "' AND ";
		}
		$qry = "SELECT COUNT(*) AS ck FROM $this->table 
			WHERE
				" . (isset($this->vars["pk"]) ? $this->vars["pk"]  . " <> '" . $this->vars["val"] . "' AND" : "") . "
				$str
				1 = 1";
		$res = nc_query($qry);
		header("Content-type: text/xml");
		echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
		echo "<xmlresponse>\n";
		echo "<data>\n";
		echo "<ck>" . $res[0]["ck"] . "</ck>\n";
		echo "</data>\n";
		echo "</xmlresponse>\n";
	}
	private function build_csv() {
		$join_str = "";
		$where_str = "";
		$field_str = "";
		$order_str = "";
		for ($i=0; $i<count($this->related); $i++) {
			if (strpos($this->related[$i]["use"],"L") !== false) $join_str .= $this->related[$i]["sql"] . "\n";
		}
		for ($i=0; $i<count($this->condition); $i++) {
			$where_str .= $this->condition[$i] . " AND\n";
		}
		for ($i=0; $i<count($this->csv_export_ref); $i++) {
			$field_str .= ($field_str != "" ? "," : "") . $this->csv_export_ref[$i] . "\n";
		}
		for ($i=0; $i<count($this->csv_export_ref); $i++) {
			$order_str .= ($order_str != "" ? "," : "") . $this->get_field_label($this->csv_export_ref[$i]) . "\n";
		}
		$qry = "SELECT DISTINCT
				$field_str
			FROM $this->table
			$join_str
			WHERE
				$where_str
				1 = 1
			ORDER BY
				$order_str";
		if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
		$res = nc_query($qry);
		header("Content-type: application/x-msexcel");
		for ($i=0; $i<count($this->csv_export_ref); $i++) {
			echo ($i>0 ? "\t" : "") . $this->get_field_label($this->csv_export_ref[$i]);
		}
		echo "\r\n";
		for ($i=0; $i<count($res); $i++) {
			for ($j=0; $j<count($this->csv_export_ref); $j++) {
				echo ($j>0 ? "\t" : "") . "\"" . $res[$i][$this->get_field_label($this->csv_export_ref[$j])] . "\"";
			}
			echo "\r\n";
		}
	}
	public function use_multiple_insert($num) {
		if (is_numeric($num))
			$this->repeat_insert = $num;
	}
	private function insert($use_table=null, $ck_confirm=1) {
		$str_field = array($this->table => "");
		$str_val = array($this->table => "");
		$ck_insert = array($this->table => 1);
		$qry_multiple = "";
		for ($i=0; $i<count($this->ref); $i++) {
			if (isset($this->ref[$i]["table"]) && 
				$this->ref[$i]["table"] != null && 
				$this->ref[$i]["type"] != "dynamiclist") {
				$table = $this->ref[$i]["table"];
			} else if (count($this->tab_ref) == 0 || $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] == null) {
				$table = $this->table;
			} else {
				$table = $this->tab_ref[$this->ref[$i]["tab_id"]]["table"];
			}
			if (!isset($ck_insert[$table])) $ck_insert[$table] = 0;
			if (!isset($str_field[$table])) {
				$str_field[$table] = "";
				$str_val[$table] = "";
			}
			$type = $this->ref[$i]["type"];
			if ($type != "entity" &&
				$type != "display" &&
				$this->ref[$i]["ck_qry"] == 1) {
				$field = $this->ref[$i]["field"];
				$val = $this->get_val($this->ref[$i]);
				if (!is_array($val) &&
					$val != "NULL" &&
					trim($val) != "''" &&
					trim($val) != "'&nbsp;'" &&
					$type != "checkbox") 
					$ck_insert[$table] = 1;
				if ($type == "daterange") {
					$str_field[$table] .= ($str_field != "" ? "," : "") . "{$field}_ini, {$field}_fim";
					$str_val[$table] .= ($str_val != "" ? "," : "") . $val["ini"] . "," . $val["fim"];
				} else if ($type == "dropdown" && array_key_exists("multiple",$this->ref[$i]["prop"])) {
					for ($j=0; $j<count($val); $j++) {
						$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " (" . $this->ref[$i]["key_field"] . ", $field) VALUES ('[pk]', '" . $val[$j] . "');\n";
					}
				} else if ($type == "dynamiclist") {
					$keys = array_keys($this->ref[$i]["xtra_key"]);
					$str_xtra_field = "";
					$str_xtra_val = "";
					for ($j=0; $j<count($keys); $j++) {
						$str_xtra_field .= $keys[$j] . ",";
						$str_xtra_val .= "'" . $this->ref[$i]["xtra_key"][$keys[$j]] . "',";
					}
					$keys = explode(";",$val);
					for ($j=0; $j<count($keys); $j++) {
						$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " ($str_xtra_field " . $this->ref[$i]["key_field"] . ", $field) VALUES ($str_xtra_val '[pk]', '" . $keys[$j] . "');\n";
					}
				} else {
					$str_field[$table] .= ($str_field[$table] != "" ? "," : "") . $field;
					$str_val[$table] .= ($str_val[$table] != "" ? "," : "") . $val;
				}
				$val = str_replace("'","",$val);
				if ($type == "radio" && 
					isset($this->ref[$i]["list"][$val]) && 
					is_array($this->ref[$i]["list"][$val]) && 
					isset($this->ref[$i]["list"][$val]["ck_xtra"]) && 
					$this->ref[$i]["list"][$val]["type"] != null) {
					$field = $this->ref[$i]["list"][$val]["field"];
					$val = $this->get_val($this->ref[$i]["list"][$val]);
					$str_field[$table] .= ($str_field[$table] != "" ? "," : "") . $field;
					$str_val[$table] .= ($str_val[$table] != "" ? "," : "") . $val;
				}
			}
			if ($type == "file" &&
				$this->ref[$i]["ck_qry"] == 0) 
				$this->get_val($this->ref[$i]);
		} // for
		$keys = array_keys($str_field);
		for ($i=0; $i<count($keys); $i++) {
			if (($use_table == null || $use_table == $keys[$i]) &&
				($keys[$i] == $this->table || $ck_insert[$keys[$i]] == 1)) {
				if ($keys[$i] != $this->table) {
					$ck_tab = 0;
					for ($j=0; $j<count($this->tab_ref); $j++) {
						if ($this->tab_ref[$j]["table"] == $keys[$i]) {
							$ck_tab = 1;
							break;
						}
					}
					if ($ck_tab == 1) {
						$str_field[$keys[$i]] .= ", " . $this->tab_ref[$j]["key"];
						$str_val[$keys[$i]] .= "," . $this->id;
					} else {
						$ck_ref = 0;
						for ($j=0; $j<count($this->ref); $j++) {
							if (isset($this->ref[$j]["table"]) && $this->ref[$j]["table"] == $keys[$i]) {
								$ck_ref = 1;
								break;
							}
						}
						if ($ck_ref == 1) {
							$str_field[$keys[$i]] .= ", " . $this->ref[$j]["key_field"];
							$str_val[$keys[$i]] .= "," . $this->id;
							$xtra_key = $this->ref[$j]["xtra_key"];
							$xtra_keys = array_keys($xtra_key);
							for ($j=0; $j<count($xtra_keys); $j++) {
								if (substr($xtra_key[$xtra_keys[$j]],0,6) != "SELECT") {
									$str_field[$keys[$i]] .= "," . $xtra_keys[$j];
									$str_val[$keys[$i]] .= ",'" . $xtra_key[$xtra_keys[$j]].",";
								}
							}
						} 
					}
				}
				$qry = "INSERT INTO " . $keys[$i] . " (" . $str_field[$keys[$i]] . ") VALUES (" . $str_val[$keys[$i]] . ")";
				if ($keys[$i] == $this->table &&
					(($this->ck_return_pk == 1 && $this->ck_return_entity == "default") ||
					 $this->redirect_str != null || 
					 count($this->ent_1XN) > 0 || 
					 count($this->ent_NXN) > 0 ||
					 $qry_multiple != "")) {
					if ($this->db == "MSSQL") {
						$qry_str = "$qry;\n";
						$qry = "SELECT @@identity AS id";
						$qry_str .= "$qry;\n";
						if ($this->debug == 1) echo "<pre style=text-align:left>$qry_str</pre>";
						$res = nc_query($qry_str, "QUERY");
					} else if ($this->db == "MYSQL") {
						if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
						nc_query($qry);
						$qry = "SELECT MAX($this->pk) AS id FROM $this->table";
						if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
						$res = nc_query($qry);
					}
					$this->id = $res[0]["id"];
					$this->return_pk .= ($this->return_pk != "" ? "," : "") . $res[0]["id"];
				} else if ($str_field[$keys[$i]] != "") {
					if ($this->debug == 1) echo "<pre style=text-align:left>$qry</pre>";
					nc_query($qry);
				}
			} // if
		} // for
		if ($this->debug == 1) echo "<pre style=text-align:left>" . str_replace("[pk]", $this->id, $qry_multiple) . "</pre>\n";
		if ($qry_multiple != "") {
			if ($this->db == "MSSQL") {
				nc_query(str_replace("[pk]", $this->id, $qry_multiple),"NONQUERY");
			} elseif ($this->db == "MYSQL") {
				$temp = explode(";", $qry_multiple);
				for ($i=0; $i<count($temp); $i++) { 
					if (trim($temp[$i]) != "") nc_query(str_replace("[pk]", $this->id, $temp[$i]));
				}
			}
		}
		if (count($this->ent_1XN) > 0 || 
			count($this->ent_NXN) > 0) {
			$this->update_entity();
		}
		if ($ck_confirm == 1)
			$this->build_confirm();
	}
	private function update() {
		if (isset($this->vars["id"])) $this->id = $this->return_pk = $this->vars["id"];
		$str_val = array($this->table => "");
		$qry_multiple = "";
		for ($i=0; $i<count($this->ref); $i++) {
			if (isset($this->ref[$i]["table"]) && $this->ref[$i]["table"] != null) {
				$table = $this->ref[$i]["table"];
				$key = $this->ref[$i]["key_field"];
				$xtra_key = $this->ref[$i]["xtra_key"];
				$join_str[$table] = "INNER JOIN $this->table ON $table.$key = $this->table.$this->pk";
				if (is_array($xtra_key)) {
					$keys = array_keys($xtra_key);
					for ($j=0; $j<count($keys); $j++) {
						if (substr($xtra_key[$keys[$j]],0,6) == "SELECT")
							$join_str[$table] .= " AND $table." . $keys[$j] . " IN (" . $xtra_key[$keys[$j]] . ")";
						else
							$join_str[$table] .= " AND $table." . $keys[$j] . " = '" . $xtra_key[$keys[$j]] . "'";
					}
				}
			} elseif (count($this->tab_ref) == 0 || $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] == null) {
				$table = $this->table;
			} else {
				$table = $this->tab_ref[$this->ref[$i]["tab_id"]]["table"];
				$key = $this->tab_ref[$this->ref[$i]["tab_id"]]["key"];
				$join_str[$table] = "INNER JOIN $this->table ON $table.$key = $this->table.$this->pk";
			}
			if (!isset($str_val[$table])) {
				$str_val[$table] = "";
			}
			if ($this->ref[$i]["type"] != "entity" &&
				$this->ref[$i]["type"] != "display" &&
				$this->ref[$i]["ck_qry"] == 1) {
				if ($this->ref[$i]["type"] != "entity")
					$val = $this->get_val($this->ref[$i]);
				if ($this->ref[$i]["type"] == "radio" && 
					isset($this->ref[$i]["list"][$val]) && 
					$this->ref[$i]["list"][$val]["type"] != null) {
					$field = $this->ref[$i]["list"][$val]["field"];
					$val = $this->get_val($this->ref[$i]["list"][$val]);
					$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . "$table.$field = $val";
				} else if ($this->ref[$i]["type"] != "file" ||
					$this->files[$this->ref[$i]["field"]]["name"] != "") {
					$field = $this->ref[$i]["field"];
					if ($this->ref[$i]["type"] == "daterange") {
						$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . "{$field}_ini = " . $val["ini"] . ", {$field}_fim = " . $val["fim"];
					} else if ($this->ref[$i]["type"] == "dropdown" && array_key_exists("multiple",$this->ref[$i]["prop"])) {
						$qry_multiple .= "DELETE FROM " . $this->ref[$i]["table"] . " WHERE " . $this->ref[$i]["key_field"] . " = '" . $this->vars["id"] . "';\n";
						$xtra_key = "";
						$xtra_key_vals = "";
						$keys = array_keys($this->ref[$i]["xtra_key"]);
						for ($j=0; $j<count($keys); $j++) {
							$xtra_key .= $keys[$j] . ",";
							$xtra_key_vals .= "'" . $this->ref[$i]["xtra_key"][$keys[$j]] . "',";
						}
						for ($j=0; $j<count($val); $j++) {
							$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " ($xtra_key " . $this->ref[$i]["key_field"] . ", $field) VALUES ($xtra_key_vals '" . $this->vars["id"] . "', '" . $val[$j] . "');\n";
						}
					} else if ($this->ref[$i]["type"] == "dynamiclist") {
						$keys = array_keys($this->ref[$i]["xtra_key"]);
						$str_xtra_keys = "";
						$str_xtra_field = "";
						$str_xtra_val = "";
						for ($j=0; $j<count($keys); $j++) {
							$str_xtra_keys .= $keys[$j] . " = '" . $this->ref[$i]["xtra_key"][$keys[$j]] . "' AND\n";
							$str_xtra_field .= $keys[$j] . ",";
							$str_xtra_val .= "'" . $this->ref[$i]["xtra_key"][$keys[$j]] . "',";
						}
						$qry_multiple .= "DELETE FROM " . $this->ref[$i]["table"] . " WHERE $str_xtra_keys " . $this->ref[$i]["key_field"] . " = '" . $this->vars["id"] . "';\n";
						$keys = explode(";",$val);
						for ($j=0; $j<count($keys); $j++) {
							$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " ($str_xtra_field " . $this->ref[$i]["key_field"] . ", $field) VALUES ($str_xtra_val '" . $this->vars["id"] . "', '" . $keys[$j] . "');\n";
						}
					} else if ($this->ref[$i]["type"] != "password" || $val != "''") {
						$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . "$table.$field = $val";
					}
					if ($this->ref[$i]["type"] == "radio" && 
						isset($this->ref[$i]["list"])) {
						$keys = array_keys($this->ref[$i]["list"]);
						for ($j=0; $j<count($keys); $j++) {
							if (is_array($this->ref[$i]["list"][$keys[$j]])) {
								$val = $this->get_val($this->ref[$i]["list"][$keys[$j]]);
								$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . $this->ref[$i]["list"][$keys[$j]]["field"] . " = $val";
							}
						}
					}
				}
			}
			if ($this->ref[$i]["type"] == "file" && 
				isset($this->vars["remove" . $this->ref[$i]["field"]])) {
				for ($j=0; $j<count($this->ref[$i]["file"]); $j++) {
					//$file = $this->ref[$i]["file"][$j]["dir"]["O"] . "/" . $this->get_file_name($this->ref[$i]["file_name_mask"], $this->vars["id"]);
					$file = $this->ref[$i]["file"][$j]["dir"]["O"] . "/" . $this->vars["remove" . $this->ref[$i]["field"]];
					@unlink($file);
				}
				if ($this->ref[$i]["ck_qry"] == 1) {
					$field = $this->ref[$i]["field"];
					$str_val[$table] .= ($str_val[$table] != "" ? "," : "") . "$field = NULL";
				}
			}
			if ($this->ref[$i]["type"] == "file" &&
				$this->ref[$i]["ck_qry"] == 0) 
				$this->get_val($this->ref[$i]);
		}
		// multiple tables
		$keys = array_keys($str_val);
		$qry_str = "";
		for ($i=0; $i<count($keys); $i++) {
			$table = $keys[$i];
			if ($str_val[$table] != "") {
				$where_str = "";
				if (is_array($this->pk)) {
					$pks = explode("|", $this->vars["id"]);
					for ($j=0; $j<count($this->pk); $j++) {
						$where_str .= ($j>0 ? " AND " : "") . "$this->table." . $this->pk[$j] . " = '" . $pks[$j] . "'";
					}
				} else {
					$where_str .= "$this->table.$this->pk = '" . $this->vars["id"] . "'";
				}
				if ($table == $this->table) {
					$qry = "UPDATE $table
						SET " . $str_val[$table] . "
						WHERE $where_str\n";
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
				} else {
					$qry = "SELECT COUNT(*) AS c FROM $table 
						" . $join_str[$table] . "
						WHERE $where_str";
					$res = nc_query($qry);
					if ($res[0]["c"] == 0) 
						$this->insert($table,0);
					else {
						if ($this->db == "MSSQL") {
							$qry = "UPDATE $table
								SET " . $str_val[$table] . "
								FROM $table
								" . $join_str[$table] . "
								WHERE $where_str\n";
						} elseif ($this->db == "MYSQL") {
							$qry = "UPDATE $table
								" . $join_str[$table] . "
								SET " . $str_val[$table] . "
								WHERE $where_str\n";
						}
						$qry_str .= "$qry;\n";
						if ($this->db == "MYSQL") nc_query($qry);
					}
				}
			}
		}
		if ($qry_multiple != "") {
			$qry_str .= "$qry_multiple";
			if ($this->db == "MYSQL") {
				$temp = explode(";", $qry_multiple);
				for ($j=0; $j<count($temp); $j++) { 
					if (trim($temp[$j]) != "") nc_query($temp[$j]);
				}
			}
		}
		if ($this->debug == 1) echo "<pre style=text-align:left>$qry_str</pre>";
		if ($qry_str != "" && $this->db == "MSSQL") nc_query($qry_str,"NONQUERY");
		if (count($this->ent_1XN) > 0 || 
			count($this->ent_NXN) > 0) {
			$this->update_entity();
		}
		$this->build_confirm();
	}
	private function delete() {
		$list_id = "";
		for ($i=0; $i<$this->vars["count"]; $i++) {
			if (isset($this->vars["id$i"]))
				$list_id .= ($list_id != "" ? "," : "") . "'" . $this->vars["id$i"] . "'";
		}
		if ($list_id != "") {
			$qry_str = "";
			$where_str = "";
			for ($i=0; $i<count($this->delete_cascade); $i++) {
				$qry = "DELETE FROM " . $this->delete_cascade[$i]["table"] . " WHERE " . $this->delete_cascade[$i]["ix"] . " IN ($list_id)";
				$qry_str .= "$qry;\n";
				if ($this->db == "MYSQL") nc_query($qry);
			}
			if (is_array($this->pk)) {
				$primero = true;
				$where_str = "(";
				for ($i=0; $i<$this->vars["count"]; $i++) {
					if (isset($this->vars["id$i"])) {
						if ($primero) {
							$primero = false;
							$where_str .= "(";
						} else {
							$where_str .= " OR (";
						}
						$result = explode("|", $this->vars["id$i"]);
						for ($j=0; $j<count($this->pk); $j++) {
							$where_str .= ($j>0 ? " AND " : "") . $this->pk[$j] . " = '" . $result[$j] . "'";
						}
						$where_str .= ")";
					}
				}
				$where_str .= ")";
			} else {
				$where_str .= $this->pk." IN (".$list_id.")";
			}
			$qry = "DELETE FROM $this->table WHERE $where_str";
			$qry_str .= "$qry;\n";			
			if ($this->db == "MYSQL") nc_query($qry);
			if ($this->debug == 1) echo "<pre style=text-align:left>$qry_str</pre>";
			if ($qry_str != "" && $this->db == "MSSQL") nc_query($qry_str,"NONQUERY");
		}
		$this->build_confirm();
	}
	public function add_file($id, $ref, $prefix=null, $c=null) {
		if ($this->use_sysdoc == 1) $sysdoc = new cls_sysdoc;
		$field = $prefix . $ref["field"] . $c;
		// files
		for ($i=0; $i<count($ref["file"]); $i++) {
			$file_name = $this->get_file_name($ref["file_name_mask"], $id);
			if ($ref["file"][$i]["maxsize"] == false) {
				// use original extension
				$temp = explode(".", $file_name);
				if (count($temp) > 1) $file_name = substr($file_name, 0, -strlen($temp[count($temp)-1])-1);
				$temp = explode(".", $this->files[$field]["name"]);
				$ext = $temp[count($temp)-1];
				$file_name .= ".$ext";
				// define original file
				$destino_original_file = $ref["file"][$i]["dir"]["D"];
				$original_file = $file_name;
				copy($this->files[$field]["tmp_name"], "$destino_original_file\\$original_file");
			}
		}
		for ($i=0; $i<count($ref["file"]); $i++) {
			$file_name = $this->get_file_name($ref["file_name_mask"], $id);
			if ($ref["file"][$i]["maxsize"] != false) {
				if ($this->use_sysdoc == 1 && $sysdoc->fn_ckpdf("$destino_original_file\\$original_file")) 
					$sysdoc->fn_convertpdf2jpg("$destino_original_file\\$original_file", $ref["file"][$i]["dir"]["D"]."\\" . str_replace(".pdf","",$original_file), $ref["file"][$i]["maxsize"], $ck_origem="abs", $ck_destino="abs"); 
				else {
					$dst_img = $this->image_resize($this->files[$field]["tmp_name"], $ref["file"][$i]["maxsize"]);
					if ($dst_img == false) {
						echo "<span class=\"$this->css_text\" style=background-color:white;padding:0><br>$this->lang_file_format: <b>" . $this->files[$field]["name"] . "</b>.<br>$this->lang_file_format_types</span>";
						$this->debug = 1;
					} else {
						if (substr($file_name, -4) == ".jpg") {
							ImageJpeg($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name", 100);
						} elseif (substr($file_name, -4) == ".gif") {
							ImageGif($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
						} else {
							$size = GetImageSize($this->files[$field]["tmp_name"]);
							if ($size[2] == 1) {
								$file_name .= ".gif";
								ImageGif($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
							} else if ($size[2] == 2) {
								$file_name .= ".jpg";
								ImageJpeg($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name", 100);
							} else if ($size[2] == 3) {
								$file_name .= ".png";
								ImagePng($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
							}
						}
						// thumb
						// $dst_img = $this->image_resize($this->files[$field]["tmp_name"], $ref["file"][$i]["maxsize"]);
						// ImageJpeg($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name", 100);
					}
				}
			} 
		}
		if (isset($original_file))
			return $original_file;
		else
			return $file_name;
	}
	private function image_resize($imgname, $maxsize, $pos=null) {
		$size = GetImageSize($imgname);
		if ($size[2] == 1) $src_img=ImageCreatefromGif($imgname); 
		else if ($size[2] == 2) $src_img=ImageCreatefromJpeg($imgname); 
		else if ($size[2] == 3) $src_img=ImageCreatefromPng($imgname); 
		else {
			return false;
		}
		$w = $size[0];
		$h = $size[1];
		$new_w = round($pos == "H" || ($w >  $h) ? $maxsize : ($w*$maxsize)/$h);
		$new_h = round($pos == "V" || ($h >= $w) ? $maxsize : ($h*$maxsize)/$w);
		$dst_img=ImageCreatetruecolor($new_w, $new_h); 
		//imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $new_w, $new_h, $w, $h);
		imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $new_w, $new_h, $w, $h);
		return $dst_img;
	}
	private function update_entity() {
		$qry_str = "";
		if ($this->db == "MSSQL") {
			$qry = "DECLARE @id_entity int";
			$qry_str .= "$qry;\n";
		}
		for ($i=0; $i<count($this->ent_1XN); $i++) {
			$p = $this->ent_1XN[$i];
			$tab_id = $this->ref[$p]["tab_id"];
			$ent_table = $this->ref[$p]["table"];
			$ent_table_ref = $p . $ent_table;
			$key_field = $this->ref[$p]["key_field"];
			$pk = $this->ref[$p]["pk"];
			if (is_array($key_field)) {
				$key_field_val = $key_field[1];
				$key_field = $key_field[0];
			} else if (count($this->tab_ref) > 0 && $this->tab_ref[$tab_id]["table"] != null && $this->modo == "update") {
				$key_field_val = $this->vars["id_" . $this->tab_ref[$tab_id]["table"]];
			//} else if ($this->db == "MSSQL") {
			//	$key_field_val = "@id_entity";
			} else if (isset($this->id)) {
				$key_field_val = $this->id;
			} else {
				$key_field_val = "";
			}
			$list_id = $this->vars["delete_list_".$ent_table_ref];
			if ($list_id != "" && $key_field_val != "") {
				$keys = array_keys($this->ref[$p]["xtra_key"]);
				$str_xtra_keys = "";
				for ($j=0; $j<count($keys); $j++) {
					$str_xtra_keys .= $keys[$j] . " = '" . $this->ref[$p]["xtra_key"][$keys[$j]] . "' AND\n";
				}
				for ($j=0; $j<count($this->ref[$p]["field"]); $j++) {
					$ref = $this->ref[$p]["field"][$j];
					if ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"])) {
						$qry = "DELETE FROM " . $ref["table"] . "
								WHERE
									" . $ref["key_field"] . " IN ($list_id)";
						$qry_str .= "$qry;\n";
						if ($this->db == "MYSQL") nc_query($qry);
					}
				}
				$qry = "DELETE FROM $ent_table
						WHERE
							$str_xtra_keys
							$key_field = $key_field_val AND
							$pk IN ($list_id)";
				$qry_str .= "$qry;\n"; // 
				if ($this->db == "MYSQL") nc_query($qry);
			}
			if ($this->ck_return_pk == 1 && $this->ck_return_entity == $ent_table) {
				if ($this->db == "MSSQL") {
					$qry = "DECLARE @str varchar(1000)";
					$qry_str .= "$qry;\n";
				}
			}
			for ($j=0; $j<$this->vars["count_".$ent_table_ref]; $j++) {
				$qry_multiple = "";
				if ($this->vars["id_$ent_table_ref$j"] == "0") {
					$str_field = $key_field;
					$str_val = $key_field_val;
					for ($k=0; $k<count($this->ref[$p]["field"]); $k++) {
						$ref = $this->ref[$p]["field"][$k];
						$field = $ref["field"];
						if ($this->ref[$p]["field"][$k]["type"] == "file") {
							if (!isset($maxid[$ref["field"]])) {
								$qry = "SELECT MAX(id) AS id FROM " . $this->ref[$p]["table"];
								$res_max = nc_query($qry);
								$maxid[$ref["field"]] = $res_max[0]["id"] + 1;
							} else {
								$maxid[$ref["field"]]++;
							}
							if ($this->files[$ent_table_ref."_".$ref["field"].$j]["tmp_name"] != "")
								$val = "'" . $this->add_file($maxid[$ref["field"]], $ref, $ent_table_ref."_", $j) . "'";
							else
								$val = "NULL";
						} else
							$val = $this->get_val($ref, $ent_table_ref."_", $j);
						if ($ref["type"] == "daterange") {
							$str_field .= ",\n{$field}_ini,\n{$field}_fim";
							$str_val .= ",\n" . $val["ini"] . ",\n" . $val["fim"];
						} else if ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"])) {
							if ($this->db == "MSSQL") 
								$qry_multiple .= "SELECT @id_entity = @@identity;\n";
							for ($l=0; $l<count($val); $l++) {
								$qry_multiple .= "INSERT INTO " . $ref["table"] . " (" . $ref["key_field"] . ", $field) VALUES (@id_entity, '" . $val[$l] . "');\n";
							}
						} else if ($ref["type"] != "dropdown" || !array_key_exists("multiple",$ref["prop"])) {
							$str_field .= ",\n" . $field;
							$str_val .= ",\n" . $val;
						}
					}
					$keys = array_keys($this->ref[$p]["xtra_key"]);
					$str_xtra_field = "";
					$str_xtra_val = "";
					for ($k=0; $k<count($keys); $k++) {
						$str_xtra_field .= $keys[$k] . ",";
						$str_xtra_val .= "'". $this->ref[$p]["xtra_key"][$keys[$k]] . "',";
					}
					$qry = "INSERT INTO $ent_table ($str_xtra_field $str_field) VALUES ($str_xtra_val $str_val)";
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
					if ($qry_multiple != "") {
						if ($this->db == "MSSQL") {
							$qry_str .= "$qry_multiple";
						} elseif ($this->db == "MYSQL") {
							$qry = "SELECT MAX(id) AS id FROM $ent_table";
							$res_max = nc_query($qry);
							$temp = explode(";", $qry_multiple);
							for ($k=0; $k<count($temp); $k++) { 
								if (trim($temp[$k]) != "") nc_query(str_replace("@id_entity", $res_max[0]["id"], $temp[$k]));
							}
						}
					}
					if ($this->ck_return_pk == 1 && $this->ck_return_entity == $ent_table) {
						$qry = "IF @str IS NULL
								SET @str = CONVERT(varchar, @@identity)
							ELSE
								SET @str = @str + ',' + CONVERT(varchar, @@identity)";
						$qry_str .= "$qry\n";
					}
					//echo "<pre style=text-align:left>$qry</pre>";
					//nc_query($qry);
				} else {
					$str_val = "";
					for ($k=0; $k<count($this->ref[$p]["field"]); $k++) {
						$ref = $this->ref[$p]["field"][$k];
						if ($ref["type"] == "file") {
							$field = $ref["field"];
							if ($this->files["{$ent_table_ref}_" . $ref["field"] . $j]["tmp_name"] != "")
								$str_val .= ($str_val != "" ? "," : "") . "$field = '" . $this->add_file($this->vars["id_$ent_table_ref$j"], $ref, $ent_table_ref."_", $j) . "'";
							else if (isset($this->vars["{$ent_table_ref}_" . "remove" . $ref["field"] . $j])) {
								for ($l=0; $l<count($ref["file"]); $l++) {
									@unlink($this->ref[$i]["file"][$l]["dir"]["O"] . "/" . $this->get_file_name($this->ref[$i]["file"][$l]["file_name_mask"], $this->vars["id_$ent_table_ref$j"]));
								}
								$str_val .= ($str_val != "" ? "," : "") . "$field = NULL";
							}
						} else if ($ref["ck_qry"] == 1) {
							$val = $this->get_val($ref, $ent_table_ref."_", $j);
							$field = $ref["field"];
							if ($ref["type"] == "daterange") {
								$str_val .= ($str_val != "" ? ",\n" : "") . "{$field}_ini = " . $val["ini"] . ", {$field}_fim = " . $val["fim"];
							} else if ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"])) {
								$qry_multiple .= "DELETE FROM " . $ref["table"] . " WHERE " . $ref["key_field"] . " = " . $this->vars["id_$ent_table_ref$j"] . ";\n";
								for ($l=0; $l<count($val); $l++) {
									$qry_multiple .= "INSERT INTO " . $ref["table"] . " (" . $ref["key_field"] . ", $field) VALUES (" . $this->vars["id_$ent_table_ref$j"] . ", '" . $val[$l] . "');\n";
								}
							} else {
								$str_val .= ($str_val != "" ? ",\n" : "") . "$field = $val";
							}
						}
					}
					$qry = "UPDATE $ent_table SET $str_val 
							WHERE 
								" . ($key_field_val != "" ? "$key_field = $key_field_val AND" : "") . "
								$pk = " . $this->vars["id_$ent_table_ref$j"];
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
					if ($qry_multiple != "") {
						if ($this->db == "MSSQL") {
							$qry_str .= "$qry_multiple";
						} elseif ($this->db == "MYSQL") {
							$temp = explode(";", $qry_multiple);
							for ($k=0; $k<count($temp); $k++) { 
								if (trim($temp[$k]) != "") nc_query($temp[$k]);
							}
						}
					}
				}
			}
		} // for ($i=0; $i<count($this->ent_1XN); $i++) {
		for ($i=0; $i<count($this->ent_NXN); $i++) {
			// get ref position
			$p = $this->ent_NXN[$i];
			// check tab entity
			$tab_id = $this->ref[$p]["tab_id"];
			if (count($this->tab_ref) > 0 && $this->tab_ref[$tab_id]["table"] != null && $this->modo == "update")
				$pk = $this->vars["id_" . $this->tab_ref[$tab_id]["table"]];
			else
				$pk = $this->id;
			// get table definition
			$ent_table = $this->ref[$p]["table"];
			$ent_table_ref = $p . $ent_table;
			$key_field = $this->ref[$p]["key_field"];
			if (is_array($key_field)) {
				$key_field = $key_field[0];
				$key_field_val = $key_field[1];
			} else {
				$key_field_val = $pk;
			}
			$entity_field = $this->ref[$p]["field"];
			$list_id = "";
			for ($j=0; $j<$this->vars["count_".$ent_table_ref]; $j++) {
				if (!isset($this->vars[$ent_table_ref.$j]) && $this->vars[$ent_table_ref."_bak".$j] == 1) {
					$list_id .= ($list_id != "" ? "," : "") . "'" . $this->vars[$ent_table_ref."_".$entity_field[0]["field"].$j] . "'";
				}
			}
			if ($list_id != "" && $key_field_val != "") {
				if ($this->ref[$p]["entity_dependent"] == 1) {
					$qry = "DELETE FROM $ent_table
						WHERE
							$key_field = $key_field_val AND
							" . $entity_field[0]["field"] . " IN ($list_id)";
				} else {
					$qry = "UPDATE $ent_table
						SET $key_field = NULL
						WHERE
							$key_field = $key_field_val AND
							" . $entity_field[0]["field"] . " IN ($list_id)";
				}
				$qry_str .= "$qry;\n";
				if ($this->db == "MYSQL") nc_query($qry);
			}
			for ($j=0; $j<$this->vars["count_".$ent_table_ref]; $j++) {
				$field_list = "";
				$var_list = "";
				if (isset($this->vars[$ent_table_ref.$j]) && $this->vars[$ent_table_ref."_bak".$j] == 0) {
					if ($this->ref[$p]["entity_dependent"] == 1) {
						for ($k=0; $k<count($entity_field); $k++) {
							$field_list .= ($k>0?",":"") . $entity_field[$k]["field"];
							$var_list .= ($k>0?",":"") . "'" . $this->vars[$ent_table_ref."_".$entity_field[$k]["field"].$j] . "'";
						}
						$qry = "INSERT INTO $ent_table ($key_field, $field_list) VALUES ($pk, $var_list)";
					} else {
						for ($k=0; $k<count($entity_field); $k++) {
							$field_list .= ($k>0?" AND ":"") . $entity_field[$k]["field"] . " = '" . $this->vars[$ent_table_ref."_".$entity_field[$k]["field"].$j] . "'";
						}
						$qry = "UPDATE $ent_table
							SET $key_field = $pk
							WHERE
								$field_list";
					}
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
				}
			}
		}
		//if ($_SESSION["user_quality"] == "chico") echo "<pre style=text-align:left>$qry_str</pre>";
		if ($this->debug == 1) echo "<pre style=text-align:left>$qry_str</pre>";
		if ($qry_str != "") {
			if ($this->db == "MSSQL" && $this->ck_return_pk == 1 && $this->ck_return_entity != "default") {
				$qry = "SELECT @str AS val";
				$qry_str .= "$qry;\n";
				$res = nc_query($qry_str,"QUERY");
				$this->return_pk .= ($this->return_pk != "" ? "," : "") . $res[0]["val"];
			} elseif ($this->db == "MSSQL") 
				nc_query($qry_str,"NONQUERY");
		}
	}
	public function add_notification($from_mail, $to_mail, $subject, $msg, $qry = null) {
		$this->ck_notification = 1;
		$this->notification_ref = array(
			"from_mail" => $from_mail,
			"to_mail" => $to_mail,
			"subject" => $subject,
			"msg" => $msg,
			"qry" => $qry
		);
	}
	private function build_confirm() {
		if ($this->ck_notification == 1) {
			$from_mail = $this->notification_ref["from_mail"];
			$to_mail = $this->notification_ref["to_mail"];
			$subject = str_replace("[id]", $this->id, $this->notification_ref["subject"]);
			$msg = str_replace("[id]", $this->id, $this->notification_ref["msg"]);
			if ($this->notification_ref["qry"] != null) {
				$qry = str_replace("[id]", $this->id, $this->notification_ref["qry"]);
				$res = nc_query($qry);
				$keys = array_keys($res[0]);
				for ($i=0; $i<count($keys); $i++) {
					$from_mail = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $from_mail);
					$to_mail = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $to_mail);
					$subject = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $subject);
					$msg = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $msg);
				}
			}
			//echo "<pre style=text-align:left>$to_mail</pre><pre style=text-align:left>$subject</pre><pre style=text-align:left>$msg</pre>";
			$header = "From: $from_mail\r\n";
			mail($to_mail, $subject, $msg, $header);
		}
		if ($this->modo == "insert") $title = $this->lang_confirm_insert;
		if ($this->modo == "update") $title = $this->lang_confirm_update;
		if ($this->modo == "delete") $title = $this->lang_confirm_delete;
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>$title</TITLE>\n";
		echo "<link rel=STYLESHEET type=text/css href=\"$this->css_path\">\n";
		echo "</HEAD>\n";
		echo "<body bgcolor=White>\n";
		echo "<table width=$this->form_width border=0 cellspacing=\"$this->cellspacing\" cellpadding=\"$this->cellpadding\" class=\"$this->css_table\">\n";
		echo "<tr><td colspan=2 class=\"$this->css_list_separator\"></td></tr>\n";
		echo "<tr><td class=\"$this->css_confirm\">$title</td></tr>\n";
		echo "<tr><td colspan=2 class=\"$this->css_list_separator\"></td></tr>\n";
		if (count($this->ck_new_ref) > 0) {
			echo "<tr><td class={$this->css_text_entity}>$this->lang_new_entity_complete:</td></tr>\n";
			for ($i=0; $i<count($this->ck_new_ref); $i++) {
				echo "<tr><td valign=TOP class=\"$this->css_text\"><img src=\"$this->img_dir/$this->img_bullet\" width=23 height=11 border=0><a class=\"$this->css_link_general\" target=_blank href=\"" . $this->ck_new_ref[$i]["url"] . "\">" . strtoupper($this->ck_new_ref[$i]["dir"]) . ": " . $this->ck_new_ref[$i]["nome"] . "</a></td></tr>\n";
			}
		}
		echo "</table>\n";
		echo "</BODY>\n";
		echo "</HTML>\n";
		$temp_str = "";
		if (isset($_SESSION["cls_form_vars"])) {
			$keys = array_keys($_SESSION["cls_form_vars"]);
			for ($i=0; $i<count($keys); $i++) {
				$ck = 0;
				for ($j=0; $j<count($this->ref_filter); $j++) {
					if ($keys[$i] == $this->ref_filter[$j]["field"]) {
						$ck = 1;
						break;
					}
				}
				if ($ck == 0 &&
					$keys[$i] != "step" && 
					$keys[$i] != "modo" && 
					$keys[$i] != "id")
					$temp_str .= "&" . $keys[$i] . "=" . $_SESSION["cls_form_vars"][$keys[$i]];
			}

			$_SESSION["cls_form_vars"] = array();
		}
		$keys = array_keys($_GET);
		for ($i=0; $i<count($keys); $i++) {
			if ($keys[$i] != "step" && 
				$keys[$i] != "modo" && 
				$keys[$i] != "id" && 
				$keys[$i] != $this->pk)
				$temp_str .= "&" . $keys[$i] . "=" . $_GET[$keys[$i]];
		}
		if ($this->redirect_str != null) {
			$url = $this->redirect_str;
			preg_match_all("[\[([a-zA-Z0-9_])+\]]", $url, $match);
			for ($k=0; $k<count($match[0]); $k++) {
				$url = str_replace($match[0][$k], $this->vars[substr($match[0][$k],1,-1)], $url);
			}
		} else
			$url = "?modo=$this->modo$temp_str";
		if ($this->ck_return_pk == 1 &&
			(($this->modo == "insert" && strpos($this->ck_return_use,"I") !== false) ||
			 ($this->modo == "update" && strpos($this->ck_return_use,"U") !== false)))
			$url .= "&ck_return_pk=$this->return_pk";
		if ($this->debug == 1) 
			echo("<a href=\"$url\">$url</a>");
		else if ($this->ck_redirect == 1) 
			echo "<META HTTP-EQUIV=Refresh content=1;url=$url>\n";
	}
}
?>