<?
// Author: Francisco Caserio - francisco.caserio@gmail.com
// Verso: 1.9.5 - 22/05/2008 
class cls_form {
	public function cls_form($db = "MSSQL") {
		$this->db = strtoupper($db);
		$this->add_print = 0;
		$this->ref = array();
		$this->label = array();
		$this->group_key = array();
		$this->order = array();
		$this->ck_ativo = 0;
		$this->ck_collapse = 0;
		$this->ck_recursive = 0;
		$this->ck_csv_export = 0;
		$this->ck_global_form = 0;
		$this->ck_multiple_entry = 0;
		$this->ck_showtotal = 0;
		$this->ck_notification = 0;
		$this->ck_flag_mode = 0;
		$this->ck_display_title = 1;
		$this->ck_repeat_row = 0;
		$this->ck_return_pk = 0;
		$this->ent_1XN = array();
		$this->ent_NXN = array();
		$this->condition = array();
		$this->related = array();
		$this->dependency = array();
		$this->delete_cascade = array();
		$this->form_rule = array();
		$this->header = array();
		$this->tab_ref = array();
		$this->hidden_ref = array();
		$this->link_ref = array();
		$this->color_ref = array();
		$this->publisher_ref = array();
		$this->flag_mode_action = array();
		$this->flag_mode_ref = array();
		$this->onload_action = array();
		$this->pageby = null;
		$this->ck_new_ref = array();
		$this->ck_redirect = 1;
		$this->redirect_str = null;
		$this->pk = "id";
		$this->list_param = array();
		$this->js_ref = array("fn_table_aux.js", "form_globals_lib.js");
		$this->field_group = null;
		$this->list_title_mode = "H";
		$this->list_modo = "auto";
		$this->document_name = "";
		$this->debug = 0;
		include "cls_form.config.php";
	}
	public function set_form_width($w) {
		$this->form_width = $w;
	}
	public function pageby($num) {
		$this->pageby = $num;
	}
	public function display_title($ck) {
		$this->ck_display_title = $ck;
	}
	public function set_document_name($value) {
		$this->document_name = $value;
	}
	public function set_redirect($value) {
		$this->redirect_str = $value;
	}
	public function set_css_path($css_path) {
		$this->css_path = $css_path;
	}
	public function set_img_dir($img_dir) {
		$this->img_dir = $img_dir;
	}
	public function set_js_dir($js_dir) {
		$this->js_dir = $js_dir;
	}
	public function set_entity($table, $ent) {
		$this->table = $table;
		$this->ent = $ent;
	}
	public function add_onload_action($action) {
		$c = count($this->onload_action);
		$this->onload_action[$c] = $action;
	}
	public function add_print_option() {
		$this->add_print = 1;
		$this->add_onload_action("window.focus()");
	}
	public function return_pk($entity = "default") {
		$this->ck_return_pk = 1;
		$this->ck_return_entity = $entity;
	}
	public function add_entity($ent, $table, $key_field, $rel = "1XN", $xtra_key=array()) {
		$c = count($this->ref); // new index
		$tab_id = count($this->tab_ref)-1;
		$this->ref[$c] = array(
			"type" => "entity", 
			"label" => $ent, 
			"table" => $table, 
			"key_field" => $key_field, 
			"key_condition" => "", 
			"xtra_key" => $xtra_key, 
			"rel" => $rel, 
			"path" => null, 
			"entity_cols" => 1, 
			"entity_layout" => "H", 
			"ck_hidden" => 0,
			"ck_edicao_global" => 0, 
			"ck_multiple_entry" => 0, 
			"ck_separator" => 0,
			"req_dependency" => $tab_id >= 0 ? $this->tab_ref[$tab_id]["req_dependency"] : array(), 
			"tab_id" => $tab_id);
		if ($rel == "1XN") $this->ent_1XN[count($this->ent_1XN)] = $c;
		if ($rel == "NXN") $this->ent_NXN[count($this->ent_NXN)] = $c;
	}
	public function set_entity_condition($sql, $key_exclusive=1) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["key_condition"] = $sql; 
		$this->ref[$c]["key_exclusive"] = $key_exclusive; 
	}
	public function set_entity_html($path) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["path"] = $path; 
	}
	public function set_entity_multiple_entry() {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["ck_multiple_entry"] = 1; 
		$this->ck_multiple_entry = 1; 
	}
	public function add_entity_global_form($ref=array()) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["ck_edicao_global"] = 1; 
		$this->ref[$c]["ck_edicao_global_ref"] = $ref; 
		$this->ck_global_form = 1; 
	}
	public function add_entity_related($condition) {
		$c = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c]["related"])) $this->ref[$c]["related"] = array();
		$this->ref[$c]["related"][count($this->ref[$c]["related"])] = $condition; 
	}
	public function add_js($name) {
		$ck_exists = 0;
		for ($i=0; $i<count($this->js_ref); $i++) {
			if ($this->js_ref[$i] == $name) {
				$ck_exists = 1;
				break;
			}
		}
		if ($ck_exists == 0) {
			$c = count($this->js_ref); // new index
			$this->js_ref[$c] = $name; 
		}
	}
	public function add_link($url, $name, $receiver=null, $popup=0, $target="_self") {
		$this->ck_label_link = -1;
		for ($i=0; $i<count($this->label); $i++) {
			if ($receiver == $this->label[$i]["field"]) {
				$this->label[$i]["link"] = array(
					"url" => $url,
					"name" => $name,
					"receiver" => $receiver,
					"popup" => $popup,
					"target" => $target,
					"param" => null,
					"param_condition" => null,
					"param_var" => null
				);
				$this->ck_label_link = $i;
				break;
			}
		}
		if ($this->ck_label_link < 0) {
			$c = count($this->link_ref); // new index
			$this->link_ref[$c] = array(
				"url" => $url,
				"name" => $name,
				"receiver" => $receiver,
				"popup" => $popup,
				"target" => $target,
				"param" => null,
				"param_condition" => null,
				"param_var" => null
			);
		}
	}
	public function add_link_param($param, $condition, $var) {
		if ($this->ck_label_link >= 0) {
			$this->label[$this->ck_label_link]["link"]["param"] = $param;
			$this->label[$this->ck_label_link]["link"]["param_condition"] = $condition;
			$this->label[$this->ck_label_link]["link"]["param_var"] = $var;
		} else {
			$c = count($this->link_ref)-1; // existing index
			$this->link_ref[$c]["param"] = $param;
			$this->link_ref[$c]["param_condition"] = $condition;
			$this->link_ref[$c]["param_var"] = $var;
		}
	}
	public function add_color_param($param, $condition, $var, $color) {
		$c = count($this->color_ref); // new index
		$this->color_ref[$c]["color"] = $color;
		$this->color_ref[$c]["param"] = $param;
		$this->color_ref[$c]["param_condition"] = $condition;
		$this->color_ref[$c]["param_var"] = $var;
	}
	public function add_header($header) {
		$c = count($this->header); // new index
		$this->header[$c] = $header;
	}
	/*
	public function set_entity_origem($join_column, $table, $id, $label) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_join"] = $join_column;
		$this->ref[$c]["entity_table"] = $table;
		$this->ref[$c]["entity_label"] = $label;
		$this->ref[$c]["entity_id"] = $id;
	}
	public function set_entity_entity_group($join_column, $table, $id, $label) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["group_join"] = $join_column;
		$this->ref[$c]["group_table"] = $table;
		$this->ref[$c]["group_label"] = $label;
		$this->ref[$c]["group_id"] = $id;
	}
	*/
	public function set_entity_origem($qry, $label, $entity_groupby_ck = 0) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_qry"] = $qry;
		$this->ref[$c]["entity_label"] = $label;
		$this->ref[$c]["entity_groupby_ck"] = $entity_groupby_ck;
	}
	public function set_entity_group($group) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_group"] = $group;
	}
	public function set_entity_cols($cols) {
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_cols"] = $cols;
	}
	public function set_entity_layout($layout) {
		// V = Vertical, H = Horizontal
		$c = count($this->ref)-1; // existing index
		$this->ref[$c]["entity_layout"] = $layout;
	}
	public function set_key($pk, $label = null) {
		$this->pk = $pk;
		if (is_array($this->pk)) {
			$this->list_param = array();
			for ($i=0; $i<count($this->pk); $i++) {
				$this->list_param[$this->pk[$i]] = "GETFROMQRY";
			}
		} else {
			$this->list_param[$pk] = "GETFROMQRY";
		}
		if ($label != null) {
			$this->label[0] = array(
				"field" => $label,
				"label" => $label,
				"orderby" => null,
				"repeat" => 0,
				"mode" => "default",
				"alignment" => "left",
				"type" => "",
				"nowrap" => 0,
				"ck_update" => 0,
				"ck_hidden" => 0
			);
		}
	}
	public function add_label($field, $label, $orderby = null, $repeat = 0) {
		if ($repeat == 1) $this->ck_repeat_row = 1;
		$c = count($this->label); // new index
		//$this->set_order($orderby != null ? $orderby : $this->get_field_index($field));
		$this->label[$c] = array(
			"field" => $field,
			"label" => $label,
			"orderby" => $orderby,
			"repeat" => $repeat,
			"mode" => "default",
			"alignment" => "left",
			"type" => "",
			"total" => 0,
			"nowrap" => 0,
			"ck_update" => 0,
			"ck_hidden" => 0
		);
	}
	public function set_order($field, $direction = "ASC") {
		$c = count($this->order); // new index
		$this->order[$c] = array(
			"field" => $field,
			"direction" => $direction
		);
	}
	public function add_label_hidden() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["ck_hidden"] = 1;
	}
	public function set_label_sum() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["mode"] = "R$";
		$this->label[$c]["nowrap"] = 1;
		$this->label[$c]["total"] = 0;
		$this->label[$c]["alignment"] = "right";
		$this->ck_showtotal = 1;
	}
	public function set_label_flag_mode() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["mode"] = "flag";
		$this->label[$c]["alignment"] = "center";
		$this->label[$c]["ck_update"] = "0";
	}
	public function set_label_edit_mode($type, $update_key=null) {
		$c = count($this->label)-1; // existing index
		//if ($type == "checkbox") $this->label[$c]["alignment"] = "center";
		$this->label[$c]["ck_update"] = "1";
		$this->label[$c]["nowrap"] = "1";
		$this->label[$c]["type"] = $type;
		$this->label[$c]["update_key"] = $update_key;
		$this->ck_flag_mode = 1;
	}
	public function add_label_field_prop($prop, $value=null, $ix=null) {
		$c = count($this->label)-1; // existing index
		if (isset($this->label[$c]["prop"][$prop]))
			$this->label[$c]["prop"][$prop] .= ";" . $value;
		else
			$this->label[$c]["prop"][$prop] = $value;
	}
	public function add_edit_mode_action($url, $label, $function="submit()") {
		$c = count($this->flag_mode_action); // new index
		$this->flag_mode_action[$c] = array("url"=>$url, "label"=>$label, "function"=>$function, "xtra_field"=>array());
	}
	public function add_edit_mode_action_val($field, $val) {
		$c = count($this->flag_mode_action)-1; // existing index
		$c_ref = count($this->flag_mode_action[$c]["xtra_field"]); // new index
		$this->flag_mode_action[$c]["xtra_field"][$c_ref] = array("field"=>$field, "val"=>$val);
	}
	public function add_edit_mode_field($field, $label, $type, $ck_req=0) {
		$c_ref = count($this->flag_mode_ref); // new index
		$this->flag_mode_ref[$c_ref] = array(
			"field" => $field, 
			"label" => $label, 
			"type" => $type, 
			"prop" => array(), 
			"ck_req" => $ck_req);
		if ($type == "filteredtext") {
			$this->add_js("ajax_lib.js");
			//$this->add_js("filteredtext.js");
			$this->add_js("sarissa.js");
		}
	}
	public function add_edit_mode_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->flag_mode_ref)-1; // existing index
		$this->flag_mode_ref[$c_ref]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label,
			"xtra_fields" => $xtra_fields,
			"ck_new_entry" => 0
		);
	}
	public function set_label_alignment($val) {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["alignment"] = $val;
	}
	public function set_label_nowrap() {
		$c = count($this->label)-1; // existing index
		$this->label[$c]["nowrap"] = 1;
	}
	public function add_group_key($field, $order=null, $direction="ASC") {
		$c = count($this->group_key);
		$this->group_key[$c]["field"] = $field;
		$this->group_key[$c]["order"] = $order == null ? $field : $order;
		$this->group_key[$c]["direction"] = $direction;
	}
	public function set_recursive_mode($ix_hierarquia) {
		$this->ck_recursive = 1;
		$this->recursive_index = $ix_hierarquia;
	}
	public function set_csv_export($ref) {
		$this->ck_csv_export = 1;
		$this->csv_export_ref = $ref;
	}
	public function add_condition($str) {
		$this->condition[count($this->condition)] = $str;
	}
	public function add_related($join, $use="L") {
		$this->related[count($this->related)] = array(
			"sql" => $join,
			"use" => $use
		);
	}
	public function add_dependency($table, $ix, $label = null) {
		$this->dependency[count($this->dependency)] = array(
			"table" => $table,
			"ix" => $ix,
			"label" => $label != null ? $label : $table
		);
	}
	public function add_delete_cascade($table, $ix) {
		$this->delete_cascade[count($this->delete_cascade)] = array(
			"table" => $table,
			"ix" => $ix
		);
	}
	public function set_groupbyativo() {
		$this->ck_ativo = 1; 
	}
	public function set_collapse() {
		$this->ck_collapse = 1; 
	}
	public function set_list_qry($qry) {
		$this->list_qry = $qry;
		$this->list_modo = "custom";
	}
	// field
	private function get_field_label($field) {
		if (strpos($field, "AS ") > 1)
			return substr($field, strpos($field, "AS ")+3);
		elseif (strpos($field, ".") > 1 && 
			(substr($field, strpos($field, ".")-3, 3) != "dbo" || $this->db != "MSSQL"))
			return substr($field, strpos($field, ".")+1);
		else
			return $field;
	}
	private function get_field_index($field) {
		if (strpos($field, "AS ") > 1)
			return substr($field, 0, strpos($field, "AS "));
		else
			return $field;
	}
	public function add_tab($label, $table=null, $key=null) {
		$c_ref = count($this->tab_ref); // new index
		$this->tab_ref[$c_ref]["label"] = $label;
		$this->tab_ref[$c_ref]["table"] = $table;
		$this->tab_ref[$c_ref]["key"] = $key;
		$this->tab_ref[$c_ref]["req_dependency"] = array();
		if ($table != null) {
			$this->add_related("LEFT JOIN $table ON $table.$key = $this->table.$this->pk", $use="FU");
		}
	}
	public function config_tab_req($field) {
		$c_ref = count($this->tab_ref)-1; // existing index
		$this->tab_ref[$c_ref]["req_dependency"][count($this->tab_ref[$c_ref]["req_dependency"])] = $field;
	}
	public function add_field($field, $label, $type, $ck_req=0, $ck_qry=1) {
		$c_ref = count($this->ref); // new index
		$tab_id = count($this->tab_ref)-1; 
		$this->ref[$c_ref] = array(
			"field" => $field, 
			"label" => $label, 
			"type" => $type, 
			"ck_req" => $ck_req, 
			"req_dependency" => $ck_req == 1 && $tab_id >= 0 ? $this->tab_ref[$tab_id]["req_dependency"] : array(), 
			"ck_qry" => $ck_qry, 
			"field_group" => $this->field_group, 
			"ck_hidden" => 0,
			"ck_separator" => 0, 
			"ck_bak" => 0,
			"prop" => array(),
			"file_name_mask" => "[id]",
			"tab_id" => $tab_id);
		if ($type == "color") {
			$this->add_js("fn_buildcolortable.js");
		} else if ($type == "publisher") {
			$this->publisher_ref[count($this->publisher_ref)] = $field;
			$this->ref[$c_ref]["publisher_img_action"] = "$this->js_dir/publisher_lib.img.php";
			$this->ref[$c_ref]["publisher_img_dir"] = "imagens/";
			$this->add_js("publisher_lib.js");
		} else if ($type == "filteredtext") {
			$this->add_js("ajax_lib.js");
			$this->add_js("sarissa.js");
		} else if ($type == "dynamiclist") {
			$this->add_js("dynamiclist_lib.js");
			$this->add_js("drag_lib.js");
			$this->add_js("sarissa.js");
		}
	}
	public function config_field_req($field) {
		$c_ref = count($this->ref)-1; // existing index
		$this->ref[$c_ref]["req_dependency"][count($this->ref[$c_ref]["req_dependency"])] = $field;
	}
	public function add_form_separator() {
		$c_ref = count($this->ref)-1; // existing index
		$this->ref[$c_ref]["ck_separator"] = 1;
	}
	public function add_form_rule($condition, $msg) {
		$c_ref = count($this->form_rule);
		$this->form_rule[$c_ref]["condition"] = $condition;
		$this->form_rule[$c_ref]["msg"] = $msg;
	}
	public function start_field_group($value) {
		$this->field_group = $value; 
	}
	public function end_field_group() {
		$this->field_group = null; 
	}
	public function set_field_mask($value,$write_mask=1) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["mask"] = $value;
		$this->ref[$c_ref]["write_mask"] = $write_mask;
		$this->add_field_prop("onfocus", "recvalue(this)");
		$this->add_field_prop("onkeyup", "gotofield(this.form,this)");
	}
	public function set_field_default($value) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["default"] = $value;
	}
	public function add_field_bak() {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ck_bak"] = 1;
	}
	public function set_field_comment($value,$pos="after") {
		$c_ref = count($this->ref)-1;
		if ($pos == "after")
			$this->ref[$c_ref]["comment"] = $value;
		if ($pos == "before")
			$this->ref[$c_ref]["comment_before"] = $value;
	}
	public function set_field_hidden() {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ck_hidden"] = 1;
		$this->hidden_ref[count($this->hidden_ref)] = $c_ref;
	}
	public function set_field_ajaxtable($table, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxtable"] = $table;
		$this->ref[$c_ref]["ajaxid"] = $id;
		$this->ref[$c_ref]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["ajaxcondition"] = "";
		$this->ref[$c_ref]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["ajaxaction"] = array();
	}
	public function set_field_ajaxqry($qry, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxqry"] = $qry;
		$this->ref[$c_ref]["ajaxid"] = $id;
		$this->ref[$c_ref]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["ajaxaction"] = array();
	}
	public function set_field_ajaxcondition($condition) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxcondition"] = $condition;
	}
	public function set_field_ajaxfunction($function) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxfunction"] = $function;
	}
	public function set_field_ajaxaction($action, $modo="S", $ix=null) {
		// $modo => S = SELECT, R = RESET
		$c_ref = is_numeric($ix) ? $ix : count($this->ref)-1;
		if (!isset($this->ref[$c_ref]["ajaxaction"])) $this->ref[$c_ref]["ajaxaction"] = array();
		$c = count($this->ref[$c_ref]["ajaxaction"]);
		$this->ref[$c_ref]["ajaxaction"][$c] = array("action" => $action, "modo" => $modo);
	}
	public function set_field_ajaxpath($url, $filter="") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ajaxpath"] = $url;
		$this->ref[$c_ref]["ajaxfilter"] = $filter;
		$this->ref[$c_ref]["ajaxaction"] = array();
	}
	public function set_field_currency($value) {
		$this->set_field_comment($value,"before");
	}
	public function add_field_prop($prop, $value=null, $ix=null) {
		$c_ref = is_numeric($ix) ? $ix : count($this->ref)-1;
		if (isset($this->ref[$c_ref]["prop"][$prop]))
			$this->ref[$c_ref]["prop"][$prop] .= ";" . $value;
		else
			$this->ref[$c_ref]["prop"][$prop] = $value;
	}
	public function add_field_list($list) {
		$this->set_field_list($list);
	}
	public function set_field_list($list) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["list"] = $list;
	}
	public function add_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$this->set_field_qry($qry, $ix, $label, $group_label, $xtra_fields);
	}
	public function set_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->ref)-1;
		$ck_ajax = 0;
		preg_match_all("[\[([a-zA-Z0-9_])+\]]", $qry, $match);
		if (count($match[0]) > 0) {
			$this->add_js("ajax_lib.js");
			//$this->add_js("filteredtext.js");
			$this->add_js("sarissa.js");
			for ($i=0; $i<count($match[0]); $i++) {
				for ($j=0; $j<count($this->ref); $j++) {
					if (strtolower(substr($match[0][$i],1,-1)) == strtolower($this->ref[$j]["field"])) {
						$action = "fn_get_list('" . $this->ref[$c_ref]["field"] . "','?modo=xml&field=" . $this->ref[$c_ref]["field"] . "',document.getElementById('".$this->ref[$j]["field"]."').value)";
						$action_reset = "fn_get_list('" . $this->ref[$c_ref]["field"] . "','?modo=xml&field=" . $this->ref[$c_ref]["field"] . "',0)";
						if ($this->ref[$j]["type"] == "dropdown") {
							$this->add_field_prop("onchange", $action, $j);
						} else if ($this->ref[$j]["type"] == "filteredtext") {
							$this->set_field_ajaxaction($action,"S", $j);
							$this->set_field_ajaxaction($action_reset, "R", $j);
						}
						$ck_ajax = 1;
					}
					if ($ck_ajax == 1) break;
				}
				if ($ck_ajax == 1) break;
			}
		}
		$this->ref[$c_ref]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label,
			"xtra_fields" => $xtra_fields,
			"ajax" => $ck_ajax,
			"ck_new_entry" => 0
		);
		$this->ref[$c_ref]["ajaxfunction"] = "nc_query";
	}
	public function set_field_qry_new_entry($table, $field, $url, $pk="@@identity") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["qry"]["ck_new_entry"] = 1;
		$this->ref[$c_ref]["qry"]["new_entry_table"] = $table;
		$this->ref[$c_ref]["qry"]["new_entry_field"] = $field;
		$this->ref[$c_ref]["qry"]["new_entry_url"] = $url;
		$this->ref[$c_ref]["qry"]["new_entry_pk"] = $pk;
		$this->add_field_prop("onchange", "document.getElementById(this.id+'_entry').style.display=this.value=='NEW'?'':'none'");
	}
	public function set_dropdown_multiple($size, $table, $key, $xtra_key=array()) {
		$c_ref = count($this->ref)-1;
		$this->add_field_prop("size", $size);
		$this->add_field_prop("multiple");
		$this->set_field_entity($table, $key, $xtra_key);
	}
	public function set_field_entity($table, $key, $xtra_key=array()) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["table"] = $table;
		$this->ref[$c_ref]["key_field"] = $key;
		$this->ref[$c_ref]["xtra_key"] = $xtra_key;
		// form join
		$str = "LEFT JOIN $table ON $table.$key = $this->table.$this->pk";
		$keys = array_keys($xtra_key);
		for ($i=0; $i<count($keys); $i++) {
			if (substr($xtra_key[$keys[$i]],0,6) == "SELECT")
				$str .= " AND $table." . $keys[$i] . " IN (" . $xtra_key[$keys[$i]] . ")";
			else
				$str .= " AND $table." . $keys[$i] . " = '" . $xtra_key[$keys[$i]] . "'";
		}
		$this->add_related($str, $use="F");
	}
	public function set_field_ref_query($sql, $label, $function="nc_query") {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["ref_qry"] = $sql;
		$this->ref[$c_ref]["ref_label"] = $label;
		$this->ref[$c_ref]["ref_function"] = $function;
	}
	public function set_field_filedir($dirgrande, $maxsizegrande=false, $dirthumb=false, $maxsizethumb=false) {
		$this->add_field_dir($dirgrande, $maxsizegrande);
		if ($dirthumb != false) $this->add_field_dir($dirthumb, $maxsizethumb, 1);
		/*
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["filedir"] = $dirgrande;
		if ($maxsizegrande != false) $this->ref[$c_ref]["filemaxsize"] = $maxsizegrande;
		if ($dirthumb != false) $this->ref[$c_ref]["filedirthumb"] = $dirthumb;
		if ($maxsizethumb != false) $this->ref[$c_ref]["filemaxsizethumb"] = $maxsizethumb;
		*/
	}
	public function set_field_file_name($mask) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["file_name_mask"] = $mask;
	}
	public function add_field_dir($dir, $maxsize=false, $ck_thumb=0) {
		$c_ref = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c_ref]["file"])) $this->ref[$c_ref]["file"] = array();
		$c = count($this->ref[$c_ref]["file"]); // new index
		if (is_array($dir)) {
			$this->ref[$c_ref]["file"][$c]["dir"]["O"] = $dir[0];
			$this->ref[$c_ref]["file"][$c]["dir"]["D"] = $dir[1];
		} else {
			$this->ref[$c_ref]["file"][$c]["dir"]["O"] = $dir;
			$this->ref[$c_ref]["file"][$c]["dir"]["D"] = $dir;
		}
		$this->ref[$c_ref]["file"][$c]["maxsize"] = $maxsize;
		$this->ref[$c_ref]["file"][$c]["ck_thumb"] = $ck_thumb;
		//$this->ref[$c_ref]["file"][$c]["mask"] = $mask;
	}
	public function set_publisher_img_dir($dir) {
		$c_ref = count($this->ref)-1;
		$this->ref[$c_ref]["publisher_img_dir"] = $dir;
	}
	public function add_radio_option($val, $label, $field=null, $type=null, $sql=null, $qry_ix=null, $qry_label=null, $group_label=null) {
		$c_ref = count($this->ref)-1; // existing index
		$this->ref[$c_ref]["list"][$val] = array(
			"ck_xtra" => 1, 
			"label" => $label, 
			"field" => $field, 
			"type" => $type, 
			"ck_req" => 0, 
			"qry" => array(
				"sql" => $sql, 
				"ix" => $qry_ix, 
				"label" => $qry_label, 
				"group_label" => $group_label, 
				"ajax" => 0)
		);
		if ($type == "text") {
			$this->ref[$c_ref]["list"][$val]["prop"]["onfocus"] = "temp=this.value";
			$this->ref[$c_ref]["list"][$val]["prop"]["onblur"] = "temp!=this.value?".$this->ref[$c_ref]["field"]."[".(count($this->ref[$c_ref]["list"])-1)."].checked=true:void(null)";
		}
	}
	public function add_radio_field_prop($prop, $value=true) {
		$c_ref = count($this->ref)-1; // existing index
		$keys = array_keys($this->ref[$c_ref]["list"]);
		$ix = $keys[count($keys)-1];
		if (isset($this->ref[$c_ref]["list"][$ix]["prop"][$prop]))
			$this->ref[$c_ref]["list"][$ix]["prop"][$prop] .= ";" . $value;
		else
			$this->ref[$c_ref]["list"][$ix]["prop"][$prop] = $value;
	}
	// entity field
	public function add_entity_field($field, $label=null, $type=null, $ck_req=0, $ck_qry=1, $title=null) {
		$c_ref = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c_ref]["field"])) $this->ref[$c_ref]["field"] = array();
		$c = count($this->ref[$c_ref]["field"]);
		$this->ref[$c_ref]["field"][$c] = array(
			"field" => $field, 
			"label" => $label, 
			"type" => $type, 
			"ck_req" => $ck_req, 
			"ck_qry" => $ck_qry, 
			"ck_bak" => 0, 
			"ck_hidden" => 0, 
			"prop" => array(),
			"file_name_mask" => "[id].jpg",
			"title" => $title,
			"tab_id" => $this->ref[$c_ref]["tab_id"]);
		if ($type == "filteredtext") {
			$this->add_js("ajax_lib.js");
			//$this->add_js("filteredtext.js");
			$this->add_js("sarissa.js");
		}
	}
	public function add_entity_trava($field, $val) {
		$c_ref = count($this->ref)-1; // existing index
		if (!isset($this->ref[$c_ref]["entity_trava"])) $this->ref[$c_ref]["entity_trava"] = array();
		$c = count($this->ref[$c_ref]["entity_trava"]);
		$this->ref[$c_ref]["entity_trava"][$c] = array(
			"field" => $field,
			"val" => $val
		);
	}
	public function set_entity_field_mask($value,$write_mask=1) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["mask"] = $value;
		$this->ref[$c_ref]["field"][$c]["write_mask"] = $write_mask;
		$this->add_entity_field_prop("onfocus", "recvalue(this)");
		$this->add_entity_field_prop("onkeyup", "gotofield(this.form,this)");
	}
	public function set_entity_field_default($value) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["default"] = $value;
	}
	public function add_entity_field_bak() {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ck_bak"] = 1;
	}
	public function set_entity_field_comment($value,$pos="after") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		if ($pos == "after")
			$this->ref[$c_ref]["field"][$c]["comment"] = $value;
		if ($pos == "before")
			$this->ref[$c_ref]["field"][$c]["comment_before"] = $value;
	}
	public function set_entity_field_hidden() {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ck_hidden"] = 1;
		//$this->hidden_ref[count($this->hidden_ref)] = $c_ref;
	}
	public function set_entity_field_ajaxtable($table, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxtable"] = $table;
		$this->ref[$c_ref]["field"][$c]["ajaxid"] = $id;
		$this->ref[$c_ref]["field"][$c]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["field"][$c]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["field"][$c]["ajaxaction"] = array();
	}
	public function set_entity_field_ajaxqry($qry, $id="id", $label="nome", $filter=null) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxqry"] = $qry;
		$this->ref[$c_ref]["field"][$c]["ajaxid"] = $id;
		$this->ref[$c_ref]["field"][$c]["ajaxlabel"] = $label;
		$this->ref[$c_ref]["field"][$c]["ajaxfilter"] = $filter == null ? $label : $filter;
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["field"][$c]["ajaxaction"] = array();
	}
	public function set_entity_field_ajaxcondition($condition) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxcondition"] = $condition;
	}
	public function set_entity_field_ajaxfunction($function) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = $function;
	}
	public function set_entity_field_ajaxaction($action, $modo = "S", $ix=null) {
		// $modo => S = SELECT, R = RESET
		$c_ref = count($this->ref)-1;
		$c = is_numeric($ix) ? $ix : count($this->ref[$c_ref]["field"])-1;
		$c_action = isset($this->ref[$c_ref]["field"][$c]["ajaxaction"]) ? count($this->ref[$c_ref]["field"][$c]["ajaxaction"]) : 0;
		$this->ref[$c_ref]["field"][$c]["ajaxaction"][$c_action] = array("action" => $action, "modo" => $modo);
	}
	public function set_entity_field_ajaxpath($url, $filter="") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ajaxpath"] = $url;
		$this->ref[$c_ref]["field"][$c]["ajaxfilter"] = $filter;
		$this->ref[$c_ref]["field"][$c]["ajaxaction"] = array();
	}
	public function set_entity_field_filedir($dirgrande, $maxsizegrande=false, $dirthumb=false, $maxsizethumb=false) {
		$this->add_entity_field_dir($dirgrande, $maxsizegrande);
		if ($dirthumb != false) $this->add_entity_field_dir($dirthumb, $maxsizethumb, 1);
		/*
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["filedir"] = $dirgrande;
		if ($maxsizegrande != false) $this->ref[$c_ref]["field"][$c]["filemaxsize"] = $maxsizegrande;
		if ($dirthumb != false) $this->ref[$c_ref]["field"][$c]["filedirthumb"] = $dirthumb;
		if ($maxsizethumb != false) $this->ref[$c_ref]["field"][$c]["filemaxsizethumb"] = $maxsizethumb;
		*/
	}
	public function set_entity_field_file_name($mask) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["file_name_mask"] = $mask;
	}
	public function add_entity_field_dir($dir, $maxsize=false, $ck_thumb=0) {
		$c_ref = count($this->ref)-1; // existing index
		$c = count($this->ref[$c_ref]["field"])-1; // existing index
		if (!isset($this->ref[$c_ref]["field"][$c]["file"])) $this->ref[$c_ref]["field"][$c]["file"] = array();
		$c2 = count($this->ref[$c_ref]["field"][$c]["file"]); // new index
		if (is_array($dir)) {
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["O"] = $dir[0];
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["D"] = $dir[1];
		} else {
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["O"] = $dir;
			$this->ref[$c_ref]["field"][$c]["file"][$c2]["dir"]["D"] = $dir;
		}
		$this->ref[$c_ref]["field"][$c]["file"][$c2]["maxsize"] = $maxsize;
		$this->ref[$c_ref]["field"][$c]["file"][$c2]["ck_thumb"] = $ck_thumb;
		//$this->ref[$c_ref]["field"][$c]["file"][$c2]["mask"] = $mask;
	}
	public function add_entity_field_prop($prop, $value=null, $ix=null) {
		$c_ref = count($this->ref)-1;
		$c = is_numeric($ix) ? $ix : count($this->ref[$c_ref]["field"])-1;
		if (isset($this->ref[$c_ref]["field"][$c]["prop"][$prop]))
			$this->ref[$c_ref]["field"][$c]["prop"][$prop] .= ";" . $value;
		else
			$this->ref[$c_ref]["field"][$c]["prop"][$prop] = $value;
	}
	public function add_entity_field_list($list) {
		$this->set_entity_field_list($list);
	}
	public function set_entity_field_list($list) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["list"] = $list;
		$this->ref[$c_ref]["field"][$c]["ref_qry"] = null;
	}
	public function add_entity_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$this->set_entity_field_qry($qry, $ix, $label, $group_label, $xtra_fields);
	}
	public function set_entity_field_qry($qry, $ix, $label, $group_label = null, $xtra_fields = null) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$ck_ajax = 0;
		preg_match_all("[\[([a-zA-Z0-9_])+\]]", $qry, $match);
		if (count($match[0]) > 0) {
			$this->add_js("ajax_lib.js");
			//$this->add_js("filteredtext.js");
			$this->add_js("sarissa.js");
			for ($i=0; $i<count($match[0]); $i++) {
				for ($j=0; $j<count($this->ref[$c_ref]["field"]); $j++) {
					//if ($_SESSION["user_quality"] == "chico") echo "[" . $this->ref[$c_ref]["field"][$j]["field"] . "]";
					if (strtolower(substr($match[0][$i],1,-1)) == strtolower($this->ref[$c_ref]["field"][$j]["field"])) {
						for ($k=0; $k<count($this->ref); $k++) {
							if ($this->ref[$k]["type"] == "entity" && $this->ref[$k]["rel"] == "1XN") {
								for ($l=0; $l<count($this->ent_1XN); $l++) {
									if ($this->ent_1XN[$l] == $k) break;
								}
								$ent_table = $l . $this->ref[$k]["table"];
							}
						}
						$action = "fn_get_list(this.id.replace('" . $this->ref[$c_ref]["field"][$j]["field"] . "','" . $this->ref[$c_ref]["field"][$c]["field"] . "').replace('list',''),'?modo=xml&field=" . $this->ref[$c_ref]["field"][$c]["field"] . "',document.getElementById(this.id).value)";
						$action_reset = "fn_get_list(this.id.replace('" . $this->ref[$c_ref]["field"][$j]["field"] . "','" . $this->ref[$c_ref]["field"][$c]["field"] . "').replace('list',''),'?modo=xml&field=" . $this->ref[$c_ref]["field"][$c]["field"] . "',0)";
						$this->set_entity_field_ajaxaction($action, "S", $j);
						$this->set_entity_field_ajaxaction($action_reset, "R", $j);
						$ck_ajax = 1;
					}
					if ($ck_ajax == 1) break;
				}
				if ($ck_ajax == 1) break;
			}
		}
		$this->ref[$c_ref]["field"][$c]["qry"] = array(
			"sql" => $qry, 
			"ix" => $ix, 
			"label" => $label, 
			"group_label" => $group_label, 
			"xtra_fields" => $xtra_fields, 
			"ajax" => $ck_ajax,
			"ck_new_entry" => 0
		);
		$this->ref[$c_ref]["field"][$c]["ajaxfunction"] = "nc_query";
		$this->ref[$c_ref]["field"][$c]["ref_qry"] = null;
	}
	public function set_entity_field_new_entry($table, $field, $url, $pk="@@identity") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["qry"]["ck_new_entry"] = 1;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_table"] = $table;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_field"] = $field;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_url"] = $url;
		$this->ref[$c_ref]["field"][$c]["qry"]["new_entry_pk"] = $pk;
		$field = $this->ref[$c_ref]["field"][$c]["field"];
		$this->add_entity_field_prop("onchange", "document.getElementById(this.id.replace('$field','{$field}_entry')).style.display=this.value=='NEW'?'':'none'");
	}
	public function set_entity_field_ref_query($sql, $label, $function="nc_query") {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["ref_qry"] = $sql;
		$this->ref[$c_ref]["field"][$c]["ref_label"] = $label;
		$this->ref[$c_ref]["field"][$c]["ref_function"] = $function;
	}
	public function set_entity_dropdown_multiple($size, $table, $key) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->add_entity_field_prop("size", $size);
		$this->add_entity_field_prop("multiple");
		$this->set_entity_field_entity($table, $key);
	}
	public function set_entity_field_entity($table, $key, $xtra_key=array()) {
		$c_ref = count($this->ref)-1;
		$c = count($this->ref[$c_ref]["field"])-1;
		$this->ref[$c_ref]["field"][$c]["table"] = $table;
		$this->ref[$c_ref]["field"][$c]["key_field"] = $key;
		$this->ref[$c_ref]["field"][$c]["xtra_key"] = $key;
	}
	public function add_list_param($param, $val = "GETFROMQRY") {
		$this->list_param[$param] = $val;
	}
	public function set_list_title_mode($value) {
		$this->list_title_mode = $value;
	}
	private function get_res_aux($ref) { 
		$ent_table = $ref["table"];
		$key_field = $ref["key_field"];
		$str_field = "";
		$str_join = "";
		for ($i=0; $i<count($ref["field"]); $i++) {
			$field = $ref["field"][$i]["field"];
			$type = $ref["field"][$i]["type"];
			$prop = $ref["field"][$i]["prop"];
			$ck_qry = $ref["field"][$i]["ck_qry"];
			if ($ck_qry == 1) {
				if ($type == "date" || $type == "datetime") {
					$str_field .= ($str_field != "" ? ",\n" : "") . "DAY($ent_table.$field) AS dia_$field, MONTH($ent_table.$field) AS mes_$field, YEAR($ent_table.$field) AS ano_$field";
				} elseif ($type == "daterange") {
					$str_field .= ($str_field != "" ? ",\n" : "") . "DAY($ent_table.{$field}_ini) AS dia_{$field}_ini, MONTH($ent_table.{$field}_ini) AS mes_{$field}_ini, YEAR($ent_table.{$field}_ini) AS ano_{$field}_ini";
					$str_field .= ($str_field != "" ? ",\n" : "") . "DAY($ent_table.{$field}_fim) AS dia_{$field}_fim, MONTH($ent_table.{$field}_fim) AS mes_{$field}_fim, YEAR($ent_table.{$field}_fim) AS ano_{$field}_fim";
				} elseif ($type != "dynamiclist" &&
					($type != "dropdown" || !array_key_exists("multiple", $prop))) {
					$str_field .= ($str_field != "" ? ",\n" : "") . "$ent_table.$field";
				}
			}
			if ($ref["field"][$i]["type"] == "filteredtext" &&
				isset($ref["field"][$i]["ajaxfunction"]) && 
				$ref["field"][$i]["ajaxfunction"] == "nc_query") {
				$str_field .= ",\n" . $ref["field"][$i]["ajaxtable"] . "." . $ref["field"][$i]["ajaxlabel"] . " AS filteredtext";
				$str_join .= "LEFT JOIN " . $ref["field"][$i]["ajaxtable"] . " ON " . $ref["field"][$i]["ajaxtable"] . "." . $ref["field"][$i]["ajaxid"] . " = $ent_table.$field\n";
			}
			if (isset($ref["field"][$i]["file"])) {
				for ($j=0; $j<count($ref["field"][$i]["file"]); $j++) {
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $ref["field"][$i]["file"][$j]["dir"]["O"], $match);
					for ($k=0; $k<count($match[0]); $k++) {
						if (strpos($match[0][$k], ".") === false)
							$temp = "$ent_table." . substr($match[0][$k],1,-1);
						else
							$temp = substr($match[0][$k],1,-1);
						if (strpos($str_field, $temp) === false) 
							$str_field .= ($str_field != "" ? ",\n" : "") . "$temp";
					}
				}
			}
		}
		if (isset($ref["related"])) {
			for ($i=0; $i<count($ref["related"]); $i++) {
				$str_join .= $ref["related"][$i] . "\n";
			}
		}
		if (isset($ref["entity_trava"])) {
			for ($i=0; $i<count($ref["entity_trava"]); $i++) {
				$str_field .= ",$ent_table." . $ref["entity_trava"][$i]["field"];
			}
		}
		$qry = "SELECT $ent_table.id, $str_field 
			FROM $ent_table
			$str_join
			WHERE 
				" . ($ref["key_condition"] != "" ? $ref["key_condition"] . " AND" : "") . "
				" . ($ref["key_condition"] == "" || $ref["key_exclusive"] == 0 ? "$ent_table.$key_field = " . $this->vars["id"] . " AND" : "") . "
				1 = 1";
		//if ($this->debug == 1) echo "<pre>$qry</pre>";
		return nc_query($qry);
	}
	private function get_file_name($mask, $id) {
		if (strpos($mask, "[id]") !== false)
			return str_replace("[id]", $id, $mask);
		else {
			preg_match_all("[\[(\.)+id\]]", $mask, $match);
			if (count($match[0]) > 0) {
				return str_replace($match[0][0], str_pad($id, (strlen($match[0][0])-2), '0', 'LEFT'), $mask);;
			}
		}
	}
	// build functions
	private function get_field($ref, $res = null, $prefix = null, $sufix = null, $class = null) {
		//echo "<pre>"; print_r($res); echo "</pre>";
		if (count($this->tab_ref) == 0 || 
			!isset($ref["tab_id"]) || 
			$this->tab_ref[$ref["tab_id"]]["table"] == null) {
			$ref["field"] = $this->get_field_label($ref["field"]);
		} else {
			$ref["field"] = $this->tab_ref[$ref["tab_id"]]["table"] . "_" . $ref["field"];
		}
		if ($class == null) $class = ($prefix == null ? "form" : "formpeq"); 
		$prop_str = "";
		if (isset($ref["prop"]) && count($ref["prop"]) > 0) {
			$keys = array_keys($ref["prop"]);
			for ($j=0; $j<count($keys); $j++) {
				$prop_str .= " " . $keys[$j] . ($ref["prop"][$keys[$j]] != null ? "=\"" . $ref["prop"][$keys[$j]] . "\"" : "");
				if ($keys[$j] == "size") $size = $ref["prop"][$keys[$j]];
			}
		}
		$str = "";
		if (isset($ref["ck_bak"]) && $ref["ck_bak"] == 1)
			$str .= "<input type=hidden name=\"{$prefix}" . $ref["field"] . "_bak{$sufix}\" id=\"{$prefix}" . $ref["field"] . "_bak{$sufix}\" value=\"" . ($res != null ? $res[$ref["field"]] : "") . "\">\n";
		if ($ref["type"] == "text") {
			if ($this->ck_print == 1)
				$str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">" . $res[$ref["field"]] . "</span>";
			else {
				if (isset($ref["mask"])) {
					$pos = 0;
					$c = 0;
					for ($i=0; $i<count($ref["mask"]); $i++) {
						if (is_numeric($ref["mask"][$i])) {
							$str .= "<input type=text name=\"{$prefix}" . $ref["field"] . "{$c}{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$c}{$sufix}\" value=\"" . ($res != null ? substr($res[$ref["field"]], $pos, $ref["mask"][$i]) : "") . "\" class=$class size=".$ref["mask"][$i]." maxlength=".$ref["mask"][$i]." $prop_str>\n";
							$pos += $ref["mask"][$i];
							$c++;
						} else {
							if ($ref["write_mask"] == 1) $pos += strlen($ref["mask"][$i]);
							$str .= $ref["mask"][$i] . "\n";
						}
					}
				} else
					$str .= "<input type=text name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "\" class=$class $prop_str>\n";
			}
		} else if ($ref["type"] == "hidden") {
			$str .= "<input type=hidden name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "\">\n";
		} else if ($ref["type"] == "file") {
			$thumb_ref = null;
			$preview_ref = null;
			for ($i=0; $i<count($ref["file"]); $i++) {
				if ($ref["file"][$i]["ck_thumb"] == 1 ||
					count($ref["file"]) == 1) {
					$thumb_ref = $ref["file"][$i];
					$thumb_dir = $thumb_ref["dir"]["O"]; // origem
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $thumb_dir, $match);
					for ($j=0; $j<count($match[0]); $j++) {
						$thumb_dir = str_replace($match[0][$j], $res[$this->get_field_label(substr($match[0][$j],1,-1))], $thumb_dir);
					}
				} 
				if ($ref["file"][$i]["ck_thumb"] == 0 ||
					count($ref["file"]) == 1) {
					$preview_ref = $ref["file"][$i];
					$preview_dir = $preview_ref["dir"]["O"];
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $preview_dir, $match);
					for ($j=0; $j<count($match[0]); $j++) {
						$preview_dir = str_replace($match[0][$j], $res[$this->get_field_label(substr($match[0][$j],1,-1))], $preview_dir);
					}
				}
			}
			if ($res != null && $res[$ref["field"]] != "") {
				$thumb_file_name = $res[$ref["field"]];
				if (substr($res[$ref["field"]],-3) == "pdf") {
					$pdf_thumb_format = substr($res[$ref["field"]],0,-3) . "jpg.0";
					$fp = @fopen("$thumb_dir/$pdf_thumb_format", "r");
					if ($fp) {
						$thumb_file_name = $pdf_thumb_format;
						fclose($fp);
					}
				}
				$preview_file_name = $res[$ref["field"]];
			}
			$fp = @fopen("$preview_dir/$preview_file_name", "r");
			if ($fp) {
				$ck_file = 1;
				fclose($fp);
			} else
				$ck_file = 0;
			//echo "[$thumb_dir/$thumb_file_name]";
			//echo "[$preview_dir/$preview_file_name][$ck_file]";
			if ($this->ck_print == 1) {
				if ($res != null && 
					(($ref["ck_qry"] == 1 && $res[$ref["field"]] != "") ||
					 ($ref["ck_qry"] == 0 && $ck_file == 1))) 
					$str .= "<a href=\"$preview_dir/$preview_file_name\" target=_blank><img src=\"$thumb_dir/$thumb_file_name\" border=0></a>"; //<br>".$res[$ref["field"]];
				else
					$str .= "SEM IMAGEM";
			} else {
				// find thumb and preview
				if ($res != null && 
					(($ref["ck_qry"] == 1 && $res[$ref["field"]] != "") ||
					 ($ref["ck_qry"] == 0 && $ck_file == 1))) {
					$size = getImageSize("$thumb_dir/$thumb_file_name");
					if ($size[2] == 1 || $size[2] == 2 || $size[2] == 3) {
						$str .= "<span id=\"{$prefix}" . "imagem" . $ref["field"] . "div{$sufix}\">";
						if ($thumb_ref != null) 
							$str .= "<a href=\"$preview_dir/$preview_file_name\" target=_blank><img src=\"$thumb_dir/$thumb_file_name\" border=0></a>"; //<br>".$res[$ref["field"]];
						else
							$str .= "<img src=\"$preview_dir/$preview_file_name\" border=0></a>"; //<br>".$res[$ref["field"]];
						$str .= "</span>";
						$str .= "<br><span id=\"{$prefix}" . "remove" . $ref["field"] . "div{$sufix}\"><input type=\"checkbox\" name=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\">Remover imagem<br></span>\n";
					} else {
						$str .= "<span id=\"{$prefix}" . "imagem" . $ref["field"] . "div{$sufix}\"><a href=\"" . $preview_ref["dir"] . "/preview_file_name\" target=_blank>" . $res[$ref["field"]] . "</a>"; 
						$str .= "<span id=\"{$prefix}" . "remove" . $ref["field"] . "div{$sufix}\"><input type=\"checkbox\" name=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\">Remover arquivo<br></span>\n";
					}
				} else {
					$str .= "<span id=\"{$prefix}" . "imagem" . $ref["field"] . "div{$sufix}\" style=display:none></span>\n";
					$str .= "<span id=\"{$prefix}" . "remove" . $ref["field"] . "div{$sufix}\" style=display:none><input type=\"checkbox\" name=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . "remove" . $ref["field"] . "{$sufix}\">Remover imagem<br></span>\n";
				}
				$str .= "<input type=\"file\" name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" class=\"$class\" $prop_str>\n";
			}
		} else if ($ref["type"] == "textarea") {
			if ($this->ck_print == 1) 
				$str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">" . nl2br($res[$ref["field"]]) . "</span>";
			else
				$str .= "<textarea name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" class=$class $prop_str>" . ($res != null ? $res[$ref["field"]] : (isset($ref["default"]) ? $ref["default"] : "")) . "</textarea>\n";
		} else if ($ref["type"] == "date") {
			if ($this->ck_print == 1) 
				$str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">" . ($res["dia_".$ref["field"]] != "" ? $res["dia_".$ref["field"]] . "/" . $res["mes_".$ref["field"]] . "/" . $res["ano_".$ref["field"]] : "") . "</span>";
			else {
				$str .= "<input type=text name=\"dia_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"dia_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? ($res["dia_".$ref["field"]] != "" ? str_pad($res["dia_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],8,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"mes_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"mes_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? ($res["mes_".$ref["field"]] != "" ? str_pad($res["mes_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],5,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"ano_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"ano_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]] : (isset($ref["default"]) ? substr($ref["default"],0,4) : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)>\n";
			}
		} else if ($ref["type"] == "datetime") {
			if ($this->ck_print == 1) 
				$str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">" . ($res["dia_".$ref["field"]] != "" ? str_pad($res["dia_".$ref["field"]],2,'0','LEFT') . "/" . str_pad($res["mes_".$ref["field"]],2,'0','LEFT') . "/" . $res["ano_".$ref["field"]] . " " . str_pad($res["hor_".$ref["field"]],2,'0','LEFT') . ":" . str_pad($res["min_".$ref["field"]],2,'0','LEFT') : "") . "</span>";
			else {
				$str .= "<input type=text name=\"dia_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"dia_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? ($res["dia_".$ref["field"]] != "" ? str_pad($res["dia_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],8,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"mes_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"mes_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? ($res["mes_".$ref["field"]] != "" ? str_pad($res["mes_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],5,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> /\n";
				$str .= "<input type=text name=\"ano_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"ano_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]] : (isset($ref["default"]) ? substr($ref["default"],0,4) : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)> - \n";
				$str .= "<input type=text name=\"hor_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"hor_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? ($res["hor_".$ref["field"]] != "" ? str_pad($res["hor_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],11,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)>:";
				$str .= "<input type=text name=\"min_{$prefix}" . $ref["field"] . "{$sufix}\" id=\"min_{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . ($res != null ? ($res["min_".$ref["field"]] != "" ? str_pad($res["min_".$ref["field"]],2,'0','LEFT') : "") : (isset($ref["default"]) ? substr($ref["default"],14,2) : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=recvalue(this) onkeyup=gotofield(this.form,this)>\n";
			}
		} else if ($ref["type"] == "daterange") {
			if ($this->ck_print == 1) {
				$str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">";
				$str .= ($res["dia_".$ref["field"]."_ini"] != "" ? $res["dia_".$ref["field"]."_ini"] . "/" . $res["mes_".$ref["field"]."_ini"] . "/" . $res["ano_".$ref["field"]."_ini"] : ""); 
				$str .= ($res["dia_".$ref["field"]."_fim"] != "" ? $res["dia_".$ref["field"]."_fim"] . "/" . $res["mes_".$ref["field"]."_fim"] . "/" . $res["ano_".$ref["field"]."_fim"] : ""); 
				$str .= "</span>";
			} else {
				$str .= "<input type=checkbox name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" value=1 onclick=dia_{$prefix}" . $ref["field"] . "_ini{$sufix}.disabled=!this.checked;mes_{$prefix}" . $ref["field"] . "_ini{$sufix}.disabled=!this.checked;ano_{$prefix}" . $ref["field"] . "_ini{$sufix}.disabled=!this.checked;dia_{$prefix}" . $ref["field"] . "_fim{$sufix}.disabled=!this.checked;mes_{$prefix}" . $ref["field"] . "_fim{$sufix}.disabled=!this.checked;ano_{$prefix}" . $ref["field"] . "_fim{$sufix}.disabled=!this.checked " . (isset($ref["default"]) ? "CHECKED" : "") . " " . ($this->modo == "insert" || ($this->modo == "update" && $this->step == 2) ? "style=display:none" : "")  . ">\n";
				$str .= "<input type=text name=\"dia_{$prefix}" . $ref["field"] . "_ini{$sufix}\" id=\"dia_{$prefix}" . $ref["field"] . "_ini{$sufix}\" value=\"" . ($res != null ? $res["dia_".$ref["field"]."_ini"] : (isset($ref["default"]) ? $ref["default"]["dia_ini"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('dia_','').replace('_ini','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"mes_{$prefix}" . $ref["field"] . "_ini{$sufix}\" id=\"mes_{$prefix}" . $ref["field"] . "_ini{$sufix}\" value=\"" . ($res != null ? $res["mes_".$ref["field"]."_ini"] : (isset($ref["default"]) ? $ref["default"]["mes_ini"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('mes_','').replace('_ini','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"ano_{$prefix}" . $ref["field"] . "_ini{$sufix}\" id=\"ano_{$prefix}" . $ref["field"] . "_ini{$sufix}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]."_ini"] : (isset($ref["default"]) ? $ref["default"]["ano_ini"] : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('ano_','').replace('_ini','')).checked=1:void(null)\"> a \n";
				$str .= "<input type=text name=\"dia_{$prefix}" . $ref["field"] . "_fim{$sufix}\" id=\"dia_{$prefix}" . $ref["field"] . "_fim{$sufix}\" value=\"" . ($res != null ? $res["dia_".$ref["field"]."_fim"] : (isset($ref["default"]) ? $ref["default"]["dia_fim"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('dia_','').replace('_fim','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"mes_{$prefix}" . $ref["field"] . "_fim{$sufix}\" id=\"mes_{$prefix}" . $ref["field"] . "_fim{$sufix}\" value=\"" . ($res != null ? $res["mes_".$ref["field"]."_fim"] : (isset($ref["default"]) ? $ref["default"]["mes_fim"] : "")) . "\" size=2 maxlength=2 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('mes_','').replace('_fim','')).checked=1:void(null)\"> /\n";
				$str .= "<input type=text name=\"ano_{$prefix}" . $ref["field"] . "_fim{$sufix}\" id=\"ano_{$prefix}" . $ref["field"] . "_fim{$sufix}\" value=\"" . ($res != null ? $res["ano_".$ref["field"]."_fim"] : (isset($ref["default"]) ? $ref["default"]["ano_fim"] : "")) . "\" size=4 maxlength=4 class=$class $prop_str onfocus=\"recvalue(this);temp=this.value\" onkeyup=\"gotofield(this.form,this)\" onblur=\"temp!=this.value?document.getElementById(this.id.replace('ano_','').replace('_fim','')).checked=1:void(null)\">\n";
			}
		} elseif ($ref["type"] == "checkbox") {
			//if ($this->ck_print == 0 || $res[$ref["field"]] == 1) 
			$str .= "<input type=checkbox name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\"" . ($res != null && $res[$ref["field"]] == 1 ? " CHECKED" : "") . " $prop_str " . ($this->ck_print == 1 ? "disabled" : "") . ">" . $ref["label"] . "\n";
		} else if ($ref["type"] == "publisher") {
			$str .= "<script language=\"JavaScript\">\n";
			$str .= "{$prefix}" . $ref["field"] . "{$sufix} = new Publisher(\"{$prefix}" . $ref["field"] . "{$sufix}\");\n";
			$url_dir = "http://" . $_SERVER["HTTP_HOST"] . substr($_SERVER["PHP_SELF"], 0, strrpos($_SERVER["PHP_SELF"], "/")+1) . $ref["publisher_img_dir"];
			$str .= "{$prefix}" . $ref["field"] . "{$sufix}.setImgDir(\"$url_dir\",\"" . str_replace("\\", "\\\\", realpath($ref["publisher_img_dir"])) . "\");\n";
			$str .= "{$prefix}" . $ref["field"] . "{$sufix}.setImgAction(\"" . $ref["publisher_img_action"] . "\");\n";
			if (isset($ref["prop"]["width"])) $str .= "{$prefix}" . $ref["field"] . "{$sufix}.setWidth(\"" . $ref["prop"]["width"] . "\");\n";
			if (isset($ref["prop"]["height"])) $str .= "{$prefix}" . $ref["field"] . "{$sufix}.setHeight(\"" . $ref["prop"]["height"] . "\");\n";
			$str .= "{$prefix}" . $ref["field"] . "{$sufix}.build();\n";
			$str .= "</script>\n";
			if ($res != null) echo "<span id=\"span{$prefix}" . $ref["field"] . "{$sufix}\" style=\"display:none\">" . $res[$ref["field"]] . "</span>"; 
		} else if ($ref["type"] == "dynamiclist") {
			$str .= "<script language=\"JavaScript\">\n";
			$str .= "{$prefix}" . $ref["field"] . "{$sufix} = new dynamicList(\"{$prefix}" . $ref["field"] . "{$sufix}\");\n";
			if (isset($ref["ajaxqry"])) $str .= "{$prefix}" . $ref["field"] . "{$sufix}.setXmlpath(\"?modo=xml&field=" . $ref["field"] . "\");\n";
			$str .= "{$prefix}" . $ref["field"] . "{$sufix}.build();\n";
			if ($res != null) {
				$keys = array_keys($ref["xtra_key"]);
				$str_xtra_keys = "";
				for ($i=0; $i<count($keys); $i++) {
					$str_xtra_keys .= $keys[$i] . " = '" . $ref["xtra_key"][$keys[$i]] . "' AND\n";
				}
				$qry = "SELECT " . $ref["field"] . " AS val
					FROM " . $ref["table"] . "
					WHERE $str_xtra_keys " . $ref["key_field"] . " = " . $res["id"] . "
					ORDER BY val";
				$res_dynlist = nc_query($qry);
				if ($this->debug == 1) echo "<pre>$qry</pre>";
				for ($i=0; $i<count($res_dynlist); $i++) {
					$str .= "{$prefix}" . $ref["field"] . "{$sufix}.addItem(\"" . $res_dynlist[$i]["val"] . "\");\n";
				}
			}
			$str .= "</script>\n";
		} else if ($ref["type"] == "color") {
			$str .= "<script language=\"JavaScript\">fn_BuildColorTable(\"{$prefix}" . $ref["field"] . "{$sufix}\",\"" . ($res != null ? $res[$ref["field"]] : "gray") . "\")</script>\n";
		} else if ($ref["type"] == "filteredtext") {
			$field = $ref["field"];
			$val = $res[$field];
			if ($res != null && 
				$res[$field] != "" && 
				$res[$field] != "0" &&
				!isset($res["filteredtext"])) {
				if (isset($ref["ref_qry"]) && $ref["ref_qry"] != null) { 
					if (!isset($this->var_bak[$field][$val])) {
						$sql = ereg_replace("\[[a-zA-Z0-9_]+\]", $val, $ref["ref_qry"]);
						if ($this->debug == 1) echo "<pre>$sql</pre>";
						$res_temp = $ref["ref_function"]($sql);
						$this->var_bak[$field][$val] = $res_temp[0][$ref["ref_label"]];
					}
					$res["filteredtext"] = $this->var_bak[$field][$val];
				} elseif (isset($ref["ajaxqry"]) && $ref["ajaxqry"] != null) { 
					$sql = $ref["ajaxqry"];
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					for ($i=0; $i<count($match[0]); $i++) {
						$sql = str_replace($match[0][$i], $res[substr($match[0][$i],1,-1)], $sql);
					}
					$res_ajax = $ref["ajaxfunction"]($sql);
					$res["filteredtext"] = $res_ajax[0][$ref["ajaxlabel"]];
				} else {
					$sql = "SELECT 
								" . $ref["ajaxid"] . " AS id,
								" . $ref["ajaxlabel"] . " AS label
							FROM " . $ref["ajaxtable"] . "
							WHERE 
								" . $ref["ajaxid"] . " = '$val'";
					//echo "<pre>$sql</pre>";
					$res_ajax = $ref["ajaxfunction"]($sql);
					$res["filteredtext"] = $res_ajax[0]["label"];
				}
			}
			if ($this->ck_print == 1)
				$str .= "<span class=tdtexto_relat id=\"{$prefix}{$field}{$sufix}\">" . (isset($res["filteredtext"])?$res["filteredtext"]:"") . "</span>";
			else {
				$param = "";
				$ckstr = "";
				if (isset($ref["ajaxqry"])) {
					$sql = $ref["ajaxqry"];
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					//print_r($match);
					for ($i=0; $i<count($match[0]); $i++) {
						$param .= "&" . substr($match[0][$i],1,-1) . "=[" . substr($match[0][$i],1,-1) . "$sufix]";
					}
				}
				if (is_array($ref["ajaxfilter"])) {
					for ($i=0; $i<count($ref["ajaxfilter"]); $i++) {
						if (is_array($ref["ajaxfilter"][$i])) {
							$keys = array_keys($ref["ajaxfilter"][$i]);
							$filter = $keys[0];
							$label = $ref["ajaxfilter"][$i][$keys[0]];
						} else {
							$filter = $ref["ajaxfilter"][$i];
							$label = $ref["ajaxfilter"][$i];
						}
						$param .= "&ck_$filter=[{$prefix}{$field}_{$filter}{$sufix}]";
						$ckstr .= "<input type=checkbox id=\"ck_{$prefix}{$field}_{$filter}{$sufix}\" onclick=document.getElementById(this.id.replace('ck_','')).value=this.checked?1:0 CHECKED>$label\n";
						$ckstr .= "<input type=hidden name=\"{$prefix}{$field}_{$filter}{$sufix}\" id=\"{$prefix}{$field}_{$filter}{$sufix}\" value=1>\n";
					}
					$ckstr = "filtrar em: $ckstr\n";
				}
				if (isset($ref["ajaxpath"]))
					$url = str_replace(array("[","]"), array("[{$prefix}","{$sufix}]"), $ref["ajaxpath"]) . (strpos($ref["ajaxpath"],"?")>0 ? "&" : "?") . $param;
				else
					$url = "?modo=xml&field={$field}{$param}";
				$str .= "<script language=\"JavaScript\">\n";
				$str .= "<!--- \n";
				$str .= "obj{$prefix}{$field}{$sufix} = new fieldFilter(\"obj{$prefix}{$field}{$sufix}\", \"{$prefix}{$field}{$sufix}\",\"$url\");\n";
				for ($i=0; $i<count($ref["ajaxaction"]); $i++) {
					$str .= "obj{$prefix}{$field}{$sufix}.add" . ($ref["ajaxaction"][$i]["modo"] == "R" ? "Reset" : "") . "Action(\"" . $ref["ajaxaction"][$i]["action"] . "\");\n";
				}
				if (isset($ref["prop"]["readonly"])) $str .= "obj{$prefix}{$field}{$sufix}.setReadOnly();\n";
				if ($res != null && $res[$field] != "" && $res[$field] != "0") $str .= "obj{$prefix}{$field}{$sufix}.setDefault('" . $res[$field] . "', '" . str_replace("'","\'",$res["filteredtext"]) . "');\n";
				if (isset($size) && is_array($size))
					$str .= "obj{$prefix}{$field}{$sufix}.build(".$size[0].",".$size[1].");\n";
				else if (isset($size) && !is_array($size))
					$str .= "obj{$prefix}{$field}{$sufix}.build($size);\n";
				else
					$str .= "obj{$prefix}{$field}{$sufix}.build(30);\n";
				//$str .= "fn_buildfilteredtext(\"{$prefix}{$field}{$sufix}\",\"$url\",".(isset($size)?$size:30).",1," . ($res != null && $res[$field] != "" && $res[$field] != "0" ? "new Array('" . $res[$field] . "','" . str_replace("'","\'",$res["filteredtext"]) . "')" : "false") . ",".$ref["ajaxaction"].",false," . (isset($ref["prop"]["readonly"])?"true":"false") . ")\n";
				$str .= "// --->\n";
				$str .= "</script>\n";
				if ($ckstr != "") $str .= $ckstr;
			}
		} else if ($ref["type"] == "display") {
			if ($this->ck_print == 1)
				$str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">" . $res[$ref["field"]] . "</span>";
			else 
				$str .= $res[$ref["field"]];
		} elseif ($ref["type"] == "radio" || $ref["type"] == "radio_checkbox") {
			if ($ref["type"] == "radio_checkbox") {
				$str .= "<input type=hidden name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" value=\"\">\n";
			}
			if (isset($ref["qry"]["sql"])) {
				$sql = $ref["qry"]["sql"];
				$ix = $ref["qry"]["ix"];
				$label = $ref["qry"]["label"];
				$res_aux = nc_query($sql);
				for ($j=0; $j<count($res_aux); $j++) {
					if ($ref["type"] == "radio") {
						if ($this->ck_print == 0 || $res[$ref["field"]] == $res_aux[$j][$ix]) {
							$str .= "<input type=radio name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . $res_aux[$j][$ix] . "\" " . (($res != null && $res[$ref["field"]] == $res_aux[$j][$ix]) || ($res == null && $ref["default"] == $res_aux[$j][$ix]) ? "CHECKED" : "") . ">" . $res_aux[$j][$label] . "\n";
						}
					} elseif ($ref["type"] == "radio_checkbox") {
						$str_action = "onclick={$prefix}" . $ref["field"] . "{$sufix}.value=this.checked?this.value:''";
						for ($k=0; $k<count($res_aux); $k++) {
							if ($k != $j) $str_action .= ";{$prefix}" . $ref["field"] . "$k{$sufix}.checked=false";
						}
						$str .= "<input type=checkbox name=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" id=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" value=\"" . $res_aux[$j][$ix] . "\" " . ($res != null && $res[$ref["field"]] == $res_aux[$j][$ix] ? "CHECKED" : "") . " $str_action>" . $res_aux[$j][$label] . "\n";
					}
					if ($j < count($keys)-1) $str .= "<br>\n";
				}
			} else if (isset($ref["list"])) {
				$list = $ref["list"];
				$keys = array_keys($list);
				for ($j=0; $j<count($keys); $j++) {
					if ($ref["type"] == "radio") {
						if ($this->ck_print == 0) {
							$str .= "<input type=radio name=\"{$prefix}" . $ref["field"] . "{$sufix}\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" value=\"" . $keys[$j] . "\" " . (($res != null && $res[$ref["field"]] == $keys[$j]) || ($res == null && isset($ref["default"]) && $ref["default"] == $keys[$j]) ? "CHECKED" : "") . ">";
						}
					} elseif ($ref["type"] == "radio_checkbox") {
						$str_action = "onclick={$prefix}" . $ref["field"] . "{$sufix}.value=this.checked?this.value:''";
						for ($k=0; $k<count($keys); $k++) {
							if ($k != $j) $str_action .= ";{$prefix}" . $ref["field"] . "$k{$sufix}.checked=false";
						}
						$str .= "<input type=checkbox name=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" id=\"{$prefix}" . $ref["field"] . "$j{$sufix}\" value=\"" . $keys[$j] . "\" " . ($res != null && $res[$ref["field"]] == $keys[$j] ? "CHECKED" : "") . " $str_action>";
					}
					if (is_array($list[$keys[$j]])) {
						if ($this->ck_print == 0 || ($res != null && $res[$ref["field"]] == $keys[$j])) {
							$str .= $list[$keys[$j]]["label"];
							if ($list[$keys[$j]]["type"] != null) {
								$str .= ": ";
								if ($this->modo == "update")
									$str .= $this->get_field($list[$keys[$j]], $res);
								else
									$str .= $this->get_field($list[$keys[$j]]);
							}
						}
					} else if ($this->ck_print == 0 || ($res != null && $res[$ref["field"]] == $keys[$j]))
						$str .= $list[$keys[$j]];
					if ($j < count($keys)-1) $str .= "<br>\n";
				}
			}
		} elseif ($ref["type"] == "dropdown") {
			if (isset($ref["ck_qry"]) && 
				$ref["ck_qry"] == 1 && 
				!array_key_exists("multiple", $ref["prop"]) && 
				$res[$ref["field"]] == "")
				$ck_sel = 1;
			else
				$ck_sel = 0;
			if ($this->ck_print == 1) $str .= "<span class=tdtexto_relat id=\"{$prefix}" . $ref["field"] . "{$sufix}\">";
			if ($this->ck_print == 0) $str .= "<select name=\"{$prefix}" . $ref["field"] . "{$sufix}" . (array_key_exists("multiple",$ref["prop"])?"[]":"") . "\" id=\"{$prefix}" . $ref["field"] . "{$sufix}\" $prop_str class=$class>\n";
			if ($res != null && array_key_exists("multiple", $ref["prop"])) {
				$qry = "SELECT " . $ref["field"] . " AS val
					FROM " . $ref["table"] . " 
					WHERE " . $ref["key_field"] . " = " . $res["id"];
				if (is_array($ref["xtra_key"])) {
					$keys = array_keys($ref["xtra_key"]);
					for ($i=0; $i<count($ref["xtra_key"]); $i++) {
						$qry .= " AND " . $keys[$i] . " = '" . $ref["xtra_key"][$keys[$i]] . "'";
					}
				}
				if ($this->debug == 1) echo "<pre>$qry</pre>\n";
				$res_multiple = nc_query($qry);
				$multiple_ref = array();
				for ($i=0; $i<count($res_multiple); $i++) {
					array_push($multiple_ref, $res_multiple[$i]["val"]);
				}
			}
			if (isset($ref["qry"]["sql"])) {
				$sql = $ref["qry"]["sql"];
				$ix = $ref["qry"]["ix"];
				$label = $ref["qry"]["label"];
				$group_label = $ref["qry"]["group_label"];
				if (!isset($ref["qry"]["ajax"]) || $ref["qry"]["ajax"] == 0)
					$res_aux = nc_query($sql);
				else {
					$ck_ajax = 0;
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $ref["qry"]["sql"], $match);
					for ($i=0; $i<count($match[0]); $i++) {
						for ($j=0; $j<count($this->ref); $j++) {
							if (!is_array($this->ref[$j]["field"]) &&
								strtolower(substr($match[0][$i],1,-1)) == strtolower($this->ref[$j]["field"])) {
								$label_origem = $this->ref[$j]["label"];
								$sql = str_replace($match[0][$i], $res[$this->ref[$j]["field"]], $sql);
								$ck_ajax = 1;
							}
							if ($this->ref[$j]["type"] == "entity" &&
								$prefix != null) {
								for ($k=0; $k<count($this->ref[$j]["field"]); $k++) {
									if (strtolower(substr($match[0][$i],1,-1)) == strtolower($this->ref[$j]["field"][$k]["field"])) {
										$label_origem = $this->ref[$j]["field"][$k]["label"];
										$sql = str_replace($match[0][$i], $res[$this->ref[$j]["field"][$k]["field"]], $sql);
										$ck_ajax = 1;
									}
									if ($ck_ajax == 1) break;
								}
							}
						}
					}
					if ($this->modo == "update") {
						$fn = $ref["ajaxfunction"];
						$res_aux = $fn($sql);
					}
					if ($this->modo == "insert" ||
						count($res_aux) == 0) {
						if (array_key_exists("multiple", $ref["prop"]))
							$res_aux = array();
						else
							$res_aux = array(array($ref["qry"]["ix"] => "", $ref["qry"]["label"] => "--Escolha {$label_origem}--"));
					}
				}
				//echo "[" . $this->ck_print . " == 0 && (" . $ref["ck_req"] . " == 0 || " . count($res_aux) . " > 1)]";
				if ($this->ck_print == 0 && 
					(!isset($ref["qry"]["ajax"]) || $ref["qry"]["ajax"] == 0) &&
					($ref["ck_req"] == 0 || count($res_aux) > 1) &&
					!isset($ref["prop"]["size"])) $str .= "<option value=\"\">--Escolha--</option>\n";
				for ($j=0; $j<count($res_aux); $j++) {
					if ($group_label != null && 
						($j == 0 ||
						 $res_aux[$j][$group_label] != $res_aux[$j-1][$group_label])) {
						if ($this->ck_print == 0) $str .= "<optgroup label=\"" . $res_aux[$j][$group_label] . "\">\n";
					}
					if ($this->ck_print == 1 && $res[$ref["field"]] == $res_aux[$j][$ix])
						$str .= $res_aux[$j][$label];
					if ($this->ck_print == 0) {
						$xtra_fields = "";
						if (is_array($ref["qry"]["xtra_fields"])) {
							for ($k=0; $k<count($ref["qry"]["xtra_fields"]); $k++) {
								$xtra_fields = $ref["qry"]["xtra_fields"][$k] . "='" . $res_aux[$j]["xtra_fields"][$k] . "'";
							}
						} elseif ($ref["qry"]["xtra_fields"] != "") {
							$xtra_fields = $ref["qry"]["xtra_fields"] . "='" . $res_aux[$j][$ref["qry"]["xtra_fields"]] . "'";
						}
						if (($res != null && array_key_exists("multiple", $ref["prop"]) && in_array($res_aux[$j][$ix], $multiple_ref)) ||
							($res != null && !array_key_exists("multiple", $ref["prop"]) && $res[$ref["field"]] == $res_aux[$j][$ix]) ||
							(isset($ref["default"]) && $ref["default"] == $res_aux[$j][$ix]) ||
							(isset($ref["default"]) && $ref["default"] == $res_aux[$j][$label])) {
							$str .= "<option $xtra_fields SELECTED value=\"" . $res_aux[$j][$ix] . "\">" . $res_aux[$j][$label] . "</option>\n";
							$ck_sel = 1;
						} else
							$str .= "<option $xtra_fields value=\"" . $res_aux[$j][$ix] . "\">" . $res_aux[$j][$label] . "</option>\n";
					}
					if ($group_label != null && 
						($j == count($res_aux)-1 ||
						 $res_aux[$j][$group_label] != $res_aux[$j+1][$group_label])) {
						if ($this->ck_print == 0) $str .= "</optgroup>\n";
					}
				}
				if ($ref["qry"]["ck_new_entry"] == 1) {
					$str .= "<option value=\"NEW\">OUTRO:</option>\n";
				}
			} else if (isset($ref["list"])) {
				$list = $ref["list"];
				$keys = array_keys($list);
				if ((count($keys) > 1 || $ref["ck_req"] == 0) && 
					$this->ck_print == 0 &&
					!isset($ref["prop"]["size"])) $str .= "<option value=\"\">--Escolha--\n";
				$ck_sel = !array_key_exists("multiple", $ref["prop"]) && $res[$ref["field"]] == "" ? 1 : 0;
				for ($j=0; $j<count($keys); $j++) {
					if ($this->ck_print == 1 && $res[$ref["field"]] == $keys[$j])
						$str .= $list[$keys[$j]];
					if ($this->ck_print == 0) {
						if (($res != null && array_key_exists("multiple", $ref["prop"]) && in_array($keys[$j], $multiple_ref)) ||
							($res != null && !array_key_exists("multiple", $ref["prop"]) && $res[$ref["field"]] == $keys[$j])) {
							$ck_sel = 1;
							$str .= "<option SELECTED value=\"" . $keys[$j] . "\">" . $list[$keys[$j]] . "\n";
						} else
							$str .= "<option value=\"" . $keys[$j] . "\">" . $list[$keys[$j]] . "\n";
					}
				}
			}
			if ($this->ck_print == 0 &&
				$res != null && 
				$ck_sel == 0) {
				$field = $ref["field"];
				$val = isset($res[$field]) ? $res[$field] : "";
				if (isset($ref["ref_qry"]) && $ref["ref_qry"] != null) {
					$sql = $ref["ref_qry"];
					preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
					$ix = "";
					for ($i=0; $i<count($match[0]); $i++) {
						$sql = str_replace($match[0][$i], $res[substr($match[0][$i],1,-1)], $sql);
						$ix .= $res[substr($match[0][$i],1,-1)];
					}
					//echo "<pre>$sql</pre>";
					if (!isset($this->var_bak[$field][$ix])) {
						$res_temp = $ref["ref_function"]($sql);
						$this->var_bak[$field][$ix] = count($res_temp) > 0 ? $res_temp[0][$ref["ref_label"]] : "";
					}
					$str .= "<option SELECTED value=\"$val\">" . $this->var_bak[$field][$ix] . "</option>\n";
				} else if (!array_key_exists("multiple", $ref["prop"]))
					$str .= "<option SELECTED value=\"$val\">$val</option>\n";
			}
			if ($this->ck_print == 0) {
				$str .= "</select>\n";
				if (isset($ref["qry"]) && $ref["qry"]["ck_new_entry"] == 1) {
					$str .= "<input name=\"{$prefix}" . $ref["field"] . "_entry{$sufix}\" id=\"{$prefix}" . $ref["field"] . "_entry{$sufix}\" size=15 style=\"display:none\" class=$class>\n";
				}
			}
			if ($this->ck_print == 1) $str .= "</span>";
		}
		return $str;
	}
	public function build($modo, $step, $vars, $files = array()) {
		if (($modo == "update" && ($step == 0 || $step == 1)) ||
			($modo == "insert" && $step == 1)) 
			$_SESSION["cls_form_vars"] = $vars;
		else if ($modo == "report")
			$_SESSION["cls_form_vars"] = array();
		if ($modo == "delete") $this->ck_recursive = 0;
		$this->modo = $modo;
		$this->step = $step;
		$this->vars = $vars;
		$this->files = $files;
		$this->ck_print = isset($this->vars["ck_print"]) ? 1 : 0;
		if (($modo == "insert" && $step == 1) || 
		    ($modo == "update" && $step == 2) ||
			($modo == "delete" && $step == 0) ||
			($modo == "update" && $step == 0) ||
			($modo == "report" && $step == 0)) 
			$this->build_form();
		if (($modo == "delete" && $step == 1) || 
		    ($modo == "update" && $step == 1) ||
			($modo == "report" && $step == 1)) 
			$this->build_list();
		if ($modo == "insert" && $step == 2) 
			$this->insert();
		if ($modo == "update" && $step == 3) 
			$this->update();
		if ($modo == "delete" && $step == 2) 
			$this->delete();
		if ($modo == "xml") 
			$this->build_xml();
		if ($modo == "csv") 
			$this->build_csv();
	}
	private function build_form($id = null) {
		if ($this->modo == "insert") $titulo = "INSERIR $this->ent";
		if ($this->modo == "report") $titulo = "RELATRIO DE $this->ent";
		if ($this->modo == "delete") $titulo = "EXCLUIR $this->ent";
		if ($this->modo == "update" && $this->ck_print == 0) $titulo = "ATUALIZAR $this->ent";
		if ($this->modo == "update" && $this->ck_print == 1) $titulo = "$this->ent #" . $this->vars["id"];
		if ($this->modo == "update" && $this->step == 2) {
			$str_field = "";
			for ($i=0; $i<count($this->ref); $i++) {
				$field = @$this->ref[$i]["field"];
				$type = @$this->ref[$i]["type"];
				if (isset($this->ref[$i]["table"]) && $this->ref[$i]["table"] != null) {
					$table = $this->ref[$i]["table"];
					$label = $field;
				} elseif (count($this->tab_ref) == 0 || $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] == null) {
					$table = $this->table;
					$label = $field;
				} else {
					$table = $this->tab_ref[$this->ref[$i]["tab_id"]]["table"];
					$label = "{$table}_{$field}";
				}
				if ($type != "entity" && 
					$this->ref[$i]["ck_qry"] == 1) {
					if ($type == "date") {
						$str_field .= "DAY($table.$field) AS dia_$label, MONTH($table.$field) AS mes_$label, YEAR($table.$field) AS ano_$label,\n";
					} elseif ($type == "datetime") {
						$str_field .= "DAY($table.$field) AS dia_$label, MONTH($table.$field) AS mes_$label, YEAR($table.$field) AS ano_$label, datepart(hh, $table.$field) AS hor_$label, datepart(n, $table.$field) AS min_$label,\n";
					} elseif ($type == "daterange") {
						$str_field .= "DAY($table.{$field}_ini) AS dia_{$label}_ini, MONTH($table.{$field}_ini) AS mes_{$label}_ini, YEAR($table.{$field}_ini) AS ano_{$label}_ini,\n";
						$str_field .= "DAY($table.{$field}_fim) AS dia_{$label}_fim, MONTH($table.{$field}_fim) AS mes_{$label}_fim, YEAR($table.{$field}_fim) AS ano_{$label}_fim,\n";
					} elseif ($this->db == "MSSQL" && ($type == "textarea" || $type == "publisher")) {
						$str_field .= "CONVERT(text, $table.$field) AS $label,\n";
					} elseif ($type != "dynamiclist" &&
						($type != "dropdown" || !array_key_exists("multiple", $this->ref[$i]["prop"]))) {
						$str_field .= "$table.$field AS $label,\n";
					}
					if ($type == "radio" &&
						isset($this->ref[$i]["list"])) {
						$keys = array_keys($this->ref[$i]["list"]);
						for ($j=0; $j<count($keys); $j++) {
							if (is_array($this->ref[$i]["list"][$keys[$j]])) {
								$str_field .= $this->ref[$i]["list"][$keys[$j]]["field"] . ",\n";
							}
						}
					}
				}
				// get fields on dir name
				if (isset($this->ref[$i]["file"])) {
					for ($j=0; $j<count($this->ref[$i]["file"]); $j++) {
						preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $this->ref[$i]["file"][$j]["dir"]["O"], $match);
						for ($k=0; $k<count($match[0]); $k++) {
							if (strpos($match[0][$k], ".") === false)
								$temp = "$table." . substr($match[0][$k],1,-1);
							else
								$temp = substr($match[0][$k],1,-1);
							if (strpos($str_field, $temp) === false) 
								$str_field .= "$temp,\n";
						}
					}
				}
			}
			for ($i=0; $i<count($this->ref); $i++) {
				if (isset($this->ref[$i]["ref_qry"])) { 
					preg_match_all("[\[([a-zA-Z0-9_\.])+\]]", $this->ref[$i]["ref_qry"], $match);
					for ($j=0; $j<count($match[0]); $j++) {
						$ix = substr($match[0][$j],1,-1);
						if (strpos($str_field, $ix) === false) $str_field .= "$ix,\n";
					}
				}
			}
			for ($i=0; $i<count($this->tab_ref); $i++) {
				$table = $this->tab_ref[$i]["table"];
				if ($table != null) $str_field .= "CASE WHEN $table.id IS NOT NULL THEN $table.id ELSE 0 END AS id_$table,\n";
			}
			if (is_array($this->pk)) {
				for ($i=0; $i<count($this->pk); $i++) {
					$str_field .= ($i > 0 ? "," : "") . "$this->table." . $this->pk[$i];
				}
			} else {
				$str_field .= "$this->table.$this->pk AS id";
			}
			// join
			$join_str = "";
			for ($i=0; $i<count($this->related); $i++) {
				if (strpos($this->related[$i]["use"],"F") !== false) $join_str .= $this->related[$i]["sql"] . "\n";
			}
			$keys = array_keys($this->list_param);
			if (isset($this->vars[$keys[0]])) {
				$qry = "SELECT $str_field 
					FROM $this->table 
					$join_str
					WHERE\n";
				if (is_array($this->pk)) {
					for ($i=0; $i<count($this->pk); $i++) {
						$qry .= ($i > 0 ? " AND " : "") . "$this->table." . $this->pk[$i] . " = '" . $this->vars[$this->pk[$i]] . "'";
					}
				} else {
					$qry .= "$this->table.$this->pk = '" . $this->vars[$this->pk] . "'";
				}
				if ($this->debug == 1) echo "<pre>$qry</pre>";
				$res_upd = nc_query($qry);
			}
		}
		echo "<HTML><HEAD><TITLE>$titulo</TITLE>\n";
		for ($i=0; $i<count($this->js_ref); $i++) {
			echo "<script language=\"JavaScript\" src=\"$this->js_dir/" . $this->js_ref[$i] . (strpos($this->js_ref[$i],"?")?"&":"?") . "rand=" . rand(1,1000) . "\"></script>\n";
		}
		// refresh dependency
		for ($i=0; $i<count($this->tab_ref); $i++) {
			if ($this->tab_ref[$i]["table"] != null) {
				$temp = array();
				for ($j=0; $j<count($this->ref); $j++) {
					if ($this->ref[$j]["tab_id"] == $i && 
						$this->ref[$j]["type"] != "entity" && 
						$this->ref[$j]["ck_req"] == 1) {
						$temp[count($temp)] = $j;
					}
				}
				for ($j=0; $j<count($temp); $j++) {
					if (count($this->ref[$temp[$j]]["req_dependency"]) > 0) {
						for ($k=0; $k<count($temp); $k++) {
							$this->ref[$temp[$j]]["req_dependency"][count($this->ref[$temp[$j]]["req_dependency"])] = $this->ref[$temp[$k]]["field"];
						}
					}
				}
			}
		}
		// build ckform
		echo "<script language=\"JavaScript\">\n";
		echo "<!--- \n";
		echo "function ckform() {\n";
		if (count($this->publisher_ref) > 0) echo "	feedPublisherContent(this.form);\n";
		echo "	msg = \"\";\n";
		for ($i=0; $i<count($this->form_rule); $i++) {
			echo "	if (" . $this->form_rule[$i]["condition"] . ") \n";
			echo "		msg += \"" . $this->form_rule[$i]["msg"] . "\\n\";\n";
		}
		for ($i=0; $i<count($this->ref); $i++) {
			// define ref
			$ref = $this->ref[$i];
			// define ref field
			if (count($this->tab_ref) > 0) {
				if ($this->tab_ref[$ref["tab_id"]]["table"] != null) $ref["field"] = $this->tab_ref[$ref["tab_id"]]["table"] . "_" . $ref["field"];
				$ref["label"] .= " (" . $this->tab_ref[$ref["tab_id"]]["label"] . ")";
			}
			// check req dependency
			if (count($ref["req_dependency"]) > 0) {
				//print_r($ref["req_dependency"]);
				echo "	if (";
				for ($k=0; $k<count($ref["req_dependency"]); $k++) {
					for ($l=0; $l<count($this->ref); $l++) {
						if ($ref["req_dependency"][$k] == $this->ref[$l]["field"]) {
							if ($this->ref[$l]["type"] == "checkbox") {
								echo "document.formulario." . (count($this->tab_ref) > 0 && $this->tab_ref[$this->ref[$l]["tab_id"]]["table"] != null ? $this->tab_ref[$this->ref[$l]["tab_id"]]["table"] . "_" : "") . $this->ref[$l]["field"] . ".checked || ";
							} else if ($this->ref[$l]["type"] == "text" && isset($this->ref[$l]["mask"])) {
								$c = 0;
								for ($m=0; $m<count($this->ref[$l]["mask"]); $m++) {
									if (is_numeric($this->ref[$l]["mask"][$m])) {
										echo "document.formulario." . (count($this->tab_ref) > 0 && $this->tab_ref[$this->ref[$l]["tab_id"]]["table"] != null ? $this->tab_ref[$this->ref[$l]["tab_id"]]["table"] . "_" : "") . $this->ref[$l]["field"] . "$c.value != \"\" || ";
										$c++;
									}
								}
							} else {
								echo "document.formulario." . (count($this->tab_ref) > 0 && $this->tab_ref[$this->ref[$l]["tab_id"]]["table"] != null ? $this->tab_ref[$this->ref[$l]["tab_id"]]["table"] . "_" : "") . $this->ref[$l]["field"] . ".value != \"\" || ";
							}
						}
					}
				}
				echo "1 == 0) {\n";
			}
			if ($ref["type"] == "entity" && $ref["rel"] == "1XN") {
				for ($j=0; $j<count($this->ent_1XN); $j++) {
					if ($this->ent_1XN[$j] == $i) break;
				}
				$ent_table = $j . $ref["table"];
				echo "	for (var i=0; i<document.formulario.count_$ent_table.value; i++) {\n";
				for ($j=0; $j<count($ref["field"]); $j++) {
					if ($ref["field"][$j]["type"] != "dbfield" &&
						$ref["field"][$j]["type"] != "checkbox" && 
						$ref["field"][$j]["ck_req"] == 1) {
						$ref_entity = $this->ref[$i]["field"][$j];
						if ($ref_entity["type"] == "text" && isset($ref_entity["mask"])) {
							echo "		if (";
							$c = 0;
							for ($k=0; $k<count($ref_entity["mask"]); $k++) {
								if (is_numeric($ref_entity["mask"][$k])) {
									echo ($c>0?" || ":"") . "document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "$c\"+i).value.length != " . $ref_entity["mask"][$k];
									$c++;
								}
							}
							echo ")\n";
							echo "			msg += \"O campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . " no foi corretamente preenchido.\\n\";\n";
						} elseif ($ref_entity["type"] == "radio") {
							echo "		var ck = 0\n";
							echo "		for (var i=0; i<document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i).length; i++) {\n";
							echo "			if (document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i)[i].checked == true) \n";
							echo "				ck = 1;\n";
							echo "		}\n";
							echo "		if (ck == 0) \n";
							echo "			msg += \"O preenchimento do campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . "  obrigatrio.\\n\";\n";
						} elseif ($ref_entity["type"] == "date" || $ref_entity["type"] == "datetime") {
							echo "		if (" . ($ref_entity["ck_req"] == 0 ? "(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "\"+i).value != \"\" || document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "\"+i).value != \"\" || document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "\"+i).value != \"\") && " : "") . "!ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "\"+i).value)) \n";
							echo "			msg += \"O campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . " " . ($ref_entity["ck_req"] == 1 ? " obrigatrio," : "") . " foi preenchido incorretamente.\\n\";\n";
						} elseif ($ref_entity["type"] == "daterange") {
							echo "		if (" . ($ref_entity["ck_req"] == 0 ? "(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i)\"+i).value != \"\" || document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value != \"\" || document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value != \"\") && " : "") . "(document.getElementById(\"" . $ent_table."_".$ref_entity["field"] . ".checked && (!ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value)))) \n";
							echo "			msg += \"O campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . " " . ($ref_entity["ck_req"] == 1 ? " obrigatrio," : "") . " foi preenchido incorretamente.\\n\";\n";
							echo "		if (" . ($ref_entity["ck_req"] == 0 ? "(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i)\"+i).value != \"\" || document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value != \"\" || document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value != \"\") && " : "") . "(document.getElementById(\"" . $ent_table."_".$ref_entity["field"] . ".checked && (!ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_ini\"+i).value) || !ckdata(document.getElementById(\"dia_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value,document.getElementById(\"mes_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value,document.getElementById(\"ano_" . $ent_table."_".$ref_entity["field"] . "_fim\"+i).value)))) \n";
							echo "			msg += \"O campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . " " . ($ref_entity["ck_req"] == 1 ? " obrigatrio," : "") . " foi preenchido incorretamente.\\n\";\n";
						} elseif ($ref_entity["type"] == "dropdown") {
							echo "		if (document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i).value == \"\") \n";
							echo "			msg += \"O preenchimento do campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . "  obrigatrio.\\n\";\n";
						} else {
							echo "		if (document.getElementById(\"".$ent_table."_" . $ref_entity["field"] . "\"+i).value == \"\") \n";
							echo "			msg += \"O preenchimento do campo \\\"" . $ref_entity["label"] . "\\\" na linha \" + (i+1) + \" de " . $this->ref[$i]["label"] . "  obrigatrio.\\n\";\n";
						}
					}
				}
				echo "	}\n";
			} elseif ($ref["type"] != "entity" && 
				$ref["type"] != "dbfield" &&
				$ref["type"] != "checkbox" && 
				$ref["type"] != "date" && 
				$ref["type"] != "datetime" && 
				($this->modo == "insert" || $ref["type"] != "file") &&
				$ref["ck_req"] == 1) {
				if ($ref["type"] == "text" && isset($ref["mask"])) {
					echo "	if (";
					$c = 0;
					for ($k=0; $k<count($ref["mask"]); $k++) {
						if (is_numeric($ref["mask"][$k])) {
							echo ($c>0?" || ":"") . "document.formulario." . $ref["field"] . "$c.value.length != " . $ref["mask"][$k];
							$c++;
						}
					}
					echo ")\n";
					echo "		msg += \"O campo \\\"" . $ref["label"] . "\\\" no foi corretamente preenchido.\\n\";\n";
				} elseif ($ref["type"] == "radio") {
					echo "	var ck = 0\n";
					echo "	for (var i=0; i<document.formulario." . $ref["field"] . ".length; i++) {\n";
					echo "	if (document.formulario." . $ref["field"] . "[i].checked == true) \n";
					echo "		ck = 1;\n";
					echo "	}\n";
					echo "	if (ck == 0) \n";
					echo "		msg += \"O preenchimento do campo \\\"" . $ref["label"] . "\\\"  obrigatrio.\\n\";\n";
					$list = $ref["list"];
					$keys = array_keys($list);
					for ($k=0; $k<count($keys); $k++) {
						if (is_array($list[$keys[$k]]) && $list[$keys[$k]]["type"] == "dropdown") {
							echo "		if (document.formulario." . $ref["field"] . "[$k].checked && document.formulario." . $list[$keys[$k]]["field"] . ".selectedIndex == 0) \n";
							echo "			msg += \"O preenchimento do campo \\\"" . $list[$keys[$k]]["label"] . "\\\"  obrigatrio.\\n\";\n";
						}
						if (is_array($list[$keys[$k]]) && $list[$keys[$k]]["type"] == "text") {
							echo "		if (document.formulario." . $ref["field"] . "[$k].checked && document.formulario." . $list[$keys[$k]]["field"] . ".selectedIndex == \"\") \n";
							echo "			msg += \"O preenchimento do campo \\\"" . $list[$keys[$k]]["label"] . "\\\"  obrigatrio.\\n\";\n";
						}
					}
				} elseif ($ref["type"] == "dropdown") {
					echo "	if (document.formulario." . $ref["field"] . ".value == \"\") \n";
					echo "		msg += \"O preenchimento do campo \\\"" . $ref["label"] . "\\\"  obrigatrio.\\n\";\n";
				} elseif ($ref["type"] == "publisher") {
					echo "	if (document.getElementById(\"obj" . $ref["field"] . "\").contentWindow.document.body.innerText) // IE, Safari\n";
					echo "		var publisher_text = document.getElementById(\"obj" . $ref["field"] . "\").contentWindow.document.body.innerText;\n";
					echo "	else // Firefox\n";
					echo "		var publisher_text = document.getElementById(\"obj" . $ref["field"] . "\").contentWindow.document.body.textContent;\n";
					echo "	if (publisher_text == \"\")\n";
					echo "		msg += \"O preenchimento do campo \\\"" . $ref["label"] . "\\\"  obrigatrio.\\n\";\n";
				} else {
					echo "	if (document.formulario." . $ref["field"] . ".value == \"\") \n";
					echo "		msg += \"O preenchimento do campo \\\"" . $ref["label"] . "\\\"  obrigatrio.\\n\";\n";
				}
			} elseif ($ref["type"] == "date" || $ref["type"] == "datetime") {
				echo "	if (" . ($ref["ck_req"] == 0 ? "(document.formulario.dia_" . $ref["field"] . ".value != \"\" || document.formulario.mes_" . $ref["field"] . ".value != \"\" || document.formulario.ano_" . $ref["field"] . ".value != \"\") && " : "") . "!ckdata(document.formulario.dia_" . $ref["field"] . ".value,document.formulario.mes_" . $ref["field"] . ".value,document.formulario.ano_" . $ref["field"] . ".value)) \n";
				echo "		msg += \"O campo \\\"" . $ref["label"] . "\\\" " . ($ref["ck_req"] == 1 ? " obrigatrio," : "") . " foi preenchido incorretamente.\\n\";\n";
			} elseif ($ref["type"] == "daterange") {
				echo "	if (" . ($ref["ck_req"] == 0 ? "(document.formulario.dia_" . $ref["field"] . "_ini.value != \"\" || document.formulario.mes_" . $ref["field"] . "_ini.value != \"\" || document.formulario.ano_" . $ref["field"] . "_ini.value != \"\") && " : "") . "(document.formulario." . $ref["field"] . ".checked && (!ckdata(document.formulario.dia_" . $ref["field"] . "_ini.value,document.formulario.mes_" . $ref["field"] . "_ini.value,document.formulario.ano_" . $ref["field"] . "_ini.value)))) \n";
				echo "		msg += \"O campo \\\"" . $ref["label"] . "\\\" " . ($ref["ck_req"] == 1 ? " obrigatrio," : "") . " foi preenchido incorretamente.\\n\";\n";
				echo "	if (" . ($ref["ck_req"] == 0 ? "(document.formulario.dia_" . $ref["field"] . "_fim.value != \"\" || document.formulario.mes_" . $ref["field"] . "_fim.value != \"\" || document.formulario.ano_" . $ref["field"] . "_fim.value != \"\") && " : "") . "(document.formulario." . $ref["field"] . ".checked && (!ckdata(document.formulario.dia_" . $ref["field"] . "_ini.value,document.formulario.mes_" . $ref["field"] . "_ini.value,document.formulario.ano_" . $ref["field"] . "_ini.value) || !ckdata(document.formulario.dia_" . $ref["field"] . "_fim.value,document.formulario.mes_" . $ref["field"] . "_fim.value,document.formulario.ano_" . $ref["field"] . "_fim.value)))) \n";
				echo "		msg += \"O campo \\\"" . $ref["label"] . "\\\" " . ($ref["ck_req"] == 1 ? " obrigatrio," : "") . " foi preenchido incorretamente.\\n\";\n";
			}
			if (count($ref["req_dependency"]) > 0) {
				echo "	}\n";
			}
		} // for ($i=0; $i<count($this->ref); $i++) {
		echo "	if (msg != \"\") {\n";
		echo "		alert(msg);\n";
		echo "	} else {\n";
		echo "		Aguarde();\n";
		echo "		document.formulario.submit();\n";
		echo "	}\n";
		echo "}\n";
		echo "function Aguarde(){\n";
		echo "	document.formulario.ok.disabled=true;\n";
		echo "	document.getElementById(\"botao\").innerHTML = \"<span class=aguarde>Aguarde ..</span>\";\n";
		echo "	return true;\n";
		echo "}\n";
		if (count($this->ent_NXN) > 0) {
			echo "function fn_chdisplay_NXN(list) {\n";
			echo "	for (var i=0; i<list.length; i++) {\n";
			echo "		if (document.getElementById(\"table_\"+list[i])) {\n";
			echo "			obj = document.getElementById(\"table_\"+list[i])\n";
			echo "			obj.style.display = obj.style.display == 'none' ? '' : 'none'\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
			echo "function fn_ckall_NXN(ck,list) {\n";
			echo "	for (var i=0; i<list.length; i++) {\n";
			echo "		if (document.getElementById(\"ck_\"+list[i]) && !document.getElementById(\"ck_\"+list[i]).disabled) {\n";
			echo "			document.getElementById(\"ck_\"+list[i]).checked = ck;\n";
			echo "		}\n";
			echo "	}\n";
			echo "	if ((ck && document.getElementById(\"table_\"+list[1]).style.display == '') || (!ck && document.getElementById(\"table_\"+list[1]).style.display == 'none')) fn_chdisplay_NXN(list);\n";
			echo "}\n";
		}
		if (count($this->tab_ref) > 0) {
			echo "function fn_chtab(tab_id) {\n";
			echo "	var tr_ref = new Array();\n";
			for ($i=0; $i<count($this->ref); $i++) {
				if ($i == 0 || 
					$this->ref[$i]["tab_id"] != $this->ref[$i-1]["tab_id"]) 
					echo "	tr_ref[" . $this->ref[$i]["tab_id"] . "] = new Array(); c=0;\n";
				if ($this->ref[$i]["type"] == "entity") {
					echo "	tr_ref[" . $this->ref[$i]["tab_id"] . "][c] = \"{$i}a\"; c++;\n";
					echo "	tr_ref[" . $this->ref[$i]["tab_id"] . "][c] = \"{$i}b\"; c++;\n";
					if ($this->ref[$i]["ck_edicao_global"] == 1) echo "	tr_ref[" . $this->ref[$i]["tab_id"] . "][c] = \"{$i}c\"; c++;\n";
				} else if ($this->ref[$i]["type"] != "hidden" &&
					$this->ref[$i]["ck_hidden"] == 0 &&
					($this->ref[$i]["field_group"] == null || 
					 $i == 0 ||
					 $this->ref[$i]["field_group"] != $this->ref[$i-1]["field_group"])) {
					echo "	tr_ref[" . $this->ref[$i]["tab_id"] . "][c] = $i; c++;\n";
				}
			}
			echo "	for (var i=0; i<tr_ref.length; i++) {\n";
			echo "		document.getElementById(\"tab\"+i).className = (i == tab_id ? \"tdtitulob\" : \"tdtitulo\");\n";
			echo "		for (var j=0; j<tr_ref[i].length; j++) {\n";
			echo "			if (!document.getElementById(\"tr\"+tr_ref[i][j])) alert(\"tr\"+tr_ref[i][j])\n";
			echo "			document.getElementById(\"tr\"+tr_ref[i][j]).style.display = (i == tab_id ? \"\" : \"none\")\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
		}
		if (count($this->hidden_ref) > 0) {
			echo "function fn_displayhidden(ck) {\n";
			echo "	var tr_ref = new Array();\n";
			for ($i=0; $i<count($this->hidden_ref); $i++) {
				echo "	tr_ref[$i] = 'tr" . $this->hidden_ref[$i] . "';\n";
			}
			echo "	for (var i=0; i<tr_ref.length; i++) {\n";
			echo "		document.getElementById(tr_ref[i]).style.display = (ck?'':'none');\n";
			echo "	}\n";
			echo "}\n";
		}
		if ($this->ck_print == 0 && 
			$this->ck_global_form == 1) {
			echo "function fn_ckall_globalform(table,ck) {\n";
			echo "	for (var i=0; i<document.getElementById(\"count_\"+table).value; i++) {\n";
			echo "		document.getElementById(\"ck_\"+table+i).checked = ck;\n";
			echo "	}\n";
			echo "}\n";
			echo "function fn_sync_dropdown_globalform(table,field,ix) {\n";
			echo "	if (document.getElementById(table+\"_\"+field+ix).value == \"\") {\n";
			echo "		document.getElementById(\"comment_\"+table+\"_\"+field+ix).innerHTML = \"\";\n";
			echo "		for (var j=document.getElementById(table+\"_\"+field+ix).length-1; j>= 0; j--) {\n";
			echo "			document.getElementById(table+\"_\"+field+ix).remove(j);\n";
			echo "		}\n";
			echo "		for (var j=0; j<document.getElementById(\"global_\"+table+\"_\"+field).length; j++) {\n";
			echo "			var oOption = document.createElement(\"OPTION\");\n";
			echo "			document.getElementById(table+\"_\"+field+ix).options.add(oOption);\n";
			echo "			oOption.value = document.getElementById(\"global_\"+table+\"_\"+field)[j].value;\n";
			echo "			oOption.text = document.getElementById(\"global_\"+table+\"_\"+field)[j].text;\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
			for ($i=0; $i<count($this->ent_1XN); $i++) {
				$c = $this->ent_1XN[$i];
				$ent_table = $i . $this->ref[$c]["table"];
				echo "function fn_ckalterdropdown_$ent_table(field,ix) {\n";
				echo "	var get_field = ''\n";
				echo "	if (document.getElementById(\"{$ent_table}_\"+field+ix).length != document.getElementById(\"global_{$ent_table}_\"+field).length)\n";
				echo "		var get_field = field\n";
				echo "	else {\n";
				echo "		for (var i=0; i<document.getElementById(\"{$ent_table}_\"+field+ix).length ;i++) {\n";
				echo "			if (document.getElementById(\"{$ent_table}_\"+field+ix)[i].value != document.getElementById(\"global_{$ent_table}_\"+field)[i].value) {\n";
				echo "				var get_field = field\n";
				echo "				break;\n";
				echo "			}\n";
				echo "		}\n";
				echo "	}\n";
				echo "	return get_field\n";
				echo "}\n";
				echo "function fn_apply_$ent_table() {\n";
				echo "	for (var i=0; i<document.getElementById(\"count_$ent_table\").value; i++) {\n";
				echo "		if (document.getElementById(\"ck_$ent_table\"+i).checked) {\n";
				$ref = $this->ref[$c]["ck_edicao_global_ref"];
				for ($j=0; $j<count($this->ref[$c]["field"]); $j++) {
					$field = $this->ref[$c]["field"][$j]["field"];
					$type = $this->ref[$c]["field"][$j]["type"];
					$ck_hidden = $this->ref[$c]["field"][$j]["ck_hidden"];
					if ($type != "hidden" &&
						$type != "file" &&
						$ck_hidden == 0 &&
						(count($ref) == 0 || in_array($field, $ref))) {
						echo "			if (document.getElementById(\"ck_global_{$ent_table}_{$field}\").checked) {\n";
						if ($type == "dropdown") { // sincroniza se houve chamadas ajax
							echo "				var x = fn_ckalterdropdown_$ent_table(\"{$field}\",i);\n";
							echo "				if (x != \"\") fn_sync_dropdown_globalform('{$ent_table}',x,i)\n";
						}
						if ($type == "checkbox") {
							echo "				document.getElementById(\"{$ent_table}_{$field}\"+i).checked = document.getElementById(\"global_{$ent_table}_{$field}\").checked?1:0\n";
						} elseif ($type == "date") {
							echo "				document.getElementById(\"dia_{$ent_table}_{$field}\"+i).value = document.getElementById(\"dia_global_{$ent_table}_{$field}\").value\n";
							echo "				document.getElementById(\"mes_{$ent_table}_{$field}\"+i).value = document.getElementById(\"mes_global_{$ent_table}_{$field}\").value\n";
							echo "				document.getElementById(\"ano_{$ent_table}_{$field}\"+i).value = document.getElementById(\"ano_global_{$ent_table}_{$field}\").value\n";
						} elseif ($type == "dropdown" && array_key_exists("multiple", $this->ref[$c]["field"][$j]["prop"])) {
							echo "				for (var j=0; j<document.getElementById(\"global_{$ent_table}_{$field}\").length; j++) {\n";
							echo "					if (document.getElementById(\"global_{$ent_table}_{$field}\")[j].selected) document.getElementById(\"{$ent_table}_{$field}\"+i)[j].selected = true\n";
							echo "					else document.getElementById(\"{$ent_table}_{$field}\"+i)[j].selected = false\n";
							echo "				}\n";
						} else {
							echo "				document.getElementById(\"{$ent_table}_{$field}\"+i).value = document.getElementById(\"global_{$ent_table}_{$field}\").value\n";
						}
						if ($type == "filteredtext") { // sincroniza dados com objeto ajax
							echo "				document.getElementById(\"nome{$ent_table}_{$field}\"+i).value = document.getElementById(\"nomeglobal_{$ent_table}_{$field}\").value\n";
						}
						echo "			}\n";
					}
				}
				echo "		}\n";
				echo "	}\n";
				echo "}\n";
			}
		}
		if ($this->ck_multiple_entry == 1) {
			echo "function fn_request_entity(table) {\n";
			echo "	var x = prompt(\"Quantas entradas deseja adicionar?\",1)\n";
			echo "	if (x && cknum(x)) {\n";
			echo "		for (var i=0; i<x; i++) {\n";
			echo "			fn_edit_item(table);\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
		}
		echo "// --->\n";
		echo "</script>\n";
		echo "<link rel='STYLESHEET' type='text/css' href='$this->css_path'>\n";
		echo "</HEAD>\n";
		$onload_str = "";
		for ($i=0; $i<count($this->onload_action); $i++) {
			$onload_str .= $this->onload_action[$i] . ";";
		}
		echo "<body bgcolor=White " . ($onload_str != "" ? "onload=\"$onload_str\"" : "") . ">\n";
		if ($this->ck_return_pk == 1 && isset($this->vars["ck_return_pk"])) {
			echo "<iframe id=\"iframe_prompt\" scrolling=no style=\"position:absolute;\n";
			echo "	left:200;\n";
			echo "	top:140;\n";
			echo "	width:180;\n";
			echo "	height:180;\n";
			echo "	background-color:white;\n";
			echo "	border:0;\n";
			echo "	z-index:1\"></iframe>\n";
			echo "<div id=\"div_prompt\" class=dragme style=\"position:absolute;\n";
			echo "	left:200;\n";
			echo "	top:140;\n";
			echo "	width:180;\n";
			echo "	height:180;\n";
			echo "	background-color:silver;\n";
			echo "	border:1px solid black;\n";
			echo "	padding:0;\n";
			echo "	z-index:2\">\n";
			echo "<table width=100% height=100% border=0 cellspacing=0 cellpadding=5 class=tdtitulo>\n";
			echo "<tr height=11>\n";
			echo "<td width=100%></td>\n";
			echo "<td><a href=javascript:void(null) onclick=document.getElementById(\"iframe_prompt\").style.display='none';document.getElementById(\"div_prompt\").style.display='none'><img src=\"$this->img_dir/fechar.gif\" width=11 height=11 border=0></a></td>\n";
			echo "</tr>\n";
			echo "<tr>\n";
			echo "<td colspan=2 width=100% align=center><b>CDIGO GERADO<br>PARA " . strtoupper($this->ck_return_entity == "default" ? $this->ent : $this->ck_return_entity) . ":<br><font color=red>" . $this->vars["ck_return_pk"] . "</font><br>&nbsp;</b></td>\n";
			echo "</tr>\n";
			echo "</table>\n";
			echo "</div>\n";
		}
		echo "<form name=\"formulario\" method=\"POST\" enctype=\"multipart/form-data\">\n";
		echo "<table width=$this->form_width border=0 cellspacing=3 cellpadding=5>\n";
		if ($this->ck_display_title == 1) {
			echo "<tr><td colspan=2 class=titulo>$titulo</td></tr>\n";
			if ($this->ck_print == 0) {
				echo "<tr><td colspan=2 background=$this->img_dir/pontilhado.gif><img src=$this->img_dir/x.gif width=1 height=5 border=0></td></tr>\n";
				echo "<tr><td colspan=2 class=obrigatorio><img src=$this->img_dir/obrigatorio1.gif width=23 height=11 border=0 align=middle>campos obrigatrios</td></tr>\n";
			}
		}
		if (count($this->tab_ref) == 0)
			echo "<tr><td colspan=2 background=$this->img_dir/pontilhado.gif><img src=$this->img_dir/x.gif width=1 height=5 border=0></td></tr>\n";
		else {
			echo "<tr><td colspan=2 style=padding:0;border:0>\n";
			echo "<table width=100% border=0 cellspacing=0 cellpadding=0><tr>\n";
			for ($i=0; $i<count($this->tab_ref); $i++) {
				if ($i>0) echo "<td style=\"width:3px\"></td>\n";
				echo "<td id=\"tab$i\" align=center class=tdtitulo" . ($i==0?"b":"") . " onclick=fn_chtab($i) style=\"cursor:pointer;padding:5px;border-bottom:0;\">" . $this->tab_ref[$i]["label"] . "</td>\n";
			}
			echo "</tr></table>\n";
			echo "</td>\n";
			echo "</tr>\n";
		}
		for ($i=0; $i<count($this->ref); $i++) {
			if ($this->ref[$i]["type"] == "entity" && $this->ref[$i]["rel"] == "1XN") {
				for ($j=0; $j<count($this->ent_1XN); $j++) {
					if ($this->ent_1XN[$j] == $i) break;
				}
				$ent_table = $j . $this->ref[$i]["table"];
				if ($this->ck_print == 0) {
					echo "<tr id=\"tr{$i}a\" " . ($this->ref[$i]["tab_id"] > 0 || $this->ref[$i]["ck_hidden"] == 1 ? "style=display:none" : "") . ">\n";
					echo "<td colspan=2 style=padding:0>\n";
					echo "<table width=100% border=0 cellspacing=0 cellpadding=5>\n";
					echo "<tr class=tdtitulo>\n";
					echo "<td valign=top class=tdtitulo>" . $this->ref[$i]["label"] . ":</td>\n";
					if ($this->ref[$i]["ck_multiple_entry"] == 1)
						$action_str = "fn_request_entity(\"{$ent_table}\")";
					else
						$action_str = "fn_edit_item(\"{$ent_table}\")";
					if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
					echo "<td width=20 nowrap style=\"width:20px; border-left:3px solid white;\"><a class=update href=javascript:$action_str>[+]</a></td>\n";
					echo "</tr>\n";
					echo "</table>\n";
					echo "</td></tr>\n";
				}
				if ($this->ck_print == 0 && $this->ref[$i]["ck_edicao_global"] == 1) {
					$ref = $this->ref[$i]["ck_edicao_global_ref"];
					echo "<tr id=\"tr{$i}c\" " . ($this->ref[$i]["tab_id"] > 0 || $this->ref[$i]["ck_hidden"] == 1 ? "style=display:none" : "") . " class=tdtitulo>\n";
					echo "<td colspan=2>\n";
					echo "<img src=\"$this->img_dir/update.gif\" width=23 height=11 border=0><a href=javascript:void(null) onclick=document.getElementById(\"indexacao_global_$ent_table\").style.display=document.getElementById(\"indexacao_global_$ent_table\").style.display=='none'?'':'none' class=update>Edio Global:</a><br>\n";
					echo "<table id=\"indexacao_global_$ent_table\" width=100% border=0 cellspacing=0 cellpadding=5 style=display:none>\n";
					echo "<tr class=tdtexto>\n";
					$count = count($ref) == 0 ? count($this->ref[$i]["field"]) : count($ref);
					// check split point
					$c = 0;
					for ($j=0; $j<$count; $j++) {
						if ($this->ref[$i]["field"][$j]["type"] != "hidden" &&
							$this->ref[$i]["field"][$j]["type"] != "file" &&
							$this->ref[$i]["field"][$j]["ck_hidden"] == 0 &&
							(count($ref) == 0 || in_array($field, $ref))) $c++;
					}
					if (count($ref) == 0)
						$split = ceil($c/2);
					// draw form
					$c = 0;
					for ($j=0; $j<$count; $j++) {
						if ($j == 0 ||
							$c == $split) echo "<td width=50% valign=top>\n";
						if (count($ref) == 0) 
							$ix = $j;
						else {
							for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
								if ($ref[$j] == $this->ref[$i]["field"][$k]["field"]) {
									$ix = $k;
									break;
								}
							}
						}
						$field = $this->ref[$i]["field"][$ix]["field"];
						$label = $this->ref[$i]["field"][$ix]["label"];
						if ($this->ref[$i]["field"][$ix]["type"] != "hidden" &&
							$this->ref[$i]["field"][$ix]["type"] != "file" &&
							$this->ref[$i]["field"][$ix]["ck_hidden"] == 0 &&
							(count($ref) == 0 || in_array($field, $ref))) {
							$c++;
							echo "<input type=checkbox id=\"ck_global_{$ent_table}_{$field}\" name=\"ck_global_{$ent_table}_{$field}\" value=1 onclick=document.getElementById('{$field}_{$ent_table}div').style.display=this.checked?'':'none' " . (count($ref) == 1 ? "style=\"display:none\" CHECKED" : "") . ">$label<br>\n";
							echo "<div id=\"{$field}_{$ent_table}div\" style=\"display:none;padding-left:4px\">\n";
							if (isset($this->ref[$i]["field"][$ix]["comment_before"])) echo $this->ref[$i]["field"][$ix]["comment_before"] . "\n";
							echo $this->get_field($this->ref[$i]["field"][$ix], null, "global_{$ent_table}_");
							echo "<span id=\"comment_global_{$ent_table}_{$field}\">";
							if (isset($this->ref[$i]["field"][$ix]["comment"])) echo $this->ref[$i]["field"][$ix]["comment"];
							echo "</span>\n";
							echo "<br>";
							echo "</div>\n";
						}
						if ($j == $count-1 ||
							$c == $split) echo "</td>\n";
					}
					echo "</tr>\n";
					echo "<tr>\n";
					echo "	<td valign=top class=tdtexto>\n";
					echo "	<input type=checkbox onclick=fn_ckall_globalform('$ent_table',this.checked) CHECKED>MARCAR/DESMARCAR TODAS\n";
					echo "	<input type=button class=submit value=\"Aplicar\" style=width:50px onclick=fn_apply_$ent_table()>\n";
					echo "	</td>\n";
					echo "</tr>\n";
					echo "</table>\n";
					echo "</td></tr>\n";
				} // if ($this->ck_print == 0 && $this->ref[$i]["ck_edicao_global"] == 1) {
				echo "<tr id=\"tr{$i}b\" " . ($this->ref[$i]["tab_id"] > 0 || $this->ref[$i]["ck_hidden"] == 1 ? "style=display:none" : "") . "><td colspan=2 style=padding:0>\n";
				echo "<div id=\"readroot_{$ent_table}\" style=\"" . ($this->ref[$i]["path"] != null ? "padding-bottom:3px;" : "") . "display:" . ($this->ck_print == 0 ? "none" : "") . "\">\n";
				if ($this->ck_print == 0 && $this->ref[$i]["ck_edicao_global"] == 1) {
					echo "<table border=0 cellspacing=0 cellpadding=0><tr>\n";
					echo "<td valign=top><input id=\"ck_{$ent_table}\" type=checkbox CHECKED></td><td>\n";
				}
				if ($this->ref[$i]["path"] != null) {
					$temp = file($this->ref[$i]["path"]);
					$tableaux_str = "";
					for ($j=0; $j<count($temp); $j++) {
						$tableaux_str .= $temp[$j];
					}
					if ($this->ck_print == 0) {
						$str = $tableaux_str;
						for ($j=0; $j<count($this->ref[$i]["field"]); $j++) {
							$field = $this->ref[$i]["field"][$j]["field"];
							if ($this->ref[$i]["field"][$j]["type"] == "hidden")
								$str = str_replace("[$field]", $this->get_field($this->ref[$i]["field"][$j], null, $ent_table . "_"), $str);
							else {
								$temp = "";
								if (isset($this->ref[$i]["field"][$j]["comment_before"])) $temp .= $this->ref[$i]["field"][$j]["comment_before"] . "\n";
								$temp .= $this->get_field($this->ref[$i]["field"][$j], null, $ent_table . "_");
								$temp .= "<span id=\"comment_{$ent_table}_{$field}\">";
								if (isset($this->ref[$i]["field"][$j]["comment"])) $temp .= $this->ref[$i]["field"][$j]["comment"];
								$temp .= "</span>";
								$str = str_replace("[$field]", $temp, $str);
							}
						}
						$action_str = "fn_delete_item('$ent_table',this.id.replace('delete',''))";
						if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
						$str = str_replace("[DELETE]", "<input type=button id=\"delete\" onclick=$action_str value=[-] class=submit>", $str);
					} else {
						$key_field = $this->ref[$i]["key_field"];
						$str_field = "";
						for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
							$str_field .= ($k>0?",":"") . $this->ref[$i]["field"][$k]["field"];
						}
						if (isset($this->ref[$i]["entity_trava"])) {
							for ($k=0; $k<count($this->ref[$i]["entity_trava"]); $k++) {
								$str_field .= "," . $this->ref[$i]["entity_trava"][$k]["field"];
							}
						}
						$qry = "SELECT id, $str_field FROM " . $this->ref[$i]["table"] . " WHERE $key_field = " . $this->vars["id"];
						if ($this->debug == 1) echo "<pre>$qry</pre>";
						$res_aux = nc_query($qry);
						for ($j=0; $j<count($res_aux); $j++) {
							for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
								if ($this->ref[$i]["field"][$k]["type"] != "hidden") {
									$field = $this->ref[$i]["field"][$k]["field"];
									$str = str_replace("[$field]", $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $this->ref[$i]["table"] . "_", null), $str);
								}
							}
						}
					} // if ($this->ref[$i]["path"] != null) {
					echo $str;
				} else {
					echo "<table border=0 cellspacing=3 cellpadding=5>\n";
					if ($this->ref[$i]["entity_layout"] == "H") {
						echo "<tr id=\"titulo_{$ent_table}\" style=\"display:" . ($this->ck_print == 0 ? "none" : "") . "\">\n";
						$c = 0;
						for ($j=0; $j<count($this->ref[$i]["field"]); $j++) {
							$c++;
							if ($j == count($this->ref[$i]["field"])-1 || 
								$this->ref[$i]["field"][$j]["label"] != $this->ref[$i]["field"][$j+1]["label"]) {
								echo "<td colspan=$c class=" . ($this->ck_print == 1 ? "tdtitulo_relat style=padding-left:2px" : "tdtitulob") . " " . ($c > 1 ? "align=center" : "") . " " . ($this->ref[$i]["field"][$j]["title"] != null ? "title=\"" . $this->ref[$i]["field"][$j]["title"] . "\"" : "") . ">" . $this->ref[$i]["field"][$j]["label"] . "</td>\n";
								$c = 0;
							}
						}
						echo "</tr>\n";
						if ($this->ck_print == 0) {
							echo "<tr>\n";
							for ($j=0; $j<count($this->ref[$i]["field"]); $j++) {
								if ($this->ref[$i]["field"][$j]["type"] == "hidden")
									echo $this->get_field($this->ref[$i]["field"][$j], null, $ent_table . "_");
								else {
									echo "<td class=tdtextob " . ($this->ref[$i]["field"][$j]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top nowrap>\n";
									if (isset($this->ref[$i]["field"][$j]["comment_before"])) echo $this->ref[$i]["field"][$j]["comment_before"] . "\n";
									echo $this->get_field($this->ref[$i]["field"][$j], null, $ent_table . "_");
									if (isset($this->ref[$i]["field"][$j]["comment"])) echo $this->ref[$i]["field"][$j]["comment"];
									echo "</td>\n";
								}
							}
							$action_str = "fn_delete_item('$ent_table',this.id.replace('delete',''))";
							if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
							if ($this->ck_print == 0) {
								echo "<td nowrap class=tdtextob valign=top width=30><input type=button id=\"delete\" onclick=$action_str value=[-] class=submit></td>\n";
							}
							echo "</tr>\n";
						} else {
							$key_field = $this->ref[$i]["key_field"];
							$str_field = "";
							for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
								$str_field .= ($k>0?",":"") . $this->ref[$i]["field"][$k]["field"];
							}
							if (isset($this->ref[$i]["entity_trava"])) {
								for ($k=0; $k<count($this->ref[$i]["entity_trava"]); $k++) {
									$str_field .= "," . $this->ref[$i]["entity_trava"][$k]["field"];
								}
							}
							$qry = "SELECT id, $str_field FROM " . $this->ref[$i]["table"] . " WHERE $key_field = " . $this->vars["id"];
							if ($this->debug == 1) echo "<pre>$qry</pre>";
							$res_aux = nc_query($qry);
							for ($j=0; $j<count($res_aux); $j++) {
								echo "<tr>\n";
								for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
									if ($this->ref[$i]["field"][$k]["type"] != "hidden") {
										echo "<td class=tdtextob valign=top style=padding-left:0 nowrap>\n";
										echo $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $this->ref[$i]["table"] . "_", null);
										echo "</td>\n";
									}
								}
								echo "</tr>\n";
							}
						} // if ($this->ref[$i]["path"] != null) {
					} else if ($this->ref[$i]["entity_layout"] == "V") {
						if ($this->ck_print == 0) {
							for ($j=0; $j<count($this->ref[$i]["field"]); $j++) {
								echo "<tr>\n";
								if ($this->ref[$i]["field"][$j]["type"] == "hidden")
									echo $this->get_field($this->ref[$i]["field"][$j], null, $ent_table . "_");
								else {
									echo "<td class=tdtitulo valign=top width=130>\n";
									if ($this->ref[$i]["field"][$j]["type"] == "checkbox") 
										echo "&nbsp;";
									else
										echo $this->ref[$i]["field"][$j]["label"];
									echo "</td>\n";
									echo "<td class=tdtexto " . ($this->ref[$i]["field"][$j]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top width=400 nowrap>\n";
									if (isset($this->ref[$i]["field"][$j]["comment_before"])) echo $this->ref[$i]["field"][$j]["comment_before"] . "\n";
									echo $this->get_field($this->ref[$i]["field"][$j], null, $ent_table . "_");
									if (isset($this->ref[$i]["field"][$j]["comment"])) echo $this->ref[$i]["field"][$j]["comment"];
									echo "</td>\n";
								}
								if ($j == 0 && $this->ck_print == 0) {
									$action_str = "fn_delete_item('$ent_table',this.id.replace('delete',''))";
									if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
									echo "<td nowrap valign=top width=30><input type=button id=\"delete\" onclick=$action_str value=[-] class=submit></td>\n";
								}
								echo "</tr>\n";
							}
						} // if ($this->ref[$i]["path"] != null) {
					}
					echo "</table>\n";
				}
				echo "<input type=hidden name=\"id_{$ent_table}\" id=\"id_{$ent_table}\" value=0>\n";
				if ($this->ck_print == 0 && $this->ref[$i]["ck_edicao_global"] == 1) {
					echo "</td></tr></table>\n";
				}
				echo "</div>\n";
				if ($this->modo == "update" && $this->ck_print == 0) {
					$res_aux = $this->get_res_aux($this->ref[$i]);
					for ($j=0; $j<count($res_aux); $j++) {
						$ck_trava = 0;
						if (isset($this->ref[$i]["entity_trava"])) {
							for ($k=0; $k<count($this->ref[$i]["entity_trava"]); $k++) {
								$field = $this->ref[$i]["entity_trava"][$k]["field"];
								$val = $this->ref[$i]["entity_trava"][$k]["val"];
								if ($res_aux[$j][$field] == $val) $ck_trava = 1;
							}
						}
						echo "<span id=\"$ent_table$j\" " . ($this->ref[$i]["path"] != null ? "style=\"padding-bottom:3px\"" : "") . ">\n";
						if ($this->ck_print == 0 && $this->ref[$i]["ck_edicao_global"] == 1) {
							echo "<table border=0 cellspacing=0 cellpadding=0>\n";
							echo "<tr><td valign=top class=tdtexto style=\"padding:0; border-top:5px white solid\"><input id=\"ck_{$ent_table}{$j}\" name=\"ck_{$ent_table}{$j}\" type=checkbox CHECKED><span class=spantexto>" . (is_numeric($res_aux[$j][$this->pk]) ? str_pad($res_aux[$j][$this->pk],7,'0','LEFT') : $res_aux[$j][$this->pk]) . "</span></td></tr>\n";
							echo "<tr><td>\n";
						}
						if ($this->ref[$i]["path"] != null) {
							if ($this->ck_print == 0) {
								$str = $tableaux_str;
								$str = ereg_replace("id=[a-zA-Z0-9_]+", "\\0".$j, $str);
								$str = ereg_replace("id=\\\"[a-zA-Z0-9_]+", "\\0".$j, $str);
								$str = ereg_replace("id=\\'[a-zA-Z0-9_]+", "\\0".$j, $str);
								for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
									$field = $this->ref[$i]["field"][$k]["field"];
									if ($this->ref[$i]["field"][$k]["type"] == "hidden")
										$str = str_replace("[$field]", $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $ent_table . "_", $j), $str);
									else {
										$temp = "";
										if (isset($this->ref[$i]["field"][$k]["comment_before"])) $temp .= $this->ref[$i]["field"][$k]["comment_before"] . "\n";
										$temp .= $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $ent_table . "_", $j);
										$temp .= "<span id=\"comment_{$ent_table}_{$field}{$j}\">";
										if (isset($this->ref[$i]["field"][$k]["comment"])) $temp .= $this->ref[$i]["field"][$k]["comment"];
										$temp .= "</span>";
										$str = str_replace("[$field]", $temp, $str);
									}
								}
								$action_str = "fn_delete_item('$ent_table',this.id.replace('delete',''))";
								if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
								$str = str_replace("[DELETE]", "<input type=button id=\"delete{$j}\" onclick=$action_str value=[-] class=submit>", $str);
							} else {
								$key_field = $this->ref[$i]["key_field"];
								$str_field = "";
								for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
									$str_field .= ($k>0?",":"") . $this->ref[$i]["field"][$k]["field"];
								}
								if (isset($this->ref[$i]["entity_trava"])) {
									for ($k=0; $k<count($this->ref[$i]["entity_trava"]); $k++) {
										$str_field .= "," . $this->ref[$i]["entity_trava"][$k]["field"];
									}
								}
								$qry = "SELECT id, $str_field FROM " . $this->ref[$i]["table"] . " WHERE $key_field = " . $this->vars["id"];
								if ($this->debug == 1) echo "<pre>$qry</pre>";
								$res_aux = nc_query($qry);
								for ($k=0; $k<count($res_aux); $k++) {
									for ($l=0; $l<count($this->ref[$i]["field"]); $l++) {
										if ($this->ref[$i]["field"][$l]["type"] != "hidden") {
											$field = $this->ref[$i]["field"][$l]["field"];
											$str = str_replace("[$field]", $this->get_field($this->ref[$i]["field"][$l], $res_aux[$j], $this->ref[$i]["table"] . "_", $j), $str);
										}
									}
								}
							} // if ($this->ref[$i]["path"] != null) {
							echo $str;
						} else {
							echo "<table border=1 cellspacing=3 cellpadding=5>\n";
							if ($this->ref[$i]["entity_layout"] == "H") {
								echo "<tr id=\"titulo_{$ent_table}{$j}\" style=\"display:" . ($this->ck_print == 0 && $j > 0 ? "none" : "") . "\">\n";
								$c = 0;
								for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
									$c++;
									if ($k == count($this->ref[$i]["field"])-1 || 
										$this->ref[$i]["field"][$k]["label"] != $this->ref[$i]["field"][$k+1]["label"]) {
										echo "<td colspan=$c class=" . ($this->ck_print == 1 ? "tdtitulo_relat style=padding-left:2px" : "tdtitulob") . " " . ($c > 1 ? "align=center" : "") . " " . ($this->ref[$i]["field"][$k]["title"] != null ? "title=\"" . $this->ref[$i]["field"][$k]["title"] . "\"" : "") . ">" . $this->ref[$i]["field"][$k]["label"] . "</td>\n";
										$c = 0;
									}
								}
								echo "</tr>\n";
								if ($this->ck_print == 0) {
									echo "<tr>\n";
									for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
										if ($this->ref[$i]["field"][$k]["type"] == "hidden")
											echo $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $ent_table . "_", $j);
										else {
											echo "<td class=tdtextob " . ($this->ref[$i]["field"][$k]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top nowrap>\n";
											if (isset($this->ref[$i]["field"][$k]["comment_before"])) echo $this->ref[$i]["field"][$k]["comment_before"] . "\n";
											echo $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $ent_table . "_", $j);
											if (isset($this->ref[$i]["field"][$k]["comment"])) echo $this->ref[$i]["field"][$k]["comment"] . "\n";
											echo "</td>\n";
										}
									}
									$action_str = "fn_delete_item('$ent_table',this.id.replace('delete',''))";
									if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
									if ($this->ck_print == 0) {
										echo "<td nowrap class=tdtextob valign=top width=30><input type=button id=\"delete{$j}\" onclick=$action_str value=[-] class=submit></td>\n";
									}
									echo "</tr>\n";
								}
							} else if ($this->ref[$i]["entity_layout"] == "V") {
								for ($k=0; $k<count($this->ref[$i]["field"]); $k++) {
									if ($this->ref[$i]["field"][$k]["type"] == "hidden")
										echo $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $ent_table . "_", $j);
									else {
										echo "<tr>\n";
										//echo "<td width=130 class=tdtitulo" . ($this->ck_print == 1 ? "_relat" : "") . " valign=top>\n";
										echo "<td width=130 valign=top class=tdtitulo" . ($this->ck_print == 1 ? "_relat" : "") . " " . ($this->ref[$i]["field"][$k] == 1 ? "style=text-indent:-20px;padding-left:25px" : "") . ">" . ($this->ref[$i]["field"][$k]["type"] != "checkbox" ? ($this->ref[$i]["field"][$k]["ck_req"] == 1 && $this->ck_print == 0 ? "<img src=$this->img_dir/obrigatorio.gif width=19 height=11 border=0 align=absmiddle>" : "") . $this->ref[$i]["field"][$k]["label"] . ":" : "&nbsp;");
										echo "</td>\n";
										echo "<td class=tdtexto " . ($this->ref[$i]["field"][$k]["type"] == "filteredtext" ? "width=100%" : "") . " valign=top width=400 nowrap>\n";
										if (isset($this->ref[$i]["field"][$k]["comment_before"])) echo $this->ref[$i]["field"][$k]["comment_before"] . "\n";
										echo $this->get_field($this->ref[$i]["field"][$k], $res_aux[$j], $ent_table . "_", $j);
										if (isset($this->ref[$i]["field"][$k]["comment"])) echo $this->ref[$i]["field"][$k]["comment"];
										echo "</td>\n";
										if ($k == 0 && $this->ck_print == 0) {
											$action_str = "fn_delete_item('$ent_table',this.id.replace('delete',''))";
											if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
											echo "<td nowrap valign=top width=30><input type=button id=\"delete\" onclick=$action_str value=[-] class=submit></td>\n";
										}
										echo "</tr>\n";
									}
								}
							}
							echo "</table>\n";
						}
						if ($this->ck_print == 0 && $this->ref[$i]["ck_edicao_global"] == 1) {
							echo "</td></tr></table>\n";
						}
						echo "<input type=hidden name=\"id_{$ent_table}{$j}\" id=\"id_{$ent_table}{$j}\" value=" . $res_aux[$j]["id"] . ">\n";
						echo "</span>\n";
					} // for ($j=0;$j<count($res_aux);$j++) {
				} // if ($this->modo == "update") {
				echo "<span id=\"tableaux_{$ent_table}\"></span>\n";
				echo "<input type=hidden name=\"count_{$ent_table}\" id=\"count_{$ent_table}\" value=" . ($this->modo == "insert" ? 0 : count($res_aux)) . ">\n";
				echo "<input type=hidden name=\"delete_list_{$ent_table}\" id=\"delete_list_{$ent_table}\" value=0>\n";
				echo "</td></tr>\n";
			} elseif ($this->ref[$i]["type"] == "entity" && $this->ref[$i]["rel"] == "NXN") {
				$table = $i . $this->ref[$i]["table"];
				$label = $this->ref[$i]["entity_label"];
				$cols = $this->ref[$i]["entity_cols"];
				preg_match_all("[\[([a-zA-Z0-9_])+\]]", $this->ref[$i]["entity_qry"], $match);
				$qry = $this->ref[$i]["entity_qry"];
				for ($k=0; $k<count($match[0]); $k++) {
					$ix = substr($match[0][$k],1,-1);
					if (isset($res_upd)) {
						if ($ix == "id" && count($this->tab_ref) > 0 && $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] != null)
							$val = $res_upd[0]["id_" . $this->tab_ref[$this->ref[$i]["tab_id"]]["table"]];
						else
							$val = $res_upd[0][$ix];
					} else if ($ix == "id")
						$val = 0;
					else 
						$val = "";
					$qry = str_replace($match[0][$k], $val, $qry);
				}
				//$qry = str_replace("[id]", ($this->modo == "insert" || $this->vars[$this->pk] == "" ? 0 : $this->vars[$this->pk]), $this->ref[$i]["entity_qry"]);
				//$field_list = $this->ref[$i]["entity_field"];
				$field_list = $this->ref[$i]["field"];
				if (isset($this->ref[$i]["entity_group"])) {
					$entity_group = $this->ref[$i]["entity_group"];
					$ck_group = 1;
				} else {
					$ck_group = 0;
				}
				$entity_groupby_ck = $this->ref[$i]["entity_groupby_ck"];
				if ($this->debug == 1) echo "<pre>$qry</pre>";
				$res_aux = nc_query($qry);
				echo "<tr id=\"tr{$i}a\" " . ($this->ref[$i]["tab_id"] > 0 || $this->ref[$i]["ck_hidden"] == 1 ? "style=display:none" : "") . ">\n";
				echo "<td colspan=2 class=tdtitulo" . ($this->ck_print == 1 ? "_relat" : "") . ">" . $this->ref[$i]["label"] . ":</td>\n";
				echo "</tr>\n";
				echo "<tr id=\"tr{$i}b\" " . ($this->ref[$i]["tab_id"] > 0 || $this->ref[$i]["ck_hidden"] == 1 ? "style=display:none" : "") . ">\n";
				echo "<td class=tdtextob valign=top colspan=2 style=padding:0>\n";
				echo "<table width=100% border=0 cellspacing=3 cellpadding=5>\n";
				$c = 0;
				$group_bak = "";
				for ($j=0; $j<count($res_aux); $j++) {
					if ($this->ck_print == 0 || $res_aux[$j]["ck"] == 1) {
						if ($ck_group == 1 && 
							($j==0 || 
							 ($entity_groupby_ck == 1 && $res_aux[$j]["ck"] != $res_aux[$j-1]["ck"]) || 
							  $res_aux[$j][$entity_group] != $group_bak)) {
							$group_bak = $res_aux[$j][$entity_group];
							$list = "0";
							for ($k=$j; $k<count($res_aux); $k++) {
								if ($res_aux[$j][$entity_group] != $res_aux[$k][$entity_group] ||
									$res_aux[$j]["ck"] != $res_aux[$k]["ck"]) break;
								$list .= ",'$table$k'";
							}
							$action_str = "fn_ckall_NXN(this.checked, new Array($list))";
							if (isset($this->ref[$i]["prop"]["onclick"])) $action_str .= ";" . $this->ref[$i]["prop"]["onclick"];
							echo "<tr style=cursor:pointer onclick=\"fn_chdisplay_NXN(new Array($list))\">\n";
							echo "<td class=tdtexto" . ($this->ck_print == 1 ? "_relat" : "") . " colspan=$cols>\n";
							if ($this->ck_print == 0) echo "<input type=checkbox onclick=\"$action_str\">\n";
							echo $res_aux[$j][$entity_group] . ($res_aux[$j]["ck"] == 0 && $this->modo == "update" && $entity_groupby_ck == 1 ? " (NO SELECIONADOS: clique para abrir)" : "") . "\n";
							echo "</td>\n";
							echo "</tr>\n";
							$c = 0;
						}
						$ck_hidden = ($this->modo == "update" && $res_aux[$j]["ck"] == 0 && $ck_group == 1 && $entity_groupby_ck == 1 ? 1 : 0);
						if ($c%$cols == 0) echo "<tr " . ($cols == 1 && $ck_hidden == 1 ? "style=display:none" : "") . " " . ($cols == 1 ? "id=\"table_$table$j\"" : "") . ">\n";
						echo "<td valign=top class=" . ($this->ck_print == 1 ? "tdtexto_relat" : "tdtextob") . " valign=top style=\"text-indent:-20px;padding-left:25px" . ($cols > 1 && $ck_hidden == 1 ? ";display:none" : "") . "\" " . ($cols > 1 ? "id=\"table_$table$j\"" : "") . " width=" . round(100/$cols) . "%>\n";
						$ck_trava = 0;
						if (isset($this->ref[$i]["entity_trava"])) {
							for ($k=0; $k<count($this->ref[$i]["entity_trava"]); $k++) {
								$field = $this->ref[$i]["entity_trava"][$k]["field"];
								$val = $this->ref[$i]["entity_trava"][$k]["val"];
								if ($res_aux[$j][$field] == $val) $ck_trava = 1;
							}
						}
						$prop_str = "";
						if ($res_aux[$j]["ck"] == 1) 
							$prop_str .= " CHECKED";
						if ($ck_trava == 1 || $this->ck_print == 1)
							$prop_str .= " disabled";
						else if (isset($this->ref[$i]["prop"]["onclick"])) 
							$prop_str .= " onclick=\"".$this->ref[$i]["prop"]["onclick"]."\"";
						if ($res_aux[$j][$field_list[0]["field"]] == "") 
							$prop_str .= " disabled";
						echo "<input type=checkbox name=\"{$table}{$j}\" id=\"ck_$table$j\" value=1 $prop_str><span id=\"comment_$table$j\">" . $res_aux[$j][$label] . "</span>\n";
						if ($ck_trava == 1 && $res_aux[$j]["ck"] == 1) echo "<input type=hidden name={$table}{$j} value=1>\n";
						echo "<input type=hidden name={$table}_bak{$j} value=" . $res_aux[$j]["ck"] . ">\n";
						for ($k=0; $k<count($field_list); $k++) {
							$field = $field_list[$k]["field"];
							echo "<input type=hidden name=\"{$table}_{$field}{$j}\" id=\"{$table}_{$field}{$j}\" value=\"" . $res_aux[$j][$field] . "\">\n";
						}
						echo "</td>\n";
						if ($j == count($res_aux)-1 || $c%$cols == $cols-1) echo "</tr>\n";
						$c++;
					}
				} // for ($j=0; $j<count($res_aux); $j++) {
				if ($c == 0) {
					echo "<tr>\n";
					echo "<td class=tdtexto" . ($this->ck_print == 1 ? "_relat" : "b") . " valign=top colspan=$cols>\n";
					if ($this->ck_print == 1) 
						echo "Nenhum evento selecionado\n";
					elseif ($this->ck_print == 0) 
						echo "No h eventos para associao\n";
					echo "</td>\n";
					echo "</tr>\n";
				}
				echo "</table>\n";
				echo "<input type=hidden name=\"count_{$table}\" id=\"count_{$table}\" value=" . count($res_aux) . ">\n";
				echo "</td></tr>\n";
			} else if ($this->ref[$i]["type"] != "dbfield") {
				if ($this->ref[$i]["type"] == "hidden") {
					echo $this->get_field($this->ref[$i]);
				} else {
					// nao mostra td label se todos os campos do tab sao checkbox
					$ck_td_label = 1;
					if (count($this->tab_ref) > 0) {
						$ck_td_label = 0;
						for ($j=0; $j<count($this->ref); $j++) {
							if ($this->ref[$j]["tab_id"] == $this->ref[$i]["tab_id"] &&
								$this->ref[$j]["type"] != "checkbox") {
								$ck_td_label = 1;
								break;
							}
						}
					}
					echo "<tr id=\"tr$i\" " . ($this->ref[$i]["tab_id"] > 0 || ($this->ref[$i]["ck_hidden"] == 1 && ($this->modo == "insert" || $this->modo == "report" || ($this->modo == "update" && $res_upd[0][$this->ref[$j]["field"]] != ""))) ? "style=display:none" : "") . ">\n";
					if ($ck_td_label == 1) {
						echo "<td width=130 valign=top class=tdtitulo" . ($this->ck_print == 1 ? "_relat" : "") . " " . ($this->ref[$i]["ck_req"] == 1 ? "style=text-indent:-20px;padding-left:25px" : "") . ">" . ($this->ref[$i]["type"] != "checkbox" || $this->ref[$i]["field_group"] != null ? ($this->ref[$i]["ck_req"] == 1 && $this->ck_print == 0 ? "<img src=$this->img_dir/obrigatorio.gif width=19 height=11 border=0 align=absmiddle>" : "") . ($this->ref[$i]["field_group"] == null ? $this->ref[$i]["label"] : $this->ref[$i]["field_group"]) . ":" : "&nbsp;");
						if ($this->ref[$i]["type"] == "publisher") echo "<br><br><br><input class=\"form1\" name=\"ck" . $this->ref[$i]["field"] . "\" value=\"" . $this->ref[$i]["field"] . "\" type=\"checkbox\" onclick=\"setMode(this.value,this.checked);\">HTML";
						echo  "</td>\n";
					}
					echo "<td width=460 class=tdtexto" . ($this->ck_print == 1 ? "_relat" : "") . " " . ($this->ref[$i]["type"] == "checkbox" && $this->ref[$i]["field_group"] == null ? "style=\"text-indent:-20px;padding-left:25px\"" : "") . ">\n";
					for ($j=$i; $j<count($this->ref); $j++) {
						if ($this->ref[$j]["field_group"] != null && $this->ref[$j]["type"] != "checkbox") echo $this->ref[$j]["label"] . ":";
						echo "<span id=\"comment_before_" . $this->ref[$j]["field"] . "\">" . (isset($this->ref[$j]["comment_before"]) ? $this->ref[$j]["comment_before"] : "") . "</span>\n";
						if ($this->modo == "update" && $this->step == 2)
							echo $this->get_field($this->ref[$j], $res_upd[0]);
						else
							echo $this->get_field($this->ref[$j]);
						echo "<span id=\"comment_" . $this->ref[$j]["field"] . "\">" . (isset($this->ref[$j]["comment"]) ? $this->ref[$j]["comment"] : "") . "</span><br>\n";
						if ($this->ref[$i]["field_group"] == null ||
							$j == count($this->ref)-1 ||
							$this->ref[$j]["field_group"] != $this->ref[$j+1]["field_group"]) break;
					}
					$i = $j;
					echo "</td></tr>\n";
				}
			}
			if ($this->ref[$i]["ck_separator"] == 1) {
				echo "<tr><td colspan=2 background=$this->img_dir/pontilhado.gif><img src=$this->img_dir/x.gif width=1 height=5 border=0></td></tr>\n";
			}
		} // for ($i=0; $i<count($this->ref); $i++) {
		if ($this->ck_print == 0) {
			echo "<tr><td colspan=2 background=$this->img_dir/pontilhado.gif><img src=$this->img_dir/x.gif width=1 height=5 border=0></td></tr>\n";
			echo "<tr><td colspan=2 align=right class=tdtitulo>\n";
			echo "<span id=\"botao\"><input type=button value=ok onclick=ckform() name=ok class=submit></span>\n";
			echo "<input type=\"hidden\" name=\"step\" value=\"" . ($this->step+1) . "\">\n";
			echo "<input type=\"hidden\" name=\"modo\" value=\"" . $this->modo . "\">\n";
			if ($this->modo == "update" && 
				$this->step == 2 &&
				isset($res_upd)) {
				if (is_array($this->pk)) {
					for ($i=0; $i<count($this->pk); $i++) {
						echo "<input type=\"hidden\" name=\"id\" value=\"" . $res_upd[0][$this->pk[$i]] . "\">\n";
					}
				} else {
					echo "<input type=\"hidden\" name=\"id\" value=\"" . $res_upd[0]["id"] . "\">\n";
				}
				for ($i=0; $i<count($this->tab_ref); $i++) {
					$table = $this->tab_ref[$i]["table"];
					if ($table != null) echo "<input type=\"hidden\" name=\"id_$table\" value=\"" . $res_upd[0]["id_$table"] . "\">\n";
				}
			}
			echo "</td></tr>\n";
		}
		echo "</table>\n";
		echo "</form>\n";
		if ($this->ck_print == 0 &&
			$this->modo == "update" && 
			count($this->ent_1XN) > 0) {
			echo "<script language=\"JavaScript\">\n";
			echo "<!--- \n";
			echo "trava_delete_aux = new Array();\n";
			for ($i=0; $i<count($this->ent_1XN); $i++) {
				$p = $this->ent_1XN[$i];
				$ent_table = $i . $this->ref[$p]["table"];
				$res_aux = $this->get_res_aux($this->ref[$p]);
				echo "trava_delete_aux[\"$ent_table\"] = new Array();\n";
				for ($j=0;$j<count($res_aux);$j++) {
					$ck_trava = 0;
					if (isset($this->ref[$p]["entity_trava"])) {
						for ($k=0; $k<count($this->ref[$p]["entity_trava"]); $k++) {
							$field = $this->ref[$p]["entity_trava"][$k]["field"];
							$val = $this->ref[$p]["entity_trava"][$k]["val"];
							if ($res_aux[$j][$field] == $val) $ck_trava = 1;
						}
					}
					if ($ck_trava == 1) echo "trava_delete_aux[\"$ent_table\"][" . $res_aux[$j]["id"] . "] = 1;\n";
					/*
					echo "fn_edit_item(\"$ent_table\");\n";
					echo "document.getElementById(\"id_$ent_table$j\").value = '" . $res_aux[$j]["id"] . "';\n";
					for ($k=0; $k<count($this->ref[$p]["field"]); $k++) {
						$ref = $this->ref[$p]["field"][$k];
						if ($ref["type"] == "checkbox") {
							echo "document.getElementById(\"".$ent_table."_" . $ref["field"] . "$j\").checked = " . ($res_aux[$j][$ref["field"]] == 1 ? "true":"false") . ";\n";
						//elseif ($this->ck_print == 1) 
							//echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").innerHTML = '" . ($res_aux[$j][$ref["field"]] == "" ? "&nbsp;" : $res_aux[$j][$ref["field"]]) . "';\n";
						} elseif ($ref["type"] == "file" && $res_aux[$j][$ref["field"]] != "") {
							echo "document.getElementById(\"{$ent_table}_remove" . $ref["field"] . "div{$j}\").style.display = '';\n";
							echo "document.getElementById(\"{$ent_table}_imagem" . $ref["field"] . "div{$j}\").style.display = '';\n";
							echo "document.getElementById(\"{$ent_table}_imagem" . $ref["field"] . "div{$j}\").innerHTML = '<a href=" . $ref["filedir"] . "/" . $res_aux[$j][$ref["field"]] . " target=_blank><img src=" . $ref["filedirthumb"] . "/" . $res_aux[$j][$ref["field"]] . " border=0></a>';\n";
						} elseif ($ref["type"] == "text" && isset($ref["mask"])) {
							$ini = 0;
							for ($l=0; $l<count($ref["mask"]); $l++) {
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$l$j\").value = '" . substr($res_aux[$j][$ref["field"]], $ini, $ref["mask"][$l]) . "';\n";
								if ($ck_trava == 1) {
									echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$l$j\").readOnly = 1;\n";
									echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$l$j\").style.backgroundColor = 'red';\n";
								}
								$ini = $ref["mask"][$l];
							}
						} else {
							if ($res_aux[$j][$ref["field"]] != "") {
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").value = '" . $res_aux[$j][$ref["field"]] . "';\n";
							}
							if ($ref["type"] == "filteredtext") {
								echo "document.getElementById(\"nome{$ent_table}_" . $ref["field"] . "$j\").value = '" . str_replace("'","\'",$res_aux[$j]["filteredtext"]) . "';\n";
							}
							if ($ck_trava == 1) {
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").readOnly = 1;\n";
								echo "document.getElementById(\"{$ent_table}_" . $ref["field"] . "$j\").style.backgroundColor = 'red';\n";
							}
						}
					}
					*/
				}
			}
			echo "// --->\n";
			echo "</script>\n";
		}
		echo "</BODY></HTML>\n";
	}
	private function build_list() {
		// label edition
		if (isset($_SESSION["cls_form_vars"])) {
			$keys = array_keys($_SESSION["cls_form_vars"]);
			for ($i=0; $i<count($keys); $i++) {
				if ($keys[$i] != "modo" &&
					$keys[$i] != "step" &&
					$keys[$i] != "id") {
					$var = $keys[$i];
					$$var = $_SESSION["cls_form_vars"][$keys[$i]];
				}
			}
		}
		if (isset($this->vars["count"])) {
			$qry_str = "";
			for ($i=0; $i<$this->vars["count"]; $i++) {
				$str_val = array();
				$ck_edit = 0;
				for ($j=0; $j<count($this->label); $j++) {
					if ($this->label[$j]["ck_update"] == 1) {
						$update_key = $this->label[$j]["update_key"];
						$field = $this->get_field_label($this->label[$j]["field"]);
						$var = "$field$i";
						$var_bak = "{$field}_bak{$i}";
						$val = "";
						if (!isset($str_val[$update_key])) $str_val[$update_key] = "";
						if ($this->label[$j]["type"] == "checkbox") {
							$ck_edit = 1;
							$this->vars[$var] = isset($this->vars[$var])?1:0;
							if ($this->vars[$var] != $this->vars[$var_bak]) 
								$val = $this->vars[$var];
						} else if ($ck_edit == 1 &&
							($this->label[$j]["type"] == "date" &&
							 (($this->vars["dia_$var"] != $this->vars["dia_$var_bak"]) ||
							  ($this->vars["mes_$var"] != $this->vars["mes_$var_bak"]) ||
							  ($this->vars["ano_$var"] != $this->vars["ano_$var_bak"])))) {
							$val = $this->get_val($this->label[$j], "", $i);
						} else if ($ck_edit == 1 &&
							($this->label[$j]["type"] == "datetime" &&
							 (($this->vars["dia_$var"] != $this->vars["dia_$var_bak"]) ||
							  ($this->vars["mes_$var"] != $this->vars["mes_$var_bak"]) ||
							  ($this->vars["ano_$var"] != $this->vars["ano_$var_bak"]) ||
							  ($this->vars["hor_$var"] != $this->vars["hor_$var_bak"]) ||
							  ($this->vars["min_$var"] != $this->vars["min_$var_bak"])))) {
							$val = $this->get_val($this->label[$j], "", $i);
						} else if ($this->label[$j]["type"] == "text" &&
							$this->vars[$var] != $this->vars[$var_bak]) {
							$val = $this->get_val($this->label[$j], "", $i);
						}
						if (strlen($val) > 0)
							$str_val[$update_key] .= ($str_val[$update_key] != "" ? "," : "") . "$field = $val";
					}
				}
				$keys = array_keys($str_val);
				for ($j=0; $j<count($keys); $j++) {
					if ($str_val[$keys[$j]] != "") {
						// add xtra_field values
						for ($k=0; $k<count($this->flag_mode_action); $k++) {
							if ($this->vars["ck_action$k"] == 1) {
								for ($l=0; $l<count($this->flag_mode_action[$k]["xtra_field"]); $l++) {
									$field = $this->flag_mode_action[$k]["xtra_field"][$l]["field"];
									$val = $this->flag_mode_action[$k]["xtra_field"][$l]["val"];
									$str_val[$keys[$j]] .= ", $field = $val";
								}
							}
						}
						$qry = "UPDATE $this->table SET " . $str_val[$keys[$j]] . " WHERE " . $keys[$j] . " = '" . $this->vars[$keys[$j].$i] . "'";
						$qry_str .= "$qry;\n";
						if ($this->db == "MYSQL") nc_query($qry);
					}
				}
			}
			if ($this->debug == 1) echo "<pre>$qry_str</pre>";
			if ($qry_str != "" && $this->db == "MSSQL") nc_query($qry_str,"NONQUERY");
		}
		$group_str = "";
		$order_str = "";
		$where_str = "";
		$join_str = "";
		$label_str = "";
		for ($i=0; $i<count($this->group_key); $i++) {
			if ($this->list_modo == "custom") {
				$temp = explode(".",$this->group_key[$i]["field"]);
				$label = $temp[count($temp)-1];
			} else if ($this->list_modo == "auto") {
				$label = "group$i";
			}
			$group_str .= $this->group_key[$i]["field"] . " AS $label,\n";
			$group_str .= $this->group_key[$i]["order"] . " AS order$label,\n";
			$order_str .= ($order_str != "" ? "," : "") . $this->group_key[$i]["order"] . " " . $this->group_key[$i]["direction"] . "\n";
		}
		for ($i=0; $i<count($this->order); $i++) {
			$ck = 0;
			for ($j=0; $j<count($this->label); $j++) {
				if ($this->order[$i]["field"] == $this->label[$j]["field"]) {
					$ck = 1;
					break;
				}
			}
			if ($ck == 0) $label_str .= $this->order[$i]["field"] . " AS order$i,\n";
			$order_str .= ($order_str != "" ? "," : "") . $this->order[$i]["field"] . " " . $this->order[$i]["direction"] . "\n";
		}
		for ($i=0; $i<count($this->label); $i++) {
			$label_str .= $this->label[$i]["field"] . ",\n";
			if ($this->label[$i]["ck_update"] == 1 && 
				($this->label[$i]["type"] == "date" || $this->label[$i]["type"] == "datetime")) {
				$field_label = $this->get_field_label($this->label[$i]["field"]);
				$field_index = $this->get_field_index($this->label[$i]["field"]);
				$label_str .= "DAY($field_index) AS dia_$field_label, MONTH($field_index) AS mes_$field_label, YEAR($field_index) AS ano_$field_label,\n";
				if ($this->label[$i]["type"] == "datetime")
					$label_str .= "DATEPART(hh, $field_index) AS hor_$field_label, DATEPART(n, $field_index) AS min_$field_label,\n";
			}
			if ($this->label[$i]["orderby"] != null) {
				$field_index = $this->label[$i]["orderby"];
			} else {
				if ($this->ck_recursive == 1 || $this->pageby != null)
					$field_index = $this->get_field_label($this->label[$i]["field"]);
				else
					$field_index = $this->get_field_index($this->label[$i]["field"]);
			}
			if (count($this->order) == 0 && 
				!is_numeric(trim($field_index)) && 
				substr($field_index, 0, 6) != "COUNT(") {
				$order_str .= ($order_str != "" ? "," : "") . $field_index . "\n";
			}
		}
		for ($j=0; $j<count($this->link_ref); $j++) {
			preg_match_all("[\[([a-zA-Z0-9_.])+\]]", $this->link_ref[$j]["url"], $match);
			for ($k=0; $k<count($match[0]); $k++) {
				$str = (strpos($match[0][$k], ".") == 0 ? $this->table."." : "") . substr($match[0][$k],1,-1);
				if (strpos($label_str, $str) == 0) 
					$label_str .= "$str,\n";
			}
		}
		for ($i=0; $i<count($this->color_ref); $i++) {
			$label_str .= $this->color_ref[$i]["param"] . ",";
		}
		for ($i=0; $i<count($this->related); $i++) {
			if (strpos($this->related[$i]["use"],"L") !== false) $join_str .= $this->related[$i]["sql"] . "\n";
		}
		if ($this->modo == "delete") {
			for ($i=0; $i<count($this->dependency); $i++) {
				$table = $this->dependency[$i]["table"];
				if (strpos($this->dependency[$i]["table"], " "))
					$table_id = trim(substr($this->dependency[$i]["table"], strpos($this->dependency[$i]["table"], " ")));
				else 
					$table_id = $table;
				$ix = $this->dependency[$i]["ix"];
				if ($this->ck_recursive == 1) {
					$where_str .= "$this->table.$this->pk NOT IN (SELECT $ix FROM $table WHERE $ix IS NOT NULL) AND\n";
				} else if ($this->ck_recursive == 0) {
					$join_str .= "LEFT JOIN $table ON $table_id.$ix = $this->table.$this->pk\n";
					$where_str .= "$table_id.$ix IS NULL AND\n";
				}
			}
		}
		for ($i=0; $i<count($this->condition); $i++) {
			$where_str .= $this->condition[$i] . " AND\n";
		}
		// define table
		$temp = explode(" ", $this->table);
		$qry_table = $temp[count($temp)-1];
		if (is_array($this->pk)) {
			$pk_str = "";
			for ($i=0; $i<count($this->pk); $i++) {
				$pk_str .= ($i>0 ? "," : "") . "$qry_table." . $this->pk[$i];
			}
		} else {
			$pk_str = "$qry_table.$this->pk AS id";
		}
		if (isset($this->list_qry)) {
			if ($this->debug == 1) echo "<pre>$this->list_qry</pre>";
			$res = nc_query($this->list_qry);
		} else if ($this->pageby != null) {
			// find paging for DESC order
			$qry = "SELECT 
					COUNT(DISTINCT $qry_table.$this->pk) AS total
				FROM $this->table
				$join_str
				WHERE
					$where_str
					1 = 1";
			if ($this->debug == 1) echo "<pre>$qry</pre>";
			$res_tot = nc_query($qry);
			$temp = explode(",", $order_str);
			if (strtoupper(substr(trim($temp[0]),-4)) == "DESC") {
				$ini = max($res_tot[0]["total"] - ($this->vars["pagina"])*$this->pageby, 0);
				$fim = $res_tot[0]["total"] - ($this->vars["pagina"]-1)*$this->pageby;
			} else {
				$ini = ($this->vars["pagina"]-1)*$this->pageby;
				$fim = ($this->vars["pagina"])*$this->pageby;
			}
			// exec query
			$qry = "SELECT * FROM (
					SELECT DISTINCT
						DENSE_RANK() OVER(ORDER BY $qry_table.$this->pk) AS rownum, 
						--ROW_NUMBER() OVER(ORDER BY $qry_table.$this->pk) AS rownum, 
						--COUNT($qry_table.$this->pk) OVER(PARTITION BY 0) AS total,
						" . ($this->ck_ativo == 1 ? "$qry_table.ativo AS ativo," : "") . "
						$group_str
						$label_str
						$pk_str
					FROM $this->table
					$join_str
					WHERE
						$where_str
						1 = 1) rs
				WHERE 
					rownum > $ini AND 
					rownum <= $fim
				ORDER BY
					" . ($this->ck_ativo == 1 ? "ativo DESC," : "") . "
					$order_str";
			if ($this->debug == 1) echo "<pre>$qry</pre>";
			$res = nc_query($qry);
		} else if ($this->ck_recursive == 1) {
			$temp = explode(",", $label_str);
			$recursive_str = "";
			for ($i=0; $i<count($temp); $i++) {
				if (trim($temp[$i]) != "") {
					$recursive_str .= $this->get_field_label($temp[$i]) . ",";
				}
			}
			$qry = "WITH tree (
					" . ($this->ck_ativo == 1 ? "ativo," : "") . " 
					$recursive_str 
					id_tree, 
					level, 
					pathstr)
				AS (SELECT
					" . ($this->ck_ativo == 1 ? "$qry_table.ativo AS ativo," : "") . "
					$label_str
					$pk_str,
					0 AS level,
					CAST(" . $this->get_field_index($this->label[0]["field"]) . " AS VARCHAR(MAX))
				FROM $this->table
				WHERE 
					$where_str
					$this->recursive_index IS NULL
				UNION ALL
				SELECT
					" . ($this->ck_ativo == 1 ? "$qry_table.ativo AS ativo," : "") . "
					$label_str
					$pk_str,
					tree.level + 1 AS level,
					tree.pathstr + ',' + " . $this->label[0]["field"] . "
				FROM $this->table
				INNER JOIN tree ON tree.id_tree = $qry_table.$this->recursive_index
				$join_str
				WHERE
					$where_str
					1 = 1)
				SELECT 
					" . ($this->ck_ativo == 1 ? "ativo," : "") . " 
					$recursive_str 
					id_tree AS $this->pk, 
					level, 
					pathstr
				FROM tree
				ORDER BY
					" . ($this->ck_ativo == 1 ? "ativo DESC," : "") . "
					pathstr,
					$order_str";
			if ($this->debug == 1) echo "<pre>$qry</pre>";
			$res = nc_query($qry, $method = "QUERY"); // check if nc_query version accepts $method = "QUERY"
		} else {
			$qry = "SELECT DISTINCT
					" . ($this->ck_ativo == 1 ? "$qry_table.ativo AS ativo," : "") . "
					$group_str
					$label_str
					$pk_str
				FROM $this->table
				$join_str
				WHERE
					$where_str
					1 = 1
				ORDER BY
					" . ($this->ck_ativo == 1 ? "ativo DESC," : "") . "
					$order_str";
			if ($this->debug == 1) echo "<pre>$qry</pre>";
			$res = nc_query($qry);
		}
		if ($this->modo == "report" && count($res) > 0 && $this->pageby == null) $this->add_header("<b>Total:</b> ".count($res));
		if ($this->modo == "report" && count($res) > 0 && $this->pageby != null) $this->add_header("<b>Total:</b> ".$res_tot[0]["total"]);
		if ($this->modo == "delete") $titulo = "EXCLUIR $this->ent";
		if ($this->modo == "update") $titulo = "ATUALIZAR $this->ent";
		if ($this->modo == "report") $titulo = "RELATRIO $this->ent";
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>$titulo</TITLE>\n";
		echo "<link rel=\"STYLESHEET\" type=\"text/css\" href=\"$this->css_path\">\n";
		for ($i=0; $i<count($this->js_ref); $i++) {
			echo "<script language=\"JavaScript\" src=\"$this->js_dir/" . $this->js_ref[$i] . (strpos($this->js_ref[$i],"?")?"&":"?") . "rand=" . rand(1,1000) . "\"></script>\n";
		}
		echo "<script language=\"JavaScript\">\n";
		echo "<!--- \n";
		if ($this->ck_collapse == 1 || $this->ck_recursive == 1) {
			echo "function fn_chdisplay(list) {\n";
			echo "	for (var i=0; i<list.length; i++) {\n";
			echo "		if (document.getElementById(list[i])) {\n";
			echo "			obj = document.getElementById(list[i])\n";
			echo "			obj.style.display = obj.style.display == '' ? 'none' : ''\n";
			echo "		}\n";
			echo "	}\n";
			echo "}\n";
		}
		if ($this->ck_flag_mode == 1) {
			echo "function fn_ckall_flag(ck,field) {\n";
			echo "	for (var i=0; i<document.getElementById(\"count\").value; i++) {\n";
			echo "		document.getElementById(field+i).checked = ck;\n";
			echo "	}\n";
			echo "}\n";
		}
		echo "// --->\n";
		echo "</script>\n";
		echo "</HEAD>\n";
		echo "<body bgcolor=White>\n";
		//echo "<table " . (count($this->label) <= 2 || count($res) == 0 ? "width=$this->form_width" : "") . " border=0 cellspacing=3 cellpadding=5>\n";
		echo "<table width=$this->form_width border=0 cellspacing=3 cellpadding=5>\n";
		if ($this->ck_recursive == 1)
			$colspan = 2;
		elseif (is_array($this->label))
			$colspan = count($this->label);
		else
			$colspan = 1;
		if ($this->modo == "delete") {
			for ($i=0; $i<count($this->dependency); $i++) {
				$this->header[count($this->header)] = "No  permitida excluso de registros relacionados  tabela \"" . $this->dependency[$i]["label"] . "\"";
			}
		}
		if (count($res) == 0) {
			$this->header[count($this->header)] = "Nenhum registro encontrado" . ($this->modo == "delete" ? " (que no esteja relacionado em outras tabelas)" : "");
		}
		if ($this->ck_display_title == 1) {
			if ($this->ck_csv_export == 1) {
				echo "<tr><td colspan=$colspan>\n";
				echo "<table border=0 cellspacing='0' cellpadding='0'>\n";
				echo "<tr>\n";
				echo "<td class=titulo width=100%>$titulo</td>\n";
				echo "<td class='update' align=right nowrap><a target=_blank href=\"?modo=csv\" class=\"update\">Salvar relatrio<br>em formato Excel</a></td>\n";
				echo "<td align=\"right\" valign=\"middle\"><img src=\"$this->img_dir/excel.gif\" width=\"31\" height=\"30\" border=\"0\" hspace=\"2\"></td>\n";
				echo "</tr>\n";
				echo "</table>\n";
				echo "</td></tr>\n";
			} else 
				echo "<tr><td colspan=$colspan class=titulo>$titulo</td></tr>\n";
			if (count($res) == 0 || 
				count($this->header) > 0) 
				echo "<tr><td colspan=$colspan background= \"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>\n";
		}
		if (count($this->header) > 0) {
			echo "<tr><td colspan=$colspan class=tdtextob valign=top>\n";
			for ($i=0; $i<count($this->header); $i++) {
				echo $this->header[$i] . "<br>\n";
			}
			echo "</td></tr>\n";
		}
		if ($this->pageby != null && count($res) > 0) {
			echo "<form method=get>\n";
			echo "<tr><td colspan=$colspan class=spantexto align=right valign=top>";
			echo "Pgina <select name=pagina class=formpeq onchange=submit()>\n";
			for ($i=0; $i<ceil($res_tot[0]["total"]/$this->pageby); $i++) {
				echo "<option " . ($this->vars["pagina"] == $i+1 ? "SELECTED" : "") . " value=" . ($i+1) . ">" . ($i+1) . "\n";
			}
			echo "</select> de " . ceil($res_tot[0]["total"]/$this->pageby) . "\n";
			$keys = array_keys($this->vars);
			for ($i=0; $i<count($keys); $i++) {
				if ($keys[$i] != "pagina")
					echo "<input type=hidden name=\"" . $keys[$i] . "\" value=\"" . $this->vars[$keys[$i]] . "\">\n";
			}
			echo "</td></tr>\n";
			echo "</form>\n";
		}
		if ($this->modo == "delete" || $this->ck_flag_mode == 1) {
			echo "<form name=formulario method=POST>\n";
		}
		if (count($this->group_key) == 0)
			echo "<tr><td colspan=$colspan background= \"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>\n";
		
		if (count($this->group_key) == 0 &&
			count($this->label) > 1 &&
			count($res) > 0) {
			echo "<tr class=tdtitulo>\n";
			for ($i=0; $i<count($this->label); $i++) {
				for ($j=$ini=$i; $j<count($this->label); $j++) {
					if ($this->label[$i]["label"] != $this->label[$j]["label"]) break;
					$i = $j;
				}
				if ($this->list_title_mode == "V") 
					$nowrap = "NOWRAP";
				elseif ($this->label[$i]["type"]=="checkbox" && $this->label[$i]["ck_update"]==1) 
					$nowrap = "NOWRAP";
				else
					$nowrap = "";
				echo "<td colspan=" . ($j-$ini) . " " . ($this->list_title_mode == "V" ? "style=\"direction:rtl; writing-mode:tb-rl\" align=right" : "valign=top align=".$this->label[$i]["alignment"]) . " $nowrap>" . ($this->label[$i]["type"]=="checkbox" && $this->label[$i]["ck_update"]==1 ? "<input type=checkbox onclick=fn_ckall_flag(this.checked,'".$this->get_field_label($this->label[$i]["field"])."')>" : "") . $this->label[$i]["label"] . "</td>";
				//if ($j > $i+1) $i = $j-1;
			}
			echo "</tr>\n";
		}
		// list loop
		for ($i=0; $i<count($res); $i++) {
			// color
			$bgcolor = "";
			if ($this->ck_ativo == 1 && $res[$i]["ativo"] == 0)
				$bgcolor = "FFFFAA";
			else {
				for ($j=0; $j<count($this->color_ref); $j++) {
					$param = $this->color_ref[$j]["param"];
					$val = $this->color_ref[$j]["param_var"];
					$condition = $this->color_ref[$j]["param_condition"];
					if (strpos($param, ".") > 0) $param = substr($param, strpos($param, ".")+1);
					if (strpos($param, "AS ") > 0) $param = substr($param, strpos($param, "AS ")+3);
					if (($condition == "==" && $res[$i][$param] == $val) || 
						($condition == "!=" && $res[$i][$param] != $val) || 
						($condition == ">=" && $res[$i][$param] >= $val) || 
						($condition == "<=" && $res[$i][$param] <= $val) || 
						($condition == ">" && $res[$i][$param] > $val) || 
						($condition == "<" && $res[$i][$param] < $val)) {
						$bgcolor = $this->color_ref[$j]["color"];
					}
				}
			}
			// group
			if (count($this->group_key) > 0) {
				for ($j=0; $j<count($this->group_key); $j++) {
					if ($this->list_modo == "custom") {
						$label = $this->get_field_label($this->group_key[$j]["field"]);
					} else if ($this->list_modo == "auto") {
						$label = "group$j";
					}
					if ($j == 0) $label_bak = $label;
					if ($i==0 || 
						$res[$i][$label] != $res[$i-1][$label] || 
						$res[$i][$label_bak] != $res[$i-1][$label_bak] ||
						($this->ck_ativo == 1 && $res[$i]["ativo"] != $res[$i-1]["ativo"])) {
						$ck_start = $i;
						if ($j == count($this->group_key)-1) 
							$str = "'trtitulo$i'";
						else
							$str = "";
						for ($k=$i; $k<count($res); $k++) {
							if ($j == count($this->group_key)-1) {
								if ($res[$i][$label] != $res[$k][$label]) break;
								if ($this->ck_ativo == 1 && $res[$i]["ativo"] != $res[$k]["ativo"]) break;
								$str .= ($str != "" ? "," : "") . "'tr$k'";
							} else {
								if ($res[$i][$label] != $res[$k][$label]) break;
								if ($this->ck_ativo == 1 && $res[$i]["ativo"] != $res[$k]["ativo"]) break;
								$str .= ($str != "" ? "," : "") . "'trlabel" . ($j+1) . "_{$k}'";
							}
						}
						if ($j == 0) {
							$str .= ",'trseparador$k'";
							echo "<tr id=\"trseparador$i\" " . ($this->ck_collapse == 1 && $i > 0 ? "style=display:none" : "") . "><td colspan=$colspan background=\"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>\n";
						}
						echo "<tr id=\"trlabel{$j}_{$i}\" " . ($this->ck_collapse == 1 ? "style=cursor:pointer" . ($j>0?";display:none":"") . " onclick=\"fn_chdisplay(new Array($str))\"" : "") . " class=tdtitulo>";
						echo "<td valign=TOP colspan=$colspan " . ($this->ck_collapse == 1 ? "width=$this->form_width" : "") . " " . ($this->ck_ativo == 1 && $res[$i]["ativo"] == 0 ? "style=background-color:#FFFFAA" : "") . ">";
						echo $res[$i][$label] . " " . ($this->ck_ativo == 1 && $res[$i]["ativo"] == 0 ? "(NO ATIVOS)" : "");
						echo "</td>";
						echo "</tr>\n";
						//if ($j == count($this->group_key)-1 && $this->ck_collapse == 1) {
						if ($j == count($this->group_key)-1) {
							if (count($this->label) > 1 &&
								count($res) > 0) {
								$bgcolor = "";
								if ($this->ck_ativo == 1 && $res[$i]["ativo"] == 0)
									$bgcolor = "FFFFAA";
								echo "<tr id=\"trtitulo$i\" " . ($this->ck_collapse == 1 ? "style=\"display:none\"" : "") . " class=tdtitulo>";
								for ($k=0; $k<count($this->label); $k++) {
									echo "<td bgcolor=\"$bgcolor\" " . ($this->list_title_mode == "V" ? "nowrap style=\"direction:rtl; writing-mode:tb-rl\" align=right" : "align=".$this->label[$k]["alignment"]) . ">" . $this->label[$k]["label"] . "</td>";
								}
								echo "</tr>\n";
							}
						}
					}
					$label_bak = $label;
				} // for ($j=0; $j<count($this->group_key); $j++) {
			} else if ($this->ck_ativo == 1) {
				if (($i==0 || $res[$i]["ativo"] != $res[$i-1]["ativo"]) && $res[$i]["ativo"] == 0) {
					if ($i > 0) echo "<tr><td colspan=$colspan background=\"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>";
					echo "<tr class=tdtitulo>\n";
					echo "<td valign=TOP colspan=$colspan " . ($this->ck_ativo == 1 && $res[$i]["ativo"] == 0 ? "style=background-color:#FFFFAA" : "") . ">\n";
					echo ($this->ck_ativo == 1 && $res[$i]["ativo"] == 0 ? "(NO ATIVOS)" : "" );
					echo "</td>";
				}
			}
			echo "<tr id=\"tr$i\" class=tdtexto " . ($this->ck_collapse == 1 || ($this->ck_recursive == 1 && $res[$i]["level"] != 0) ? "style=display:none" : "") . ">\n";
			if ($this->ck_recursive == 1) {
				$str = "";
				for ($j=$i; $j<count($res); $j++) {
					if ($j != $i && $res[$i]["level"] == $res[$j]["level"]) break;
					if ($res[$j]["level"] == $res[$i]["level"]+1) $str .= ($str != "" ? "," : "") . "'tr$j'";
				}
				if ($res[$i]["level"] < $res[$j-1]["level"])
					echo "<td><a href=\"javascript:fn_chdisplay(new Array($str))\" class=update>[+]</a></td>\n";
				else
					echo "<td bgcolor=white></td>\n";
			}
			$params = "";
			if ($this->modo == "update" || $this->modo == "report") {
				$keys = array_keys($this->list_param);
				for ($j=0; $j<count($keys); $j++) {
					if (strtoupper($this->list_param[$keys[$j]]) == "GETFROMQRY")
						$val = $res[$i][$keys[$j]];
					else
						$val = $this->list_param[$keys[$j]];
					$params .= ($params != "" ? "&" : "") . $keys[$j] . "=" . urlencode($val);
				}
				$keys = array_keys($_GET);
				for ($j=0; $j<count($keys); $j++) {
					if ($keys[$j] != "modo" && $keys[$j] != "step")
						$params .= ($params != "" ? "&" : "") . $keys[$j] . "=" . urlencode($_GET[$keys[$j]]);
				}
				//$params = "";
				//for ($j=0; $j<count($this->ref); $j++) {
				//	if ($this->ref[$j]["type"] == "dbfield") $params .= "&".$this->ref[$j]["field"]."=".$this->vars[$this->ref[$j]["field"]];
				//}
			}
			// rowspan
			if ($this->ck_repeat_row == 1 &&
				$i < count($res)-1) {
				$rowspan = 0;
				for ($j=$i; $j<count($res); $j++) {
					if ($res[$i][$this->pk] != $res[$j][$this->pk]) break;
					$rowspan++;
				}
			} else
				$rowspan = 1;
			for ($j=0; $j<count($this->label); $j++) {
				echo $this->get_list_td($i, $j, $this->label[$j], $res[$i], $rowspan, $bgcolor, $params);
			}
			for ($j=0; $j<count($this->link_ref); $j++) {
				preg_match_all("[\[([a-zA-Z0-9_.])+\]]", $this->link_ref[$j]["url"], $match);
				$url = $this->link_ref[$j]["url"];
				for ($k=0; $k<count($match[0]); $k++) {
					$url = str_replace($match[0][$k], urlencode($res[$i][$this->get_field_label(substr($match[0][$k],1,-1))]), $url);
				}
				$target = $this->link_ref[$j]["target"];
				$param = $this->link_ref[$j]["param"];
				$val = $this->link_ref[$j]["param_var"];
				$condition = $this->link_ref[$j]["param_condition"];
				if ($this->link_ref[$j]["receiver"] != null) {
					echo "<td width=22 valign=top style=background-color:white>";
					if ($param == null || 
						($condition == "==" && $res[$i][$param] == $val) || 
						($condition == "!=" && $res[$i][$param] != $val) || 
						($condition == ">=" && $res[$i][$param] >= $val) || 
						($condition == "<=" && $res[$i][$param] <= $val) || 
						($condition == ">" && $res[$i][$param] > $val) || 
						($condition == "<" && $res[$i][$param] < $val)) {
						if ($this->link_ref[$j]["popup"] == 1)
							echo "<a href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,menubar=yes,scrollbars=yes')\"><img src=\"" . $this->link_ref[$j]["receiver"] . "\" width=22 height=22 border=0 title=\"" . $this->link_ref[$j]["name"] . "\"></a>";
						else
							echo "<a target=\"$target\" href=\"$url\"><img src=\"" . $this->link_ref[$j]["receiver"] . "\" width=22 height=22 border=0 title=\"" . $this->link_ref[$j]["name"] . "\"></a>";
					}
					echo "</td>\n";
				} else {
					echo "<td valign=top width=" . (strlen($this->link_ref[$j]["name"])*8) . " nowrap>";
					if ($param == null || 
						($condition == "==" && $res[$i][$param] == $val) || 
						($condition == "!=" && $res[$i][$param] != $val)) {
						if ($this->link_ref[$j]["popup"] == 1)
							echo "<a href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,menubar=yes,scrollbars=yes')\">[" . $this->link_ref[$j]["name"] . "]</a>";
						else
							echo "<a target=\"$target\" class=update href=\"$url\">[" . $this->link_ref[$j]["name"] . "]</a>";
					}
					echo "</td>\n";
				}
			}
			if ($this->add_print == 1) {
				echo "<td width=22 valign=top style=background-color:white>\n";
				$url = $_SERVER["SCRIPT_NAME"] . "?modo=update&step=2&id=" . $res[$i]["id"] . "&ck_print=1&$params";
				echo "<a href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,scrollbars=yes')\"><img src=\"$this->img_dir/imprimir.gif\" width=22 height=22 border=0 title=\"VERSO PARA IMPRESSO\"></a>\n";
				echo "</td>\n";
			} 
			echo "</tr>\n";
			if ($this->ck_repeat_row == 1 &&
				$i < count($res)-1 &&
				$res[$i][$this->pk] == $res[$i+1][$this->pk]) {
				$i++;
				for ($j=$i; $j<count($res); $j++) {
					if ($res[$i][$this->pk] == $res[$j][$this->pk]) {
						echo "<tr id=\"tr$j\" class=tdtexto " . ($this->ck_collapse == 1 ? "style=display:none" : "") . ">\n";
						for ($k=0; $k<count($this->label); $k++) {
							if ($this->label[$k]["repeat"] == 1)
								echo $this->get_list_td($i, $k, $this->label[$k], $res[$j], 1, $bgcolor, $params);
						}
						echo "</tr>\n";
					} else
						break;
				}
				$i = $j-1;
			} // if ($this->ck_repeat_row == 1) {
		} // for ($i=0; $i<count($res); $i++) {
		if (is_array($this->label) &&
			count($res) > 0 && 
			count($this->group_key) == 0) {
			echo "<tr class=tdtitulo>\n";
			$ck_total = 0;
			for ($i=0; $i<count($this->label); $i++) {
				if ($this->label[$i]["mode"] == "R$") $ck_total = 1;
			}
			if ($ck_total == 1) {
				for ($i=0; $i<count($this->label); $i++) {
					if ($this->label[$i]["mode"] == "R$")
						echo "<td align=right nowrap>R$ " . number_format($this->label[$i]["total"], 2, ",", ".") . "</td>";
					else {
						$c = 0;
						for ($j=$i; $j<count($this->label); $j++) {
							if ($this->label[$j]["mode"] == "R$") break;
							$c++;
						}
						echo "<td colspan=$c>" . ($i == 0 ? "TOTAL" : "") . "</td>";
						$i = $j-1;
					}
				}
			}
			echo "</tr>\n";
		}
		if ($this->modo == "delete" || $this->ck_flag_mode == 1) {
			echo "<tr><td colspan=$colspan background=\"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>\n";
			echo "<tr><td colspan=$colspan align=right class=tdtexto>\n";
			echo "<input type=hidden name=\"count\" id=\"count\" value=" . count($res) . ">\n";
			echo "<input type=hidden name=\"step\" id=\"step\" value=" . ($this->modo == "delete" ? 2 : 1) . ">\n";
			echo "<input type=hidden name=\"modo\" id=\"modo\" value=$this->modo>\n";
			for ($i=0; $i<count($this->ref); $i++) {
				$field = $this->ref[$i]["field"];
				if ($this->ref[$i]["type"] != "entity" && isset($this->vars[$field])) {
					echo "<input type=hidden name=$field id=$field value=\"" . $this->vars[$field] . "\">\n";
					if ($this->ref[$i]["type"] == "daterange") {
						echo "<input type=hidden name=dia_{$field}_ini id=dia_{$field}_ini value=\"" . $this->vars["dia_{$field}_ini"] . "\">\n";
						echo "<input type=hidden name=mes_{$field}_ini id=mes_{$field}_ini value=\"" . $this->vars["mes_{$field}_ini"] . "\">\n";
						echo "<input type=hidden name=ano_{$field}_ini id=ano_{$field}_ini value=\"" . $this->vars["ano_{$field}_ini"] . "\">\n";
						echo "<input type=hidden name=dia_{$field}_fim id=dia_{$field}_fim value=\"" . $this->vars["dia_{$field}_fim"] . "\">\n";
						echo "<input type=hidden name=mes_{$field}_fim id=mes_{$field}_fim value=\"" . $this->vars["mes_{$field}_fim"] . "\">\n";
						echo "<input type=hidden name=ano_{$field}_fim id=ano_{$field}_fim value=\"" . $this->vars["ano_{$field}_fim"] . "\">\n";
					}
					if (isset($this->ref[$i]["comment"]) && $this->ref[$i]["comment"] != "") {
						preg_match_all("[name=([A-Za-z0-9_])+]", $this->ref[$i]["comment"], $match);
						for ($j=0; $j<count($match[0]); $j++) {
							$match[0][$j] = str_replace("name=","",$match[0][$j]);
							if (isset($this->vars[$match[0][$j]])) echo "<input type=hidden name=" . $match[0][$j] . " id=" . $match[0][$j] . " value=\"" . $this->vars[$match[0][$j]] . "\">\n";
						}
					}
				}
			}
			//$this->flag_mode_action
			//if (count($this->flag_mode_ref) > 0) {
				for ($i=0; $i<count($this->flag_mode_ref); $i++) {
					echo $this->flag_mode_ref[$i]["label"].": ";
					echo $this->get_field($this->flag_mode_ref[$i]);
				}
			//}
			echo "<span id=\"botao\">";
			if (count($this->flag_mode_action) == 0)
				echo "<input type=button value=ok onclick=submit() name=ok class=submit>";
			else {
				for ($i=0; $i<count($this->flag_mode_action); $i++) {
					$str_action = "";
					preg_match_all("[step=([0-9])+]", $this->flag_mode_action[$i]["url"], $match);
					if (count($match[0]) > 0) $str_action .= "step.value='" . str_replace("step=","",$match[0][0]) . "';";
					preg_match_all("[modo=([a-zA-Z0-9_])+]", $this->flag_mode_action[$i]["url"], $match);
					if (count($match[0]) > 0) $str_action .= "modo.value='" . str_replace("modo=","",$match[0][0]) . "';";
					$str_action .= "this.form.action='" . $this->flag_mode_action[$i]["url"] . "';";
					$str_action .= "ck_action$i.value=1;";
					$str_action .= $this->flag_mode_action[$i]["function"];
					echo "<input type=button value=\"" . $this->flag_mode_action[$i]["label"] . "\" style=width:" . (strlen($this->flag_mode_action[$i]["label"])*10) . " onclick=$str_action class=submit>";
					echo "<input type=hidden name=\"ck_action$i\" name=\"ck_action$i\" value=\"0\">";
				}
			}
			echo "</span>\n";
			echo "</td></tr>\n";
			echo "</form>\n";
		}
		echo "</table>\n";
		echo "</body></html>\n";
	}
	private function get_val($ref, $prefix=null, $c=null) {
		//if ($_SESSION["user_quality"] == "chico") echo "<pre>"; print_r($ref); echo "</pre>"; 
		if (count($this->tab_ref) == 0 || $this->tab_ref[$ref["tab_id"]]["table"] == null) {
			$field = $prefix . $this->get_field_label($ref["field"]);
		} else {
			$table = $this->tab_ref[$ref["tab_id"]]["table"];
			$field = $table . "_" . $this->get_field_label($ref["field"]);
		}
		if ($ref["type"] == "dbfield" && is_numeric($ref["value"]))
			return $ref["value"];
		elseif ($ref["type"] == "dbfield" && !is_numeric($ref["value"]))
			return "'".$ref["value"]."'";
		elseif ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"]) && !isset($this->vars[$field.$c]))
			return array();
		elseif ($ref["type"] == "dropdown" && !array_key_exists("multiple",$ref["prop"]) && $this->vars[$field.$c] == "")
			return "NULL";
		elseif ($ref["type"] == "checkbox" && isset($this->vars[$field.$c]))
			return 1;
		elseif ($ref["type"] == "checkbox" && !isset($this->vars[$field.$c]))
			return 0;
		elseif ($ref["type"] == "radio" && !isset($this->vars[$field.$c]))
			return "NULL";
		elseif ($ref["type"] == "date" && 
			$this->vars["dia_".$field.$c] != "" && 
			$this->vars["mes_".$field.$c] != "" && 
			$this->vars["ano_".$field.$c] != "")
			return "CONVERT(datetime, '".$this->vars["ano_".$field.$c]."-".$this->vars["mes_".$field.$c]."-".$this->vars["dia_".$field.$c]." 00:00:00', 120)";
		elseif ($ref["type"] == "datetime" && 
			$this->vars["dia_".$field.$c] != "" && 
			$this->vars["mes_".$field.$c] != "" && 
			$this->vars["ano_".$field.$c] != "")
			return "CONVERT(datetime, '".$this->vars["ano_".$field.$c]."-".$this->vars["mes_".$field.$c]."-".$this->vars["dia_".$field.$c]." ".$this->vars["hor_".$field.$c].":".$this->vars["min_".$field.$c].":00', 120)";
		elseif (($ref["type"] == "date" || $ref["type"] == "datetime") && ($this->vars["dia_".$field.$c] == "" || $this->vars["mes_".$field.$c] == "" || $this->vars["ano_".$field.$c] == ""))
			return "NULL";
		elseif ($ref["type"] == "daterange" && 
			$this->vars["dia_".$field."_ini".$c] != "" && 
			$this->vars["mes_".$field."_ini".$c] != "" && 
			$this->vars["ano_".$field."_ini".$c] != "" && 
			$this->vars["dia_".$field."_fim".$c] == "" && 
			$this->vars["mes_".$field."_fim".$c] == "" && 
			$this->vars["ano_".$field."_fim".$c] == "")
			return array(
				"ini" => "CONVERT(datetime, '".$this->vars["ano_".$field."_ini".$c]."-".$this->vars["mes_".$field."_ini".$c]."-".$this->vars["dia_".$field."_ini".$c]." 00:00:00', 120)",
				"fim" => "NULL"
			);
		elseif ($ref["type"] == "daterange" && 
			$this->vars["dia_".$field."_ini".$c] != "" && 
			$this->vars["mes_".$field."_ini".$c] != "" && 
			$this->vars["ano_".$field."_ini".$c] != "" && 
			$this->vars["dia_".$field."_fim".$c] != "" && 
			$this->vars["mes_".$field."_fim".$c] != "" && 
			$this->vars["ano_".$field."_fim".$c] != "")
			return array(
				"ini" => "CONVERT(datetime, '".$this->vars["ano_".$field."_ini".$c]."-".$this->vars["mes_".$field."_ini".$c]."-".$this->vars["dia_".$field."_ini".$c]." 00:00:00', 120)",
				"fim" => "CONVERT(datetime, '".$this->vars["ano_".$field."_fim".$c]."-".$this->vars["mes_".$field."_fim".$c]."-".$this->vars["dia_".$field."_fim".$c]." 00:00:00', 120)"
			);
		elseif ($ref["type"] == "daterange" && 
			($this->vars["dia_".$field."_ini".$c] == "" || 
			 $this->vars["mes_".$field."_ini".$c] == "" || 
			 $this->vars["ano_".$field."_ini".$c] == "" || 
			 $this->vars["dia_".$field."_fim".$c] == "" || 
			 $this->vars["mes_".$field."_fim".$c] == "" || 
			 $this->vars["ano_".$field."_fim".$c] == ""))
			return array("ini" => "NULL", "fim" => "NULL");
		elseif ($ref["type"] == "text" && isset($ref["mask"])) {
			$str = "";
				$c_mask = 0;
				for ($i=0; $i<count($ref["mask"]); $i++) {
					if ($this->vars[$field.$c_mask.$c] != "") {
						if (is_numeric($ref["mask"][$i])) {
							$str .= str_pad($this->vars[$field.$c_mask.$c], $ref["mask"][$i], '0');
							$c_mask++;
						} else if ($ref["write_mask"] == 1)
							$str .= $ref["mask"][$i];
					}
				}
			if ($str != "") {
				if ($this->db == "MSSQL")
					return "'" . str_replace(array('\"',"\'"), array('"',"''"), $str) . "'";
				elseif ($this->db == "MYSQL" && strpos($str, "\'") === false)
					return "'" . str_replace("'", "\'", $str) . "'";
				elseif ($this->db == "MYSQL" && strpos($str, "\'") !== false)
					return "'" . $str . "'";
			} else
				return "NULL";
		} elseif ($ref["type"] == "file" && $this->files[$field.$c] != "" && $this->files[$field.$c] != "none") {
			if ($this->files[$field.$c]["tmp_name"] != "")
				return "'" . $this->add_file($this->vars["id"], $ref) . "'";
			else
				return "NULL";
			//return "'" . $this->files[$field.$c]["name"] . "'";
		} elseif ($ref["type"] == "dropdown" && 
			isset($ref["qry"]) && 
			$ref["qry"]["ck_new_entry"] == 1 && 
			$this->vars[$field.$c] == "NEW") { // new entry
			$this->ck_redirect = 0;
			$new_entry_table = $ref["qry"]["new_entry_table"];
			$new_entry_field = $ref["qry"]["new_entry_field"];
			$new_entry_url = $ref["qry"]["new_entry_url"];
			$new_entry_pk = $ref["qry"]["new_entry_pk"];
			$qry = "INSERT INTO $new_entry_table ($new_entry_field) VALUES ('" . $this->vars[$field."_entry".$c] . "')";
			if ($this->db == "MSSQL") {
				$qry_str  = "$qry;\n";
				$qry_str .= "SELECT @@identity AS id;\n";
				if ($this->debug == 1) echo "<pre>$qry_str</pre>";
				$res_new_entry = nc_query($qry_str, "QUERY");
			} elseif ($this->db == "MYSQL") {
				if ($this->debug == 1) echo "<pre>$qry</pre>";
				nc_query($qry);
				$qry = "SELECT MAX($new_entry_pk) AS id FROM $new_entry_table";
				if ($this->debug == 1) echo "<pre>$qry</pre>";
				$res_new_entry = nc_query($qry);
			}
			$this->ck_new_ref[count($this->ck_new_ref)] = array(
				"dir" => $new_entry_table,
				"id" => $res_new_entry[0]["id"],
				"nome" => $this->vars[$field."_entry".$c],
				"url" => str_replace("[id]", $res_new_entry[0]["id"], $new_entry_url)
			); 
			return $res_new_entry[0]["id"];
		} elseif ($ref["type"] == "text" && $this->vars[$field.$c] == "")
			return "NULL";
		elseif ($ref["type"] == "publisher") {
			if ($this->db == "MSSQL")
				return "'" . str_replace(array('\"',"\'"), array('"',"''"), $this->vars["content".$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars["content".$field.$c], "\'") === false)
				return "'" . str_replace("'", "\'", $this->vars["content".$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars["content".$field.$c], "\'") !== false)
				return "'" . $this->vars["content".$field.$c] . "'";
		} elseif ($ref["type"] == "dropdown" && is_array($this->vars[$field.$c])) // multiple
			return $this->vars[$field.$c];
		elseif ($ref["type"] == "dynamiclist")
			return $this->vars["val".$field.$c];
		else {
			if ($this->db == "MSSQL")
				return "'" . str_replace(array('\"',"\'"), array('"',"''"), $this->vars[$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars[$field.$c], "\'") === false)
				return "'" . str_replace("'", "\'", $this->vars[$field.$c]) . "'";
			elseif ($this->db == "MYSQL" && strpos($this->vars[$field.$c], "\'") !== false)
				return "'" . $this->vars[$field.$c] . "'";
		}
	}
	private function get_list_td($i, $j, $label, $val, $rowspan, $bgcolor, $params) {
		// index
		$ix = $this->get_field_label($label["field"]);
		$str = "";
		// td
		if ($label["repeat"] == 1) $rowspan = 1;
		if ($this->modo == "update") {
			$str .= "<td " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " valign=top align=" . $label["alignment"] . " " . ($label["nowrap"] == 1 ? "nowrap" : "") . " style=\"" . ($label["ck_update"] == 0 ? "cursor:pointer;":"") . ($bgcolor != "" ? "background-color:$bgcolor;" : "") . ($this->ck_recursive == 1 ? "padding-left:" . ($val["level"]*20) . ";width:100%" : "") . "\" " . ($label["ck_update"] == 0 ? "onclick=window.location=\"$this->document_name?$params&modo=update&step=2\" onmouseover=document.getElementById(\"tr$i\").style.color=\"silver\" onmouseout=document.getElementById(\"tr$i\").style.color=\"black\"" : "") . ($j == 0 ? " nowrap" : "") . ">";
			if ($j == 0) $str .= "<img src=\"$this->img_dir/update.gif\" width=23 height=11 border=0>";
		} else if ($this->modo == "delete") {
			$str .= "<td " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " valign=top align=" . $label["alignment"] . " " . ($label["nowrap"] == 1 ? "nowrap" : "") . " " . ($bgcolor != "" ? "style=background-color:$bgcolor" : "") . ($this->ck_recursive == 1 ? ";padding-left:" . ($val["level"]*20) : "") . " " . ($j == 0 ? "nowrap" : "") . ">";
			if ($j == 0) $str .= "<input type=checkbox name=id$i value=" . $val["id"] . ">";
		} else if ($this->modo == "report") {
			$str .= "<td " . ($rowspan > 1 ? "rowspan=$rowspan" : "") . " valign=top align=" . $label["alignment"] . " " . ($label["nowrap"] == 1 ? "nowrap" : "") . " " . ($bgcolor != "" ? "style=background-color:$bgcolor" : "") . ($this->ck_recursive == 1 ? ";padding-left:" . ($val["level"]*20) : "") . ">";
		}
		if (isset($label["link"]) &&
			($label["link"]["param"] == null ||
			($label["link"]["param_condition"] == "==" && $val[$label["link"]["param"]] == $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == "!=" && $val[$label["link"]["param"]] != $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == ">=" && $val[$label["link"]["param"]] >= $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == "<=" && $val[$label["link"]["param"]] <= $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == ">" && $val[$label["link"]["param"]] > $label["link"]["param_var"]) ||
			($label["link"]["param_condition"] == "<" && $val[$label["link"]["param"]] < $label["link"]["param_var"]))) {
			preg_match_all("[\[([a-zA-Z0-9_.])+\]]", $label["link"]["url"], $match);
			$url = $label["link"]["url"];
			for ($i=0; $i<count($match[0]); $i++) {
				$url = str_replace($match[0][$i], urlencode($val[$this->get_field_label(substr($match[0][$i],1,-1))]), $url);
			}
			if ($label["link"]["popup"] == 1)
				$str .= "<a class=update href=javascript:void(null) onclick=\"window.open('$url','win{$this->table}_{$i}_{$j}','width=800,height=500,status=yes,resizable=yes,toolbar=yes,menubar=yes,scrollbars=yes')\">";
			else
				$str .= "<a class=update href=\"$url\">";
		}
		if ($label["ck_update"] == 1) {
			$update_key = $label["update_key"];
			//$str .= "<input type=checkbox name={$ix}{$i} value=1 " . ($val[$ix] == 1 ? "CHECKED" : "") . ">\n";
			$str .= $this->get_field($label, $val, "", $i, "formpeq");
			if ($label["type"] == "date" || $label["type"] == "datetime") {
				$str .= "<input type=hidden name=dia_{$ix}_bak{$i} id=dia_{$ix}_bak{$i} value=\"" . $val["dia_$ix"] . "\">\n";
				$str .= "<input type=hidden name=mes_{$ix}_bak{$i} id=mes_{$ix}_bak{$i} value=\"" . $val["mes_$ix"] . "\">\n";
				$str .= "<input type=hidden name=ano_{$ix}_bak{$i} id=ano_{$ix}_bak{$i} value=\"" . $val["ano_$ix"] . "\">\n";
				if ($label["type"] == "datetime") {
					$str .= "<input type=hidden name=hor_{$ix}_bak{$i} id=hor_{$ix}_bak{$i} value=\"" . $val["hor_$ix"] . "\">\n";
					$str .= "<input type=hidden name=min_{$ix}_bak{$i} id=min_{$ix}_bak{$i} value=\"" . $val["min_$ix"] . "\">\n";
				}
			} else {
				$str .= "<input type=hidden name={$ix}_bak{$i} id={$ix}_bak{$i} value=\"" . $val[$ix] . "\">\n";
			}
			$str .= "<input type=hidden name={$update_key}{$i} id={$update_key}{$i} value=\"" . $val[$update_key] . "\">\n";
		} else if ($label["mode"] == "R$") {
			$str .= "R$ " . number_format($val[$ix], 2, ",", "."); 
			$this->label[$j]["total"] += $val[$ix];
		} else if ($label["mode"] == "flag" && $label["ck_update"] == 0) {
			$str .= $val[$ix] == 0 ? "" : "X";
		} else {
			$str .= nl2br($val[$ix]);
		} 
		if ($label["ck_hidden"] == 1) {
			$str .= "<input type=hidden name={$ix}{$i} value=\"" . $val[$ix] . "\">\n";
		}
		if (isset($label["link"])) {
			$str .= "</a>";
		}
		$str .= "</td>\n";
		return $str;
	}
	public function add_qry_default_value($field, $value) {
		$c = count($this->ref); // new index
		$this->ref[$c] = array(
			"type" => "dbfield", 
			"field" => $field, 
			"value" => $value, 
			"ck_qry" => 1, 
			"ck_separator" => 0); 
	}
	private function build_xml() {
		for ($i=0; $i<count($this->ref); $i++) {
			if ($this->ref[$i]["type"] != "entity" &&
				strtolower($this->ref[$i]["field"]) == strtolower($this->vars["field"])) {
				$ref = $this->ref[$i];
				break;
			}
			if ($this->ref[$i]["type"] == "entity") {
				$ck = 0;
				for ($j=0; $j<count($this->ref[$i]["field"]); $j++) {
					if (strtolower($this->ref[$i]["field"][$j]["field"]) == strtolower($this->vars["field"])) {
						$ref = $this->ref[$i]["field"][$j];
						$ck = 1;
					}
					if ($ck == 1) break;
				}
				if ($ck == 1) break;
			}
		}
		//echo "<pre>"; print_r($ref); echo "</pre>";
		if (isset($this->vars["pchave"])) {
			if (isset($ref["ajaxtable"])) {
				$table = $ref["ajaxtable"];
				$id = $ref["ajaxid"];
				$label = $ref["ajaxlabel"];
				$filter = $ref["ajaxfilter"];
				$condition = "";
				if (is_array($filter)) {
					$condition .= "(\n";
					for ($i=0; $i<count($filter); $i++) {
						if (is_array($filter[$i])) {
							$keys = array_keys($filter[$i]);
							$ix = $keys[0];
						} else {
							$ix = $filter[$i];
						}
						if ($this->vars["ck_$ix"] == 1)
						$condition .= "$ix LIKE '%" . $this->vars["pchave"] . "%' OR\n";
					}
					$condition .= "1=0) AND\n";
				} else {
					$condition .= "$filter LIKE '%" . $this->vars["pchave"] . "%' AND\n";
				}
				//if ($ref["condition"] != "") $condition .= $ref["condition"] . " AND\n";
				$sql = "SELECT 
						$table.$id AS id,
						$label AS label
					FROM $table
					WHERE 
						$condition
						1 = 1 
					ORDER BY 
						$label";
				$ref["qry"]["ix"] = "id";
				$ref["qry"]["label"] = "label";
			} elseif (isset($ref["ajaxqry"])) {
				$sql = $ref["ajaxqry"];
				preg_match_all("[\[([a-zA-Z0-9_])+\]]", $sql, $match);
				for ($i=0; $i<count($match[0]); $i++) {
					$sql = str_replace($match[0][$i], $this->vars[substr($match[0][$i],1,-1)], $sql);
				}
				$ref["qry"]["ix"] = $ref["ajaxid"];
				$ref["qry"]["label"] = $ref["ajaxlabel"];
			}
			$function = $ref["ajaxfunction"];
			$res = $function($sql);
		} else if (isset($ref["qry"])) {
			$sql = ereg_replace("\[[a-zA-Z0-9_]+\]", $this->vars["id_ref"], $ref["qry"]["sql"]);
			$function = $ref["ajaxfunction"];
			$res = $function($sql);
		} else if (isset($ref["list"])) {
			$res = array();
			$keys = array_keys($ref["list"]);
			for ($i=0; $i<count($keys); $i++) {
				$res[count($res)] = array(
					"id" => $keys[$i], 
					"label" => $ref["list"][$keys[$i]]
				);
			}
			$ref["qry"]["ix"] = "id";
			$ref["qry"]["label"] = "label";
		}
		//echo "<pre>$sql</pre>"; 
		header("Content-type: text/xml");
		echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
		echo "<xmlresponse>\n";
		for ($j=0; $j<count($res); $j++) { 
			echo "<data>\n";
			echo "<id>" . $res[$j][$ref["qry"]["ix"]] . "</id>\n";
			echo "<text><![CDATA[" . $res[$j][$ref["qry"]["label"]] . "]]></text>\n";
			echo "</data>\n";
		}
		echo "</xmlresponse>\n";
	}
	private function build_csv() {
		$join_str = "";
		$where_str = "";
		$field_str = "";
		$order_str = "";
		for ($i=0; $i<count($this->related); $i++) {
			if (strpos($this->related[$i]["use"],"L") !== false) $join_str .= $this->related[$i]["sql"] . "\n";
		}
		for ($i=0; $i<count($this->condition); $i++) {
			$where_str .= $this->condition[$i] . " AND\n";
		}
		for ($i=0; $i<count($this->csv_export_ref); $i++) {
			$field_str .= ($field_str != "" ? "," : "") . $this->csv_export_ref[$i] . "\n";
		}
		for ($i=0; $i<count($this->csv_export_ref); $i++) {
			$order_str .= ($order_str != "" ? "," : "") . $this->get_field_label($this->csv_export_ref[$i]) . "\n";
		}
		$qry = "SELECT DISTINCT
				$field_str
			FROM $this->table
			$join_str
			WHERE
				$where_str
				1 = 1
			ORDER BY
				$order_str";
		if ($this->debug == 1) echo "<pre>$qry</pre>";
		$res = nc_query($qry);
		header("Content-type: application/x-msexcel");
		for ($i=0; $i<count($this->csv_export_ref); $i++) {
			echo ($i>0 ? "\t" : "") . $this->get_field_label($this->csv_export_ref[$i]);
		}
		echo "\r\n";
		for ($i=0; $i<count($res); $i++) {
			for ($j=0; $j<count($this->csv_export_ref); $j++) {
				echo ($j>0 ? "\t" : "") . "\"" . $res[$i][$this->get_field_label($this->csv_export_ref[$j])] . "\"";
			}
			echo "\r\n";
		}
	}
	private function insert($use_table=null) {
		$str_field = array($this->table => "");
		$str_val = array($this->table => "");
		$ck_insert = array($this->table => 1);
		$qry_multiple = "";
		for ($i=0; $i<count($this->ref); $i++) {
			if (isset($this->ref[$i]["table"]) && $this->ref[$i]["table"] != null) {
				$table = $this->ref[$i]["table"];
			} else if (count($this->tab_ref) == 0 || $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] == null) {
				$table = $this->table;
			} else {
				$table = $this->tab_ref[$this->ref[$i]["tab_id"]]["table"];
			}
			if (!isset($ck_insert[$table])) $ck_insert[$table] = 0;
			if (!isset($str_field[$table])) {
				$str_field[$table] = "";
				$str_val[$table] = "";
			}
			$type = $this->ref[$i]["type"];
			if ($type != "entity" &&
				$type != "display" &&
				$this->ref[$i]["ck_qry"] == 1) {
				$field = $this->ref[$i]["field"];
				$val = $this->get_val($this->ref[$i]);
				if (!is_array($val) &&
					$val != "NULL" &&
					trim($val) != "''" &&
					trim($val) != "'&nbsp;'" &&
					$type != "checkbox") 
					$ck_insert[$table] = 1;
				if ($type == "daterange") {
					$str_field[$table] .= ($str_field != "" ? "," : "") . "{$field}_ini, {$field}_fim";
					$str_val[$table] .= ($str_val != "" ? "," : "") . $val["ini"] . "," . $val["fim"];
				} else if ($type == "dropdown" && array_key_exists("multiple",$this->ref[$i]["prop"])) {
					for ($j=0; $j<count($val); $j++) {
						$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " (" . $this->ref[$i]["key_field"] . ", $field) VALUES ('[pk]', '" . $val[$j] . "');\n";
					}
				} else if ($type == "dynamiclist") {
					$keys = array_keys($this->ref[$i]["xtra_key"]);
					$str_xtra_field = "";
					$str_xtra_val = "";
					for ($j=0; $j<count($keys); $j++) {
						$str_xtra_field .= $keys[$j] . ",";
						$str_xtra_val .= "'" . $this->ref[$i]["xtra_key"][$keys[$j]] . "',";
					}
					$keys = explode(";",$val);
					for ($j=0; $j<count($keys); $j++) {
						$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " ($str_xtra_field " . $this->ref[$i]["key_field"] . ", $field) VALUES ($str_xtra_val '[pk]', '" . $keys[$j] . "');\n";
					}
				} else {
					$str_field[$table] .= ($str_field[$table] != "" ? "," : "") . $field;
					$str_val[$table] .= ($str_val[$table] != "" ? "," : "") . $val;
				}
				$val = str_replace("'","",$val);
				if ($type == "radio" && 
					isset($this->ref[$i]["list"][$val]) && 
					is_array($this->ref[$i]["list"][$val]) && 
					isset($this->ref[$i]["list"][$val]["ck_xtra"]) && 
					$this->ref[$i]["list"][$val]["type"] != null) {
					$field = $this->ref[$i]["list"][$val]["field"];
					$val = $this->get_val($this->ref[$i]["list"][$val]);
					$str_field[$table] .= ($str_field[$table] != "" ? "," : "") . $field;
					$str_val[$table] .= ($str_val[$table] != "" ? "," : "") . $val;
				}
			}
			if ($type == "file" &&
				$this->ref[$i]["ck_qry"] == 0) 
				$this->get_val($this->ref[$i]);
		} // for
		$keys = array_keys($str_field);
		for ($i=0; $i<count($keys); $i++) {
			if (($use_table == null || $use_table == $keys[$i]) &&
				($keys[$i] == $this->table || $ck_insert[$keys[$i]] == 1)) {
				if ($keys[$i] != $this->table) {
					$ck_tab = 0;
					for ($j=0; $j<count($this->tab_ref); $j++) {
						if ($this->tab_ref[$j]["table"] == $keys[$i]) {
							$ck_tab = 1;
							break;
						}
					}
					if ($ck_tab == 1) {
						$str_field[$keys[$i]] .= ", " . $this->tab_ref[$j]["key"];
						$str_val[$keys[$i]] .= "," . $this->id;
					} else {
						$ck_ref = 0;
						for ($j=0; $j<count($this->ref); $j++) {
							if (isset($this->ref[$j]["table"]) && $this->ref[$j]["table"] == $keys[$i]) {
								$ck_ref = 1;
								break;
							}
						}
						if ($ck_ref == 1) {
							$str_field[$keys[$i]] .= ", " . $this->ref[$j]["key_field"];
							$str_val[$keys[$i]] .= "," . $this->id;
							$xtra_key = $this->ref[$j]["xtra_key"];
							$xtra_keys = array_keys($xtra_key);
							for ($j=0; $j<count($xtra_keys); $j++) {
								if (substr($xtra_key[$xtra_keys[$j]],0,6) != "SELECT") {
									$str_field[$keys[$i]] .= "," . $xtra_keys[$j];
									$str_val[$keys[$i]] .= ",'" . $xtra_key[$xtra_keys[$j]].",";
								}
							}
						} 
					}
				}
				$qry = "INSERT INTO " . $keys[$i] . " (" . $str_field[$keys[$i]] . ") VALUES (" . $str_val[$keys[$i]] . ")";
				if ($keys[$i] == $this->table &&
					(($this->ck_return_pk == 1 && $this->ck_return_entity == "default") ||
					 $this->redirect_str != null || 
					 count($this->ent_1XN) > 0 || 
					 count($this->ent_NXN) > 0) ||
					 $qry_multiple != "") {
					if ($this->db == "MSSQL") {
						$qry_str = "$qry;\n";
						$qry = "SELECT @@identity AS id";
						$qry_str .= "$qry;\n";
						if ($this->debug == 1) echo "<pre>$qry_str</pre>";
						$res = nc_query($qry_str, "QUERY");
					} else if ($this->db == "MYSQL") {
						if ($this->debug == 1) echo "<pre>$qry</pre>";
						$res = nc_query($qry);
						$qry = "SELECT MAX($this->pk) AS id FROM $this->table";
						if ($this->debug == 1) echo "<pre>$qry</pre>";
						$res = nc_query($qry);
					}
					$this->id = $res[0]["id"];
					$this->return_pk = $res[0]["id"];
				} else {
					if ($this->debug == 1) echo "<pre>$qry</pre>";
					nc_query($qry);
				}
			} // if
		} // for
		if ($this->debug == 1) echo "<pre>" . str_replace("[pk]", $this->id, $qry_multiple) . "</pre>\n";
		if ($qry_multiple != "") {
			if ($this->db == "MSSQL") {
				nc_query(str_replace("[pk]", $this->id, $qry_multiple),"NONQUERY");
			} elseif ($this->db == "MYSQL") {
				$temp = explode(";", $qry_multiple);
				for ($i=0; $i<count($temp); $i++) { 
					if (trim($temp[$i]) != "") nc_query(str_replace("[pk]", $this->id, $temp[$i]));
				}
			}
		}
		if (count($this->ent_1XN) > 0 || 
			count($this->ent_NXN) > 0) {
			$this->update_entity();
		}
		if ($use_table == null)
			$this->build_confirm();
	}
	private function update() {
		if (isset($this->vars["id"])) $this->id = $this->vars["id"];
		$str_val = array($this->table => "");
		$qry_multiple = "";
		for ($i=0; $i<count($this->ref); $i++) {
			if (isset($this->ref[$i]["table"]) && $this->ref[$i]["table"] != null) {
				$table = $this->ref[$i]["table"];
				$key = $this->ref[$i]["key_field"];
				$xtra_key = $this->ref[$i]["xtra_key"];
				$join_str[$table] = "INNER JOIN $this->table ON $table.$key = $this->table.$this->pk";
				$keys = array_keys($xtra_key);
				for ($j=0; $j<count($keys); $j++) {
					if (substr($xtra_key[$keys[$j]],0,6) == "SELECT")
						$join_str[$table] .= " AND $table." . $keys[$j] . " IN (" . $xtra_key[$keys[$j]] . ")";
					else
						$join_str[$table] .= " AND $table." . $keys[$j] . " = '" . $xtra_key[$keys[$j]] . "'";
				}
			} elseif (count($this->tab_ref) == 0 || $this->tab_ref[$this->ref[$i]["tab_id"]]["table"] == null) {
				$table = $this->table;
			} else {
				$table = $this->tab_ref[$this->ref[$i]["tab_id"]]["table"];
				$key = $this->tab_ref[$this->ref[$i]["tab_id"]]["key"];
				$join_str[$table] = "INNER JOIN $this->table ON $table.$key = $this->table.$this->pk";
			}
			if (!isset($str_val[$table])) {
				$str_val[$table] = "";
			}
			if ($this->ref[$i]["type"] != "entity" &&
				$this->ref[$i]["type"] != "display" &&
				$this->ref[$i]["ck_qry"] == 1) {
				if ($this->ref[$i]["type"] == "radio" && 
					isset($this->ref[$i]["list"][$val]) && 
					$this->ref[$i]["list"][$val]["type"] != null) {
					$field = $this->ref[$i]["list"][$val]["field"];
					$val = $this->get_val($this->ref[$i]["list"][$val]);
					$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . "$table.$field = $val";
				} else if ($this->ref[$i]["type"] != "file" ||
					$this->files[$this->ref[$i]["field"]]["name"] != "") {
					$field = $this->ref[$i]["field"];
					$val = $this->get_val($this->ref[$i]);
					if ($this->ref[$i]["type"] == "daterange") {
						$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . "{$field}_ini = " . $val["ini"] . ", {$field}_fim = " . $val["fim"];
					} else if ($this->ref[$i]["type"] == "dropdown" && array_key_exists("multiple",$this->ref[$i]["prop"])) {
						$qry_multiple .= "DELETE FROM " . $this->ref[$i]["table"] . " WHERE " . $this->ref[$i]["key_field"] . " = '" . $this->vars["id"] . "';\n";
						$xtra_key = "";
						$xtra_key_vals = "";
						$keys = array_keys($this->ref[$i]["xtra_key"]);
						for ($j=0; $j<count($keys); $j++) {
							$xtra_key .= $keys[$j] . ",";
							$xtra_key_vals .= "'" . $this->ref[$i]["xtra_key"][$keys[$j]] . "',";
						}
						for ($j=0; $j<count($val); $j++) {
							$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " ($xtra_key " . $this->ref[$i]["key_field"] . ", $field) VALUES ($xtra_key_vals '" . $this->vars["id"] . "', '" . $val[$j] . "');\n";
						}
					} else if ($this->ref[$i]["type"] == "dynamiclist") {
						$keys = array_keys($this->ref[$i]["xtra_key"]);
						$str_xtra_keys = "";
						$str_xtra_field = "";
						$str_xtra_val = "";
						for ($j=0; $j<count($keys); $j++) {
							$str_xtra_keys .= $keys[$j] . " = '" . $this->ref[$i]["xtra_key"][$keys[$j]] . "' AND\n";
							$str_xtra_field .= $keys[$j] . ",";
							$str_xtra_val .= "'" . $this->ref[$i]["xtra_key"][$keys[$j]] . "',";
						}
						$qry_multiple .= "DELETE FROM " . $this->ref[$i]["table"] . " WHERE $str_xtra_keys " . $this->ref[$i]["key_field"] . " = '" . $this->vars["id"] . "';\n";
						$keys = explode(";",$val);
						for ($j=0; $j<count($keys); $j++) {
							$qry_multiple .= "INSERT INTO " . $this->ref[$i]["table"] . " ($str_xtra_field " . $this->ref[$i]["key_field"] . ", $field) VALUES ($str_xtra_val '" . $this->vars["id"] . "', '" . $keys[$j] . "');\n";
						}
					} else {
						$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . "$table.$field = $val";
					}
					if ($this->ref[$i]["type"] == "radio" && 
						isset($this->ref[$i]["list"])) {
						$keys = array_keys($this->ref[$i]["list"]);
						for ($j=0; $j<count($keys); $j++) {
							if (is_array($this->ref[$i]["list"][$keys[$j]])) {
								$val = $this->get_val($this->ref[$i]["list"][$keys[$j]]);
								$str_val[$table] .= ($str_val[$table] != "" ? ",\n" : "") . $this->ref[$i]["list"][$keys[$j]]["field"] . " = $val";
							}
						}
					}
				}
			}
			if ($this->ref[$i]["type"] == "file" && 
				isset($this->vars["remove" . $this->ref[$i]["field"]])) {
				for ($j=0; $j<count($this->ref[$i]["file"]); $j++) {
					$file = $this->ref[$i]["file"][$j]["dir"]["O"] . "/" . $this->get_file_name($this->ref[$i]["file_name_mask"], $this->vars["id"]);
					@unlink($file);
				}
				if ($this->ref[$i]["ck_qry"] == 1) {
					$field = $this->ref[$i]["field"];
					$str_val[$table] .= ($str_val[$table] != "" ? "," : "") . "$field = NULL";
				}
			}
			if ($this->ref[$i]["type"] == "file" &&
				$this->ref[$i]["ck_qry"] == 0) 
				$this->get_val($this->ref[$i]);
		}
		// multiple tables
		$keys = array_keys($str_val);
		$qry_str = "";
		for ($i=0; $i<count($keys); $i++) {
			$table = $keys[$i];
			if ($str_val[$table] != "") {
				$where_str = "";
				if (is_array($this->pk)) {
					for ($j=0; $j<count($this->pk); $j++) {
						$where_str .= ($j>0 ? " AND " : "") . "$this->table." . $this->pk[$j] . " = '" . $this->vars[$this->pk[$j]] . "'";
					}
				} else {
					$where_str .= "$this->table.$this->pk = '" . $this->vars["id"] . "'";
				}
				if ($table == $this->table) {
					$qry = "UPDATE $table
						SET " . $str_val[$table] . "
						WHERE $where_str\n";
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
				} else {
					$qry = "SELECT COUNT(*) AS c FROM $table 
						" . $join_str[$table] . "
						WHERE $where_str";
					$res = nc_query($qry);
					if ($res[0]["c"] == 0) 
						$this->insert($table);
					else {
						if ($this->db == "MSSQL") {
							$qry = "UPDATE $table
								SET " . $str_val[$table] . "
								FROM $table
								" . $join_str[$table] . "
								WHERE $where_str\n";
						} elseif ($this->db == "MYSQL") {
							$qry = "UPDATE $table
								" . $join_str[$table] . "
								SET " . $str_val[$table] . "
								WHERE $where_str\n";
						}
						$qry_str .= "$qry;\n";
						if ($this->db == "MYSQL") nc_query($qry);
					}
				}
			}
		}
		if ($qry_multiple != "") {
			$qry_str .= "$qry_multiple";
			if ($this->db == "MYSQL") {
				$temp = explode(";", $qry_multiple);
				for ($j=0; $j<count($temp); $j++) { 
					if (trim($temp[$j]) != "") nc_query($temp[$j]);
				}
			}
		}
		if ($this->debug == 1) echo "<pre>$qry_str</pre>";
		if ($qry_str != "" && $this->db == "MSSQL") nc_query($qry_str,"NONQUERY");
		if (count($this->ent_1XN) > 0 || 
			count($this->ent_NXN) > 0) {
			$this->update_entity();
		}
		$this->build_confirm();
	}
	private function delete() {
		$list_id = "";
		for ($i=0; $i<$this->vars["count"]; $i++) {
			if (isset($this->vars["id$i"]))
				$list_id .= ($list_id != "" ? "," : "") . "'" . $this->vars["id$i"] . "'";
		}
		$qry_str = "";
		for ($i=0; $i<count($this->delete_cascade); $i++) {
			$qry = "DELETE FROM " . $this->delete_cascade[$i]["table"] . " WHERE " . $this->delete_cascade[$i]["ix"] . " IN ($list_id)";
			$qry_str .= "$qry;\n";
			if ($this->db == "MYSQL") nc_query($qry);
		}
		$qry = "DELETE FROM $this->table WHERE $this->pk IN ($list_id)";
		$qry_str .= "$qry;\n";
		if ($this->db == "MYSQL") nc_query($qry);
		if ($this->debug == 1) echo "<pre>$qry_str</pre>";
		if ($qry_str != "" && $this->db == "MSSQL") nc_query($qry_str,"NONQUERY");
		$this->build_confirm();
	}
	public function add_file($id, $ref, $prefix=null, $c=null) {
		if ($this->use_sysdoc == 1) $sysdoc = new cls_sysdoc;
		$field = $prefix . $ref["field"] . $c;
		// files
		for ($i=0; $i<count($ref["file"]); $i++) {
			$file_name = $this->get_file_name($ref["file_name_mask"], $id);
			if ($ref["file"][$i]["maxsize"] == false) {
				// use original extension
				$temp = explode(".", $file_name);
				if (count($temp) > 1) $file_name = substr($file_name, 0, -strlen($temp[count($temp)-1])-1);
				$temp = explode(".", $this->files[$field]["name"]);
				$ext = $temp[count($temp)-1];
				$file_name .= ".$ext";
				// define original file
				$destino_original_file = $ref["file"][$i]["dir"]["D"];
				$original_file = $file_name;
				copy($this->files[$field]["tmp_name"], "$destino_original_file\\$original_file");
			}
		}
		for ($i=0; $i<count($ref["file"]); $i++) {
			$file_name = $this->get_file_name($ref["file_name_mask"], $id);
			if ($ref["file"][$i]["maxsize"] != false) {
				if ($this->use_sysdoc == 1 && $sysdoc->fn_ckpdf("$destino_original_file\\$original_file")) 
					$sysdoc->fn_convertpdf2jpg("$destino_original_file\\$original_file", $ref["file"][$i]["dir"]["D"]."\\" . str_replace(".pdf","",$original_file), $ref["file"][$i]["maxsize"], $ck_origem="abs", $ck_destino="abs"); 
				else {
					$dst_img = $this->image_resize($this->files[$field]["tmp_name"], $ref["file"][$i]["maxsize"]);
					if ($dst_img == false) {
						echo "<span class=tdtexto style=background-color:white;padding:0><br>FORMATO DE IMAGEM INVALIDO PARA O ARQUIVO: <b>" . $this->files[$field]["name"] . "</b>.<br>FORMATOS ACEITOS: JPG, PNG ou GIF</span>";
						$this->debug = 1;
					} else {
						if (substr($file_name, -4) == ".jpg")
							ImageJpeg($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
						elseif (substr($file_name, -4) == ".gif")
							ImageGif($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
						else {
							$size = GetImageSize($this->files[$field]["tmp_name"]);
							if ($size[2] == 1) {
								$file_name .= ".gif";
								ImageGif($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
							} else if ($size[2] == 2) {
								$file_name .= ".jpg";
								ImageJpeg($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
							} else if ($size[2] == 3) {
								$file_name .= ".png";
								ImagePng($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
							}
						}
						// thumb
						$dst_img = $this->image_resize($this->files[$field]["tmp_name"], $ref["file"][$i]["maxsize"]);
						ImageJpeg($dst_img, $ref["file"][$i]["dir"]["D"]."/$file_name");
					}
				}
			} 
		}
		if (isset($original_file))
			return $original_file;
		else
			return $file_name;
	}
	private function image_resize($imgname, $maxsize, $pos=null) {
		$size = GetImageSize($imgname);
		if ($size[2] == 1) $src_img=ImageCreatefromGif($imgname); 
		else if ($size[2] == 2) $src_img=ImageCreatefromJpeg($imgname); 
		else if ($size[2] == 3) $src_img=ImageCreatefromPng($imgname); 
		else {
			return false;
		}
		$w = $size[0];
		$h = $size[1];
		$new_w = round($pos == "H" || ($w >  $h) ? $maxsize : ($w*$maxsize)/$h);
		$new_h = round($pos == "V" || ($h >= $w) ? $maxsize : ($h*$maxsize)/$w);
		$dst_img=ImageCreatetruecolor($new_w, $new_h); 
		// imagecopyresized(int dst_im, int src_im, int dstX, int dstY, int srcX, int srcY, int dstW, int dstH, int srcW, int srcH);
		imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $new_w, $new_h, $w, $h);
		return $dst_img;
	}
	private function update_entity() {
		$qry_str = "";
		if ($this->db == "MSSQL") {
			$qry = "DECLARE @id_entity int";
			$qry_str .= "$qry;\n";
		}
		for ($i=0; $i<count($this->ent_1XN); $i++) {
			$p = $this->ent_1XN[$i];
			$ent_table = $this->ref[$p]["table"];
			$ent_table_ref = $i . $ent_table;
			$key_field = $this->ref[$p]["key_field"];
			if (is_array($key_field)) {
				$key_field_val = $key_field[1];
				$key_field = $key_field[0];
			} else if (isset($this->id)) {
				$key_field_val = $this->id;
			} else {
				$key_field_val = "";
			}
			$list_id = $this->vars["delete_list_".$ent_table_ref];
			if ($list_id != "" && $key_field_val != "") {
				$keys = array_keys($this->ref[$p]["xtra_key"]);
				$str_xtra_keys = "";
				for ($j=0; $j<count($keys); $j++) {
					$str_xtra_keys .= $keys[$j] . " = '" . $this->ref[$p]["xtra_key"][$keys[$j]] . "' AND\n";
				}
				for ($j=0; $j<count($this->ref[$p]["field"]); $j++) {
					$ref = $this->ref[$p]["field"][$j];
					if ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"])) {
						$qry = "DELETE FROM " . $ref["table"] . "
								WHERE
									" . $ref["key_field"] . " IN ($list_id)";
						$qry_str .= "$qry;\n";
						if ($this->db == "MYSQL") nc_query($qry);
					}
				}
				$qry = "DELETE FROM $ent_table
						WHERE
							$str_xtra_keys
							$key_field = $key_field_val AND
							id IN ($list_id)";
				$qry_str .= "$qry;\n";
				if ($this->db == "MYSQL") nc_query($qry);
			}
			if ($this->ck_return_pk == 1 && $this->ck_return_entity == $ent_table) {
				if ($this->db == "MSSQL") {
					$qry = "DECLARE @str varchar(1000)";
					$qry_str .= "$qry;\n";
				}
			}
			for ($j=0; $j<$this->vars["count_".$ent_table_ref]; $j++) {
				$qry_multiple = "";
				if ($this->vars["id_$ent_table_ref$j"] == "0") {
					$str_field = $key_field;
					$str_val = $key_field_val;
					for ($k=0; $k<count($this->ref[$p]["field"]); $k++) {
						$ref = $this->ref[$p]["field"][$k];
						if ($this->ref[$p]["field"][$k]["type"] == "file") {
							if (!isset($maxid[$ref["field"]])) {
								$qry = "SELECT MAX(id) AS id FROM " . $this->ref[$p]["table"];
								$res_max = nc_query($qry);
								$maxid[$ref["field"]] = $res_max[0]["id"] + 1;
							} else {
								$maxid[$ref["field"]]++;
							}
							if ($this->files[$ent_table_ref."_".$ref["field"].$j]["tmp_name"] != "")
								$val = "'" . $this->add_file($maxid[$ref["field"]], $ref, $ent_table_ref."_", $j) . "'";
							else
								$val = "NULL";
						} else
							$val = $this->get_val($ref, $ent_table_ref."_", $j);
						$field = $ref["field"];
						if ($ref["type"] == "daterange") {
							$str_field .= ",\n{$field}_ini,\n{$field}_fim";
							$str_val .= ",\n" . $val["ini"] . ",\n" . $val["fim"];
						} else if ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"])) {
							if ($this->db == "MSSQL") 
								$qry_multiple .= "SELECT @id_entity = @@identity;\n";
							for ($l=0; $l<count($val); $l++) {
								$qry_multiple .= "INSERT INTO " . $ref["table"] . " (" . $ref["key_field"] . ", $field) VALUES (@id_entity, '" . $val[$l] . "');\n";
							}
						} else if ($ref["type"] != "dropdown" || !array_key_exists("multiple",$ref["prop"])) {
							$str_field .= ",\n" . $field;
							$str_val .= ",\n" . $val;
						}
					}
					$keys = array_keys($this->ref[$p]["xtra_key"]);
					$str_xtra_field = "";
					$str_xtra_val = "";
					for ($k=0; $k<count($keys); $k++) {
						$str_xtra_field .= $keys[$k] . ",";
						$str_xtra_val .= "'". $this->ref[$p]["xtra_key"][$keys[$k]] . "',";
					}
					$qry = "INSERT INTO $ent_table ($str_xtra_field $str_field) VALUES ($str_xtra_val $str_val)";
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
					echo "[$qry_multiple]";
					if ($qry_multiple != "") {
						if ($this->db == "MSSQL") {
							$qry_str .= "$qry_multiple";
						} elseif ($this->db == "MYSQL") {
							$qry = "SELECT MAX(id) AS id FROM $ent_table";
							$res_max = nc_query($qry);
							$temp = explode(";", $qry_multiple);
							for ($k=0; $k<count($temp); $k++) { 
								if (trim($temp[$k]) != "") nc_query(str_replace("@id_entity", $res_max[0]["id"], $temp[$k]));
							}
						}
					}
					if ($this->ck_return_pk == 1 && $this->ck_return_entity == $ent_table) {
						$qry = "IF @str IS NULL
								SET @str = CONVERT(varchar, @@identity)
							ELSE
								SET @str = @str + ',' + CONVERT(varchar, @@identity)";
						$qry_str .= "$qry\n";
					}
					//echo "<pre>$qry</pre>";
					//nc_query($qry);
				} else {
					$str_val = "";
					for ($k=0; $k<count($this->ref[$p]["field"]); $k++) {
						$ref = $this->ref[$p]["field"][$k];
						if ($ref["type"] == "file") {
							$field = $ref["field"];
							if ($this->files["{$ent_table_ref}_" . $ref["field"] . $j]["tmp_name"] != "")
								$str_val .= ($str_val != "" ? "," : "") . "$field = '" . $this->add_file($this->vars["id_$ent_table_ref$j"], $ref, $ent_table_ref."_", $j) . "'";
							else if (isset($this->vars["{$ent_table_ref}_" . "remove" . $ref["field"] . $j])) {
								for ($l=0; $l<count($ref["file"]); $l++) {
									@unlink($this->ref[$i]["file"][$l]["dir"]["O"] . "/" . $this->get_file_name($this->ref[$i]["file"][$l]["file_name_mask"], $this->vars["id_$ent_table_ref$j"]));
								}
								$str_val .= ($str_val != "" ? "," : "") . "$field = NULL";
							}
						} else if ($ref["ck_qry"] == 1) {
							$val = $this->get_val($ref, $ent_table_ref."_", $j);
							$field = $ref["field"];
							if ($ref["type"] == "daterange") {
								$str_val .= ($str_val != "" ? ",\n" : "") . "{$field}_ini = " . $val["ini"] . ", {$field}_fim = " . $val["fim"];
							} else if ($ref["type"] == "dropdown" && array_key_exists("multiple",$ref["prop"])) {
								$qry_multiple .= "DELETE FROM " . $ref["table"] . " WHERE " . $ref["key_field"] . " = " . $this->vars["id_$ent_table_ref$j"] . ";\n";
								for ($l=0; $l<count($val); $l++) {
									$qry_multiple .= "INSERT INTO " . $ref["table"] . " (" . $ref["key_field"] . ", $field) VALUES (" . $this->vars["id_$ent_table_ref$j"] . ", '" . $val[$l] . "');\n";
								}
							} else {
								$str_val .= ($str_val != "" ? ",\n" : "") . "$field = $val";
							}
						}
					}
					$qry = "UPDATE $ent_table SET $str_val 
							WHERE 
								" . ($key_field_val != "" ? "$key_field = $key_field_val AND" : "") . "
								id = " . $this->vars["id_$ent_table_ref$j"];
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
					if ($qry_multiple != "") {
						if ($this->db == "MSSQL") {
							$qry_str .= "$qry_multiple";
						} elseif ($this->db == "MYSQL") {
							$temp = explode(";", $qry_multiple);
							for ($k=0; $k<count($temp); $k++) { 
								if (trim($temp[$k]) != "") nc_query($temp[$k]);
							}
						}
					}
				}
			}
		}
		for ($i=0; $i<count($this->ent_NXN); $i++) {
			// get ref position
			$p = $this->ent_NXN[$i];
			// check tab entity
			$tab_id = $this->ref[$p]["tab_id"];
			if (count($this->tab_ref) > 0 && $this->tab_ref[$tab_id]["table"] != null && $this->modo == "update")
				$pk = $this->vars["id_" . $this->tab_ref[$tab_id]["table"]];
			else
				$pk = $this->id;
			// get table definition
			$ent_table = $this->ref[$p]["table"];
			$ent_table_ref = $p . $ent_table;
			$key_field = $this->ref[$p]["key_field"];
			if (is_array($key_field)) {
				$key_field = $key_field[0];
				$key_field_val = $key_field[1];
			} else {
				$key_field_val = $pk;
			}
			$entity_field = $this->ref[$p]["field"];
			$list_id = "";
			for ($j=0; $j<$this->vars["count_".$ent_table_ref]; $j++) {
				if (!isset($this->vars[$ent_table_ref.$j]) && $this->vars[$ent_table_ref."_bak".$j] == 1) {
					$list_id .= ($list_id != "" ? "," : "") . $this->vars[$ent_table_ref."_".$entity_field[0]["field"].$j];
				}
			}
			if ($list_id != "" && $key_field_val != "") {
				$qry = "DELETE FROM $ent_table
						WHERE
							$key_field = $key_field_val AND
							" . $entity_field[0]["field"] . " IN ($list_id)";
				$qry_str .= "$qry;\n";
				if ($this->db == "MYSQL") nc_query($qry);
			}
			for ($j=0; $j<$this->vars["count_".$ent_table_ref]; $j++) {
				$field_list = "";
				$var_list = "";
				if (isset($this->vars[$ent_table_ref.$j]) && $this->vars[$ent_table_ref."_bak".$j] == 0) {
					for ($k=0; $k<count($entity_field); $k++) {
						$field_list .= ($k>0?",":"") . $entity_field[$k]["field"];
						$var_list .= ($k>0?",":"") . "'" . $this->vars[$ent_table_ref."_".$entity_field[$k]["field"].$j] . "'";
					}
					$qry = "INSERT INTO $ent_table ($key_field, $field_list) VALUES ($pk, $var_list)";
					$qry_str .= "$qry;\n";
					if ($this->db == "MYSQL") nc_query($qry);
				}
			}
		}
		//if ($_SESSION["user_quality"] == "chico") echo "<pre>$qry_str</pre>";
		if ($this->debug == 1) echo "<pre>$qry_str</pre>";
		if ($qry_str != "") {
			if ($this->db == "MSSQL" && $this->ck_return_pk == 1 && $this->ck_return_entity != "default") {
				$qry = "SELECT @str AS val";
				$qry_str .= "$qry;\n";
				$res = nc_query($qry_str,"QUERY");
				$this->return_pk = $res[0]["val"];
			} elseif ($this->db == "MSSQL") 
				nc_query($qry_str,"NONQUERY");
		}
	}
	public function add_notification($from_mail, $to_mail, $subject, $msg, $qry = null) {
		$this->ck_notification = 1;
		$this->notification_ref = array(
			"from_mail" => $from_mail,
			"to_mail" => $to_mail,
			"subject" => $subject,
			"msg" => $msg,
			"qry" => $qry
		);
	}
	private function build_confirm() {
		if ($this->ck_notification == 1) {
			$from_mail = $this->notification_ref["from_mail"];
			$to_mail = $this->notification_ref["to_mail"];
			$subject = str_replace("[id]", $this->id, $this->notification_ref["subject"]);
			$msg = str_replace("[id]", $this->id, $this->notification_ref["msg"]);
			if ($this->notification_ref["qry"] != null) {
				$qry = str_replace("[id]", $this->id, $this->notification_ref["qry"]);
				$res = nc_query($qry);
				$keys = array_keys($res[0]);
				for ($i=0; $i<count($keys); $i++) {
					$from_mail = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $from_mail);
					$to_mail = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $to_mail);
					$subject = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $subject);
					$msg = str_replace("[".$keys[$i]."]", $res[0][$keys[$i]], $msg);
				}
			}
			//echo "<pre>$to_mail</pre><pre>$subject</pre><pre>$msg</pre>";
			$header = "From: $from_mail\r\n";
			mail($to_mail, $subject, $msg, $header);
		}
		if ($this->modo == "insert") $titulo = "REGISTRO INSERIDO";
		if ($this->modo == "update") $titulo = "REGISTRO ATUALIZADO";
		if ($this->modo == "delete") $titulo = "REGISTRO(S) EXCLUIDO(S)";
		echo "<HTML>\n";
		echo "<HEAD>\n";
		echo "<TITLE>$titulo</TITLE>\n";
		echo "<link rel=STYLESHEET type=text/css href=\"$this->css_path\">\n";
		echo "</HEAD>\n";
		echo "<body bgcolor=White>\n";
		echo "<table width=$this->form_width border=0 cellspacing=3 cellpadding=5>\n";
		echo "<tr><td colspan=2 background=\"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>\n";
		echo "<tr><td valign=TOP class=\"msg\">$titulo</td></tr>\n";
		echo "<tr><td colspan=2 background=\"$this->img_dir/pontilhado.gif\"><img src=\"$this->img_dir/x.gif\" width=1 height=5 border=0></td></tr>\n";
		if (count($this->ck_new_ref) > 0) {
			echo "<tr><td class=tdtextob>Clique abaixo para complementar o cadastro dos novos registros criados:</td></tr>\n";
			for ($i=0; $i<count($this->ck_new_ref); $i++) {
				echo "<tr><td valign=TOP class=tdtexto><img src=\"$this->img_dir/update.gif\" width=23 height=11 border=0><a class=update target=_blank href=\"" . $this->ck_new_ref[$i]["url"] . "\">" . strtoupper($this->ck_new_ref[$i]["dir"]) . ": " . $this->ck_new_ref[$i]["nome"] . "</a></td></tr>\n";
			}
		}
		echo "</table>\n";
		echo "</BODY>\n";
		echo "</HTML>\n";
		$temp_str = "";
		if (isset($_SESSION["cls_form_vars"])) {
			$keys = array_keys($_SESSION["cls_form_vars"]);
			for ($i=0; $i<count($keys); $i++) {
				if ($keys[$i] != "step" && $keys[$i] != "modo" && $keys[$i] != "id")
					$temp_str .= "&" . $keys[$i] . "=" . $_SESSION["cls_form_vars"][$keys[$i]];
			}
			$_SESSION["cls_form_vars"] = array();
		}
		if ($this->redirect_str != null) {
			$url = $this->redirect_str;
			preg_match_all("[\[([a-zA-Z0-9_])+\]]", $url, $match);
			for ($k=0; $k<count($match[0]); $k++) {
				$url = str_replace($match[0][$k], $this->vars[substr($match[0][$k],1,-1)], $url);
			}
		} else
			$url = "?modo=$this->modo$temp_str";
		if ($this->modo == "insert" && $this->ck_return_pk == 1)
			$url .= "&ck_return_pk=$this->return_pk";
		if ($this->debug == 1) exit("<a href=\"$url\">$url</a>");
		if (count($this->ck_new_ref) == 0) echo "<META HTTP-EQUIV=Refresh content=1;url=$url>\n";
	}
}
?>