﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="MultipleGrid.aspx.cs" Inherits="MultipleGrid" %>

<%@ Register Assembly="GroupGridViewCtrl" Namespace="GroupGridViewCtrl" TagPrefix="gsoft" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>Grouping GridView Demo</title>
    <link media="all" href="css/StyleSheet.css" rel="Stylesheet" type="text/css" />
    <script type="text/javascript" language="javascript" src="js/jquery-1.4.2.min.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <h2>
        Multiple GroupGridView in a Page
    </h2>
        <hr />
    <div style="width:800px;">
        <div>
            This page provides you the example of using multiple GroupGridView in a Page.
        </div>
        <a href="Default.aspx">View Group Grid Demo</a> <br />
        <table style="width:100%;">
            <tr>
                <td align="left">
                    Group Column: <asp:DropDownList ID="ddlGroupColumn" runat="server" AutoPostBack="true" Width="150" 
                        OnSelectedIndexChanged="ddlGroupColumn_SelectedIndexChanged"></asp:DropDownList>
                </td>
                <td align="right">
                    Animation Speed: <asp:DropDownList ID="ddlAnimationSpeed" runat="server"  AutoPostBack="true"
                        Width="150" OnSelectedIndexChanged="ddlAnimationSpeed_SelectedIndexChanged"></asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <gsoft:GroupGridView AllowGrouping="true" GroupColumnName="Year" ID="grdRawData" runat="server" AutoGenerateColumns="false"
            CssClass="grid" Width="900" GridLines="None" DefaultState="Collapsed">
            <GroupHeaderTemplate>
                <div style="background-color:#ccddff;">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:50%; font-weight:bold;"><%# Container.GroupColumnName + ": " + Container.GroupColumnData.ToString() %> </td>
                            <td style="width:50%;">Total Students: <%# Container.Count("Name") %></td>
                        </tr>
                        <tr>
                            <td>Average Marks: <%# Math.Round((decimal)Container.Average("Marks"), 2) %></td>
                            <td>Highest: <%# Container.Max("Marks") %> (<%# Container.GetValue("Name", "Marks", Container.Max("Marks").ToString())%>)</td>
                        </tr>
                    </table>
                </div>
            </GroupHeaderTemplate>
            <GroupFooterTemplate>
                <div style="background-color:#fcddcf; text-align:center; padding:5px;">
                    This is Footer of <%# Container.GroupColumnName + ": " + Container.GroupColumnData.ToString() %>.
                </div>
            </GroupFooterTemplate>
            <Columns>
                <asp:TemplateField HeaderText="S. No.">
                    <ItemTemplate>
                        <%# Container.DataItemIndex + 1 %>.
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField HeaderText="Name" DataField="Name" />
                <asp:BoundField HeaderText="Branch" DataField="Branch" />
                <asp:BoundField HeaderText="Year" DataField="Year" />
                <asp:BoundField HeaderText="Marks" DataField="Marks" />
                <asp:BoundField HeaderText="Gender" DataField="Gender" />
                <asp:BoundField HeaderText="College" DataField="College" />
            </Columns>
            <RowStyle BackColor="#FFFFFF" />
            <FooterStyle BackColor="#CCCC99" />
            <SelectedRowStyle BackColor="#CE5D5A" Font-Bold="True" ForeColor="White" />
            <HeaderStyle BackColor="#5B598B" Font-Bold="True" ForeColor="White" />
            <AlternatingRowStyle BackColor="#e8e8ff" />
            <PagerStyle BackColor="#ffcccc" />
        </gsoft:GroupGridView>
    </div>
    <br /><br />
    <h2>Employee Data</h2>
    <div>
        <gsoft:GroupGridView AllowGrouping="true" GroupColumnName="Company" ID="grdEmployee" runat="server" AutoGenerateColumns="false"
            CssClass="grid" Width="900" GridLines="None">
            <GroupHeaderTemplate>
                <div style="background-color:#ccddff;">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:50%; font-weight:bold;"><%# Container.GroupColumnName + ": " + Container.GroupColumnData.ToString() %> </td>
                            <td style="width:50%;">Total Employees: <%# Container.Count("Name") %></td>
                        </tr>
                        <tr>
                            <td>Average Salary: <%# Math.Round((decimal)Container.Average("CTC"), 2) %></td>
                            <td>Highest Salary: <%# Container.Max("CTC") %></td>
                        </tr>
                        <tr>
                            <td colspan="2">Top Salary Holder: <%# Container.GetValue("Name", "CTC", Container.Max("CTC").ToString())%></td>
                        </tr>
                    </table>
                </div>
            </GroupHeaderTemplate>
            <%--<GroupFooterTemplate>
                <div style="background-color:#fcddcf; text-align:center; padding:5px;">
                    This is Footer of <%# Container.GroupColumnName + ": " + Container.GroupColumnData.ToString() %>.
                </div>
            </GroupFooterTemplate>--%>
            <Columns>
                <asp:TemplateField HeaderText="S. No.">
                    <ItemTemplate>
                        <%# Container.DataItemIndex + 1 %>.
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField HeaderText="Name" DataField="Name" />
                <asp:BoundField HeaderText="Designation" DataField="Designation" />
                <asp:BoundField HeaderText="Department" DataField="Department" />
                <asp:BoundField HeaderText="Company" DataField="Company" />
                <asp:BoundField HeaderText="Salary" DataField="CTC" />
            </Columns>
            <RowStyle BackColor="#FFFFFF" />
            <FooterStyle BackColor="#CCCC99" />
            <SelectedRowStyle BackColor="#CE5D5A" Font-Bold="True" ForeColor="White" />
            <HeaderStyle BackColor="#5B598B" Font-Bold="True" ForeColor="White" />
            <AlternatingRowStyle BackColor="#e8e8ff" />
            <PagerStyle BackColor="#ffcccc" />
        </gsoft:GroupGridView>
    </div>
    </form>
</body>
</html>
