﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            BindDropDownList();
            BindGridView(grdRawData.GroupColumnName + ", Name");
        }
    }

    //Binds the Data in GridView used in the page.//
    private void BindGridView(string SortColumn)
    {
        // Retrieve the data table from Excel Data Source.//
        DataTable dt = ExcelLayer.GetDataTable(GlobalData.DataSource.FileName, GlobalData.DataSource.TableName, SortColumn);

        grdRawData.DataSource = dt;
        grdRawData.DataBind();
    }

    /// <summary>
    /// Binds the Data in DropDownList used in the page.//
    /// </summary>
    private void BindDropDownList()
    {
        ddlGroupColumn.DataSource = GlobalData.GetGroupColumns();
        ddlGroupColumn.DataTextField = "Value";
        ddlGroupColumn.DataValueField = "Key";
        ddlGroupColumn.DataBind();

        ddlAnimationSpeed.DataSource = Enum.GetNames(typeof(GroupGridViewCtrl.Animation));
        ddlAnimationSpeed.DataBind();
    }
    
    /// <summary>
    /// Event Handler for Group Column.//
    /// </summary>
    /// <param name="sender">sender control</param>
    /// <param name="e">Event Args</param>
    protected void ddlGroupColumn_SelectedIndexChanged(object sender, EventArgs e)
    {
        string ColumnName = ddlGroupColumn.SelectedValue;
        grdRawData.GroupColumnName = ColumnName;
        BindGridView(ColumnName + ", Name");
    }

    /// <summary>
    /// Event Handler for Animation Speed.//
    /// </summary>
    /// <param name="sender">sender control</param>
    /// <param name="e">Event Args</param>
    protected void ddlAnimationSpeed_SelectedIndexChanged(object sender, EventArgs e)
    {
        GroupGridViewCtrl.Animation SelectedAnimation = (GroupGridViewCtrl.Animation)Enum.Parse(typeof(GroupGridViewCtrl.Animation), ddlAnimationSpeed.SelectedValue);
        grdRawData.AnimationSpeed = SelectedAnimation;
        grdRawData.GroupColumnName = ddlGroupColumn.SelectedValue;
        BindGridView(ddlGroupColumn.SelectedValue + ", Name");
    }

    protected void grdRawData_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdRawData.PageIndex = e.NewPageIndex;
        BindGridView(grdRawData.GroupColumnName + ", Name");
    }
}