﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<%@ Register Assembly="GroupGridViewCtrl" Namespace="GroupGridViewCtrl" TagPrefix="gsoft" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Grouping GridView Demo</title>
    <link media="all" href="css/StyleSheet.css" rel="Stylesheet" type="text/css" />
    <script type="text/javascript" language="javascript" src="js/jquery-1.4.2.min.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <h2>
        Group GridView Data Using Custom Control
    </h2>
        <hr />
    <div style="width:900px;">
        <div>
            Here, this page allows you to choose the column which you wish to Group and set the animation speed for fading In and Out.
        </div>
        <a href="MultipleGrid.aspx">View Multiple Grid Demo</a> <br />

        <div>
            JavaScript Options: 
                <input type="button" value="Collapse All Data" onclick="javascript: CollapseAllData('grdRawData');" />
                <input type="button" value="Expand All Data" onclick="javascript: ExpandAllData('grdRawData');" />
                <input type="button" value="Collapse Headers" onclick="javascript: CollapseHeaders('grdRawData');" />
                <input type="button" value="Expand Headers" onclick="javascript: ExpandHeaders('grdRawData');" />
                <input type="button" value="Collapse Footers" onclick="javascript: CollapseFooters('grdRawData');" />
                <input type="button" value="Expand Footers" onclick="javascript: ExpandFooters('grdRawData');" />
        </div>

        <table style="width:100%;">
            <tr>
                <td align="left">
                    Group Column: <asp:DropDownList ID="ddlGroupColumn" runat="server" AutoPostBack="true" Width="150" 
                        OnSelectedIndexChanged="ddlGroupColumn_SelectedIndexChanged"></asp:DropDownList>
                </td>
                <td align="right">
                    Animation Speed: <asp:DropDownList ID="ddlAnimationSpeed" runat="server"  AutoPostBack="true"
                        Width="150" OnSelectedIndexChanged="ddlAnimationSpeed_SelectedIndexChanged"></asp:DropDownList>
                </td>
            </tr>
        </table>
    </div>
    <div>
        <gsoft:GroupGridView AllowGrouping="true" AllowPaging="false" PageSize="20" DefaultState="Collapsed"
            GroupColumnName="Year" ID="grdRawData" runat="server" BackColor="White" AutoGenerateColumns="false"
            CssClass="grid" Width="900" GridLines="None"
            OnPageIndexChanging="grdRawData_PageIndexChanging">
            <GroupHeaderTemplate>
                <div style="background-color:#ccddff;">
                    <table style="width:100%;">
                        <tr>
                            <td style="width:50%; font-weight:bold;"><%# Container.GroupColumnName + ": " + Container.GroupColumnData.ToString() %> </td>
                            <td style="width:50%;">Total Students: <%# Container.Count("Name") %></td>
                        </tr>
                        <tr>
                            <td>Average Marks: <%# Math.Round((decimal)Container.Average("Marks"), 2) %></td>
                            <td>Highest: <%# Container.Max("Marks") %></td>
                        </tr>
                        <tr>
                            <td colspan="2">Topper: <%# Container.GetValue("Name", "Marks", Container.Max("Marks").ToString())%></td>
                        </tr>
                    </table>
                </div>
            </GroupHeaderTemplate>
            <GroupFooterTemplate>
                <div style="background-color:#fcddcf; text-align:center; padding:5px;">
                    This is Footer of <%# Container.GroupColumnName + ": " + Container.GroupColumnData.ToString() %>.
                </div>
            </GroupFooterTemplate>
            <Columns>
                <asp:TemplateField HeaderText="S. No.">
                    <ItemTemplate>
                        <%# Container.DataItemIndex + 1 %>.
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField HeaderText="Name" DataField="Name" />
                <asp:BoundField HeaderText="Branch" DataField="Branch" />
                <asp:BoundField HeaderText="Year" DataField="Year" />
                <asp:BoundField HeaderText="Marks" DataField="Marks" />
                <asp:BoundField HeaderText="Gender" DataField="Gender" />
                <asp:BoundField HeaderText="College" DataField="College" />
            </Columns>
            <RowStyle BackColor="#FFFFFF" />
            <FooterStyle BackColor="#CCCC99" />
            <SelectedRowStyle BackColor="#CE5D5A" Font-Bold="True" ForeColor="White" />
            <HeaderStyle BackColor="#5B598B" Font-Bold="True" ForeColor="White" />
            <AlternatingRowStyle BackColor="#e8e8ff" />
            <PagerStyle BackColor="#ffcccc" />
        </gsoft:GroupGridView>
    </div>
    </form>
    <script type="text/javascript">
        function CollapseAllData(id) {
            $('#' + id + ' tr[group]').fadeOut('fast');
            $('#' + id + ' tr[id^=GroupHeader]').attr('expanded', 'false');
        }

        function ExpandAllData(id) {
            $('#' + id + ' tr[group]').fadeIn('fast');
            $('#' + id + ' tr[id^=GroupHeader]').attr('expanded', 'true');
        }

        function CollapseHeaders(id) {
            $('#' + id + ' tr[id^=GroupHeader]').fadeOut('fast');
        }

        function ExpandHeaders(id) {
            $('#' + id + ' tr[id^=GroupHeader]').fadeIn('fast');
        }

        function CollapseFooters(id) {
            $('#' + id + ' tr[id^=GroupFooter]').fadeOut('fast');
        }

        function ExpandFooters(id) {
            $('#' + id + ' tr[id^=GroupFooter]').fadeIn('fast');
        }
    </script>
</body>
</html>
