﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Zeon.Web.UI.Code;
using System.Web.Optimization;

public partial class _Default : System.Web.UI.Page
{
    #region Constants

    private const string JAVA_SCRIPT_CLASS_KEY = "AdminHomePage";
    private const string CONTROL_KEY = "ControlKey";
    private const string SCRIPT_PATH = "~/AdminJS.js";

    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {
        RegisterClientClass();
    }

    /// <summary>
    /// Register javascript class file. Also create a javascript class object.
    /// </summary>
    private void RegisterClientClass()
    {
        if (!Page.ClientScript.IsClientScriptIncludeRegistered(CONTROL_KEY))
        {
            Page.ClientScript.RegisterStartupScript(typeof(Page), CONTROL_KEY, Scripts.Render(SCRIPT_PATH).ToHtmlString());
        }

        Dictionary<string, string> jsControls = new Dictionary<string, string>();
        jsControls.Add(divBannerContainer.ID, divBannerContainer.ClientID);

        WebHelper.RegisterClientScriptClass(this.ClientID, this.Page, JAVA_SCRIPT_CLASS_KEY, jsControls);
    }

}
