﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Web;

namespace Zeon.Web.UI.Code
{
    /// <summary>
    /// Add common functions here those can not be categories modulewise to put in a separate help file and can be used as a generic functions all over the application.
    /// </summary>
    public class WebHelper
    {
        /// <summary>
        /// Generic class to add client javascript class to page. This fuction mapps server page controls id with their respective client id.
        /// </summary>
        /// <param name="page"></param>
        /// <param name="className"></param>
        /// <param name="controls"></param>
        public static void RegisterClientScriptClass(string objUniqueName, System.Web.UI.Page page, string className, Dictionary<string, string> controls)
        {
            StringBuilder strScript = new StringBuilder();

            string objName = objUniqueName + "_" + className.ToLower();
            strScript.Append("var " + objName + " = new " + className + "({");

            foreach (KeyValuePair<string, string> key in controls)
            {
                strScript.Append("\"" + key.Key + "\":\"" + key.Value + "\",");
            }

            strScript.Append("});" + objName + ".Init();");
            page.ClientScript.RegisterStartupScript(page.GetType(), objUniqueName + "class" + className, strScript.ToString(), true);
        }

        /// <summary>
        /// Generic class to add client javascript class to page. Also this will add a messages collection to script class. 
        /// So the recieving function will recieve two parameters as controls collection and messages collection.
        /// </summary>
        /// <param name="page"></param>
        /// <param name="className"></param>
        /// <param name="controls"></param>
        /// <param name="messages"></param>
        public static void RegisterClientScriptClass(string objUniqueName, System.Web.UI.Page page, string className, Dictionary<string, string> controls, Dictionary<string, string> messages)
        {
            StringBuilder strScript = new StringBuilder();

            string objName = objUniqueName + "_" + className.ToLower();

            strScript.Append("var " + objName + " = new " + className + "({");

            // Adding controls collection
            foreach (KeyValuePair<string, string> key in controls)
            {
                strScript.Append("\"" + key.Key + "\":\"" + key.Value + "\",");
            }

            strScript.Append("},{");

            // Adding messages collection as separate from controls collection.
            foreach (KeyValuePair<string, string> key in messages)
            {
                strScript.Append("\"" + key.Key + "\":\"" + key.Value + "\",");
            }

            strScript.Append("});" + objName + ".Init();");

            page.ClientScript.RegisterStartupScript(page.GetType(), objUniqueName + "class" + className, strScript.ToString(), true);
        }
    }
}