<?php

/*
 *      W-AGORA 4.0
 *      -----------
 *      $Id: update.php,v 1.70 2005/06/05 16:31:58 mdruilhe Exp $
 *      Usage:  Update a note in the forum
 *      Author: Marc Druilhe <mdruilhe@w-agora.com>
 */

# initialization stuff
# --------------------
	if (isSet($_POST['preview'])) {
		$bn_action="preview";
		$bn_action_mode="R";
	} else {
		$bn_action="update";
		$bn_action_mode="W";
	}

	require ("init.inc");

	$actiontype = (empty($_POST['actiontype'])) ? $bn_action : $_POST['actiontype'] ;

	// Some installations (multimania.fr..) seems to lose/unset $key
	if (isset ($_POST['key'])) {
		$key = $_POST['key'];
	} elseif (isset ($_GET['key'])) {
		$key = $_GET['key'];
	}

# A forum must be selected
# ------------------------
	if (empty($bn)) {
		die (ERROR_NO_FORUM_SPECIFIED);
	}

# Set the page to return to (in case of error)
# --------------------------------------------
	$back_form = (isset($back_form)) ? "$back_form" : "edit";
	$back = $back_form . ".$ext?key=$key";

# if note to update is not defined then return to the list
# --------------------------------------------------------
	if (!$key) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		msgForm (ERROR_SPECIFY_KEY, "list.$ext", "close");
		display_footer ($header_footer);
	}

# Check that the "allow modify" option is set on this forum
# If not set then only the moderator of this board can edit a message
# -------------------------------------------------------------------
	if (!$bn_modify && !$is_moderator) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		msgForm (ERROR_FORBIDDEN_ACCESS, "list.$ext", "close");
		display_footer ($header_footer);
	}

# read note in order to insure that this note exists and to get userid/password of the owner
# ---------------------------------------------------------------------------------------
	$old_note = $db->getNote ($bn_db, $key);
	if (!is_array($old_note) ) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_EDIT_MESSAGE, $header_footer);
		msgForm (sprintf(ERROR_NOTE_NOT_FOUND, $msg[0]), "list.$ext", "close");
		display_footer ($header_footer);
	}

# If thread is closed : only moderator can update it
# --------------------------------------------------
	if (($old_note["closed"]==1) && !$is_moderator) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		msgForm (MSG_THREAD_IS_CLOSED, "list.$ext", "close");
		display_footer ($header_footer);
	}

# get thread for later usage (thread subscription)
# ------------------------------------------------------
	$thread= $old_note["thread"];

# Check that this user is either a moderator or the original poster of this note
# and set the note's attributes 
# ------------------------------------------------------------------------------------

	$is_owner = false;
	
	if ($is_moderator) {

		# 1. We're a moderator => no check is done
		# ----------------------------------------

		$mod_userid = $auth->userid;            // set userid of modifier
		// $username = $old_note["username"];      // don't change username
		// $useraddress = $old_note["useraddress"];        // don't change user email
		$password = $old_note["password"];      // don't change password
		$userid = $old_note["userid"];          // don't change user id
		$is_owner=true;
		$ask_password = false;

	} elseif ($old_note["userid"] == 'guest') {

		# 2. This note was posted by a guest user => check password
		# ---------------------------------------------------------

		if ($is_authenticated) {
			// user is authenticated => compare password with current in profile
			if ($auth->user["password"] == $old_note["password"]) {
				// Update the note atributes with the user profile
				$mod_userid = $auth->userid;            // set userid of modifier
				$username = $auth->user["username"];
				$useraddress = $auth->user["useraddress"];
				$userid = $auth->user["userid"];
				$password = $auth->user["password"];
				$is_owner = true;
				$ask_password = false;
			} else {
				$is_owner = false;
				$error = ERROR_INVALID_PASSWORD;
			}
		} elseif (md5($password) == $old_note["password"]) {
			// not authenticated, same password entered
			$mod_userid = "guest";           // set userid of modifier
			$userpw = $password;             // save password in case of preview
			$password = $old_note["password"];      // don't change password
			$userid = $old_note["userid"];          // don't change user id
			$is_owner = true;
			$ask_password = true;
		} else {
			$is_owner = false;
			$error = ERROR_INVALID_PASSWORD;
		}

	} elseif ($is_authenticated && ($auth->user["userid"] == $old_note["userid"]) ) {

		# 3. We are logged in as the original poster
		# ------------------------------------------
		
			// preserve user info
			$mod_userid = $auth->userid;            // set userid of modifier
			$username = $auth->user["username"];
			$useraddress = $auth->user["useraddress"];
			$userid = $auth->user["userid"];
			$password = $auth->user["password"];
			$is_owner = true;
			$ask_password = false;
	} else {

		# 4. Overwise, we're not the owner => exit with error
		# ---------------------------------------------------

		$is_owner = false;
		$error = ERROR_FORBIDDEN_ACCESS;
	}

	if (! $is_owner) {
		// exit => not owner
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		msgForm ($error, "view.$ext?key=$key", "close"); // access forbidden
		display_footer ($header_footer);
		exit;
	}

# validate user mail address if mail reply has been checked
# ---------------------------------------------------------
	$mail_reply = (empty($mail_reply) ) ? 0 : 1;

	$useraddress=ereg_replace (" ", "", $useraddress);
	if ($useraddress) {
		if (validate_email ($useraddress, MAIL_CHECK_DNS)) {
			$valid_address = 1;
		} else {
			if (!empty($before_access)) include $before_access;
			display_header (TITLE_ERROR, $header_footer);
			msgForm (ERROR_INVALID_EMAIL, "$back", "back");
			display_footer ($header_footer);
		}
	} else {
		$valid_address = 0;
	}

	if ($mail_reply) {
		if (!$valid_address) {
			if (!empty($before_access)) include $before_access;
			display_header (TITLE_ERROR, $header_footer);
			msgForm (ERROR_INVALID_EMAIL, "$back", "back");
			display_footer ($header_footer);
		}
	} else {
		$mail_reply = 0;
	}

# Check for required fields
# -------------------------
	if (isset($subject)) {
		// remove trailing whitespace => avoid "only blanks" subjects
		$subject = chop($subject);
	}

	if (!empty($url)) {
		if ($url=='http://') {
			$url='';
		} elseif (!ereg('://', $url)) {
			$url = 'http://'.$url;
		}
	}

	if (is_array($bn_bind_var)) {
		reset($bn_bind_var);
		while (list($field, $required) = each($bn_bind_var)) {
			if ($required && isset($_POST[$field]) && ($$field=="") ) {
				if (!empty($before_access)) include $before_access;
				display_header (LABEL_EDIT_MESSAGE, $header_footer);
				$alert = sprintf (ERROR_MISSING_FIELD, $field);
				msgForm ("$alert", "$back", "back", "", "post");
				display_footer ($header_footer);
			}
		}
	}

# set some default values
# -----------------------
	if (empty($icon) ) {
		$icon = "icon1.gif";
	} else {
		// prevent abusers to select an image outside ./images/icons
		$icon = basename (preg_replace("/\s/", "", $icon)); 
		if (! @file_exists("$icon_dir/$icon")) {
			$icon = "icon1.gif";
		}
	}

	if (empty($subject)) {
		// Build subject from body if subject not set as required field
		$lines = explode("\n", str_replace("\r", '', strip_tags($body)));
		$maxlen = (int) $bn_var_size['subject'];
		if (strlen($lines[0]) > $maxlen) {
			$subject = substr($lines[0], 0, $maxlen-3). '...';
		} else {
			$subject = substr($lines[0], 0, $maxlen);
		}
	}

# (4.x) set hidden flag if it is a moderated forum
# ------------------------------------------------
	if (!$is_moderator && $forum["moderated"] == "1") {
		$hidden = 1;
		$fields["hidden"] = 1;
	}

# Handle attachments (either uploaded from the browser or choosen on the server)
# ------------------------------------------------------------------------------
	$thanks_msg = "";

	include "$inc_dir/fileupload.$ext";
	$fu = new FileUpload;
	$fu->init ($site, $bn_db, $bn_dir_notes);

	$att_count = 0;
	$att_size = 0;
	$total_att_count = 0;
	$total_att_size = 0;

	$attkey = $key;

	if ($bn_file_upload) {
		$attachments = $fu->getUploadedFiles($key, "P");
		if (is_array ($attachments) ) {
			$att_count = $attachments["att_count"];
			$att_size = $attachments["att_size"];
			if (is_array($pcfile_name)) {
				reset ($pcfile_name);
				$names = implode (", ", $pcfile_name);
				$pcfile_name = $names;
			}
			$pcfile_size = $att_size;       // backward compatibility
			$thanks_msg .= str_replace ('{NAME}', $pcfile_name, str_replace('{SIZE}', $pcfile_size, MSG_FILE_UPLOADED));
			$total_att_count += $att_count;
			$total_att_size += $att_size;
		}
	}

	if ($bn_browse_server && !empty($server_file) ) {
		$files = $fu->getServerFiles($key, "P");
		if (is_array ($files) ) {
			$att_count = $files["att_count"];
			$att_size = $files["att_size"];
			$thanks_msg .= sprintf(MSG_FILE_COPIED, $attachment);
			$total_att_count += $att_count;
			$total_att_size += $att_size;
		}
	}

# Set attachments needing to be deleted (just set a flag, deletion will be effective later
# ----------------------------------------------------------------------------------------
	if (is_array ($del_att) ) {
		$db->setDeleteAttachment ($bn_db, $key, $del_att);
	}

# Set attachments inline state
# ----------------------------------------------------------------------------------------
	if (is_array ($inline_att) ) {
		reset($inline_att);
		while (list($id, $mode) = each($inline_att)) {
			$db->setInlineAttachment ($bn_db, $key, $id, $mode);
		}
	}

# populate the note array with all defined variables
# --------------------------------------------------

# set modification date/time and userid of modifier
	$mod_date = $now;

# variables handled by w-agora
	for (reset ($bn_var); $field=current($bn_var); next($bn_var)) {
		if (isset ($$field) ) {
			$$field=kill_html(chop(strip_magic_quotes($$field)));
			$fields[$field]=$$field;
		}
	}

# user's defined variables
	for (reset ($db_var); $field=current($db_var); next($db_var)) {
		if (isset ($$field) ) { // preserve fields that are not used in FORM
			$$field=ereg_replace ("\\\\", "\\\\", chop(strip_magic_quotes($$field)));
			if ($bn_allow_html && $bn_html_var[$field] && $html_tags) {
				$$field = strip_banned_tags($$field);
			} else {
				$$field = kill_html($$field);
			}
			if ($bn_auto_url && $bn_html_var[$field]) {
				$$field = checkURL ($$field);
			}
			if ($bn_use_smileys && $bn_html_var[$field]) {
				$$field = add_smileys($$field);
			}
			$fields[$field]=$$field;
		}
	}

# Set user_* profile variables
# ----------------------------
	if ( ($actiontype=='preview') && $is_authenticated) {
		reset($auth->user);
		while ( list($var, $val) = each($auth->user) ){
			$GLOBALS["user_$var"] = $val;
		}
		$userid = $auth->user['userid'];
	}

# Set summary (can be redefined into the before_access)
# -----------------------------------------------------
	$summary = get_summary (strip_magic_quotes($_POST['body']));
	$fields['summary']= $summary;

# Execute before_access program
# -----------------------------
	if (!empty($before_access)) include $before_access;

# reload note fields array with possibly modified values (from before_access)
# ---------------------------------------------------------------------------
	for (reset ($fields); $field=key($fields); next($fields)) {
		$fields[$field]=$$field;
	}

# if Preview or Apply mode has been choosen then send the updated note to the browser
# --------------------------------------------------------------------------
	switch ($actiontype) {
	 case 'upload':
	 case 'copy':
	 case 'delete':
	 case 'preview':
		display_header (LABEL_EDIT_MESSAGE, $header_footer);
		if ($actiontype=='preview') {
			$viewkey = $key;
			$unixdate = $old_note['unixdate'];
			$ip = $old_note['ip'];
 			$hits = $old_note['hits'];
 			unset($attachments); // set in viewnote.php
			include "$inc_dir/viewnote.$ext";
			print '<hr noshade>';	    
		}

#		... then display the form
#		-------------------------
		if (isset($_POST) ) {
			reset ($_POST);
			while ( list( $var, $val ) = each( $_POST)) {
				if (is_string ($var)) {
					$$var = kill_quotes(strip_magic_quotes($val));
				}
			}
		} else {
			reset ($fields);
			while ( list( $var, $val ) = each( $fields)) {
				if (is_string ($var)) {
					if ($bn_use_smileys && $bn_html_var[$var]) {
						$$var = strip_smileys($$var);
					}
					if ($bn_auto_url && $bn_html_var[$var]) {
						$$var = strip_url($$var);
					}
					$$var = kill_quotes($$var);
				}
			}
		}
		$setUserField = false; // don't reset username and password

		// restore password before sending the form (only for public (password protected) forums
		if ($forum["type"] == "pub") {
			$password = $userpw;
		}

		$form_action = "update.$ext";
		$bn_action="edit";
		if (!isset($html_tags)) $html_tags=0;
		include "$inc_dir/form.$ext";
		display_footer ($header_footer);
		break;
	}

# ... else Update note in database
# --------------------------------
	$ret = $db->updateNote ($bn_db, $key, $fields);
	if ($ret < 0) {
		display_header (TITLE_ERROR, $header_footer);
		msgForm (sprintf(ERROR_DATABASE, $ret), "$back", "back");
		display_footer ($header_footer);
	}

# Attach all temporary files that were previously uploaded (in preview mode)
# and remove files that have been selected
# --------------------------------------------------------------------------
	$db->validateAttachments ($bn_db, $bn_dir_notes, $key, $key);

# update HTML document if static mode is set
# ------------------------------------------
	if ($bn_doc_type == "static") {
		$formated_date = date ($bn_date_format, $unixdate+($bn_tz_offset*3600));
		if (!is_file("$bn_dir_notes/$filename")) {
			$filename = $unixdate. ".html";
			$fields["filename"]=$filename;
		}

		$fd = @fopen ("$bn_dir_notes/$filename", "w+");
		if (!$fd) {
			display_header (TITLE_ERROR, $header_footer);
			msgForm (sprintf (ERROR_CREATE_FILE, "$bn_dir_notes/$filename"), "$back", "back");
			display_footer ($header_footer);
		}
		$body = format_text($body);
		$doc = str_replace('"','\"', $bn_doc_var);
		eval ("\$tmp=stripSlashes(\"$doc\");");
		fputs ($fd, "$tmp");
		fclose ($fd);
	}

# Start search indexation if a search engine is configured
# --------------------------------------------------------
	if ($bn_search && ($bn_doc_type == "static") && ($bn_search_engine != "none") ) {
		include "$inc_dir/$bn_search_engine.$ext";
		$search->indexNotes();
	}

# (4.0) subscribe user to this thread if required
# -----------------------------------------------
	if ($bn_user_mail) {
		if ( ($mail_reply==1) && ($old_note["mail_reply"]==0) ) {
			$db->subscribeUser ($site, $bn_db, $useraddress, $thread);
		} elseif ( ($mail_reply==0) && ($old_note["mail_reply"]==1) ) {
			$db->unSubscribeUser ($site, $bn_db, $useraddress, $thread);
		}
	}

# Send mail to main moderator and subscribed users
# ------------------------------------------------
	include "$inc_dir/mail.$ext";
	$fields["cle"]=$key;
	mail_note ($fields);

	$thanks_msg .= str_replace('{MSG}', $msg[0], str_replace('{KEY}', $key, MSG_NOTE_UPDATED));
	if ($hidden) {
		$thanks_msg .= str_replace('{FORUM}', $msg[1], str_replace('{MSG}', $msg[0], MSG_NEED_APPROVE));
	}

# set the next page to be displayed
# ---------------------------------
	if (empty($redirect_url) ) {
		if ($bn_post_return == "list") {
			$redirect_url = "list.$ext?bn=$bn";
		}elseif ($bn_post_return == "thread") {
			$redirect_url = "view.$ext?bn=$bn&key=$thread";
		} elseif ($hidden) {
			$redirect_url = "list.$ext?bn=$bn";
		} else {
			$redirect_url = "view.$ext?bn=$bn&key=$key";
		}

		if (!empty($folder)) {
			$redirect_url .= "&folder=$folder";
		}
		$redirect_url = "$bn_base_url/$redirect_url";	// HTTP 1.1 requires full URI
	}

# Display "thanks message" or redirect to the next page
# -----------------------------------------------------
	if ( ($bn_popup && $popup) || $hidden) {
		// We force the message to be displayed to be able to close the window
	    $bn_no_thanks_msg = 0;
	}

	if (!$bn_no_thanks_msg && !$no_thanks_msg) {
		display_header (LABEL_EDIT_MESSAGE, $header_footer);
		msgForm ($thanks_msg, $redirect_url, "close");
		display_footer ($header_footer);
	} else {
		if (!@header ("Location: $redirect_url")) {
			display_header (LABEL_EDIT_MESSAGE, $header_footer);
			msgForm ($thanks_msg, $redirect_url, "close");
			display_footer ($header_footer);
		}
	}

?>
