<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_410.php,v 1.6 2005/06/10 21:53:01 mdruilhe Exp $
 *	Usage:		Upgrade all installation from 4.0.3 to 4.1.0
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

# Define globals
# --------------

	$agora_dir = "..";

function updateSite ($site, $title) {
	global $db, $tmpl_dir, $ext;

	$db->Halt_On_Error = "report";

	// create Attachments table 
	// ------------------------
	echo ("<li> <I>creating table</I> <B>${site}_attachments</B>");
	include "$tmpl_dir/admin/att_fields.$ext";
	reset ($bn_var);
	while (list(, $var) = each($bn_var)) {
		$field_descr[$var] = $bn_var_size[$var];
	}
	$ret = $db->createTable ("${site}_attachments", $field_descr);

	// Insert main category 
	// --------------------
	$db->query ("select cle FROM $site where cle='0' AND category='1'");
	if (! $db->next_record()) {
		echo ("<li> <I>adding main category</I> ");
		$cat["cle"] = 0;
		$cat["parent"] = 0;
		$cat["thread"] = 0;
		$cat["newest"] = $GLOBALS["now"];	// used as update time
		$cat["childs"] = 0;
		$cat["unixdate"] = $GLOBALS["now"];
		$cat["category"] = 1;
		$cat["rank"] = 1;
		$cat["owner"] = "admin";
		$cat["bn_name"] = $site;
		$cat["bn_title"] = $title;
		$cat["bn_db"] = $site;
		$ret = $db->insertRow($site, $cat);
	}

	// Update USERS table
	// -------------------
	echo ("<li> <I>altering table</I> <B>${site}_users</B>");
	$db->query ("alter table ${site}_users add country VARCHAR(255) NOT NULL DEFAULT ''");

	$db->Halt_On_Error = "halt";
}

function updateForum ($site, $table, $name) {
	global $db, $cfg_dir, $ext;

	include "$cfg_dir/${name}.$ext";

	// update messages
	// ---------------
	if (!empty($bn_msgs) && file_exists ("$bn_dir/$bn_msgs")  ) {
		updateMsgFile ("$bn_dir/$bn_msgs");
	}

	echo ("<li> <I>Move attachments to the <B>${site}_attachment</B> table</I>");

	// Gets all attachements from the forum table
	// ------------------------------------------
	$db->Halt_On_Error = "report";
	$query = "select cle, unixdate, attachment, att_size, att_type from $table where attachment!= 'none' AND att_size != 0";
	$db->query ($query);
	$i=0;
	while ($db->next_record() ) {
		$attachments[$i]["note_id"] = $db->f("cle");
		$attachments[$i]["unixdate"] = $db->f("unixdate");
		$attachments[$i]["att_name"] = $db->f("attachment");
		$attachments[$i]["att_size"] = $db->f("att_size");
		$attachments[$i]["att_type"] = $db->f("att_type");
		$attachments[$i]["bn_name"]  = $table;
		$attachments[$i]["att_path"] = $bn_dir_notes;
		$attachments[$i]["state"] = '1';
		$attachments[$i]["hidden"]   = '0';
		$i++;
	}

	// Now insert all atchements in the attachment table
	// -------------------------------------------------
	if (is_array($attachments)) {
		reset($attachments);
		while ( list (,$att) = each ($attachments) ) {
			$note_id = $att["note_id"];
			$att_name = $att["att_name"];
			$att["att_id"] = $db->nextId("attachments");
			if ($att["att_id"] <0) {
				echo "could not get auto-increment field";
				break;
			}

			$db->query ("select note_id FROM ${site}_attachments where note_id='$note_id' AND att_name='$att_name' AND bn_name='$table'");
			if ($db->next_record()) {
				// attachment should be unique!
				continue;
			}

			$ret = $db->insertRow("${site}_attachments", $att);
			if ($ret != 0) {
				echo "could not insert attachment in table ${site}_attachments";
				break;
			}

			$att_id = $db->lastId("attachments");
			if (copy ("$bn_dir_notes/$note_id.$att_name", "$bn_dir_notes/$att_id.$att_name")) {
			    unlink ("$bn_dir_notes/$note_id.$att_name");
			} else {
				echo "could not rename file $bn_dir_notes/$note_id.$att_name";
			    break;
			}
			echo "&nbsp;&nbsp;&nbsp;note: $note_id - file: $att_name<br>"; 
	   
		}
	}
	$db->Halt_On_Error = "halt";
}

function updateMsgFile ($msgfile) {

	global $bn_dir, $new_msg;

	include "$msgfile";
	reset ($new_msg);

	print "<li> <I>updating messages in </I> <B>$msgfile</B> ";
	$touch = FALSE;

	while (list ($i, $m) = each($new_msg) ) {
		if (!isset($msg[$i]) ) {
			$touch = TRUE;
			$msg[$i] = $new_msg[$i];
			echo " <B>$i</B> ";
		}
	}

	if ($touch) {
		print "<li> <I>writing file </I> <B>$msgfile</B>";
		$f = new Config;
		$ret = $f->open("$msgfile");
		if (!$ret) {
			return FALSE;
		}
		reset ($msg);
		while (list ($i, $m) = each($msg) ) {
			$f->writeString ("msg[$i]", $msg[$i]);
		}
		$f->close ();
	}
}

	chdir ("$agora_dir");

	$site = "agora";
	include ("init_admin.inc");

?>
<html>
<head>
<style type="text/css">
<!-- 
body { font-size: 9pt  font-family: Helvetica, Arial, Geneva; }
-->
</style>
</head><body><H3>Upgrading w-agora from version 4.0.3 to 4.1.0</H3>
<?php 

# Load default messages
# ---------------------
	include "$tmpl_dir/default/agora/msgs.$ext";
	$new_msg = $msg;
	unset ($msg);

# gets all configured sites
# -------------------------
	$db->query ("select bn_name, bn_title from agora");
	while ($db->next_record() ) {
		$sitename = $db->f("bn_name");
		$sites[$sitename] = $db->f("bn_title");
	}

	$db->closeDB();
	unset ($db);

# loop over all sites
# -------------------
	reset ($sites);
	while (list ($site, $site_title) = each($sites) ) {
		@set_time_limit(30);
		print "<hr><h2>Upgrading site: <B>$site</B> ($site_title)</h2> ";

		// include Site configuration
		if (!is_file ("$cfg_dir/site_${site}.$ext") ) {
			die ("Cannot open file: $cfg_dir/site_${site}.$ext, make sure that site $site really exists");
		}
		include "$cfg_dir/site_${site}.$ext";

		// open new DB connection for this site
		include "$inc_dir/$bn_access.$ext";
		$db_class = "${bn_access}_access";
		$db = new $db_class;
		$db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

		// update messages
		updateMsgFile ("$bn_dir_default/msgs.$ext");

		// update site
		updateSite($site, $site_title);

		// gets all configured forums
		if (is_array($forums) ) {
			unset($forums);
		}
		$forums = Array();
		$db->query ("select bn_db, bn_name from $site where category!=1");
		while ($db->next_record() ) {
			$bn_db = $db->f("bn_db");
			$forums[$bn_db] = $db->f("bn_name");
		}
		print "<li> <I>Updating forums in $site</I>";
		print "<ul>";
		reset ($forums);
		while (list ($table, $name) = each($forums) ) {
			print "<li><I>updating forum</I>: <B>$name</B> <br>";
			updateForum ($site, $table, $name);
		}

		// close DB connection
		$db->closeDB();
		unset ($db);

		print "</ul>";

	}

?>