<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_401.php,v 1.6 2005/06/10 21:53:01 mdruilhe Exp $
 *	Usage:		Upgrade all installation from 4.0 beta to 4.0.1
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */

# Define globals
# --------------

	$agora_dir = "..";

function updateSite ($site) {
	global $db;

	$db->Halt_On_Error = "no";

	// Update site table
	echo ("<li> <I>updating table</I> <B>$site</B>");
	$db->query ("alter table $site add bn_db varchar(64) NOT NULL DEFAULT ''"); // v4.0b1
	$db->query ("UPDATE $site SET bn_db=bn_name WHERE bn_db=''"); // all

	$db->query ("alter table $site add totalthreads int NOT NULL DEFAULT 0"); // v4.0b1
	$db->query ("alter table $site add category int NOT NULL DEFAULT 0"); // v4.0b1
	$db->query ("alter table $site add totalusers int NOT NULL DEFAULT 0"); // v4.0b1

	$db->query ("alter table $site change bn_db bn_db varchar(64) NOT NULL DEFAULT ''"); // v4.0b2
	$db->query ("alter table $site change bn_name bn_name varchar(64) NOT NULL DEFAULT ''");
	$db->query ("alter table $site change bn_title bn_title varchar(255) NOT NULL DEFAULT ''");

	// Update site_users
	echo ("<li> <I>updating table</I> <B>${site}_users</B>");
	$db->query ("alter table ${site}_users add mailok char(1)"); // v4.0b1
	$db->Halt_On_Error = "halt";
}

function updateForum ($forum) {
	global $db;

	$db->Halt_On_Error = "no";

	// Update site table
	echo ("<li> <I>updating table</I> <B>$forum</B>");

	$db->query ("ALTER TABLE $forum ADD hits INT NOT NULL DEFAULT 0"); // v4.0b1
	$db->query ("ALTER TABLE $forum ADD closed  INT NOT NULL DEFAULT 0"); // v4.0b1
	$db->query ("ALTER TABLE $forum ADD ip varchar(32) NOT NULL DEFAULT ''"); // v4.0b1

	$db->query ("ALTER TABLE $forum ADD icon varchar(32) NOT NULL DEFAULT 'icon1.gif'"); // all
	$db->query ("ALTER TABLE $forum ADD downloads INT NOT NULL DEFAULT '0'"); // all
	$db->query ("ALTER TABLE $forum ADD summary varchar(255) NOT NULL DEFAULT ''"); // all

	$db->query ("ALTER TABLE $forum ADD mod_date INT NOT NULL DEFAULT 0"); // all
	$db->query ("UPDATE $forum SET mod_date=unixdate WHERE mod_date=0"); // all
	$db->query ("ALTER TABLE $forum ADD mod_userid varchar(32) NOT NULL DEFAULT ''"); // all
	$db->query ("UPDATE $forum SET mod_userid='none' WHERE mod_userid=''"); // all

	$db->Halt_On_Error = "halt";

}

function updateMsgFile ($msgfile) {

	global $bn_dir, $new_msg;

	include "$msgfile";
	reset ($new_msg);

	print "<li> <I>updating messages in </I> <B>$msgfile</B> ";
	$touch = FALSE;
	while (list ($i, $m) = each($new_msg) ) {
		if (!isset($msg[$i]) ) {
			$touch = TRUE;
			$msg[$i] = $new_msg[$i];
			echo " <B>$i</B> ";
		}
	}

	if ($touch) {
		print "<li> <I>writing file </I> <B>$msgfile</B>";
		$f = new Config;
		$ret = $f->open("$msgfile");
		if (!$ret) {
			return FALSE;
		}
		reset ($msg);
		while (list ($i, $m) = each($msg) ) {
			$f->writeString ("msg[$i]", $msg[$i]);
		}
		$f->close ();
	}
}

function updateFields ($file) {

	$bn_var = array();
	$db_var = array();
	$bn_var_size = array();
	$bn_bind_var = array();
	$bn_html_var = array();
	$list_var = array();

	include "$file";

	print "<li> <I>updating fields</I> in file <B>$file</B> ";

	$fd = fopen ("$file", "w");
	if (!$fd) {
		return FALSE;
	}
	fputs ($fd, "<?php \n");
	fputs ($fd,"unset (\$db_var);\n");

# User variables
# --------------
	fputs ($fd, "\n# User variables\n");
	$i = 0;			// db_var index
	$db_count = 0;	// new count index
	while (is_array($db_var) && ($i < count ($db_var)) ) {
		$var = $db_var[$i];
		if (!empty($var) ) {
			$sz = $bn_var_size[$var];
			fputs ($fd, "\$db_var[$db_count]=\"$var\";\n");
			fputs ($fd, "\$bn_var_size[\"$var\"]=\"$sz\";\n");
			$db_count++;
		}
		$i++;
	}

	fputs ($fd, "\n# Listed variables\n");
	while (is_array($list_var) && (list($var,$val) = each($list_var)) ) {
		if ($val)
			fputs ($fd, "\$list_var[\"$var\"] = 1;\n");
		else
			fputs ($fd, "\$list_var[\"$var\"] = 0;\n");
	}

	fputs ($fd, "\n# Required variables\n");
	while (is_array($list_var) && (list($var,$val) = each($bn_bind_var)) ) {
		if ($val)
			fputs ($fd, "\$bn_bind_var[\"$var\"] = 1;\n");
		else
			fputs ($fd, "\$bn_bind_var[\"$var\"] = 0;\n");
	}

	if (is_array($bn_html_var)) {
		fputs ($fd, "\n# HTML accepted variables\n");
		while (list($var,$val) = each($bn_html_var)) {
			if ($val)
				fputs ($fd, "\$bn_html_var[\"$var\"] = 1;\n");
			else
				fputs ($fd, "\$bn_html_var[\"$var\"] = 0;\n");
		}
	}

	if (is_array($bn_cookie_var)) {
		fputs ($fd, "\n# variables set as permanent cookie\n");
		while (list($var,$val) = each($bn_cookie_var)) {
			$val = (isset($val) ) ? "1" : "0";
			fputs ($fd, "\$bn_cookie_var[\"$var\"] = $val;\n");
		}
	}

	fputs ($fd, "?>\n");		// <?php  help syntax highlighting --
	fclose ($fd);
}

function updateTemplate ($template) {

	include "$template";

	if (!ereg ("att_url", $bn_doc_var) ) {
		if (ereg ("attachment_url", $bn_doc_var) ) {
			$bn_doc_var = ereg_replace ("attachment_url", "att_url", $bn_doc_var);
		} else {
			$bn_doc_var .= "<BR>\\\$att_url";
		}
	}

	$bn_doc_var = ereg_replace ("attach_icon", "att_icon", $bn_doc_var);

	print "<li> <I>updating template</I> in file <B>$template</B> ";

	$conf = new Config;
	$ret = $conf->open($template);
	if (!$ret) {
		return FALSE;
	}

	$conf->writeString ("bn_doc_type", $bn_doc_type);
	$conf->writeString ("bn_doc_var", $bn_doc_var);
	$conf->close();
}

	chdir ("$agora_dir");
	include ("init_admin.inc");

# Load default messages
# ---------------------
	require "$tmpl_dir/default/agora/msgs.php";
	$new_msg = $msg;
	unset ($msg);

?>
<html>
<head>
<style type="text/css">
<!--
 body { font-size: 9pt  font-family: Helvetica, Arial, Geneva; }
-->
</style>
</head>
<body>
<H3>Upgrading w-agora from version 4.0 beta to 4.0.1</H3>

<?php 


# If site specified then upgrade it
# ---------------------------------
	if (!empty ($site) ) {
		set_time_limit(30);
		print "<ul>";
		print "<li><I>Upgrading site:</I> <B>$site</B><br> ";
		require "tools/upgrade_site_401.php";
		print "</ul>";
		exit;
	}

# ... else (no site specified => upgrade all sites)
# -------------------------------------------------

# Initial setup
# -------------
	include "$cfg_dir/site_agora.$ext";

# Open database
# -------------
	include "$inc_dir/$bn_access.$ext";
	$db_class = "${bn_access}_access";
	$db = new $db_class;
	$ret = $db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

	print "<ul>";
	print "<li><I>Upgrading agora main configuration and database:</I> <br> ";

	print "<ul>";

# Update site config. files
# -------------------------
	// update messages
	echo "<li> copy $tmpl_dir/admin/msgs.php $bn_dir_forums/$site/msgs.$ext ";
	copy ("$tmpl_dir/admin/msgs.php", "$bn_dir_forums/$site/msgs.$ext");

	// update site fields
	echo "<li> copy $tmpl_dir/admin/site_fields.php $bn_dir_forums/$site/site_fields.$ext";
	copy ("$tmpl_dir/admin/site_fields.php", "$bn_dir_forums/$site/site_fields.$ext");

# Update site tables
# ------------------
	updateSite("agora");

	// rename backup configuration file
	if (file_exists ("$cfg_dir/site_agora.$ext.bak") ) {
		echo "<li> remame backup file  <B>$cfg_dir/site_agora.$ext.bak</B>";
		copy ("$cfg_dir/site_agora.$ext.bak", "$cfg_dir/site_agora.$ext.bak.$ext");
		unlink ("$cfg_dir/site_agora.$ext.bak");
	}

	print "</ul>";

# Update all sites
# ----------------

	// gets all configured sites
	$db->query ("select bn_name AS site from agora");
	while ($db->next_record() ) {
		$sites[] = $db->f("site");
	}

	$db->closeDB();
	unset ($db);

	reset ($sites);
	while (list (, $site) = each($sites) ) {
		set_time_limit(30);
		print "<hr>";
		print "<li><I>Upgrading site:</I> <B>$site</B><br> ";
		require "tools/upgrade_site_401.php";
	}

	print "</ul>";

?>