<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: month_stats.php,v 1.9 2005/06/10 22:07:05 mdruilhe Exp $
 *	Usage:		Show monthly Statistics
 *	Author:		Syloo (syloo@w-agora.net)
 */


global $agora_dir;
$agora_dir = "..";
$base_url = "..";

chdir($agora_dir);

include ("init_admin.inc");
include ("stats/find_stats.inc");


function dspMonthGeneralStats(& $stat) {
	global $site;
?>
<table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
 <tr class="stats_border"><td>
  <table width="100%" border="0" cellspacing="1" cellpadding="5" align="center">
   <tr>
    <td colspan=2 class="stats_title">
     <?php printf(TITLE_M_GENERAL_STATS,$stat["site_name"],$stat["month_name"])?>
    </td>
   </tr>
   <tr class="stats_even">
    <td class="stats_label" width="70%"><?php echo LABEL_LOGINS?></td>
	<td class="stats_value"><?php echo $stat["totallogins"]?>&nbsp;</td>
   </tr>
   <tr class="stats_odd">
    <td class="stats_label" width="70%"><?php echo LABEL_VISITS?></td>
    <td class="stats_value"><?php echo $stat["totalvisits"]?>&nbsp;</td>
   </tr>
   <tr class="stats_even">
    <td class="stats_label" width="70%"><?php echo COLUMN_HITS?></td>
    <td class="stats_value"><?php echo $stat["totalhits"]?>&nbsp;</td>
   </tr>
   <tr class="stats_odd">
    <td class="stats_label" width="70%"><?php echo LABEL_POSTS?></td>
    <td class="stats_value"><?php echo $stat["totalposts"]?>&nbsp;</td>
   </tr>
   <tr class="stats_even">
    <td class="stats_label" width="70%"><?php echo LABEL_SUBSCRIBES?></td>
    <td class="stats_value"><?php echo $stat["totalsubscribes"]?>&nbsp;</td>
   </tr>
  </table>
 </td></tr></table>

<?php
}

/**
 * Display stats by day for site
 */
function dspMonthDailyStats(& $stat) {
	global $db, $site, $ext, $month, $year;
	$month_name = date("M. Y",strtotime("$month/1/$year"));
?>
	<table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
     <tr class="stats_border"><td>
      <table width="100%" border="0" cellspacing="1" cellpadding="1">
        <tr align="center">
         <td colspan=6 class="stats_title"><?php echo TITLE_DAILY_STATS?></td></tr>
        <tr>
          <td rowspan="2" bgcolor="#CCCCCC" class="stats_th" width="25%"><?php echo COLUMN_DAY?></td>
          <td colspan="5" bgcolor="#CCCCCC" class="stats_th"><?php echo COLUMN_DAILY_TOT?></td></tr>
        <tr>
		  <td align="center" bgcolor="#FFCCFF" class="stats_th" width="15%"><?php echo COLUMN_HITS?></td>
          <td align="center" bgcolor="#CCFFCC" class="stats_th" width="15%"><?php echo COLUMN_LOGINS?></td>
          <td align="center" bgcolor="#FFFFCC" class="stats_th" width="15%"><?php echo COLUMN_POSTS?></td>
		  <td align="center" bgcolor="#99FF99" class="stats_th" width="15%"><?php echo COLUMN_SUBSCRIBES?></td>
          <td align="center" bgcolor="#66FFCC" class="stats_th" width="15%"><?php echo COLUMN_VISITS?></td></tr>
<?php
	if (is_array($stat)) {
		reset($stat);
		while (list($k,$tab) = each($stat)) {
			$cur_date = sprintf("%02d ",$k) . $month_name;
?>
	<tr>
	  <td class="stats_value"><?php echo $cur_date?>&nbsp;</td>
	  <td class="stats_value"><?php echo (empty($tab[BAR_NUM_HITS]))? "-" : $tab[BAR_NUM_HITS]?>&nbsp;</td>
	  <td class="stats_value"><?php echo (empty($tab[BAR_NUM_LOGINS]))? "-" : $tab[BAR_NUM_LOGINS]?>&nbsp;</td>
	  <td class="stats_value"><?php echo (empty($tab[BAR_NUM_POSTS]))? "-" : $tab[BAR_NUM_POSTS]?>&nbsp;</td>
	  <td class="stats_value"><?php echo (empty($tab[BAR_NUM_SUBSCRIBES]))? "-" : $tab[BAR_NUM_SUBSCRIBES]?>&nbsp;</td>
	  <td class="stats_value"><?php echo (empty($tab[BAR_NUM_VISITS]))? "-" : $tab[BAR_NUM_VISITS]?>&nbsp;</td>
    </tr>
<?php
		}
	}
?>
      </table>
    </td>
  </tr>
</table>
<?php
} // end func

$month_date = strtotime("$month/1/$year");
$month_name = date("M. Y",$month_date);
$general_stats = monthGeneralStats($site,$month,$year);
$to_find["hits"] = 1;
$to_find["logins"] = 1;
$to_find["posts"] = 1;
$to_find["subscribes"] = 1;
$to_find["visits"] = 1;
$daily_stats = monthDailyStats($site,$month,$year,$to_find);

$categories = $db->getCategories($site);
$site_title = $categories[0];

$img1 = "wa_bar_graph.$ext?site=$site&graph=monthstats&month=$month&year=$year&width=680&height=200&hits=1";
$img2 = "wa_bar_graph.$ext?site=$site&graph=monthstats&month=$month&year=$year&width=680&height=200&logins=1&visits=1&posts=1";

$db->closeDB();

display_header (sprintf(TITLE_MONTH_GRAPH,$site,$month_name), "$base_url");

?>

<div align="center">
 <small><strong><?php printf (LABEL_GENERATED_ON, $formated_date)?></strong></small>
 <hr noshade width="90%">
 <p>
 <small>
  <a href="#DAYGRAPH" class="label"><?php echo LABEL_DAY_STATS?></a>&nbsp;
  <a href="#DAYSTATS" class="label"><?php echo LABEL_DAY_DETAILS?></a>&nbsp;
  <a href="<?php echo "index.$ext?site=$site"?>"class="label"><?php echo LABEL_RETURN_MAIN_STATS?></a>&nbsp;
  <a href="<?php echo "../admin_site.$ext?site=$site"?>" target="_top" class="label"><?php echo LABEL_ADMIN?></a>
 </small>
</div>


<!-- Month general stats -->
<p>
<?php dspMonthGeneralStats($general_stats)?>
</p>

<!-- Graph for month stats -->
<hr noshade="noshade" width="90%">
<p>
<a name="DAYGRAPH">
<table width="90%" border="0" cellspacing="1" cellpadding="0" align="center">
 <tr class="stats_border"><td>
  <table width="100%" border="0" cellspacing="1" cellpadding="10">
   <tr><td class="stats_title" colspan="2"><?php printf(TITLE_DAILY_GRAPH, $site, $month_name)?></td></tr>
   <tr bgcolor="white">
    <td align="center">
     <img src="<?php echo $img1?>" align="absmiddle" width=680 height=200 alt="<?php printf(ALT_MONTH_IMG1, $site, $month_name)?>">
	</td>
   </tr>
   <tr bgcolor="white">
    <td align="center">
     <img src="<?php echo $img2?>" align="absmiddle" width="680" height="200" alt="<?php printf(ALT_MONTH_IMG2, $site, $month_name)?>">
    </td>
   </tr>
  </table>
 </td></tr>
</table>

<!-- Month daily stats -->
<p>
<a name="DAYSTATS">
<?php dspMonthDailyStats($daily_stats)?>
</p>

<?php
	display_footer();
?>
